/* ***********************************************************************
   *									 *
   *		    Solids of Revolution Database Generator		 *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "alloc.h"
#include "math.inc"
#include "graph.inc"
#include "model.inc"
#include "shpmk.inc"

/* ***********************************************************************
   *									 *
   *				Radial Arrays				 *
   *									 *
   ***********************************************************************
*/

int I;
float RS[62];


char ObjF[]="LGBEADS.DAT";

void RadialArray()
{
  for(I=1; I<=59; I++)
    RS[I]=SinD(I*10)*0.5+0.5;
  RS[60]=0.05;
}


/*
char ObjF[]="BEADS.DAT";

void RadialArray()
{
  for(I=1; I<=60; I++)
    RS[I]=SinD((I-1)*9)*0.5;
}
*/
/*

char ObjF[]="FUNNELS.DAT";

void RadialArray()
{
  for(I=1; I<=60; I++)
    RS[I]=sin(sqrt(60.1-I)-0.5)*0.45+0.5;
}
*/

/*
char ObjF[]="MECHPART.DAT";

void RadialArray()
{
  for(I=1; I<=6; I++)
    RS[I]=(float)I/6*0.5+0.1;
  for(I=7; I<=20; I++)
    RS[I]=0.6;
  for(I=21; I<=32; I++)
    RS[I]=0.6+(float)(I-21)/32.0;
  for(I=33; I<=53; I++)
    RS[I]=1.0;
  for(I=54; I<=60; I++)
    RS[I]=0.1;
}
*/

/*
char ObjF[]="ROCKET.DAT";

void RadialArray()
{
  for(I=60; I>=53; I--)
    RS[I]=0.02;
  for(I=52; I>=47; I--)
    RS[I]=(float)(52-I)/52.0+0.05;
  for(I=46; I>=35; I--)
    RS[I]=0.16;
  for(I=34; I>=27; I--)
    RS[I]=(float)(34-I)/34.0+0.19;
  for(I=26; I>=5; I--)
    RS[I]=0.4;
  for(I=4; I>=1; I--)
    RS[I]=(float)(4-I)/22+0.4;
}
*/

/*
char ObjF[]="CHESPAWN.DAT";

void RadialArray()
{
  for(I=60; I>=44; I--)
    RS[I]=SinD((60-I)*9)*0.6;
  for(I=43; I>=11; I--)
    RS[I]=0.2;
  for(I=10; I>=1; I--)
    RS[I]=0.2+SinD((10-I)*12)*0.5;
}
*/

/* *********************************************************************** */

void DisplayRadialArray()
{
  for(I=1; I<=60; I++)
    Draw(260-Round(60.0*RS[I]), 150-I, 260+Round(60.0*RS[I]), 150-I, 35);
}

int Theta, DTheta, HalfDTheta;
float Zs, Dz, HalfDz;
int HorzLoop, VertLoop;

void SetupSolidOfRevolution(int Horizontal, int Vertical)
{
  VertexNum=1;
  VertexNumInFacet=1;
  HorzLoop=Horizontal;
  VertLoop=Vertical;
  LastFacet=HorzLoop*(VertLoop-1);
  LastVertexNumInFacet=MaxVertexNumInFacet;
  LastVertex=LastFacet*LastVertexNumInFacet;
  DTheta=360/HorzLoop;
  HalfDTheta=DTheta/2;
  Theta=HalfDTheta+90;
  Dz=2.0/(float)VertLoop;
  HalfDz=Dz/2.0;
  Zs=HalfDz;
}

void MakeSolidOfRevolutionDatabase()
{
  float CosThetaMinus, SinThetaMinus;
  float CosThetaPlus, SinThetaPlus;
  float ZMinus, ZPlus, x, y, z;

  FacetNum=0;
  for(I=1; I<=60; I++)
    RS[I]=0.0;
  RadialArray();
  DisplayRadialArray();
  do
  {
    I=1;
    CosThetaMinus=CosD(Theta-HalfDTheta);
    SinThetaMinus=SinD(Theta-HalfDTheta);
    CosThetaPlus=CosD(Theta+HalfDTheta);
    SinThetaPlus=SinD(Theta+HalfDTheta);
    Zs=-1.0+HalfDz;
    do
    {
      ZMinus=Zs-HalfDz;
      ZPlus=Zs+HalfDz;
      ++FacetNum;
      x=CosThetaMinus*RS[I];
      y=SinThetaMinus*RS[I];
      z=ZMinus;
      AddVertex(x, y, z);
      x=CosThetaPlus*RS[I];
      y=SinThetaPlus*RS[I];
      z=ZMinus;
      AddVertex(x, y, z);
      x=CosThetaPlus*RS[I+1];
      y=SinThetaPlus*RS[I+1];
      z=ZPlus;
      AddVertex(x, y, z);
      x=CosThetaMinus*RS[I+1];
      y=SinThetaMinus*RS[I+1];
      z=ZPlus;
      AddVertex(x, y, z);
      VertexNumInFacet=1;
      ++I;
      Zs+=Dz;
    }
    while(I!=60);
    Theta+=DTheta;
  }
  while(Theta<(360+HalfDTheta+90));
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  Facet=farcalloc(((MaxFacet+1)*(MaxVertexNumInFacet+1)), sizeof(int));
  InitVertexMaker();
  SetupSolidOfRevolution(60, 60);
  MakeSolidOfRevolutionDatabase();
  SaveData(ObjF);
  ExitGraphics();
  farfree(Facet);
}
