/* ***********************************************************************
   *									 *
   *		          Sphere Database Generator		         *
   *									 *
   *				Program by				 *
   *			   Christopher D. Watkins			 *
   *									 *
   *			     'C' conversion by				 *
   *                            Larry Sharp				 *
   *									 *
   ***********************************************************************
*/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "math.h"
#include "string.h"
#include "alloc.h"
#include "math.inc"
#include "graph.inc"
#include "model.inc"
#include "shpmk.inc"

int Theta, DTheta, HalfDTheta;
int Phi, DPhi, HalfDPhi;
int HorzLoop, VertLoop;
int Horz, Vert;
float SinPhi, CosPhi;

void SetupSphere(int Horizontal, int Vertical)
{
  VertexNum=1;
  VertexNumInFacet=1;
  HorzLoop=Horizontal;
  VertLoop=Vertical;
  LastFacet=HorzLoop*VertLoop;
  LastVertexNumInFacet=MaxVertexNumInFacet;
  LastVertex=LastFacet*LastVertexNumInFacet;
  DTheta=360/HorzLoop;
  HalfDTheta=DTheta/2;
  Theta=HalfDTheta;
  DPhi=180/VertLoop;
  HalfDPhi=DPhi/2;
  Phi=HalfDPhi;
}

void MakeSphereDatabase()
{
  Horz=1;
  Vert=1;
  for(FacetNum=1; FacetNum<=LastFacet; FacetNum++)
  {
    SinPhi=SinD(Phi+HalfDPhi);
    CosPhi=CosD(Phi+HalfDPhi);
    AddVertex(SinPhi*CosD(Theta-HalfDTheta), SinPhi*SinD(Theta-HalfDTheta), CosPhi);
    AddVertex(SinPhi*CosD(Theta+HalfDTheta), SinPhi*SinD(Theta+HalfDTheta), CosPhi);
    SinPhi=SinD(Phi-HalfDPhi);
    CosPhi=CosD(Phi-HalfDPhi);
    AddVertex(SinPhi*CosD(Theta+HalfDTheta), SinPhi*SinD(Theta+HalfDTheta), CosPhi);
    AddVertex(SinPhi*CosD(Theta-HalfDTheta), SinPhi*SinD(Theta-HalfDTheta), CosPhi);
    Theta+=DTheta;
    VertexNumInFacet=1;
    ++Horz;
    if(Horz>HorzLoop)
    {
      Horz=1;
      ++Vert;
      Theta=HalfDTheta;
      Phi+=DPhi;
    }
  }
}

/* ***********************************************************************
   *									 *
   *				Main Program				 *
   *									 *
   ***********************************************************************
*/

void main()
{
  Facet=farcalloc(((MaxFacet+1)*(MaxVertexNumInFacet+1)), sizeof(int));
  InitVertexMaker();
  SetupSphere(60, 45);
  MakeSphereDatabase();
  SaveData("SPHERE.DAT");
  ExitGraphics();
  farfree(Facet);
}
