/*===========================================================================*\
| QWIKC20.H                                                ver 2.0c, 01-06-89 |
|                                                                             |
| Header file for quick, direct screen writing for C                          |
| Copyright (c)1988-1989 James H. LeMay, All rights reserved.                 |
|                                                                             |
| Conversion to C by Jordan Gallagher/Wisdom Research                         |
|                                                                             |
| For documentation on this file see QWIKC20.DOC and QWIKREF.DOC.             |
| Only 44 bytes of global data are used.                                      |
\*===========================================================================*/

#ifndef __DOS_DEF_
#include <dos.h>                  /* DOS.H needed for MK_FP below! */
#endif

#define videomode   *(char far *)MK_FP(0x0000,0x0449) /* Video mode:
                                                         Mono=7, Color=0-3 */
#define videopage   *(char far *)MK_FP(0x0000,0x0462) /* Video page number */
#define egarows     *(char far *)MK_FP(0x0000,0x0484) /* Rows on screen
                                                         (0-based) */
#define egainfo     *(char far *)MK_FP(0x0000,0x0487) /* EGA info.
                                                         See QWIKREF.DOC */
#define egafontsize *(int far *)MK_FP(0x0000,0x0485)  /* Character cell height
                                                         (1-based) */
#define crtcolumns  *(int far *)MK_FP(0x0000,0x0044)  /* Number of CRT columns
                                                         (1-based) */

extern unsigned char system_id, /* Equipment ID.  See QWIKREF.DOC */
submodel_id,                    /* Equipment ID.  See QWIKREF.DOC */
cpuid,                       /* Model number of Intel CPU */
qvideo_mode,                 /* Video mode detected by Qwik */
qvideo_page,                 /* Video page to which Qwik is writing */
maxpage,                     /* Maximum possible page */
cardsnow,                    /* Wait-for-retrace (snow) for video card */
have_ps2,                    /* Using some type of IBM PS/2 equip */
have_3270,                   /* Using IBM 3270 PC workstation hard/software */
ega_switches,                /* EGA card and monitor setup */
active_disp_dev,             /* Active Display Device */
active_disp_dev_3270,        /* Active Display Device for IBM 3270 PC */
alt_disp_dev,                /* Alternate Display Device */
herc_model,                  /* Model of Hercules card. */
inmultask;                   /* Set to 1 if setmultitask() called in
                                multitasking environment */
extern int page0seg;         /* Segment for page 0 for video card/buffer */
extern int cardseg;          /* Segment for page 0 for video card */
extern int alt_disp_dev_pcc; /* Alt Display Device for PC Convertible */
extern int scroll_attr;      /* Attribute used to clear row in qeosln() */

typedef struct {
    void far *vscrptr;     /* Pointer to memory writes are done to */
    unsigned veosofs;      /* End Of String offset after Qwik writing */
    unsigned vsize;        /* Essentially size of CRT video buffer in bytes */
    unsigned char vrows;   /* Global variable of Rows/Ega rows (1-based!) */
    unsigned char vcols;   /* Global variable of CRT columns (1-based) */
    char vsnow;            /* Wait-for-retrace (snow) while Qwik writing */
} vscr_t;

extern vscr_t qscr;

#define crt_rows qscr.vrows
#define crt_cols qscr.vcols
#define qsnow qscr.vsnow
#define crt_size qscr.vsize
#define qeosofs qscr.veosofs
#define qscrofs *((unsigned *) (&qscr.vscrptr))
#define qscrseg *((unsigned *) (&qscr.vscrptr)+1)
#define qscrptr qscr.vscrptr

/* Constants assigned by IBM:              */
enum {
    no_display,          /* 00 through 0C, FF */
    mda_mono,
    cga_color,
    dcc3,
    ega_color,
    ega_mono,
    pgc_color,
    vga_mono,
    vga_color,
    dcc9,
    dcc10,
    mcga_mono,
    mcga_color,
    unknown = 255
};

/* Arbitrarily assigned constants: */
enum {
    no_herc,
    hgc_mono,
    hgc_plus,
    herc_incolor
};

enum {
    cpu8086,
    cpu80186,
    cpu80286,
    cpu80386
};

/* These are the foreground text colors */
#if !defined(__COLORS)
#define __COLORS

enum COLORS {
    BLACK,
    BLUE,
    GREEN,
    CYAN,
    RED,
    MAGENTA,
    BROWN,
    LIGHTGRAY,
    DARKGRAY,
    LIGHTBLUE,
    LIGHTGREEN,
    LIGHTCYAN,
    LIGHTRED,
    LIGHTMAGENTA,
    YELLOW,
    WHITE
};
#endif

/* These are the background colors */
enum {
    BLACK_BG     = 0x00,
    BLUE_BG      = 0x10,
    GREEN_BG     = 0x20,
    CYAN_BG      = 0x30,
    RED_BG       = 0x40,
    MAGENTA_BG   = 0x50,
    BROWN_BG     = 0x60,
    LIGHTGRAY_BG = 0x70
};

#define  BLINK     128   /* blink bit -- add to attribute */
#define  SAMEATTR  -1    /* supresses attribute changes to the screen */

/* The following are macros used in calling setcursor() and modcursor() */
#define cursor_on    0x0000  /* Turns cursor on with same shape */
#define cursor_off   0x2000  /* Turns cursor off with same shape */
#define cursor_blink 0x6000  /* Creates erratic blinking for many machines */

/* These cursor modes are set by qinit() as detected for the video card: */
extern int cursor_initial;         /* Cursor detected at startup */
extern int cursor_underline;       /* Standard underline cursor */
extern int cursor_halfblock;       /* Usually used for Insert editing */
extern int cursor_block;           /* For those who have to squint */

/* ----------- QINIT ----------- */
void qinit( void );
void qreinit( void );

/* ----------- QWRITES ----------- */
void qwrite(  unsigned char row, unsigned char col, int attr,
              char far *astr );
void qwritec( unsigned char row, unsigned char col, unsigned char cols,
              int attr, char far *astr );
void qwriteeos( int attr, char far *astr );

/* ----------- QWRSUB ----------- */
void qwrite_sub( unsigned char row, unsigned char col, int attr, int length,
                 char far *astr );
void qwriteeos_sub( int attr, int length, char far *astr );

/* ----------- QFILLS ----------- */
void qfill(  unsigned char row, unsigned char col, unsigned char rows,
             unsigned char cols, int attr, char ch );
void qattr(  unsigned char row, unsigned char col, unsigned char rows,
             unsigned char cols, int attr );
void qfillc( unsigned char row, unsigned char col_l, unsigned char col_r,
             unsigned char rows, unsigned char cols, int attr, char ch );
void qattrc( unsigned char row, unsigned char col_l, unsigned char col_r,
             unsigned char rows, unsigned char cols, int attr );
void qfilleos( unsigned char rows, unsigned char cols, int attr, char ch );
void qattreos( unsigned char rows, unsigned char cols, int attr );

/* ----------- QSTORES ----------- */
void qstoretomem( unsigned char row, unsigned char col, unsigned char rows,
                  unsigned char cols, void far *dest );
void qstoretoscr( unsigned char row, unsigned char col, unsigned char rows,
                  unsigned char cols, void far *src );
void qscrtovscr(  unsigned char row, unsigned char col, unsigned char rows,
                  unsigned char cols, unsigned char vrow, unsigned char vcol,
                  unsigned char vwidth, void far *vscrptr );
void qvscrtoscr(  unsigned char row, unsigned char col, unsigned char rows,
                  unsigned char cols, unsigned char vrow, unsigned char vcol,
                  unsigned char vwidth, void far *vscrptr );

/* ----------- QSCROLLS ----------- */
void qscrollup(   unsigned char row, unsigned char col, unsigned char rows,
                  unsigned char cols, int blankattr );
void qscrolldown( unsigned char row, unsigned char col, unsigned char rows,
                  unsigned char cols, int blankattr );

/* ----------- QPAGES ----------- */
void qviewpage(  char pagenum );
void qwritepage( char pagenum );

/* ----------- QREADS ----------- */
void qreadstr(  char far *astr, char row, char col, char num );
unsigned char qreadchar( unsigned char row, unsigned char col );
unsigned char qreadattr( unsigned char row, unsigned char col );

/* ----------- QEOSLN ----------- */
void qeosln( void );

/* ----------- CURSOR ----------- */
int getcursor( void );
void setcursor( int cursor );
void modcursor( int modify );
void gotorc( unsigned char row, unsigned char col );
unsigned char wherer( void );
unsigned char wherec( void );

/* ----------- EOS ----------- */
void gotoeos( void );
unsigned char eosr( void );
unsigned char eosc( void );
void eostorc( unsigned char row, unsigned char col );
void eostorcrel( int row, int col );
void eostocursor( void );
void eosln( void );

/* ----------- CPUIDENT ----------- */
void getcpuid( void );

/* ----------- GETSUBID ----------- */
void get_submodel_id( void );           /* Read docs before using! */

/* ----------- SETMULTI ----------- */
void setmultitask( void );
