/* Initializes the balls and adds them to the object list. */
#include <stdlib.h>
#include <math.h>
#include "polygon.h"

#define NUM_BALLS 1              /* # of balls to initialize */

#include "balvert0.inc" /* face and vertex definitions for ball */

/* X, Y, Z rotations for balls, in tenths of degrees (angles) */
static RotateControl InitialRotate[NUM_BALLS] = {
   {0,90,0},};
static MoveControl InitialMove[NUM_BALLS] = {
   {0,0,35,0,0,-6000,0,0,-350}, };
/* Face colors for various balls */
static int Colors[NUM_BALLS][NUM_FACES] = {
   {15,14,13,12,11,10,9,8,7,6,5,4,
    14,13,12,11,10,9,8,7,6,5,4,15,
    13,12,11,10,9,8,7,6,5,4,15,14,
    12,11,10,9,8,7,6,5,4,15,14,13,
    11,10,9,8,7,6,5,4,15,14,13,12,
    10,9,8,7,6,5,4,15,14,13,12,11,},
};
/* Starting coordinates for balls in world space */
static int BallStartCoords[NUM_BALLS][3] = {
   {30,0,-6000},
};
/* Delay counts (speed control) for balls */
static int InitRDelayCounts[NUM_BALLS] = {1};
static int BaseRDelayCounts[NUM_BALLS] = {1};
static int InitMDelayCounts[NUM_BALLS] = {1};
static int BaseMDelayCounts[NUM_BALLS] = {1};

void InitializeBalls()
{
   int i, j, k;
   PObject *WorkingBall;

   for (i=0; i<NUM_BALLS; i++) {
      if ((WorkingBall = malloc(sizeof(PObject))) == NULL) {
         printf("Couldn't get memory\n"); exit(1); }
      WorkingBall->DrawFunc = DrawPObject;
      WorkingBall->RecalcFunc = XformAndProjectPObject;
      WorkingBall->MoveFunc = RotateAndMovePObject;
      WorkingBall->RecalcXform = 1;
      for (k=0; k<2; k++) {
         WorkingBall->EraseRect[k].Left =
            WorkingBall->EraseRect[k].Top = 0x7FFF;
         WorkingBall->EraseRect[k].Right = 0;
         WorkingBall->EraseRect[k].Bottom = 0;
      }
      WorkingBall->RDelayCount = InitRDelayCounts[i];
      WorkingBall->RDelayCountBase = BaseRDelayCounts[i];
      WorkingBall->MDelayCount = InitMDelayCounts[i];
      WorkingBall->MDelayCountBase = BaseMDelayCounts[i];
      /* Set the object->world xform to none */
      for (j=0; j<3; j++)
         for (k=0; k<4; k++)
            WorkingBall->XformToWorld[j][k] = INT_TO_FIXED(0);
      WorkingBall->XformToWorld[0][0] = 
         WorkingBall->XformToWorld[1][1] =
         WorkingBall->XformToWorld[2][2] = INT_TO_FIXED(1);
      /* Set the initial location */
      for (j=0; j<3; j++) {
          WorkingBall->XformToWorld[j][3] =
                INT_TO_FIXED(BallStartCoords[i][j]);
      }
      /* Initial center coordinates */
      WorkingBall->CenterInView.X = WorkingBall->XformToWorld[0][3];
      WorkingBall->CenterInView.Y = WorkingBall->XformToWorld[1][3];
      WorkingBall->CenterInView.Z = WorkingBall->XformToWorld[2][3];
      WorkingBall->NumVerts = NUM_VERTS;
      WorkingBall->VertexList = Verts;
      WorkingBall->NumFaces = NUM_FACES;
      WorkingBall->Rotate = InitialRotate[i];
      WorkingBall->Move.MoveX = INT_TO_FIXED(InitialMove[i].MoveX);
      WorkingBall->Move.MoveY = INT_TO_FIXED(InitialMove[i].MoveY);
      WorkingBall->Move.MoveZ = INT_TO_FIXED(InitialMove[i].MoveZ);
      WorkingBall->Move.MinX = INT_TO_FIXED(InitialMove[i].MinX);
      WorkingBall->Move.MinY = INT_TO_FIXED(InitialMove[i].MinY);
      WorkingBall->Move.MinZ = INT_TO_FIXED(InitialMove[i].MinZ);
      WorkingBall->Move.MaxX = INT_TO_FIXED(InitialMove[i].MaxX);
      WorkingBall->Move.MaxY = INT_TO_FIXED(InitialMove[i].MaxY);
      WorkingBall->Move.MaxZ = INT_TO_FIXED(InitialMove[i].MaxZ);
      if ((WorkingBall->XformedVertexList =
            malloc(NUM_VERTS*sizeof(Point3))) == NULL) {
         printf("Couldn't get memory\n"); exit(1); }
      if ((WorkingBall->ProjectedVertexList =
            malloc(NUM_VERTS*sizeof(Point3))) == NULL) {
         printf("Couldn't get memory\n"); exit(1); }
      if ((WorkingBall->ScreenVertexList =
            malloc(NUM_VERTS*sizeof(Point))) == NULL) {
         printf("Couldn't get memory\n"); exit(1); }
      if ((WorkingBall->FaceList =
            malloc(NUM_FACES*sizeof(Face))) == NULL) {
         printf("Couldn't get memory\n"); exit(1); }
      /* Initialize the faces */
      for (j=0; j<NUM_FACES; j++) {
         WorkingBall->FaceList[j].VertNums = VertNumList[j];
         WorkingBall->FaceList[j].NumVerts = VertsInFace[j];
         WorkingBall->FaceList[j].Color = Colors[i][j];
      }
      AddObject((Object *)WorkingBall);
   }
}
