{
Object selection using the Tab key for the XView-PC interface
By Antonio Carlos Moreirao de Queiroz - acmq@coe.ufrj.br
Version 1.0 - 10/04/94
Version 1.0a - 30/04/94 Ctrl-Tab moves up
Version 1.0b - 24/06/94 Operation with the mouse emulator corrected

This procedure moves the mouse cursor to the next object in the active
window when the Tab key is pressed, using the "interposer".
The Shift-Tab key moves the cursor to the top of the next window.
The Return key is equivalent to the mouse left button.
To install, include this file in the program, and insert after "xv_init"
the statement: interposer:=TabKeys;
The program must use the units Mickey and XView.
}

{$I extkeys.inc}

{$F+}

PROCEDURE TabKeys;
VAR
  pto,ptw:Xv_opaque;
  mx,my:INTEGER;
BEGIN
  ptw:=active_w; pto:=nil;
  IF ie_code=kTab THEN BEGIN
    IF active_o<>nil THEN pto:=active_o^.next
    ELSE pto:=ptw^.next
  END
  ELSE IF ie_code=kShiftTab THEN ptw:=ptw^.over
  ELSE IF ie_code=kCr THEN BEGIN
    ie_code:=MS_LEFT;
    Exit
  END
  ELSE Exit;
  IF pto=nil THEN BEGIN
    mx:=ptw^.x+ptw^.dx div 2;
    my:=ptw^.y+mrgy div 2;
    open_window(ptw);
  END
  ELSE BEGIN
    mx:=ptw^.x+mrgx+pto^.x+pto^.dx div 2;
    my:=ptw^.y+mrgy+pto^.y+pto^.dy div 2;
  END;
  mouse_move(mx,my);
END;

{$F-}
