;	SOUNDBAS.ASM
;
;	Marc Savary, Editions Ad Lib., 3-06-87
;
;	assembler interface to the Sound Driver for Basic programs
;
;	This code should be included in a Basic array and used with the CALL
;	command :	func = VARPTR (array(0)): CALL func(s0,s1,s2, ....)
;


sound_driver_int	equ	101			; SD interrrupt number

fSDInit		equ	0
fSDRelTimeStart	equ	2
fSDSetState	equ	3
fSDGetState	equ	4
fSDFlush	equ	5
fSDSetMode	equ	6
fSDGetMode	equ	7
fSDSetRelVolume	equ	8
fSDSetTempo	equ	9
fSDSetTranspose	equ	10
fSDGetTranspose	equ	11
fSDSetActVoice	equ	12
fSDGetActVoice	equ	13
fSDPlayNoteDel	equ	14
fSDPlayNote	equ	15
fSDSetTimbre	equ	16
fSDSetPitch	equ	17
fSDSetTickBeat	equ	18
fSDNoteOn	equ	19
fSDNoteOff	equ	20
fSDTimbre	equ	21


Code	SEGMENT	BYTE
	assume cs:code
		

;	SoundBasic( s0, s1, s2, s3, s4, s5)
;	int * s0, * s1, * s2, * s3, * s4, * s5;
;
;	s0:	 	function number
;	s1 - s5:	arguments
;
;	return result in s0.
;
SoundBasic PROC FAR
	   PUBLIC SoundBasic
frames STRUC
	dw	?		; old di
	dw	?		; old si
old_es	dw	?		; old ES
	dd	?		; return addr
s5	dw	?		; ptrs to s5 argument
s4	dw	?		; ....  s4
s3	dw	?
s2	dw	?
s1	dw	?
s0	dw	?		; .. ptr to function number

frames ENDS

	push	es
	push	si
	push	di
	mov	bp, sp
	mov	bx, [bp].s0
	mov	si, [bx]		; get function number
	
	mov	bx, [bp].s5
	push	[bx]
	mov	bx, [bp].s4
	push	[bx]
	mov	bx, [bp].s3
	push	[bx]
	mov	bx, [bp].s2
	push	[bx]
	cmp	si, fSDSetTimbre	; s1 is a pointer ??
	jne	suite
	push	ds			; we need a Far prt ...
	push	[bp].s1
	jmp	ok
suite:	mov	bx, [bp].s1
	push	[bx]
ok:	push	ss			; set ES:BX to point to list of arg.
	pop	es
	mov	bx, sp
	int	sound_driver_int
	mov	sp, bp

	mov	bx, [bp].s0		; store return value in S0
	mov	[bx], ax
	pop	di
	pop	si
	pop	es
	ret	12			; 6 words arguments
SoundBasic ENDP


Code	ENDS
	END
	

