PROGRAM Example2;

{Demonstrates using scrolling backgrounds}

USES ANIVGA,CRT;
CONST Tile_Name='tile2.COD';    {4 simple tiles}
      Sprite_Name='flower.COD';

VAR ch:Char;
    i,j:Integer;
    temp:WORD;
    collide:BOOLEAN;

PROCEDURE Init;
VAR gx,gy,count:INTEGER;
BEGIN
 XTiles:=0; YTiles:=0;
 SetBackgroundMode(scrolling);
 SetBackgroundScrollRange(-500,-500,100,100);

 {paste tiles into this background, using circular enumeration 0,1,2,3,0,...}
 count:=0;
 gy:=BackY1;
 REPEAT
  gx:=BackX1;
  REPEAT
   PutTile(gx,gy,count);
   inc(count); count:=count mod 4;
   inc(gx,16);
  UNTIL gx>BackX2;
  inc(gy,16);
 UNTIL gy>BackY2;

 {Set SPRITEAD[10]:}
 IF loadSprite(Sprite_Name,10)=0
  THEN BEGIN
        WRITELN(GetErrorMessage); halt(1)
       END;
END;

BEGIN
 Init;
 InitGraph;
 temp:=LoadTile(Tile_Name,0); {load the 4 tiles & give them the numbers 0..3}
 IF Error<>Err_None
  THEN BEGIN
        CloseRoutines;
        WRITELN(GetErrorMessage); halt(1)
       END;

 SetCycleTime(0); {animation as fast as possible}

 SpriteN[0]:=10; SpriteX[0]:=0;   SpriteY[0]:=0;
 SpriteN[5]:=10; SpriteX[5]:=100; SpriteY[5]:=100;

 WHILE keypressed DO ch:=readkey;
 Animate;
 REPEAT
  collide:=Hitdetect(0,5);
  IF collide THEN BEGIN sound(1000); delay(5); nosound END;
  if KeyPressed
   THEN BEGIN
         WHILE KeyPressed DO ch:=Upcase(ReadKey);
         CASE ch OF
          'I':dec(SpriteY[0]);  {change position of sprite with I,J,K,M}
          'J':dec(SpriteX[0]);
          'K':inc(SpriteX[0]);
          'M':inc(SpriteY[0]);
          'E':dec(StartVirtualY,10);  {change position of whole scene with}
          'S':dec(StartVirtualX,10);  {E,S,D,X}
          'D':inc(StartVirtualX,10);
          'X':inc(StartVirtualY,10);
         END;
         IF POS(ch,'IJKMESDX')>0 THEN Animate;
        END;

 UNTIL ch='Q';  {"Q" to quit}

 CloseRoutines;

END.