;BIOSFIO.ASM (C) Copyright 1994 Gertjan Klein
;
;BIOS File I/O is a sample program demonstrating the use of only BIOS calls
; to perform File I/O. It displays the contents of a file you specify on the
; commandline, residing on the first bootable, DOS 16 bit FAT partition on
; the first physical hard disk. It does no writes, and is therefore harmless
; even if malfunctioning. It assembles under TASM 2.0, but can easily be
; modified to assemble under MASM 5.1. Other assemblers are untested.
;
;The program makes some assumptions that should not be made when coding a
; "real-world" program. It does not check for corrupted FAT's, for example.
; The program should be seen only as a coding example; no fitness for any
; particular purpose is guaranteed. The output of the program is done via BIOS
; function 0eh, in the subroutine 'Displ'. This routine can be easily modified
; to use DOS function 40h to display the output, making it redirectable to a
; file (in fact, that is what I did during debugging).
;
;It should also be noted that no attempt has been made to optimise the code
; for size, speed, or whatever. Especially when displaying large files, it
; would be beneficial to keep, for example, the last accessed FAT sector in
; memory, since it is likely to be accessed again soon. One could also try
; to do multi-sector transfers, if possible.
;
;Though the source code in this file is copyrighted, it can be used freely by
; anyone. If substantial portions of the code are copied into another program,
; credits should be given to me in an accompanying text file.
;
;I do appreciate any comments, bug reports or whatever you might want to
; tell me. I can be reached on Fidonet at address 2:280/901.14
;                      and at Internet at address gklein@hacktic.nl
;
;Version 1.1 is updated to allow for 12-bit cylinder numbers, where
; bit 11-10 are merged into the upper two bits of the head number.
;Version 1.2 fixes a bug in the GetSect routine (and ah,0f0h -> and ah,0c0h)
; giving trouble with cylinder numbers greater then 256. It removes the 512
; byte sectors assumption. It also has reorganised and expanded code to allow
; FAT- and directory searching, and the specification of a filename on the
; commandline.

;********************************************************************

;General equates:
os      equ     offset
bptr    equ     byte ptr
wptr    equ     word ptr
eom     equ     13,10,'$'

_pe     STRUC                   ;Structure of Partition Table Entry
        boot    db      ?       ;Boot flag: 80h = active, 0 = not active
        head    db      ?       ;Start head number
        seccyl  dw      ?       ;Start sector and cylinder number
        sys     db      ?       ;System code
        hdend   db      ?       ;End head number
        scend   dw      ?       ;End sector and cylinder number
        start   dd      ?       ;Start relative sector number
        psize   dd      ?       ;Total number of sectors
_pe     ENDS

_bpb    STRUC                   ;Structure of BIOS Parameter Block
        secsiz  dw      ?       ;Number of bytes per sector
        clust   db      ?       ;Number of sectors per cluster
        ressec  dw      ?       ;Number of (reserved) sectors before FAT 1
        fatcnt  db      ?       ;Number of FAT's
        rootsiz dw      ?       ;Number of 32-byte root dir entries
        totsect dw      ?       ;Total number of sectors in partition
        mdb     db      ?       ;Media descriptor byte
        fatsiz  dw      ?       ;Number of sectors per FAT
        spt     dw      ?       ;Number of sectors per track
        heads   dw      ?       ;Number of heads
        hidsect dd      ?       ;Number of hidden sectors
        lrgtot  dd      ?       ;Large total number of sectors (if totsect = 0)
_bpb    ENDS

_iopb   STRUC                   ;Disk I/O Parameter Block (for GetSect call)
        snr     dd      ?       ;Sector number of first sector to read/write
        nrs     dw      ?       ;Number of sectors to read/write
        buf_os  dw      ?       ;Offset of buffer
        buf_seg dw      ?       ;Segment of buffer
_iopb   ENDS

_de     STRUC                   ;Structure of directory entry
        fname   db      8 dup (?)  ;Filename, blank padded
        ext     db      3 dup (?)  ;File extention, blank padded
        attr    db      ?       ;Attribute
        rsvd    db      10 dup (?) ;Reserved
        de_time dw      ?       ;File time
        de_date dw      ?       ;File date
        de_strt dw      ?       ;First cluster number of file
        fsiz    dd      ?       ;File size in bytes
_de     ENDS

;********************************************************************

        .MODEL TINY
        .CODE
        ORG     100h

main            proc    far

        mov     sp,os stktop            ;Initialise stack pointer
        cmp     bptr [ds:80h],0         ;Any commandline parameters?
        jnz     M1                      ; yes: go on
Merr0:
        mov     dx,os usage             ; no: tell user usage
Merr:
        mov     ah,9                    ;DOS display string function
        int     21h
        mov     ax,4c01h                ; and back to DOS
        int     21h
M1:
        mov     [iopb.buf_os],os sbuff  ;Initialise buffer address in disk I/O
        mov     [iopb.buf_seg],ds       ; parameter block to sbuff
        mov     [iopb.nrs],1            ;Initialise nr of sectors to r/w to 1
        call    GetParms                ;Get parameters of drive/partition
        mov     dx,os msg1              ;(assume error)
        jc      Merr                    ; error: tell user and exit
        call    NextName                ;Find directory or file name
        call    SearchRoot              ;Find it in the root directory
        jnc     M2                      ;Found: go on
Merr4:
        mov     dx,os msg4              ;Tell user filename not found
        mov     ah,9                    ;DOS display string function
        int     21h
        mov     bx,[clpptr]             ;Get ptr to last byte processed
        mov     bptr [bx],'$'           ;Place string terminator
        mov     dx,82h                  ;Get ptr to start of dir/filename
        mov     ah,9                    ;DOS display string function
        int     21h
        mov     dx,os crlf              ;Terminate line
        jmp     short Merr              ;Display and exit
Merr2:
        mov     dx,offset msg2          ;Tell user error reading drive
        jmp     Merr                    ;Display and exit
M2:
        push    si                      ;Save pointer to direntry
        add     si,1ch                  ;Point to filesize entry
        mov     di,os fsize             ;Place to keep it
        mov     cx,2                    ;Copy two words
        rep     movsw                   ;Save filesize
        pop     si                      ;Get pointer to direntry back
        mov     ax,[si.de_strt]         ;Get first cluster number
        mov     [clust1],ax             ;Save it
        mov     [cclust],ax             ;Save as current cluster number too
        cmp     [isdir],0               ;Do we expect this to be the file?
        jz      M3                      ; yes: go on
        call    NextName                ; no: get next name to look for
        call    SearchDir               ;Search this directory for it
        jc      Merr4                   ;Not found: error, tell user and exit
        jmp     short M2                ;Check this one out
M3:
        test    [si.attr],10h           ;Is this a directory?
        jz      M3a                     ; no: file, go on
        mov     dx,os msg5              ; yes: error, tell user
        jmp     short Merr              ;Display and exit
M3a:
        mov     wptr [fread],0          ;Clear the bytes read counter
        mov     wptr [fread+2],0
Mloop1:
        call    Clust2Sect              ;Calculate sector number from cluster
        mov     cl,[bpb.clust]          ;Get number of sectors per cluster
        xor     ch,ch                   ;Make it word size for counter
        mov     bx,os sbuff             ;Get offset of sector buffer in BX
Mloop2:
        call    GetSect                 ;Go read the sector
        jc      Merr2                   ;On errors: tell user and exit
        mov     ax,[bpb.secsiz]         ;Get sector size
        add     wptr [fread],ax         ;Update the bytes read counter
        adc     wptr [fread+2],0
        mov     ax,wptr [fsize]         ;Get file size
        mov     dx,wptr [fsize+2]
        cmp     dx,wptr [fread+2]       ;Check if all is read yet
        jb      M4                      ; no: go on
        cmp     ax,wptr [fread]
        jbe     M5                      ; yes: go on
M4:
        mov     ax,[bpb.secsiz]         ;Get number of bytes to display
        call    Displ                   ; and display them
        add     wptr [iopb.snr],1       ;Increase sector number
        adc     wptr [iopb.snr+2],0
        loop    Mloop2                  ; and read next sector of cluster
        call    NextClust               ;Get next cluster number in 'cclust'
        jmp     short Mloop1            ;Get and display next sectors
M5:
        add     ax,[bpb.secsiz]         ;Calculate number of bytes left to
        sub     ax,wptr [fread]         ; display
        call    Displ                   ;Display the last bytes
        mov     ax,4c00h                ;Back to DOS with errorlevel 0
        int     21h

main            endp

;********************************************************************

GetParms        proc    near
;This procedure tries to find a primary, bootable, DOS 16-bit FAT
; partition. If it finds one, it saves the partition entry and the boot
; sector data (Bios Parameter Block), and calculates some other values. It
; preserves no registers.

        mov     ax,0201h                ;Read one sector
        mov     cx,1                    ; track 0, sector 1 (master boot rec)
        mov     dx,80h                  ; head 0, drive 80h
        mov     bx,os sbuff             ; ES:BX points to buffer
        call    BiosRW                  ;Read it
        jnc     Gp1                     ;No errors: go on
        mov     al,1                    ;Code 1 = can't read master boot record
        ret
Gp1:
        mov     si,os sbuff + 1beh      ;Get ptr to first partition entry
GpNext:
        test    [si.boot],80h           ;Is it bootable?
        jnz     Gp2                     ; yes: go on
        add     si,10h                  ; no: point to next partition entry
        cmp     si,os sbuff + 1feh      ;Did we check all four partitions?
        jne     GpNext                  ; no: go check this one
        mov     al,2                    ; yes: code 2 = can't find boot part.
        stc                             ;Indicate error to caller
        ret                             ; and return
Gp2:
        cmp     [si.sys],4              ;16-bit FAT, < 32 MB, DOS partition?
        jz      Gp3                     ; yes: go on
        cmp     [si.sys],6              ;16-bit FAT, >= 32 MB, DOS partition?
        jz      Gp3                     ; yes: go on
        mov     al,3                    ;Code 3 = Not 16-bit FAT DOS bootable
        stc                             ;Indicate error to caller
        ret                             ; and return
Gp3:
        mov     di,os pentry            ;Get start of partition entry buffer
        mov     cx,10h                  ; and copy all of it
        rep     movsb
        mov     di,os pentry            ;Get ptr to part. entry buffer again
        mov     ax,0201h                ;Start reading partition boot sector
        mov     cx,[di.seccyl]          ;Start sector and cylinder
        mov     dh,[di.head]            ;Start head
        mov     dl,80h                  ;First harddisk
        mov     bx,os sbuff             ;ES:BX points to buffer
        call    BiosRW                  ;Read it
        jnc     Gp4                     ;No errors: go on
        mov     al,4                    ;Code 4 = Can't read part. boot sector
        ret
Gp4:
        mov     si,os sbuff + 0bh       ;Let's save the BIOS Parameter Block
        mov     di,os bpb               ; in our data space
        mov     cx,size _bpb            ; for later use
        rep     movsb
        mov     ax,[bpb.fatsiz]         ;Get number of sectors/fat
        mov     cl,[bpb.fatcnt]         ;Get number of FATs
        xor     ch,ch                   ;Make it word size
        mul     cx                      ; and multiply them
        add     ax,[bpb.ressec]         ;Add sectors before first FAT
        adc     dx,0
        mov     wptr [rootdir],ax       ;Save the first sector of root dir
        mov     wptr [rootdir+2],dx
        mov     wptr [fdata],ax         ;Save it as first data sector too
        mov     wptr [fdata+2],dx       ; (will be updated furtheron)
        mov     ax,[bpb.secsiz]         ;Get number of bytes per sector
        mov     dx,0                    ;Make it dword size
        mov     cx,32                   ;Get number of bytes per dir entry
        div     cx                      ;Calc nr of entries per sector
        mov     cx,ax                   ;Move them to CX
        mov     ax,[bpb.rootsiz]        ;Get nr of 32-byte root dir entries
        div     cx                      ;Calc nr of root dir sectors
        mov     [rsects],ax             ;Save that number
        add     wptr [fdata],ax         ;Update first data sector number
        adc     wptr [fdata+2],0
        clc                             ;Indicate success
        ret                             ;Return to caller

GetParms        endp

;********************************************************************

GetSect         proc    near
;This procedure translates a logical sector number to the appropriate BIOS
; sector/head/track values, and then calls BiosRW. It expects ES:BX to hold
; the buffer address. It preserves all registers.

        push    ax                      ;Save registers used
        push    bx
        push    cx
        push    dx
        push    bx                      ;Save buffer offset
        mov     ax,wptr [iopb.snr]      ;Get number of sector to read
        mov     dx,wptr [iopb.snr+2]    ; in DX:AX
        add     ax,wptr [bpb.hidsect]   ;Add number of hidden sectors
        adc     dx,wptr [bpb.hidsect+2] ; to get really absolute sector nr :-)
        mov     bx,[bpb.spt]            ;Get number of sectors per track
        call    divl                    ;Get sector number (remainder)
        inc     bx                      ; make it 1-based
        push    bx                      ; and save it
        mov     bx,[bpb.heads]          ;Get number of heads
        call    divl                    ;Get head number (remainder)
        mov     dh,bl                   ;Move it to DH for BIOS call
        push    ax                      ;Save the upper 4 bits of cylinder nr
        mov     cl,4                    ;Initialise shift count
        shl     ah,cl                   ;Merge the upper two of them into
        and     ah,0c0h                 ; high two bits of head number
        or      dh,ah
        pop     ax                      ;Get 4 upper bits of cylinder back
        mov     cl,6                    ;Initialise shift count
        shl     ah,cl                   ;Merge lower two of them into
        pop     bx                      ; high two bits of sector number
        add     ah,bl
        mov     cl,ah                   ;Place in CL for BIOS call
        mov     ch,al                   ;Get cylinder nr in CH for BIOS call
        mov     dl,80h                  ;Drive nr
        mov     ax,0201h                ;Read 1 sector
        pop     bx                      ;Restore buffer offset
        call    BiosRW                  ;Read the sector
        pop     dx                      ;Restore registers used
        pop     cx
        pop     bx
        pop     ax
        ret                             ;Return to caller

;Note that the requested number of sectors (iopb.nrs) is ignored here, only
; one sector is read.

GetSect         endp

;********************************************************************

BiosRW          proc    near
;This procedure takes care of the retries when reading or writing with BIOS
; int 13h. It expects all registers to be setup for the appropriate int 13h
; call. They will be returned unmodified.

        push    ax                      ;Save values in case of retry
        push    bx
        push    cx
        push    dx
        push    bp                      ;Set up stack frame
        mov     bp,sp

        mov     [retries],10            ;Set up for 10 retries
Br1:
        int     13h                     ;Read/write the sector(s)
        jnc     BrDone                  ;No errors: go on
BrRetry1:
        dec     [retries]               ;Errors: decrement retries count
        jnz     BrRetry2                ; not yet zero: go reset disk and retry
        stc                             ; zero: indicate error
        jmp     short BrDone            ; and go back to caller
BrRetry2:
        xor     ah,ah                   ;Reset disk
        mov     dl,[bp+2]
        int     13h                     ;(Disk BIOS)
        jc      BrRetry1                ;On error: go decrement retries
        mov     ax,[bp+8]               ;Get old AX value
        mov     bx,[bp+6]               ;Get old BX value
        mov     cx,[bp+4]               ;Get old CX value
        mov     dx,[bp+2]               ;Get old DX value
        jmp     short Br1               ;Go read/write the sector(s)
BrDone:
        pop     bp
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret

BiosRW          endp

;********************************************************************

divl            proc    near
;This procedure divides a long integer in DX:AX by the number in BX. The
; result is returned in DX:AX, the remainder in BX. It uses the div
; instruction only when absolutely sure no divide overflow can happen,
; otherwise a division algorithm is used. It preserves all other registers.

        or      dx,dx                   ;Could normal div overflow?
        jnz     divl1                   ; yes: go do long division
        or      bx,bx                   ;Divide-by-zero?
        jz      divl1                   ; yes: long div. can handle that, too
        div     bx                      ;DIV leaves quotint in AX, remainder
        mov     bx,dx                   ; in DX; move the latter to BX
        xor     dx,dx                   ;Clear high half of new 32-bit quotint
        ret                             ; and return to caller
divl1:
        push    cx                      ;Save registers used
        push    di
        mov     di,bx                   ;Save divisor in di
        mov     cx,32                   ;Divide 32 bits
        xor     bx,bx                   ;Clear remainder register
divl2:
        shl     ax,1                    ;Shift left BX:DX:AX, witch means
        rcl     dx,1                    ; shift one bit of number DX:AX into
        rcl     bx,1                    ; the remainder/subtraction register.
                                        ; As the number is shifted out of DX:AX,
                                        ; the result is shifted in.
        cmp     bx,di                   ;Is remainder larger than divisor?
        jb      divl3                   ; no: go shift in one more bit
        sub     bx,di                   ; yes: subtract divisor from remainder
        inc     ax                      ; and set corresponding bit in result
divl3:
        loop    divl2
        pop     di                      ;Restore registers used
        pop     cx
        ret

divl            endp

;********************************************************************

SearchRoot      proc    near
;This procedure searches the root directory for the filename in 'dname'.
; It returns carry set if the name is not found, otherwise SI will point
; to the corresponding direntry. It destroys SI, all other registers are
; preserved.

        push    ax                      ;Save registers used
        push    bx
        push    cx
        push    dx
        mov     ax,wptr [rootdir]       ;Get first sector number of root dir
        mov     dx,wptr [rootdir+2]
        mov     wptr [iopb.snr],ax      ;Save sector number in disk I/O
        mov     wptr [iopb.snr+2],dx    ; parameter block
        mov     ax,os sbuff             ;Get start of buffer
        add     ax,[bpb.secsiz]         ;Calculate end of buffer (1 sect)
        mov     [buftop],ax             ;Save the buffer top
        mov     bx,os sbuff             ;Get offset of sector buffer in BX
        mov     cx,[rsects]             ;Get nr of root dir sectors in CX
Srloop1:
        push    cx                      ; and save it temporarily
        call    GetSect                 ;Get the first root dir sector
        pop     cx                      ;Get saved CX back
        jnc     Sr1                     ; no errors: go on
        jmp     Merr2                   ;Errors: display and exit
Sr1:
        call    FindName                ;Search for this name in root sect
        jz      Sr2                     ;Last entry found: done searching
        jnc     Sr3                     ;Filename found: go on
        add     wptr [iopb.snr],1       ;Point to next sector
        adc     wptr [iopb.snr+2],0
        loop    Srloop1                 ; and go get next sector
Sr2:
        stc                             ;Indicate filename not found
Sr3:
        pop     dx                      ;Restore registers used
        pop     cx
        pop     bx
        pop     ax
        ret                             ;Return to caller

SearchRoot      endp

;********************************************************************

SearchDir       proc    near
;This procedure searches a directory for the filename in 'dname'.
; It returns carry set if the name is not found, otherwise SI will point
; to the corresponding direntry. It destroys SI, all other registers are
; preserved.

        push    ax                      ;Save registers used
        push    bx
        push    cx
        push    dx
        mov     al,[bpb.clust]          ;Get number of sectors per cluster
        xor     ah,ah                   ;Make it word size
        mul     [bpb.secsiz]            ;Calculate number of bytes in cluster
        add     ax,os sbuff             ;Calculate 'buftop'
        mov     [buftop],ax             ; and save it
Sd1:
        call    ReadClust               ;Read in the first cluster of the dir
        call    FindName
        jz      SdErr                   ;Last entry and name not found: error
        jnc     SdEnd                   ;Name found: exit
        call    NextClust               ;Calculate next cluster number
        cmp     [cclust],0ffffh         ;Last one in dir?
        jnz     Sd1                     ; no: load and search it
SDErr:
        stc
SdEnd:
        pop     dx                      ;Restore registers used
        pop     cx
        pop     bx
        pop     ax
        ret                             ;Return to caller

SearchDir       endp

;********************************************************************

NextClust       proc    near
;This procedure uses the cluster number in 'cclust' as an index in the
; FAT to get the next cluster number. This is returned in 'cclust' also.
; It reads in the appropriate FAT sector to get the value. All registers
; are preserved.

        push    ax                      ;Save registers used
        push    bx
        push    cx
        push    dx
        mov     bx,[bpb.secsiz]         ;Get number of bytes per sector
        shr     bx,1                    ;Calc nr of 16-bit entries per sector
        xor     dx,dx                   ;Initialise high part of cluster nr
        mov     ax,[cclust]             ;Get current cluster number in AX
        div     bx                      ;Calc FAT sector nr/offset
        shl     dx,1                    ;Make offset in sector byte size
        mov     cx,dx                   ;Save it in cx
        xor     dx,dx                   ;Make sector nr dword size
        add     ax,[bpb.ressec]         ;Add number of first FAT sector
        adc     dx,0
        mov     wptr [iopb.snr],ax      ;Save in disk I/O parameter block
        mov     wptr [iopb.snr+2],dx
        mov     bx,os sbuff             ;Get offset of buffer
        call    GetSect                 ; and read sector
        jnc     Nc1                     ;All went well: go on
        jmp     Merr2                   ;Errors: tell user and exit
Nc1:
        mov     bx,cx                   ;Get offset in sector to BX
        mov     ax,[os sbuff + bx]      ;Get next cluster number
        mov     [cclust],ax             ; and save it again
        pop     dx                      ;Restore registers used
        pop     cx
        pop     bx
        pop     ax
        ret                             ;Return to caller

NextClust       endp

;********************************************************************

Clust2Sect      proc    near
;This procedure calculates the first sector number for the cluster in
; 'cclust', and places it in the disk I/O parameter block. It preserves all
; registers.

        push    ax                      ;Save registers used
        push    bx
        push    dx
        mov     ax,[cclust]             ;Get cluster number
        sub     ax,2                    ;Start calculating sector number
        mov     bl,[bpb.clust]          ;Get number of sectors in cluster
        xor     bh,bh                   ; make it word size, to calculate
        mul     bx                      ; sector nr relative to first data sect
        add     ax,wptr [fdata]         ;Add number of first data sector to get
        adc     dx,wptr [fdata+2]       ; int 25h-like sector number
        mov     wptr [iopb.snr],ax      ;Save requested sector in disk I/O
        mov     wptr [iopb.snr+2],dx    ; parameter block
        pop     dx                      ;Restore registers used
        pop     bx
        pop     ax
        ret                             ;Return to caller

Clust2Sect      endp

;********************************************************************

ReadClust       proc    near
;This procedure reads in all the sectors of the requested cluster in
; 'cclust'. All registers return unmodidfied.

        push    ax                      ;Save registers used
        push    bx
        push    cx
        push    dx
        mov     ax,[cclust]             ;Get requested cluster number
        call    Clust2Sect              ;Calculate sector number from cluster
        mov     cl,[bpb.clust]          ;Get number of sectors per cluster
        xor     ch,ch                   ;Make it word size for counter
        mov     bx,os sbuff             ;Get offset of sector buffer in BX
Rcloop1:
        call    GetSect                 ;Go read the sector
        jnc     Rc1                     ;No errors: go on
        jmp     Merr2                   ;On errors: tell user and exit
Rc1:
        add     bx,[bpb.secsiz]         ;Update buffer pointer
        add     wptr [iopb.snr],1       ;Increase sector number
        adc     wptr [iopb.snr+2],0
        loop    Rcloop1                 ; and read next sector of cluster
        pop     dx                      ;Restore registers used
        pop     cx
        pop     bx
        pop     ax
        ret                             ;Return to caller

ReadClust       endp

;********************************************************************

Displ           proc    near
;Displays the number of bytes in AX from the sectorbuffer 'sbuff'. It
; alters no registers. Alternatively, a routine is provided displaying
; the bytes via DOS to stdout, allowing redirection.

        push    ax                      ;Save registers used
        push    bx
        push    cx
        push    si
        mov     cx,ax                   ;Number of bytes to display to CX
        xor     bh,bh                   ;Write to video page 0
        mov     si,os sbuff             ;Get pointer to sector buffer
Dloop1:
        mov     ah,0eh                  ;BIOS TTY function
        lodsb                           ;Get character to display
        int     10h                     ;(BIOS)
        loop    Dloop1                  ;Display next character
        pop     si                      ;Restore registers used
        pop     cx
        pop     bx
        pop     ax
        ret

Displ           endp

;********************************************************************

Nextname        proc    near
;This procedure parses the commandline. It assumes it to be a full path
; from the root directory to a file. If errors are found in the path or
; filename, it exits to DOS with an appropriate message. Otherwise, it
; returns the next directory name in the path. It returns 'isdir' = 1 if the
; returned name is a directory, if it is the file 'isdir' = 0.

        push    ax                      ;Save registers used
        push    cx
        push    si
        push    di
        mov     si,[clpptr]             ;Get saved pointer back
        cmp     si,80h                  ;Is this our first run?
        jnz     Nn2                     ; no: go on
Nn1:
        inc     si                      ; yes: start scanning off blanks
        cmp     bptr [si],20h           ;Pointing to space?
        jz      Nn1                     ; yes: keep on scanning
        cmp     bptr [si],9             ;Pointing to tab?
        jz      Nn1                     ; yes: keep on scanning
        cmp     bptr [si],0dh           ;End of commandline?
        jnz     Nn2                     ; no: we found our first name
        jmp     Merr0                   ; yes: no arguments, explain usage
Nn2:
        lodsb                           ;Get the byte in AL
        cmp     al,'\'                  ;Must always start with backslash
        jnz     NnErr                   ; it isn't: error
Nn3:
        mov     di,os dname             ;Set up for copy
        mov     cx,8                    ; of 8 bytes filename
NnLoop1:
        lodsb                           ;Get byte
        call    CheckChar               ;Check what kind of char
        jc      NnDot                   ;If dot: go on
        js      NnSl                    ;If backslash: go on
        jz      NnLast                  ;If end-of-commandline: go on
        call    ToUpper                 ;None of these: convert to uppercase
        stosb                           ; and copy the byte
        loop    NnLoop1                 ; and get next one
        lodsb                           ;All bytes copied, must be '.' or '\'
        call    CheckChar               ;Check what kind it is
        jc      NnDot3                  ;If dot: OK, go on
        js      NnSl                    ;If backslash: OK, go on
        jnz     NnErr                   ;Not end of line: 8+ byte name, error
NnLast:
        cmp     cx,8                    ;Is this empty filename? (Check only
        jz      NnErr                   ; needed coming from NnLoop1 loop)
        add     cx,3                    ;No extention, so blank it too
NnLast1:
        mov     [isdir],0               ;Indicate this is the file
        jmp     short NnFill            ;Fill name with spaces and return
NnSl:
        cmp     cx,8                    ;No chars between backslashes?
        jz      Nn3                     ; no: we'll allow (ignore) this
NnSl1:
        mov     [isdir],1               ;Remember a dir found
        add     cx,3                    ;No extention, so blank it too
NnFill:
        mov     al,' '                  ;Fill dirname with spaces
        rep     stosb
        dec     si                      ;Point SI to backslash again
        mov     [clpptr],si             ;Save current commandline pointer
        jmp     NnEnd                   ;Return to caller
NnDot:
        cmp     cx,8                    ;Is this a dot dir?
        jnz     NnDot2                  ; no: normal file/dir with extention
        stosb                           ; yes: store the dot
        dec     cx                      ;Remember one byte copied
        lodsb                           ;Get next byte
        cmp     al,'.'                  ;Dot-dot file?
        jnz     NnDot1                  ; no: go on
        stosb                           ; yes: store this one too
        dec     cx                      ;Remember one byte copied
        lodsb                           ;Get next byte
NnDot1:
        cmp     al,'\'                  ;This MUST be a backslash
        jz      short NnSl1             ; it is: go fill up with spaces
NnErr:
        mov     dx,os msg3              ;Tell user error in path
        jmp     Merr
        jnz     NnErr                   ; it isn't: error
NnDot2:
        mov     al,' '                  ;Fill up rest of filename with
        rep     stosb                   ; spaces
NnDot3:
        mov     cx,3                    ;Copy max 3 bytes
NnLoop2:
        lodsb                           ;Get first char of extention
        call    CheckChar               ;Check what kind of char
        jc      NnErr                   ;If dot: error
        js      NnFill                  ;If backslash: dir, fill rest of name
        jz      NnLast1                 ;If end-of-commandline: file, go on
        call    ToUpper                 ;None of these: convert to uppercase
        stosb                           ; and copy the byte
        loop    NnLoop2                 ; and get next one
        lodsb                           ;All bytes copied, must be '\' or eol
        call    CheckChar               ;Check what kind it is
        jc      NnErr                   ;If dot: error
        js      NnFill                  ;If backslash: OK, go on
        jnz     NnErr                   ;Not end of line: 3+ byte ext., erro
        mov     [isdir],0               ;Indicate this is the file
NnEnd:
        pop     di                      ;Restore registers used
        pop     si
        pop     cx
        pop     ax
        ret                             ;Return to caller

Nextname        endp

;********************************************************************

CheckChar       proc    near
;This procedure checks the character in al.
; It returns:  if AL = '\': SF = 1, CY = 0, ZR = 0
;              if AL = '.': SF = 0, CY = 1, ZR = 0
;              if AL = 0dh: SF = 0, CY = 0, ZR = 1
;              else       : SF = 0, CY = 0, ZR = 0
;No registers are altered.

        push    ax                      ;Save register used
        cmp     al,'\'                  ;Backslash?
        jnz     Cc1                     ; no: go on
        or      al,80h                  ;Set sign, clear carry/zero flags
        jmp     short CcEnd             ; and restore register/return
Cc1:
        cmp     al,'.'                  ;Dot?
        jnz     Cc2                     ; no: go on
        add     al,(101h - 0dh)         ;Set carry, clear zero/sign flags
        jmp     short CcEnd             ; and restore register/return
Cc2:
        cmp     al,0dh                  ;End-of-line?
        jnz     Cc3                     ; no: go on
        xor     al,al                   ;Set zero, clear carry/sign flags
        jmp     short CcEnd             ; and restore register/return
Cc3:
        xor     al,al                   ;Clear carry and sign flags
        inc     al                      ;Clear zero flag
CcEnd:
        pop     ax                      ;Restore register used
        ret                             ;Return to caller

CheckChar       endp

;********************************************************************

ToUpper         proc    near
;This procedure uppercases lower case characters in AL.

        cmp     al,'a'                  ;Check his character
        jb      TuEnd                   ;Not lowercase: done
        cmp     al,'z'                  ;Check character
        ja      TuEnd                   ;Not lowercase: done
        and     al,NOT 20h              ;Uppercase the character
TuEnd:
        ret

ToUpper         endp

;********************************************************************

FindName        proc    near
;This procedure tries to find the name in 'dname' in a directory. It
; expects to find the directory (or part of it) in 'sbuff'.
;It returns: if not found       : CY = 1, ZR = 0
;            if last entry found: CY = 0, ZR = 1
;            else               : CY = 0, ZR = 0 and si -> entry.
;The buffer is assumed to end at 'buftop'. SI is destroyed.

        push    ax                      ;Save registers used
        push    bx
        push    cx
        push    dx
        push    di
        mov     si,os sbuff             ;Get pointer to buffer
        mov     bx,os dname             ;Get pointer to name
        mov     ax,[buftop]             ;Get end of buffer
Fn1:
        mov     dx,si                   ;Save pointer
        mov     di,bx                   ;This one stays the same
        mov     cx,11                   ;Compare name of 11 bytes
        rep     cmpsb                   ;Check if names equal
        mov     si,dx                   ;(Restore pointer)
        jcxz    Fn3                     ;Name equal: go on
        cmp     bptr [si],0             ;Zero as first char?
        jz      FnEnd                   ; yes: last entry found (CY=0, ZR=1)
        add     si,20h                  ;Point to next entry
        cmp     si,ax                   ;All entries done?
        jb      Fn1                     ; no: check next one
        sub     cx,0ffh                 ; yes: name not found (CY=1, ZR=0)
        jmp     short Fnend             ;Return to caller
Fn3:
        add     cx,1                    ;Indicate name found (CY=0, ZR=0)
FnEnd:
        pop     di                      ;Restore registers used
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        ret

FindName        endp

;********************************************************************

usage   db      "Usage: bfio12 \path-from-root\filename",eom
msg1    db      "Error obtaining drive parameters.",eom
msg2    db      "Error reading drive.",eom
msg3    db      "Error in path.",eom
msg4    db      "Directory or filename not found: $"
msg5    db      "Requested file is a directory."
crlf    db      eom

clpptr  dw      80h             ;Pointer to commandline parameters

dname   db      11 dup (?)      ;Current file/directory name
clust1  dw      ?               ;First cluster number of directory or file
cclust  dw      ?               ;Current cluster number being read
csect   dw      ?               ;Current sector in cluster
fsize   dd      ?               ;Size of file (why not of dir too, Bill?)
fread   dd      ?               ;Number of bytes already read
isdir   db      ?               ;1 if we expect this to be a directory, else 0

rootdir dd      ?               ;First sector of root directory
rsects  dw      ?               ;Number of sectors in root directory
fdata   dd      ?               ;First data sector

retries db      ?               ;Number of retries counter on disk I/O
buftop  dw      ?               ;Top of valid buffer data
pentry  db      size _pe dup (?)   ;Partition table entry for our partition
bpb     db      size _bpb dup (?)  ;BIOS Parameter Block for our partition
iopb    db      size _iopb dup (?) ;Disk I/O parameter block
        db      512 dup (?)     ;Stack space
stktop  equ     $               ;Stack top
sbuff   db      4096 dup (?)    ;Sector buffer for disk I/O

        END     main

