;
;
;    (CEVS) Cross-Eyed Viking Solutions 
;
;   GETE286 (Graphics Effect Test Engine) 1.0 for real mode
;   Lorne Kirkland Chartier (1996) - public domain
;
;   * 286 version limitations *
;   - 16-bit math / processing of 32-bit counters, pointers, and timers
;   - source buffer -> destination buffer requires segment override
;
;

                .286p
                .model medium, pascal
                .seq                            ; don't screw with this!
                jumps

include         bitmap.inc                      ; bitmap effects
include         cellular.inc                    ; cellular automata
include         demofx.inc                      ; demo effects
include         kb.inc                          ; keyboard handler
include         modex.inc                       ; Matt Pritchard's Mode-X
include         pcx.inc                         ; pcx stuff
include         support.inc                     ; various support stuff
include         timer.inc                       ; high-resolution timer

;  BUFWID/BUFDEP are here as good programming technique only - you
;  cannot simply alter them beyond 64K as the effect routines will
;  not function correctly (you will exceed the segments from which
;  they access data - the read/write addresses will need to be
;  normalized every 16k bytes or whatever, see @normalize macro in
;  support.inc and how it is used in pcx.asm)

BUFWID          equ 320                         ; buffer width
BUFDEP          equ 200                         ; buffer depth

SCRWID          equ 320                         ; screen width
SCRDEP          equ 240                         ; screen depth

WRKSINC         equ 8                           ; work sizing increment
WRKXMIN         equ 80                          ; minimum x working size
WRKYMIN         equ 50                          ; minimum y working size

; jump table entry
JUMP_Tbl struc
    jtrtnoff    dw ?                            ; routine offset
    jtrtnseg    dw ?                            ; routine segment
    jtdesoff    dw ?                            ; description offset
    jtdesseg    dw ?                            ; description
    jtflags     dw ?                            ; flags
                                                ; (lsb) 01h: do extra line
                                                ;       02h: copy frame1->2
                                                ;       04h: no frame swap
                                                ;       08h: clear borders
JUMP_Tbl ends

; calculate active algorithm pointer
; returns:  si - active algorithm pointer
@activeaptr     macro
                mov ax,[activealgo]
                mov cx,size JUMP_Tbl
                mul cx
                mov si,ax
                add si,[activetable]
                mov [activeaptr],si
                endm

                .stack 1024

                .code

;
;
;   MAIN GRAPHICS EFFECT TEST ENGINE
;
;

start:
                startupcode

                call kbinit                     ; fire up keyboard handler
                call timerinit                  ; fire up high-res timer

                ; you must preserve es: before calling modmem!
                call modmem                     ; reduce memory allocation
                jc criterr                      ; quit on failure

                mov bx,BUFDEP * ((BUFWID/16) + 1)
                call alocmem                    ; allocate memory
                jc criterr                      ; quit on failure
                mov w [frame1+2],ax             ; setup frame 1 pointer

                call fillrandom pascal, \
                    frame1, BUFWID, BUFDEP      ; setup initial state

                mov bx,BUFDEP * ((BUFWID/16) + 1)
                call alocmem                    ; allocate memory
                jc criterr                      ; quit on failure
                mov w [frame2+2],ax             ; setup frame 2 pointer

                call read_dac_registers \
                  pascal, ds, o palbuf, \
                  0, 255                        ; read existing palette

                mov dx,o palfname
                mov si,o palbuf
                call loadfile pascal            ; load the palette file

                mov ax,13h
                int 10h
                call set_modex pascal, 4        ; initialize Mode-X
                call load_dac_registers \
                  pascal, ds, o palbuf, \
                  0, 255, 1                     ; set the palette

                call contrast pascal, ds, \
                    o palbuf                    ; find best contrasting color
                mov [bcc],ax


                ;
                ;
                ;   MAIN ENGINE LOOP
                ;
                ;
align 2
testloop0:
                mov w [generations],0
                mov w [generations+2],0         ; reset generation count
                mov w [genertime],0
                mov w [genertime+2],0           ; reset generation timer

                mov si,[activeaptr]
                test [si].jtflags,08h           ; clear borders?
                jz testloop

                call clrborder pascal, \
                    frame1, wrkwid, wrkdep      ; clear borders in frame 1
                call clrborder pascal, \
                    frame2, wrkwid, wrkdep      ; clear borders in frame 2

align 2
testloop:
                xor [actpage],1                 ; toggle active page
                call set_active_page pascal, [actpage]
                call clear_vga_screen, 0

                mov si,[activeaptr]

                ; check pause
                cmp [pause],0                   ; paused?
                jne copyframe                   ; yes, copy frame 1 to 2
                test [si].jtflags,02h           ; force copy frame 1 to 2?
                jz nopause                      ; no, skip

copyframe:
                ; copy frame 1 to 2
                push ds es si di
                cld
                mov ax,w [frame2+2]
                mov es,ax
                mov di,w [frame2]
                mov si,w [frame1]
                mov ax,w [frame1+2]
                mov ds,ax
                mov cx,(BUFWID * BUFDEP) / 2
           rep  movsw
                pop di si es ds

                cmp [pause],0                   ; paused?
                je nopause                      ; no, skip to function
                cmp [pause],0ffh                ; full pause?
                je fullpause                    ; yes, skip function
                dec [pause]                     ; else paused for 1 frame
                jmp fullpause                   ; skip function

nopause:
                ; save pre-function ticks
                call timerread pascal
                mov w [genertemp],ax
                mov w [genertemp+2],dx

                mov si,[activeaptr]

                ; call the active function
                push frame1 frame2 wrkwid
                mov ax,wrkdep
                test [si].jtflags,01h           ; do extra line?
                jz afnotadd
                inc ax
afnotadd:
                push ax
                call d [si]

                ; update frames / generations total ticks
                call timerread pascal
                sub ax,w [genertemp]
                sbb dx,w [genertemp+2]          ; calc elapsed ticks
                add w [genertime],ax
                adc w [genertime+2],dx          ; add to total ticks

                add w [generations],1
                adc w [generations+2],0         ; update generation count

                ; have we reached maximum count?
                cmp [genermax],0
                je nomaxgens
                dec [genermax]
                jz testloopd
nomaxgens:

                ; cycle the colors
                cmp [cycle],1                   ; cycle forward?
                jne cycle1

                call cyclefwd pascal, \
                    ds, o palbuf, 1, 255        ; cycle colors forward

                call load_dac_registers \
                  pascal, ds, o palbuf, \
                  0, 255, 0                     ; set the palette

                call tgprintc pascal, \
                    '+', SCRWID-10, SCRDEP-13, \
                    [bcc]                       ; show cycle flag

                jmp cycle2

cycle1:
                cmp [cycle],-1                  ; cycle backward?
                jne cycle2

                call cyclebck pascal, \
                    ds, o palbuf, 1, 255        ; cycle colors backward

                call load_dac_registers \
                  pascal, ds, o palbuf, \
                  0, 255, 0                     ; set the palette

                call tgprintc pascal, \
                    '-', SCRWID-10, SCRDEP-13, \
                    [bcc]                       ; show cycle flag
cycle2:

fullpause:
                ; draw the centered bitmap
                push frame2
                mov ax,SCRWID/2
                mov bx,wrkwid
                shr bx,1
                sub ax,bx
                push ax
                mov ax,SCRDEP/2
                mov bx,wrkdep
                shr bx,1
                sub ax,bx
                push ax
                push wrkwid wrkdep
                call draw_bitmap pascal
                call set_display_page, [actpage]

                test [si].jtflags,04h           ; frame swap?
                jnz noframeswap

                mov ax,w [frame1]
                xchg ax,w [frame2]
                mov w [frame1],ax

                mov ax,w [frame1+2]
                xchg ax,w [frame2+2]
                mov w [frame1+2],ax             ; swap src & dest frames
noframeswap:

                mov si,[activeaptr]

                call tprint_str pascal, \
                    [si].jtdesseg, [si].jtdesoff, \
                    39,  5,  5,  [bcc]          ; show effect description

                call tprint_str pascal, \
                    s msgenerat2, o msgenerat2, \
                    39,  5,  SCRDEP-13,  [bcc]  ; show generations

                cmp [pause],0
                jne sgpaused

                mov ax,w [generations]
                mov dx,w [generations+2]
                mov si,o errbuff
                mov cx,10
                call ltoa pascal
                push si
                add si,ax
                mov byte ptr [si],0
                pop si

                call tprint_str pascal, \
                    s errbuff, si, \
                    39,  SCRWID/3*2, SCRDEP-13,  [bcc]
                jmp sgdone

sgpaused:
                call tprint_str pascal, \
                    s mspause, o mspause, \
                    39,  SCRWID/3*2, SCRDEP-13,  [bcc]

sgdone:
                mov ax,'P'
                and al,[pcxloadpal]
                call tgprintc pascal, \
                    ax, SCRWID-20, SCRDEP-13, \
                    [bcc]                       ; show palette load flag

                call d [keystep]                ; get scan code (step frame)
                cmp ax,0                        ; any key?
                je testloop                     ; no, continue processing

                cmp ax,kbesc                    ; is escape?
                je testloopd                    ; yes, quit

                @toupper al                     ; make uppercase


                ; -----------------------------------------
                ;   [F1] - Handle help
                ; -----------------------------------------

                cmp ax,kbf1
                jne nothelp

                call set_active_page pascal, 2
                call clear_vga_screen, 0
                call print_str pascal, s mshelp, o mshelp, \
                    40,  10,  10,  [bcc],  0

                call print_str pascal, s mshelp0a, o mshelp0a, \
                    40,  10,  30,  [bcc],  0
                call print_str pascal, s mshelp0b, o mshelp0b, \
                    40,  10,  40,  [bcc],  0
                call print_str pascal, s mshelp0c, o mshelp0c, \
                    40,  10,  50,  [bcc],  0
                call print_str pascal, s mshelp0d, o mshelp0d, \
                    40,  10,  60,  [bcc],  0
                call print_str pascal, s mshelp0e, o mshelp0e, \
                    40,  10,  70,  [bcc],  0
                call print_str pascal, s mshelp0f, o mshelp0f, \
                    40,  10,  80,  [bcc],  0
                call print_str pascal, s mshelp0g, o mshelp0g, \
                    40,  10,  90,  [bcc],  0
                call print_str pascal, s mshelp0h, o mshelp0h, \
                    40,  10, 100,  [bcc],  0
                call print_str pascal, s mshelp0i, o mshelp0i, \
                    40,  10, 110,  [bcc],  0

                call print_str pascal, s mshelp1, o mshelp1, \
                    40,  10, 130,  [bcc],  0
                call print_str pascal, s mshelp2, o mshelp2, \
                    40,  10, 140,  [bcc],  0
                call print_str pascal, s mshelp3, o mshelp3, \
                    40,  10, 150,  [bcc],  0
                call print_str pascal, s mshelp4, o mshelp4, \
                    40,  10, 160,  [bcc],  0
                call print_str pascal, s mshelp5, o mshelp5, \
                    40,  10, 170,  [bcc],  0
                call print_str pascal, s mshelp6, o mshelp6, \
                    40,  10, 180,  [bcc],  0
                call print_str pascal, s mshelp7, o mshelp7, \
                    40,  10, 190,  [bcc],  0
                call print_str pascal, s mshelp8, o mshelp8, \
                    40,  10, 200,  [bcc],  0
                call print_str pascal, s mshelp9, o mshelp9, \
                    40,  10, 210,  [bcc],  0
                call set_display_page, 2

                call kbget                      ; wait for key

                call set_display_page, [actpage]
                jmp testloop
nothelp:


                ; -----------------------------------------
                ;   [F2] - Handle best contrasting color
                ; -----------------------------------------

                cmp ax,kbf2
                jne notf2
                call contrast pascal, ds, \
                    o palbuf                    ; find best contrasting color
                mov [bcc],ax
                jmp testloop
notf2:


                ; -----------------------------------------
                ;   [F3] - Handle toggle PCX palette load
                ; -----------------------------------------

                cmp ax,kbf3
                jne notf3

                xor [pcxloadpal],0ffh
                jmp testloop
notf3:


                ; -----------------------------------------
                ;   [F5] - Handle bitmap effects
                ; -----------------------------------------

                cmp ax,kbf5
                jne notf5
                cmp [activetable],o bmptable
                je testloop
                mov [activealgo],0
                mov [activetable],o bmptable
                mov al,[bmpents]
                mov [activeents],al
                @activeaptr
                jmp testloop0
notf5:


                ; -----------------------------------------
                ;   [F6] - Handle cellular automata
                ; -----------------------------------------

                cmp ax,kbf6
                jne notf6
                cmp [activetable],o catable
                je testloop
                mov [activealgo],0
                mov [activetable],o catable
                mov al,[caents]
                mov [activeents],al
                @activeaptr
                jmp testloop0
notf6:


                ; -----------------------------------------
                ;   [F7] - Handle demo FX
                ; -----------------------------------------

                cmp ax,kbf7
                jne notf7
                cmp [activetable],o dfxtable
                je testloop
                mov [activealgo],0
                mov [activetable],o dfxtable
                mov al,[dfxents]
                mov [activeents],al
                @activeaptr
                jmp testloop0
notf7:


                ; -----------------------------------------
                ;   [F9] - Handle frame step
                ; -----------------------------------------

                cmp ax,kbf9
                jne notf9

                cmp w [keystep], o kbgetn       ; in run mode?
                je keystep1                     ; yes, skip

                mov w [keystep], o kbgetn
                mov w [keystep+2], s kbgetn     ; set run mode!
                jmp testloop

keystep1:
                mov w [keystep], o kbget
                mov w [keystep+2], s kbget      ; set step mode!
                jmp testloop
notf9:


                ; -----------------------------------------
                ;   [F10] - Handle do 100 frames
                ; -----------------------------------------

                cmp ax,kbf10
                jne notf10

                mov [seed1],irseed1
                mov [seed2],irseed2
                mov [seed3],irseed3
                mov [seed4],irseed4             ; reset FC randno generator
                mov [genermax],100              ; set count frames
                mov [pause],0                   ; shut-off pause
                jmp testloop0
notf10:


                ; -----------------------------------------
                ;   [A..Z] - Handle new algorithm
                ; -----------------------------------------

                cmp al,'A'
                jl notnewalgo
                cmp ah,0
                jne notnewalgo
                mov bl,'A'
                add bl,[activeents]
                cmp al,bl
                jge notnewalgo

                sub al,'A'
                and ax,0ffh
                mov [activealgo],ax             ; save new algorithm
                @activeaptr
                jmp testloop0
notnewalgo:


                ; -----------------------------------------
                ;   [1..9] - Handle screen fills
                ; -----------------------------------------

                cmp al,'1'
                jl notscrdraw
                cmp al,'9'
                jg notscrdraw
                cmp ah,0
                jne notscrdraw

                cmp al,'1'
                jne notfill1
                call fillrandom pascal, \
                    frame1, BUFWID, BUFDEP      ; do random fill
                cmp [pause],0                   ; already paused?
                jnz testloop0
                mov [pause],1                   ; show undamaged for 1 frame
                jmp testloop0
notfill1:
                sub al,'2'
                and ax,0ffh
                shl ax,3
                mov si,ax
                add si,o patttable
                call pattfill pascal, \
                    frame1, BUFWID, BUFDEP, \
                    ds, si, 0, bcc
                cmp [pause],0                   ; already paused?
                jnz testloop0
                mov [pause],1                   ; show undamaged for 1 frame
                jmp testloop0
notscrdraw:


                ; -----------------------------------------
                ;   [alt 1..9] - Handle palette loads
                ; -----------------------------------------

                cmp al,'1'
                jl notpalload
                cmp al,'9'
                jg notpalload

                push ax
                mov si,offset palfname
                mov di,offset errbuff
copystr2:
                mov al,byte ptr [si]
                inc si
                mov byte ptr [di],al
                inc di
                or al,al
                jnz copystr2
                sub di,6
                pop ax
                mov byte ptr [di],al

                mov dx,o errbuff
                mov si,o palbuf
                call loadfile pascal            ; load the palette file
                call load_dac_registers \
                  pascal, ds, o palbuf, \
                  0, 255, 1                     ; set the palette
                call contrast pascal, ds, \
                    o palbuf                    ; find best contrasting color
                mov [bcc],ax

                jmp testloop
notpalload:


                ; -----------------------------------------
                ;   [0] - Handle pcx picture fill
                ; -----------------------------------------

                cmp al,'0'
                jne notpcxfill
                cmp ah,0
                jne notpcxfill

                mov dx,o picfname
                mov ax,3d00h
                int 21h                         ; open the pcx picture
                jc pcxerror
                mov bx,ax

                push bx
                call pcxreadhdr pascal, \
                    ds, o pcxh, bx              ; read pcx header
                pop bx

                mov si,o pcxh

                mov ax,[si].pcxhymax
                sub ax,[si].pcxhymin
                cmp ax,BUFDEP-1                 ; depth ok?
                jne pcxerror3
                mov ax,[si].pcxhxmax
                sub ax,[si].pcxhxmin
                cmp ax,BUFWID-1                 ; width ok?
                jne pcxerror3

                push bx
                cmp [pcxloadpal],0              ; load palette?
                je pcxloadp1                    ; no, skip

                call pcxdecode pascal, \
                    ds, o pcxh, bx, \
                    frame1, ds, o palbuf        ; decode pcx picture
                jmp pcxloadp2
pcxloadp1:
                call pcxdecode pascal, \
                    ds, o pcxh, bx, \
                    frame1, 0, 0                ; decode pcx picture
pcxloadp2:
                pop bx

                push bx
                call load_dac_registers \
                  pascal, ds, o palbuf, \
                  0, 255, 1                     ; set the palette
                pop bx

                cmp [pause],0                   ; already paused?
                clc                             ; signal all ok
                jnz pcxerror2
                mov [pause],1                   ; show undamaged for 1 frame
                jmp pcxerror2

pcxerror3:
                stc
pcxerror2:
                pushf
                mov ah,3eh
                int 21h                         ; close the file
                popf
                jnc testloop0                   ; avoid honk if ok
pcxerror:
                call soundit pascal, \
                    98, 3
                jmp testloop0
notpcxfill:


                ; -----------------------------------------
                ;   [prtscr] - Handle pcx screenshot save
                ; -----------------------------------------

                cmp ax,kbprtscr
                jne notprtscr

                mov si,o pcxofname
                mov di,o errbuff
copystr:
                mov al,byte ptr [si]
                inc si
                mov byte ptr [di],al
                inc di
                or al,al
                jnz copystr

                call fileuname pascal, ds, \
                    o errbuff                   ; create unique name

                mov ah,3ch
                mov cx,0
                mov dx,o errbuff
                int 21h                         ; create output file
                jc opcxerror2
                mov bx,ax

                push bx
                call pcxwritehdr pascal, \
                    ds, o pcxh, bx, \
                    wrkwid, wrkdep              ; create / write pcx header
                pop bx

                push bx
                call pcxencode pascal, \
                    ds, o pcxh, bx, \
                    frame1, ds, o palbuf        ; encode pcx picture
                pop bx

                call soundit pascal, \
                    981, 3

                clc                             ; signal all ok
                jmp opcxerror2

opcxerror3:
                stc
opcxerror2:
                pushf
                mov ah,3eh
                int 21h                         ; close the file
                popf
                jnc testloop                    ; avoid honk if ok
opcxerror:
                call soundit pascal, \
                    98, 3
                jmp testloop
notprtscr:


                ; -----------------------------------------
                ;   [pause] - Handle pause action
                ; -----------------------------------------

                cmp ax,kbpause
                jne notpause

                xor [pause],0ffh
                jmp testloop
notpause:


                ; -----------------------------------------
                ;   [arrows/home/end] - Handle size buffer
                ; -----------------------------------------

                cmp al,kbleft
                jne notleft
                sub [wrkwid],WRKSINC
                cmp [wrkwid],WRKXMIN
                jnc testloop0
                mov [wrkwid],WRKXMIN
                jmp testloop0
notleft:

                cmp al,kbright
                jne notright
                add [wrkwid],WRKSINC
                cmp [wrkwid],BUFWID+1
                jc testloop0
                mov [wrkwid],BUFWID
                jmp testloop0
notright:

                cmp al,kbup
                jne notup
                sub [wrkdep],WRKSINC
                cmp [wrkdep],WRKYMIN
                jnc testloop0
                mov [wrkdep],WRKYMIN
                jmp testloop0
notup:

                cmp al,kbdown
                jne notdown
                add [wrkdep],WRKSINC
                cmp [wrkdep],BUFDEP+1
                jc testloop0
                mov [wrkdep],BUFDEP
                jmp testloop0
notdown:

                cmp al,kbhome
                jne nothome
                mov [wrkwid],BUFWID
                mov [wrkdep],BUFDEP
                jmp testloop0
nothome:

                cmp al,kbend
                jne notend
                mov [wrkwid],WRKXMIN
                mov [wrkdep],WRKYMIN
                jmp testloop0
notend:


                ; -----------------------------------------
                ;   [+] - Handle cycle colors forward
                ; -----------------------------------------

                cmp al,'+'
                jne notplus

                cmp [cycle],1                   ; already forward?
                je testloop                     ; yep, ignore

                inc [cycle]
                jmp testloop
notplus:


                ; -----------------------------------------
                ;   [-] - Handle cycle colors forward
                ; -----------------------------------------

                cmp al,'-'
                jne notminus

                cmp [cycle],-1                  ; already backward?
                je testloop                     ; yep, ignore

                dec [cycle]
                jmp testloop
notminus:


                ; -----------------------------------------
                ;   uncomment to show scan code on no find
                ; -----------------------------------------

                ;mov dx,0
                ;mov si,o errbuff
                ;mov cx,16
                ;call ltoa pascal
                ;push si
                ;add si,ax
                ;mov byte ptr [si],0
                ;pop si
                ;
                ;call tprint_str pascal, \
                ;    s errbuff, si, \
                ;    39,  5,  SCRDEP-23,  [bcc]  ; show generations

                jmp testloop


                ;
                ;
                ;   CLEANUP AND SHUTDOWN
                ;
                ;
testloopd:

                mov ax,0                        ; signal all ok
criterr:

                ; restore text mode
                push ax
                mov ax,3
                int 10h
                pop ax

                push ax
                mov dx,o msusage
                mov ah,09h
                int 21h                         ; show usage
                pop ax

                ;
                ;  show generation count
                ;
                push ax
                mov dx,o msgenerations
                mov ah,09h
                int 21h

                mov ax,w [generations]
                mov dx,w [generations+2]
                mov si,o palbuf
                mov cx,10
                call ltoa pascal
                mov dx,si
                mov ah,09h
                int 21h                         ; show generations
                pop ax

                ;
                ;  show generation count
                ;
                push ax
                mov dx,o msgenertime
                mov ah,09h
                int 21h

                mov ax,w [genertime]
                mov dx,w [genertime+2]
                mov si,o palbuf
                mov cx,10
                call ltoa pascal
                mov dx,si
                mov ah,09h
                int 21h                         ; show generations
                pop ax

                ;
                ;  show errors if any
                ;
                cmp ax,0                        ; any errors?
                je noerrors                     ; no, skip

                push ax
                mov dx,o mserror
                mov ah,09h
                int 21h
                pop ax

                mov si,o palbuf
                mov cx,10
                call itoa pascal
                mov dx,si
                mov ah,09h
                int 21h                         ; show error number
noerrors:
                mov dx,o mscrlf
                mov ah,09h
                int 21h

                call timerdnit                  ; shut down high-res timer
                call kbdnit                     ; shut down keyboard handler

                exitcode


;
;   alocmem() - allocate memory from DOS
;   pass:       bx - number of paragraphs (16 byte chunks) needed
;   returns:    carry clear if ok, carry set on error
;               ax - segment of allocated block
;

alocmem         proc near
                mov ah,48h
                int 21h                         ; allocate memory
                ret
alocmem         endp


;
;   modmem() - reduce memory usage of executable
;   pass:       nothing
;   returns:    carry clear if ok, carry set on error
;

modmem          proc near
                mov bx,s endofexe               ; paragraph at end of program
                mov ax,es
                sub bx,ax                       ; minus starting paragraph
                inc bx                          ; plus one for safety
                mov ah,4ah
                int 21h                         ; modify memory allocation
                ret
modmem          endp


;
;
;   DATA
;
;

                .data

mscrlf          db 13,10,'$'
msusage         db 13,10,' (CEVS) Cross-Eyed Viking Solutions ',13,10
                db 'GETE286 (Graphics Effect Test Engine) 1.0 for real mode.',13,10
                db 'Lorne Kirkland Chartier (1996) - public domain.',13,10
                db 13,10,'F1 for help inside program.',13,10,'$'
mserror         db 13,10,'error # $'
msgenerations   db 13,10
msgenerat2      db 'frames(generations):  ',0,'$'
msgenertime     db 13,10,'ticks of frames:       $'
mspause         db 'pause',0
mshelp          db 'HELP:',0
mshelp0a        db 'esc       quit',0
mshelp0b        db 'f1        help',0
mshelp0c        db 'f2        calculate contrasting color',0
mshelp0d        db 'f3        toggle pcx palette load',0
mshelp0e        db 'f5        group: bitmap fx',0
mshelp0f        db 'f6        group: cellular automata',0
mshelp0g        db 'f7        group: demo fx',0
mshelp0h        db 'f9        toggle frame step',0
mshelp0i        db 'f10       run 100 frames, show stats',0
mshelp1         db '1..9      fill functions',0
mshelp2         db '0         fill using '
picfname        db 'GETE.PCX',0                 ; picture name
mshelp3         db 'a..z      effects for active group',0
mshelp4         db 'alt 1..9  load palette GETE#.PAL',0
mshelp5         db 'arrows    resize buffer',0
mshelp6         db 'home      maximize buffer',0
mshelp7         db 'end       minimize buffer',0
mshelp8         db 'pause     pause effect function',0
mshelp9         db 'prtscr    save buffer as pcx',0

errbuff         db 80 dup (0)

actpage         dw 0                            ; active display page
frame1          dd 0                            ; frame 1 far address
frame2          dd 0                            ; frame 2 far address
wrkwid          dw 160                          ; working width
wrkdep          dw 100                          ; working depth

generations     dd 0                            ; generations processed
genertime       dd 0                            ; generations timed
genertemp       dd 0
genermax        dw 0                            ; maximum lsb generations
keystep         dw o kbgetn, s kbgetn           ; get key stepping function
pause           db 0                            ; pause action

bcc             dw 0                            ; best contrasting pal color
palfname        db 'GETE1.PAL',0                ; palette name
palbuf          db 768 dup (0)                  ; palette buffer
cycle           db 0                            ; cycle direction flag

pcxh            PCX_Hdr <0>                     ; pcx header
pcxofname       db 'SHOT.PCX',0                 ; pcx output file
pcxloadpal      db 0ffh                         ; pcx load palette flag

;
;  bitmap fx jump table
;
msflipx         db '(bmp) flip horizontally',0
msflipy         db '(bmp) flip vertically',0
msrotate        db '(bmp) rotate',0

bmpstart        label byte
bmptable        JUMP_Tbl <o flipx,   s flipx,   o msflipx,   s msflipx,   02h>
                JUMP_Tbl <o flipy,   s flipy,   o msflipy,   s msflipy,   02h>
                JUMP_Tbl <o rotate,  s rotate,  o msrotate,  s msrotate,  04h>
bmpend          label byte
bmpents         db (bmpend - bmpstart) / (size JUMP_Tbl)

;
;  cellular automata jump table
;
mslife          db '(ca) game of life, Conway',0
msevenodd       db '(ca) evens / odds',0
mslichens       db '(ca) lichens',0

castart         label byte
catable         JUMP_Tbl <o life,    s life,    o mslife,    s mslife,    08h>
                JUMP_Tbl <o evenodd, s evenodd, o msevenodd, s msevenodd, 08h>
                JUMP_Tbl <o lichens, s lichens, o mslichens, s mslichens, 08h>
caend           label byte
caents          db (caend - castart) / (size JUMP_Tbl)

;
;  demo fx jump table
;
msfire1         db '(dfx) PHRO demo fire, Phred/OTM',0
msplasma1       db '(dfx) SWAG plasma, GEM/Gaalen/Heel',0

dfxstart        label byte
dfxtable        JUMP_Tbl <o fire1,   s fire1,   o msfire1,   s msfire1,   01h>
                JUMP_Tbl <o plasma1, s plasma1, o msplasma1, s msplasma1, 01h>
dfxend          label byte
dfxents         db (dfxend - dfxstart) / (size JUMP_Tbl)

;
;  active algorithm pointers / data
;
activealgo      dw 0                            ; active algo (number)
activeaptr      dw o catable                    ; active algo (direct pointer)
activetable     dw o catable                    ; active function table
activeents      db (caend - castart) / (size JUMP_Tbl)

;
;  various patterns for filling with
;
patttable       db 000h, 06ch, 092h, 082h, 082h, 044h, 028h, 010h
                db 000h, 07fh, 041h, 05dh, 045h, 07dh, 001h, 0ffh
                db 000h, 008h, 018h, 018h, 028h, 0cbh, 004h, 000h
                db 000h, 07fh, 041h, 077h, 000h, 0f7h, 014h, 077h
                db 000h, 010h, 010h, 038h, 038h, 07ch, 07ch, 010h
                db 000h, 0bfh, 060h, 03fh, 088h, 0e7h, 030h, 0efh
                db 001h, 003h, 007h, 00fh, 01fh, 03fh, 07fh, 0ffh
                db 042h, 0c3h, 03ch, 024h, 024h, 03ch, 0c3h, 042h


                .data?                          ; don't screw with this!


;
;
;   *** WARNING!!! - discardable marker ***
;   every thing past this point will be discarded
;   when the modmem() function is called.
;
;

endofexe        segment
endofexe        ends

                end

