/*
==============================================================================================================
   Name:             AWE_DLL.H

   Description:      Entire API message function header file for accessing AWEMAN.DLL.
                     This header file includes the necessary header files inorder to access the AWEMAN.DLL.
                     These header files contains public APIs which is essential to address the APIs provided
                     by AWEMAN.DLL and AWEGUI.DLL.
                     
   Purpose:          Developer API Guide.

   Author:           E.W. Khor
                     Copyright 1993,94 Creative Technology Ltd.

   Date:             version 1.0    -     27th Jan 1994

   Revision:

==============================================================================================================
*/

#ifndef  _AWE_DLL_H
#define  _AWE_DLL_H


#include "awe_api.h"          /* Header file for public APIs. Public */

#include "errormsg.h"         /* Header file containing legal error messages for DLL and MIDI driver*/
#include "indices.h"          /* Header file containing macro for Effect Type, Variation and Synth emulation */

/*
-----------------------------------------------------------------------------------------------------

      GLOBAL MACRO AND EXTERN DEFINITION
      
-----------------------------------------------------------------------------------------------------
*/
DECLARE_HANDLE32(AWEHANDLE);
/*
      Type define a AWEHANDLE. This handle is required whenever the application requires to access the APIs
      of AWEMAN.DLL. This handle serves as and identification of proper initialization and acquisition of
      AWEMAN.DLL.
      
      Example:
      
      :

      int         nCounter;
      AWEHANDLE   hMyID;                  // hMyID stores a copy of AWEManager returned ID.

      :
      (Acquire AWE Manager)
      :
*/

typedef  LRESULT  (FAR PASCAL *LPFNAWEMANAGER)   (AWEHANDLE, UINT, LPARAM, LPARAM);
/*
      The LPFNAWEMANAGER type is used to declare a pointer to the message function. This message function will
      receive all necessary messages from the application who wishes to access its API. This type declaration
      is useful especially when dynamic linking is used.

      Example:
      
      :
      
      AWEHANDLE         hMyID;
      LPFNAWEMANAGER    lpfnAWEManager;
      
      :
      lpfnAWEManager = (Retrieve Address of function);
      :
*/

#ifdef __cplusplus
extern "C" 
{
#endif

LRESULT FAR PASCAL _export AWEManager( AWEHANDLE hUserID, UINT unMsg, LPARAM lParam1, LPARAM lParam2 );
/*
   Message Entry Function. This function provides entry to the AWE DLL Manager. An error message will 
   be returned via the LRESULT return type.

*/

LRESULT FAR PASCAL _export AWEControlPanel( LPCSTR lpszAppTitle, BOOL bButton );
/*
   Activates the AWE Control application.
   lpszAppTitle contains a null-terminated string to the caption title of control panel. If NULL is
   specified, the default name 'AWE Control' will be used.
   bButton turns on or off the button which allows control panel to switch to Controller BOB.
*/

LRESULT FAR PASCAL _export AWEControllerBOB( LPCSTR lpszAppTitle, BOOL bButton );
/*
   Activates the AWE Controller Break-Out-Box.
   lpszAppTitle contains a null-terminated string to the caption title of control panel. If NULL is
   specified, the default name 'AWE Control' will be used.
   bButton turns on or off the button which allows to Controller BOB switch to control panel.
*/

#ifdef __cplusplus
}
#endif


#endif      /* _AWEDLL_H */
