/* vidlib.h */
#ifndef __VIDLIB__
#define __VIDLIB__

#define  VIDLIB_VERSION    "1.5"

#define BIOScrtmode        (*((char far *)    0x00000449L))
#define BIOScrtcols        (*((char far *)    0x0000044aL))
#define BIOScrtrows        (*((char far *)    0x00000484L))
#define BIOScrtpoints      (*((char far *)    0x00000485L))
#define BIOScrtbuflen      (*((unsigned far *)0x0000044cL))
#define BIOScrtstartoff    (*((unsigned far *)0x0000044eL))
#define BIOScursor_page1   (*((unsigned far *)0x00000450L))
#define BIOScursor_page1x  (*((unsigned char far *)0x00000450L))
#define BIOScursor_page1y  (*((unsigned char far *)0x00000451L))
#define BIOScrtpage        (*((char far *)    0x00000462L))

#define DACSIZE            768
#define DEFAULTDAC         ((char *) -1L)

#define WPlane0            0x01
#define WPlane1            0x02
#define WPlane2            0x04
#define WPlane3            0x08
#define WPlaneALL          0x0f

#ifdef VIDLIB               /* when compiling the vidlib.c only */
               char _vidinit=0;
               char _olddacs[DACSIZE];
      unsigned char _oldmode;
      unsigned int  _screen_width;
      unsigned int  _screen_length;
      unsigned int  _memory_length;
          char far *_screen_start;
          char far *_screen_end;
      unsigned short _background_color=0;
      unsigned short _foreground_color=0x40;
               char  tdbg[120];
               FILE *vgadebug=NULL;
#else
extern          FILE *vgadebug;
extern          char _vidinit;
extern          char _olddacs[DACSIZE];
extern unsigned char _oldmode;
extern unsigned int  _screen_width;      /* in bytes */
extern unsigned int  _screen_length;
extern unsigned int  _memory_length;     /* in total scan lines, e.g.
                                            modes 0x0e,0x10, and 0x12= 819,
                                            even though a different number
                                            are displayed in each */

extern    char far  *_screen_start;      /* Usually 0xA0000000 */
extern    char far  *_screen_end;        /* actually, the first byte after
                                            the displayed portion */
extern      unsigned short _background_color;
extern      unsigned short _foreground_color;
extern         char  tdbg[135];

#endif /* endif VIDLIB */

int   Vinit(void);
void  Vclose(void);
int   VGAmode(unsigned int mode, char *palette);   /* palette may be NULL */
int   isVGA(void);             /* returns 0 if no, 1 if yes */
int   Textmode(int lines);     /* 25, 28, 33, 40, 50 are valid */
int   _select_scanline_count(int scans);
int   _select_character_points(int points);
void  Start_vgadebug(char *path);
void  Close_vgadebug(void);

/* the following routines make use of _screen_width, _screen_length, and
   _screen_start to check for logical errors, so any changing of VGA register
   that change these attributes should be reflected in these variables */

/* area fills */

int Vfill256(unsigned dx, unsigned dy, unsigned sdx, unsigned sdy,
                unsigned color);

/* video to video copy */
int Vcopy256(unsigned dx, unsigned dy,
             unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);
int Vcopy16(unsigned dx, unsigned dy,
            unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);

/* System memory to video copy */
int Vdisp256(unsigned dx, unsigned dy,
             char far *s, unsigned sw, unsigned sl,
             unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);
int Vdisp16(unsigned dx, unsigned dy,
            char far *s, unsigned sw, unsigned sl,
                     unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);

/* Video to System memory copy */
int Vcapt256(char far *d, unsigned dw, unsigned dl,
                      unsigned dx, unsigned dy,
                      unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);
int Vcapt16(char far *d, unsigned dw, unsigned dl,
                     unsigned dx, unsigned dy,
                     unsigned sx, unsigned sy, unsigned sdx, unsigned sdy);


/* low level routines */
void Select_RPlane(int plane);
void Select_Wmode(int mode);    /* mode ranges 0-3 for VGA */
int  What_Wmode(void);
void Select_WPlane(int planes);    /* planes = bit mask
                                                0=plane 0 write enable,
                                                1=plane 1, etc.  */
int            SQread_reg(int reg);
void           SQset_reg(int reg, int value);
void           SQset_regm(int reg, int value, int bitmask);
void           Vdisable_refresh(void);
void           Venable_refresh(void);   /* doesn't work in text mode ? */
int            GCread_reg(int reg);
void           GCset_reg(int reg, int value);
void           GCset_regm(int reg, int value, int bitmask);
int            ACread_reg(int reg);
void           ACset_reg(int reg, int value);
void           ACset_regm(int reg, int value, int bitmask);
#define        Vborder_color(x)    (ACset_reg(0x11, (x)))
int            MOread_reg(void);
void           MOset_reg(int value);
void           MOset_regm(int value, int mask);
int            CRTCread_reg(int reg);
void           CRTCset_reg(int reg, int value);
void           CRTCset_regm(int reg, int value, int bitmask);
void           Vwait_vretrace(void);
void           Vwait_hretrace(void);
void           L40set(void); /* line drawing characters don't connect in this
                                mode */
void           L33set(void);
extern unsigned char EGA12set[256][12]; /* smaller (8x12) ega-like font */
                                        /* used in the 33 line text mode */

void ReadDACs(void *palette);
void WriteDACs(void *palette);
int  LoadDACs(int fh, char *savearea);  /* savearea must be DACSIZE bytes */
int  SaveDACs(int fh, char *savearea);
void Load_Palette(int start, int count, char *palette);
int   putstty(const char *s, int color);
#define Vputs(x)       putstty(x, _foreground_color)

/* miscellaneous utilities */
void huge * normalize(void far *); /* convert a far pointer to a huge. */
char far * memcpyb(char far *dest, char far *src, unsigned count);
           /* garauntees one byte at a time, unlike memcpy, which will
              attempt to copy by words if on a 286,386,486,etc. */
char far * memcpybr(char far *dest_end, char far *src_end, unsigned count);
           /* same as memcpyb, except a reverse direction move (bottom to top).
              Note that the pointers must be to the last byte in the area. */

#endif
