/*The following Borland C program should be linked with the assembly langauge
library in EXAMP3B.ASM.  Combine the library with XLIBB.LIB using the Borland
TLIB utility.  The C program first initializes XLIBB.  Next, it creates a
float array.  A control block for SUMARRAY is then constructed and the call to
SUMARRAY is executed.  Finally, the condition code in the control block is
inspected and results are printed.*/

#include <stdio.h>
#include <xlibb.h>

extern long far pascal LINADR(void far *ptr);
extern void far pascal SUMARRAY(void far *ptr);

struct arraydata              /*Structure for passing arguments to SUMARRAY*/
{
  long condcode;
  long n;
  long address;
  float sum;
} ad;

void main(void)
{
  int i;
  long errcode;
  float a[101];

  errcode = INITXLIB();       /*Initialize XLIB*/
  if (errcode != 0)           /*See if an error occurred*/
  {
    printf("Initialization Error:  %lX\n",errcode);
    return;
  }

  for(i = 0; i <= 100; i++)   /*Initialize a[]*/
    a[i] = i;

  ad.condcode = 0;            /*Initialize the condition code*/
  ad.n = 50;                  /*Will sum the first 50 elements in a[]*/
  ad.address = LINADR(a);     /*Compute and record linear address of a[]*/

  SUMARRAY(&ad);              /*Sum the array elements*/
  if (ad.condcode != 0)       /*See if an FPU error occurred*/
  {
    printf("Error:  %lX\n",ad.condcode);
    return;
  }
  printf("Sum:  %f\n",ad.sum);   /*The sum should be 1225*/
}
