			--------------------------
			-- Shell sort Benchmark --
			--------------------------
without type_check -- makes no difference

constant BATCH = 100
constant BENCH_TIME = 15

constant TRUE = 1

sequence list, slist

function shell_sort(sequence x)
-- Shell sort 
-- will sort any sequence of integers
    integer gap, j
    integer first, last 
    integer tempi, tempj

    last = length(x)
    gap = floor(last / 4) + 1
    while TRUE do
	first = gap + 1
	for i = first to last do
	    tempi = x[i]
	    j = i - gap 
	    while TRUE do
		tempj = x[j]
		if tempi >= tempj then
		    j = j + gap
		    exit
		end if
		x[j+gap] = tempj
		if j <= gap then
		    exit
		end if
		j = j - gap
	    end while
	    x[j] = tempi
	end for
	if gap = 1 then
	    return x
	else
	    gap = floor(gap / 4) + 1 
	end if
    end while
end function

list = {9, 34, 14, 18, 33, 46, 11, 13, 7, 26, 22, 10, 36, 40, 2, 28, 32, 1,
	23, 31, 43, 5, 24, 42, 45, 50, 16, 3, 47, 39, 21, 49, 41, 6, 19, 30,
	20, 35, 44, 38, 25, 15, 27, 17, 8, 4, 29, 37, 48, 12}

atom t, cycles

puts(1, "shell sort benchmark ...\n")
cycles = 0
t = time()
while time() < t + BENCH_TIME do
    for i = 1 to BATCH do 
	slist = shell_sort(list) 
    end for
    cycles = cycles + BATCH
end while
t = time() - t
printf(1, "%6.1f sorts per second\n", cycles / t)
? slist

