
#ifndef AAFII_H
#define AAFII_H

#ifndef AAFLI_H
#include "aafli.h"
#endif /* AAFLI_H */

/* Low level decompression functions */
void fii_unbrun(Cbuf *cbuf, Pixel *screen, int linect);	/* 1st frame */
void fii_unlccomp(Cbuf *cbuf, Pixel *screen);		/* delta frames */
void fii_mem_fcuncomp(Cbuf *cbuf, Cmap *cmap);		/* colors to memory */
void fii_reg_fcuncomp(Cbuf *cbuf);					/* colors to registers */

/* Longest run for byte-oriented compression */
#define FLI_MAX_RUN 127

/** Low level assembler routines used by fii_lccomp to do a single line **/
/* Find out how far until have the next match of mustmatch or more pixels */
int fii_tnskip(Pixel *s1,Pixel *s2,int bcount,int mustmatch);
/* Find out how far until next run of identical pixels mustmatch long */
int fii_tnsame(Pixel *s,int bcount,int mustmatch);

/** Mid level routines to compress 1st frame, delta frames, and color maps **/
/* Run length compress a single frame using Animator 8086 
	1st frame technique */
Cbuf *fii_brun(Pixel *s1,Pixel *s2,USHORT *cbuf,int width,int height);
/* Delta compress a single frame using Animator 8086 byte-oriented scheme */
Cbuf *fii_lccomp(Pixel *s1,Pixel *s2,USHORT *cbuf,int width,int height);
/* fii_fccomp - compress an rgb triples color map doing 'skip' compression */
Cbuf *fii_fccomp(Cmap *s1, Cmap *s2, USHORT *cbuf, int count);

#endif /* AAFII_H */
