;copybyte.asm - contains i86_bcopy.

_TEXT	SEGMENT  BYTE PUBLIC 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  WORD PUBLIC 'DATA'
_DATA	ENDS
CONST	SEGMENT  WORD PUBLIC 'CONST'
CONST	ENDS
_BSS	SEGMENT  WORD PUBLIC 'BSS'
_BSS	ENDS
DGROUP	GROUP	CONST,	_BSS,	_DATA
	ASSUME  CS: _TEXT, DS: DGROUP, SS: DGROUP, ES: DGROUP
_TEXT      SEGMENT

;i86_bcopy(source,dest,count)
;Copy count bytes from source to dest.  Actual copy is done a byte at a
;time.  No allignment restrictions on source,dest.  No parity
;restrictions on count.  Zero counts will trash memory!
	public _i86_bcopy
_i86_bcopy proc far
	push bp
	mov bp,sp
	push ds
	push si
	push di

	cld
	lds	si,[4+bp+2]
	les	di,[8+bp+2]
	mov cx,[12+bp+2]
	rep movsb

	pop di
	pop si
	pop ds
	pop bp
	ret
_i86_bcopy endp

_TEXT	ENDS
END
