// PCX Image Loading.
// ==================
// This code was taken from Flights Of Fantasy and reworded to fit my style.
// Flights Of Fantasy is a great book written by Christopher Lampton and
// published by Waite Group Press.  The ISBN is 1-878739-18-2.
//
// A couple of very minor adjustments have been made to this code.  Basically
// to fit my coding style.
//
// Scott A. Deming
// sad@umcc.umich.edu

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>

#include "gfxpcx.h"

#define     BYTEMODE    0
#define     RUNMODE     1
#define     BUFFERSIZE  1024*5

struct  pcxHeaderS {
    char    manufacturer;
    char    version;
    char    encoding;
    char    bitsPerPixel;
    int     xMin, yMin;
    int     xMax, yMax;
    int     hRes, vRes;
    char    pal16[48];
    char    reserverd;
    char    colorPlanes;
    int     bytesPerLine;
    int     paletteType;
    char    filler[58];
};

char    *gfxLoadPCX(char *pcxFName, char *image, char *palette)
{
    struct  pcxHeaderS pcxHeader;
    FILE    *pcxFile;
    int     mode = BYTEMODE;
    int     bRead = 0;
    int     bufPtr = 0;
    long    i;
    unsigned char *buffer;
    unsigned char outByte;
    unsigned char byteCount;
    char    *scr;
    char    pcxFilename[69];

    sprintf(pcxFilename, "%s", pcxFName);

    // Open PCX file.
    pcxFile = fopen(pcxFilename, "rb");
    if (pcxFile == NULL) {
        return (NULL);
    }

    // Read PCX file header.
    fseek(pcxFile, 0L, SEEK_SET);
    fread(&pcxHeader, sizeof(struct pcxHeaderS), 1, pcxFile);

    // Make sure this is a 256 color PCX file.
    if (pcxHeader.bitsPerPixel != 8) {
        return (NULL);
    }

    // Is this going to the screen, or a buffer?  If a buffer we need to
    // allocate some memory.
    if (image != MK_FP(0xA000, 0x0000)) {
        image = malloc(64000U);
    }
    scr = image;

    buffer = malloc(BUFFERSIZE);

    // Load and uncompress image.
    for (i=0L; i<64000L; i++) {
        if (mode == BYTEMODE) {
            if (bufPtr >= bRead) {
                bufPtr = 0;

                if ((bRead = fread(buffer, 1, BUFFERSIZE, pcxFile)) == 0) {
                    break;
                }
            }

            outByte = buffer[bufPtr++];
            if (outByte > 0xBF) {
                byteCount = (int) ((int) outByte & 0x3F);

                if (bufPtr >= bRead) {
                    bufPtr = 0;

                    if ((bRead = fread(buffer, 1, BUFFERSIZE, pcxFile)) == 0) {
                        break;
                    }
                }

                outByte = buffer[bufPtr++];

                if (--byteCount > 0) {
                    mode = RUNMODE;
                }
            }
        } else
        if (--byteCount == 0) {
            mode = BYTEMODE;
        }

        *scr++=outByte;
    }

    // Load palette
    if (palette != NULL) {
        fseek(pcxFile, -768L, SEEK_END);

        fread(palette, 1, 768, pcxFile);
        for (i=0; i<768; i++) {
            palette[i]>>=2;
        }
    }

    free(buffer);

    return (image);
}
