Uses Dos;

Type
  ColorValue =
  Record
    RedVal, GreenVal, BlueVal : Byte;
  End;
  PaletteType = Array [0..255] Of ColorValue;

Var
  Regs : Registers;
  P : PaletteType;
  X, Y, I : Integer;

Procedure SetVGAPalette (Var Pt : PaletteType);

Begin
  With Regs Do
  Begin
    AX := $1012;
    BX := 0;
    CX := 256;
    ES := Seg (Pt);
    DX := Ofs (Pt);
  End;
  Intr ($10, Regs);
End;

Procedure RotatePalette (Var P : PaletteType; N1, N2, D : Integer);

Var
  Q : PaletteType;

Begin
  Q := P;
  For I := N1 To N2 Do P [I] := Q [N1 + (I + D) MOD (N2 - N1 + 1)];
  SetVGAPalette (P);
End;

Procedure PutPixel (X, Y : Integer; Color : Byte);

Begin
  Mem [$A000 : Word (320 * Y + X)] := Color;
End;

Function KeyPressed : Boolean;

Begin
  Regs.AH := $0B;
  Regs.DL := $FF;
  Intr ($21, Regs);
  KeyPressed := (Regs.AL = $FF);
End;

Procedure GoToXY (X, Y : Integer);

Begin
  Regs.AH := 2;
  Regs.DL := Y;
  Regs.DH := X;
  Regs.BL := 0;
  Intr ($10, Regs);
End;

Begin
  Regs.AH := 0;
  Regs.AL := 19;
  Intr ($10, Regs);
  For I := 0 To 63 Do
  Begin
    With P [I + 1] Do
    Begin
      RedVal := I;
      GreenVal := 63 - I;
      BlueVal := 0;
    End;
    With P [I + 65] Do
    Begin
      RedVal := 63 - I;
      GreenVal := 0;
      BlueVal := I;
    End;
    With P [I + 129] Do
    Begin
      RedVal := 0;
      GreenVal := I;
      BlueVal := 63 - I;
    End;
  End;
  SetVGAPalette (P);
  For X := 0 To 170 Do For Y := 0 To 192 Do
  Begin
    PutPixel (Y, X, Y);
  End;
  GoToXY (1, 29);
  Write ('VGA-Demo');
  GoToXY (2, 29);
  Write ('--------');
  GoToXY (5, 32);
  Write ('by');
  GoToXY (7, 26);
  Write ('Petri Nikkonen');
  GoToXY (13, 31);
  Write ('***');
  GoToXY (22, 3);
  Write ('(c) Copyright Petri Nikkonen 1991');
  GoToXY (24, 10);
  Write ('All rights reserved');
  Repeat
    RotatePalette (P, 1, 192, +1);
  Until KeyPressed;
  Regs.AH := 0;
  Regs.AL := 3;
  Intr ($10, Regs);
End.
