; PMC v0.8b startup header by Tran (a.k.a. Thomas Pytel).

.386p
locals

PMODE_TEXT      segment para public use16 'CODE'
PMODE_TEXT      ends
_TEXS           segment para use16 'CODE'
_TEXS           ends
_TEXT           segment para public use32 'CODE'
_TEXT           ends
_DAT@           segment para use16 'DATA'
_DAT@           ends
_DATA           segment para public use32 'DATA'
_DATA           ends
_BSR            segment para use16 'BSS'
_BSR            ends
_BSS            segment para public use32 'BSS'
_BSS            ends
_STACK          segment para stack use16 'STACK'
_STACK          ends

; Without that little _DAT@ segment there, TLINK refused to put the _DATA
; segment on a paragraph boundary. That put NULL at an address higher than
; zero. That made the C NULL string not very NULL at all.

DGROUP          group   _DATA, _BSS
assume  cs:_TEXT, ds:DGROUP

extrn   _pm_info:far, _pm_init:far

extrn   _pm_pagetables:byte, _pm_selectors:word, _pm_rmstacklen:word
extrn   _pm_pmstacklen:word, _pm_rmstacks:byte, _pm_pmstacks:byte
extrn   _pm_callbacks:byte

PMODE_TEXT      segment para public use16 'CODE'
assume  cs:PMODE_TEXT, ds:PMODE_TEXT

;
dataseg         dw      _DATA

errmsgtbl       dw      errmsg0,errmsg1,errmsg2,errmsg3
                dw      errmsg4,errmsg5,errmsg6

errmsg0         db      'Not enough low memory!',13,10,36
errmsg1         db      '80386 or better not detected!',13,10,36
errmsg2         db      'System already in protected mode and no VCPI or DPMI found!',13,10,36
errmsg3         db      'DPMI host is not 32bit!',13,10,36
errmsg4         db      'Could not enable A20 gate!',13,10,36
errmsg5         db      'Could not enter DPMI 32bit protected mode!',13,10,36
errmsg6         db      'Could not allocate needed DPMI selectors!',13,10,36
errmsg7         db      'Not enough extended memory!',13,10,36
errmsg8         db      'DOS version too low!',13,10,36

;
start:
        push cs
        pop ds

        call _pm_info
        jc short @@startf1

        push es
        mov ebx,offset __PMpagetables
        call get32bitval
        mov _pm_pagetables,al
        mov ebx,offset __PMselectors
        call get32bitval
        mov _pm_selectors,ax
        mov ebx,offset __PMrmstacklen
        call get32bitval
        mov _pm_rmstacklen,ax
        mov ebx,offset __PMpmstacklen
        call get32bitval
        mov _pm_pmstacklen,ax
        mov ebx,offset __PMrmstacks
        call get32bitval
        mov _pm_rmstacks,al
        mov ebx,offset __PMpmstacks
        call get32bitval
        mov _pm_pmstacks,al
        mov ebx,offset __PMcallbacks
        call get32bitval
        mov _pm_callbacks,al
        pop es

        call _pm_info
        jnc short @@startf0

;-----------------------------------------------------------------------------
@@startf1:
        mov si,ax
        add si,ax
        mov dx,errmsgtbl[si]
        mov ah,9
        int 21h

        mov ax,4cffh
        int 21h

;-----------------------------------------------------------------------------
@@startf0:
        shrd ebp,ecx,16

        mov bp,ss
        mov cx,es:[2]
        sub cx,40h
        mov es,bp
        mov ss,cx

        add bp,bx
        xor ax,ax
        cmp bp,cx
        ja @@startf1

;-----------------------------------------------------------------------------
        call _pm_init
        jc @@startf1

;-----------------------------------------------------------------------------
        mov cx,1
        xor ax,ax
        int 31h

        mov bx,ax

        mov dx,0ffffh
        mov cx,dx
        mov ax,8
        int 31h

        mov edi,_TEXT
        shl edi,4
        mov dx,di
        shld ecx,edi,16
        mov ax,7
        int 31h

        mov ax,cs
        lar cx,ax
        mov cl,ch
        mov ch,0c0h
        mov ax,9
        int 31h

        push ebx
        db 66h,68h
        dd offset start32

;-----------------------------------------------------------------------------
        mov bx,ds

        mov dx,0ffffh
        mov cx,dx
        mov ax,8
        int 31h

        mov esi,_DATA
        shl esi,4
        mov dx,si
        shld ecx,esi,16
        mov ax,7
        int 31h

;-----------------------------------------------------------------------------
        mov ds,bx

        db 66h
        retf

;
get32bitval:
        mov eax,DGROUP
        shl eax,4
        add eax,ebx
        and bx,0fh
        shr eax,4
        mov es,ax
        mov ax,es:[bx]
        ret

;
assume  ds:_DATA
rmcpm0noregs:
        mov edi,offset rmapm0noregs

;-----------------------------------------------------------------------------
rmcpm0:
        mov ds,cs:dataseg
        mov bx,ss

;-----------------------------------------------------------------------------
rmcpm:
        shl ebx,16
        mov bx,sp
        sub bx,8
        xchg ebx,ssespbuf
        push ebx

        mov ebx,_pmstacktop
        push ebx

        mov eax,ebx
        sub eax,_pmstacklen
        mov _pmstacktop,eax

        mov si,_codesel
        mov dx,_datasel
        mov cx,dx
        mov ax,dx
        jmp _rmswitch

;
rmcpm0regs:
        mov edi,offset rmapm0regs
        jmp rmcpm0

;
rmcpmi0noregs:
        mov edi,offset rmapmi0noregs
        jmp rmcpm0

;
rmcpmi0regs:
        mov edi,offset rmapmi0regs
        jmp rmcpm0

;-----------------------------------------------------------------------------
rmrpm0:
        pop _pmstacktop
        pop ssespbuf

        retf

;
rmcpm1noregs:
        mov esi,offset rmapm1noregs

;-----------------------------------------------------------------------------
rmcpm1:
        mov ds,cs:dataseg
        mov bx,ss
        mov es,bx
        sub sp,_statesize
        mov di,sp
        xor al,al
        call _rmstate

        mov edi,esi
        jmp rmcpm

;
rmcpm1regs:
        mov esi,offset rmapm1regs
        jmp rmcpm1

;
rmcpmi1noregs:
        mov esi,offset rmapmi1noregs
        jmp rmcpm1

;
rmcpmi1regs:
        mov esi,offset rmapmi1regs
        jmp rmcpm1

;-----------------------------------------------------------------------------
rmrpm1:
        pop _pmstacktop
        pop ssespbuf

        mov ax,ss
        mov es,ax
        mov di,sp
        mov al,1
        call _rmstate
        add sp,_statesize

        retf

;
pmarm0noregs:
        push large offset pmrrm0
        dw 6866h,pmarmnoregsr,PMODE_TEXT
        push ebp
        retf

;
pmarm0regs:
        push large offset pmrrm0

;-----------------------------------------------------------------------------
pmarmregs:
        dw 6866h,pmarmregsr,PMODE_TEXT
        push ebp
        mov edi,_rs[0]
        mov esi,_rs[4]
        mov ebp,_rs[8]
        mov ebx,_rs[16]
        mov edx,_rs[20]
        mov ecx,_rs[24]
        mov eax,_rs[28]
        mov fs,_rs[38]
        mov gs,_rs[40]
        mov ds,_rs[36]
        retf

;-----------------------------------------------------------------------------
pmarmregsr:
        push ds
        mov ds,cs:dataseg
        pushf
        pop word ptr _rs[32]
        mov _rs[0],edi
        mov _rs[4],esi
        mov _rs[8],ebp
        mov _rs[16],ebx
        mov _rs[20],edx
        mov _rs[24],ecx
        mov _rs[28],eax
        mov _rs[34],es
        mov _rs[38],fs
        mov _rs[40],gs
        pop word ptr _rs[36]

;-----------------------------------------------------------------------------
pmarmnoregsr:
        mov ds,cs:dataseg
        mov ax,_datasel
        mov dx,ax
        mov cx,ax
        mov ebx,ssespbuf
        mov si,_codesel
        pop edi
        jmp _rmswitch

;
pmarmi0noregs:
        push large offset pmrrm0
        pushf
        dw 6866h,pmarmnoregsr,PMODE_TEXT
        push ebp
        retf

;
pmarmi0regs:
        push large offset pmrrm0
        pushf
        jmp pmarmregs

;
pmarm1noregs:
        push large offset pmrrm1
        dw 6866h,pmarmnoregsr,PMODE_TEXT
        push ebp
        retf

;
pmarm1regs:
        push large offset pmrrm1
        jmp pmarmregs

;
pmarmi1noregs:
        push large offset pmrrm1
        pushf
        dw 6866h,pmarmnoregsr,PMODE_TEXT
        push ebp
        retf

;
pmarmi1regs:
        push large offset pmrrm1
        pushf
        jmp pmarmregs

PMODE_TEXT      ends

extrn   MBINIT:near
extrn   MBMALLOC:near
extrn   MBCORELEFT:near
extrn   MB_INFO:near
extrn   MB_ALLOC:near
extrn   MB_FREE:near

extrn   _PMmain:near

public  EXIT
public  DATASTACK
public  RESTORESTACK

_TEXT           segment para public use32 'CODE'
assume  cs:_TEXT, ds:DGROUP
org     0

;
start32:
        cld
        sti

        mov _codebase,edi
        mov _codesel,cs
        mov _database,esi
        mov _datasel,ds

        sub edi,esi
        mov _data_code,edi
        neg edi
        mov _code_data,edi

        neg esi
        mov _zeroptr,esi

        mov bx,es:[2ch]
        mov _envsel,bx
        mov ax,6
        int 31h
        mov word ptr _envbase[0],dx
        mov word ptr _envbase[2],cx

        mov bx,es
        mov _pspsel,bx
        mov ax,6
        int 31h
        mov word ptr _pspbase[0],dx
        mov word ptr _pspbase[2],cx

        mov ax,cs
        lar ax,ax
        shr ah,5
        and ah,3
        mov _CPL,ah
        mov ax,3
        int 31h
        mov _selinc,ax
        shld eax,ebp,8
        mov _PMtype,al
        mov ax,400h
        int 31h
        mov _DPMIversion,ax
        mov _processor,cl
        mov _PICmaster,dh
        mov _PICslave,dl

        mov ax,305h
        int 31h
        mov _statesize,ax
        mov word ptr _rmstate[0],cx
        mov word ptr _rmstate[2],bx
        mov dword ptr _pmstate[0],edi
        mov word ptr _pmstate[4],si
        mov ax,306h
        int 31h
        mov word ptr _rmswitch[0],cx
        mov word ptr _rmswitch[2],bx
        mov dword ptr _pmswitch[0],edi
        mov word ptr _pmswitch[4],si

        mov ah,30h
        int 21h
        xchg al,ah
        mov _osversion,ax
        cmp ax,__minosversion
        jae short @@start32f0

        mov ax,offset errmsg8

;-----------------------------------------------------------------------------
@@start32f1:
        push ds
        pop es

        mov edi,offset _rs
        mov [edi+14h],ax
        mov word ptr [edi+24h],PMODE_TEXT
        mov byte ptr [edi+1ch+1],9
        xor cx,cx
        mov bx,21h
        mov ax,300h
        int 31h

        mov ax,4cffh
        int 21h

;-----------------------------------------------------------------------------
@@start32f0:
        movzx edi,word ptr es:[2]
        movzx esi,bp
        shl edi,4
        shl esi,4

        push ds
        pop es

        mov eax,__stklen
        add eax,0fh
        and al,0f0h

        add esi,eax
        mov ax,offset errmsg0
        sub edi,esi
        jc @@start32f1

        mov ebx,esi
        sub ebx,_database
        mov ax,ds
        mov ss,ax
        mov esp,ebx

;-----------------------------------------------------------------------------
        mov ebx,__lowheaplen
        add ebx,MBheadersize
        add ebx,3
        mov ax,offset errmsg0
        cmp edi,ebx
        jb @@start32f1

        mov _lowheapblock[0],esi
        mov _lowheapblock[4],edi

        mov ecx,_zeroptr
        mov [ecx+4d0h],esp

        push offset _lowheapblock
        call MBINIT

;-----------------------------------------------------------------------------
        movzx ecx,__lowbuflen
        jecxz short @@start32f4

        push offset _lowheapblock
        push ecx
        call MBMALLOC

        mov __lowbufptr,eax
        or eax,eax
        mov ax,offset errmsg0
        jz @@start32f1

;-----------------------------------------------------------------------------
@@start32f4:
        cmp _statesize,0
        je short @@start32f5

        mov _rmcpmnoregs,offset rmcpm1noregs
        mov _rmcpmregs,offset rmcpm1regs
        mov _rmcpminoregs,offset rmcpmi1noregs
        mov _rmcpmiregs,offset rmcpmi1regs
        mov _pmcrmnoregs,offset pmcrm1noregs
        mov _pmcrmregs,offset pmcrm1regs
        mov _pmcrminoregs,offset pmcrmi1noregs
        mov _pmcrmiregs,offset pmcrmi1regs

;-----------------------------------------------------------------------------
@@start32f5:
        movzx edi,__pmcrmstacks
        movzx eax,__pmcrmstacklen
        shl eax,4
        mov _rmstacklen,ax
        imul edi,eax

        movzx esi,__rmcpmstacks
        movzx eax,__rmcpmstacklen
        shl eax,4
        mov _pmstacklen,eax
        imul esi,eax

        lea eax,[esi+edi+0fh]
        push offset _lowheapblock
        push eax
        call MBMALLOC

        lea ebx,[eax+0fh]
        and bl,0f0h
        mov _pmstackbase,ebx
        add ebx,esi
        mov _pmstacktop,ebx
        add ebx,_database
        shr ebx,4
        mov _rmstackbase,bx
        shr edi,4
        add ebx,edi
        mov _rmstacktop,bx

        or eax,eax
        mov ax,offset errmsg0
        jz @@start32f1

;-----------------------------------------------------------------------------
        push offset _lowheapblock
        call MBCORELEFT
        cmp eax,__lowheaplen
        mov ax,offset errmsg0
        jb @@start32f1

;-----------------------------------------------------------------------------
        mov edi,__extheapmax
        or edi,edi
        jz short @@start32f2

        add edi,MBheadersize
        add edi,3
        call MB_INFO

        cmp edi,eax
        jb short @@start32f3
        mov edi,eax

@@start32f3:
        mov edx,__extheapmin
        lea esi,[edx+3]
        add esi,MBheadersize

@@start32l0:
        mov ax,offset errmsg7
        cmp edi,esi
        ja short @@start32l0f1

        cmp edi,edx
        jb @@start32f1

        jmp short @@start32f2

@@start32l0f1:
        push offset _extheapblock
        push edi
        call MB_ALLOC

        sub edi,1024
        or eax,eax
        js @@start32l0

        push offset _extheapblock
        call MBINIT
@@start32f2:

;-----------------------------------------------------------------------------
        call _PMmain

        push eax
        push eax
EXIT:
        cmp _extheapblock[4],0
        je short @@exitf0

        push offset _extheapblock
        call MB_FREE

@@exitf0:
        mov al,[esp+4]
        mov ah,4ch
        int 21h

;
pmcrm0noregs:
        mov di,offset pmarm0noregs

;-----------------------------------------------------------------------------
pmcrm:
        lea eax,[esp-6]
        xchg eax,ssespbuf
        push eax

        mov dx,_rmstacktop
        mov bx,_rmstacklen
        push dx

        sub dx,__pmcrmstacklen
        mov _rmstacktop,dx

        mov si,PMODE_TEXT
        mov cx,word ptr _rs[34]
        mov ax,_DATA
        jmp _pmswitch

;
pmcrm0regs:
        mov di,offset pmarm0regs
        jmp pmcrm
        
;
pmcrmi0noregs:
        mov di,offset pmarmi0noregs
        jmp pmcrm
        
;
pmcrmi0regs:
        mov di,offset pmarmi0regs
        jmp pmcrm
        
;-----------------------------------------------------------------------------
pmrrm0:
        pop _rmstacktop
        pop ssespbuf

        cld
        ret

;
pmcrm1noregs:
        mov si,offset pmarm1noregs

;-----------------------------------------------------------------------------
pmcrm1:
        sub esp,dword ptr _statesize
        mov edi,esp
        xor al,al
        call _pmstate

        mov edi,esi
        jmp pmcrm

;
pmcrm1regs:
        mov si,offset pmarm1regs
        jmp pmcrm1

;
pmcrmi1noregs:
        mov si,offset pmarmi1noregs
        jmp pmcrm1

;
pmcrmi1regs:
        mov si,offset pmarmi1regs
        jmp pmcrm1

;-----------------------------------------------------------------------------
pmrrm1:
        pop _rmstacktop
        pop ssespbuf

        mov edi,esp
        mov al,1
        call _pmstate
        add esp,dword ptr _statesize

        cld
        ret

;
rmapm0noregs:
        push offset rmrpm0
        push offset rmapmnoregsr
        cld
        jmp ebp

;
rmapm0regs:
        push offset rmrpm0

;
rmapmregs:
        push offset rmapmregsr
        push ebp
        mov edi,_rs[0]
        mov esi,_rs[4]
        mov ebp,_rs[8]
        mov ebx,_rs[16]
        mov edx,_rs[20]
        mov ecx,_rs[24]
        mov eax,_rs[28]
        cld
        ret

;-----------------------------------------------------------------------------
rmapmregsr:
        db 66h,9ch
        pop word ptr _rs[32]
        mov _rs[0],edi
        mov _rs[4],esi
        mov _rs[8],ebp
        mov _rs[16],ebx
        mov _rs[20],edx
        mov _rs[24],ecx
        mov _rs[28],eax

;-----------------------------------------------------------------------------
rmapmnoregsr:
        mov ax,_DATA
        mov bx,word ptr ssespbuf
        mov dx,word ptr ssespbuf[2]
        mov si,PMODE_TEXT
        pop edi
        jmp _pmswitch

;
rmapmi0noregs:
        push offset rmrpm0
        pushfd
        push cs
        push offset rmapmnoregsr
        cld
        jmp ebp

;
rmapmi0regs:
        push offset rmrpm0
        pushfd
        push cs
        jmp rmapmregs

;
rmapm1noregs:
        push offset rmrpm1
        push offset rmapmnoregsr
        cld
        jmp ebp

;
rmapm1regs:
        push offset rmrpm1
        jmp rmapmregs

;
rmapmi1noregs:
        push offset rmrpm1
        pushfd
        push cs
        push offset rmapmnoregsr
        cld
        jmp ebp

;
rmapmi1regs:
        push offset rmrpm1
        pushfd
        push cs
        jmp rmapmregs

;
DATASTACK:
        pop ecx
        mov eax,_pmstacktop
        mov edx,eax
        sub edx,_pmstacklen
        mov _pmstacktop,edx
        mov dx,ss
        mov ss,_datasel
        xchg esp,eax
        jmp ecx

;
RESTORESTACK:
        pop ecx
        mov ss,dx
        mov esp,eax
        mov eax,_pmstacklen
        add _pmstacktop,eax
        jmp ecx

_TEXT           ends

extrn   MBheadersize:dword

extrn   __PMpagetables:byte
extrn   __PMselectors:word
extrn   __PMrmstacklen:word
extrn   __PMpmstacklen:word
extrn   __PMrmstacks:byte
extrn   __PMpmstacks:byte
extrn   __PMcallbacks:byte
extrn   __pmcrmstacklen:word
extrn   __pmcrmstacks:byte
extrn   __rmcpmstacklen:word
extrn   __rmcpmstacks:byte

extrn   __stklen:dword
extrn   __lowheaplen:dword
extrn   __extheapmin:dword
extrn   __extheapmax:dword
extrn   __minosversion:word
extrn   __lowbufptr:dword
extrn   __lowbuflen:word

public  _codebase
public  _database
public  _pspbase
public  _envbase
public  _codesel
public  _datasel
public  _pspsel
public  _envsel
public  __TEXTseg
public  __DATAseg
public  __BSSseg
public  _zeroptr
public  _data_code
public  _code_data

public  _osversion
public	_osminor
public	_osmajor
public	_DPMIversion
public	_DPMIminor
public	_DPMImajor

public	_CPL
public	_selinc
public	_PMtype
public	_processor
public  _PICtable
public  _PICmaster
public	_PICslave

public  _rmstate
public	_rmswitch
public	_pmstate
public	_pmswitch
public  _statesize

public  _pmcrmnoregs
public  _pmcrmregs
public  _pmcrminoregs
public  _pmcrmiregs
public  _rmcpmnoregs
public  _rmcpmregs
public  _rmcpminoregs
public  _rmcpmiregs

public  _pmstacklen
public  _pmstackbase
public  _pmstacktop
public  _rmstacklen
public  _rmstackbase
public  _rmstacktop

public  _lowheapblock
public  _extheapblock
public  _rs

_DATA           segment para public use32 'DATA'
org     0
NULL            dd      0

_codebase       dd      ?               ; linear base of 32bit code segment
_database       dd      ?               ; linear base of 32bit data segment
_pspbase        dd      ?               ; linear base of PSP
_envbase        dd      ?               ; linear base of environment
_codesel        dw      ?, 0            ; 32bit code selector
_datasel        dw      ?, 0            ; 32bit data selector
_pspsel         dw      ?, 0            ; PSP selector
_envsel         dw      ?, 0            ; environment selector
__TEXTseg       dw      _TEXT, 0
__DATAseg       dw      _DATA, 0
__BSSseg        dw      _BSS, 0
_zeroptr        dd      ?               ; realative ptr to 0
_data_code      dd      ?               ; _codebase - _database
_code_data      dd      ?               ; _database - _codebase

_osversion      label   word            ; full DOS version                   |
_osminor        db      ?               ; minor version of DOS               |
_osmajor        db      ?               ; major version of DOS               |
                dw      0
_DPMIversion    label   word            ; full DPMI version                  |
_DPMIminor      db      ?               ; minor version of DPMI              |
_DPMImajor      db      ?               ; major version of DPMI              |
                dw      0

_rmstate        dd      ?               ; real mode state save seg:off
_rmswitch       dd      ?               ; real mode mode switch seg:off
_pmstate        df      ?               ; protected mode state save sel:off
_pmswitch       df      ?               ; protected mode mode switch sel:off
_statesize      dw      ?, 0            ; size of state buffer
_rmcpmnoregs    dw      rmcpm0noregs    ; call protected mode, no regs       |
                dw      PMODE_TEXT      ;                                    |
_rmcpmregs      dw      rmcpm0regs      ; call protected mode, regs         |
                dw      PMODE_TEXT      ;                                   |
_rmcpminoregs   dw      rmcpmi0noregs   ; call protected mode iret, no regs  |
                dw      PMODE_TEXT      ;                                    |
_rmcpmiregs     dw      rmcpmi0regs     ; call protected mode iret, regs    |
                dw      PMODE_TEXT      ;                                   |
_pmstacklen     dd      ?
_pmstackbase    dd      ?
_pmstacktop     dd      ?
_pmcrmnoregs    dd      pmcrm0noregs    ; call real mode, no regs
_pmcrmregs      dd      pmcrm0regs      ; call real mode, pass regs
_pmcrminoregs   dd      pmcrmi0noregs   ; call real mode iret, no regs
_pmcrmiregs     dd      pmcrmi0regs     ; call real mode iret, pass regs
_rmstacklen     dw      ?, 0
_rmstackbase    dw      ?, 0
_rmstacktop     dw      ?, 0

ssespbuf        dd      ?

_selinc         dw      ?, 0            ; selector increment value
_CPL            db      ?, 0,0,0        ; task CPL
_PMtype         db      ?, 0,0,0        ; protected mode type (from PMODE)
_processor      db      ?, 0,0,0        ; processor type
_PICtable       label   byte            ;                                    |
_PICmaster      db      ?               ; base interrupt of master PIC       |
_PICslave       db      ?               ; base interrupt of slave PIC        |

_lowheapblock   dd      0,0,0           ; low memory heap info block
_extheapblock   dd      0,0,0           ; extended memory heap info block

_rs             label   dword           ; register data structure
                db      32h dup(0)

_DATA           ends

_STACK          segment para stack use16 'STACK'
                db      400h dup(?)
_STACK          ends

end     start

