;
;                        MEMBLOCK Reallocate Mem Block
;
;
; Borland C++ 4.0 for WIN32 prototype:
; PTR   __pascal mbrealloc (MEMBLOCK *mb, PTR ptr, DWORD size);
;
; version 0.3
; - White Shadow -
;
.386p
Ideal
include "bmmalloc.inc"

Public MBREALLOC


extrn MBMALLOC:near, MBFREE:near


;
Segment _TEXT byte public use32 'CODE'
Assume  cs:_TEXT, ds:DGROUP


; -- argument stack offsets
arg1 = 8
arg2 = 4
arg3 = 0

MBREALLOC:      push ebx esi edi ebp
pct = (4)+(4*4)

                mov  ecx, [esp+pct+arg3]        ; - New size
                mov  edx, [esp+pct+arg2]        ; -> MemArea to resize
                mov  esi, [esp+pct+arg1]        ; -> MEMBLOCK

                ;-- Align new size; is size valid
                add  ecx, 03h
                and  ecx, NOT (03h)             ; dword alignment
                jz   RA_ExitNull
                js   RA_ExitNull
                ; 0 < requested size < 2^31

                ;-- MemArea ptr null (do a regular malloc) ?
                or   edx, edx
                jnz  RA_00

;--------------- Do MALLOC
;PTR __pascal mbmalloc (MEMBLOCK *mb, DWORD size);
                push esi                        ; -> MEMBLOCK
                push ecx                        ; New size
                call MBMALLOC
                ; eax = ptr to memarea (or null)
                jmp  RA_Exit
;---------------

RA_00:          ;-- Get MemNode ptr
                sub  edx, size MemNode          ; -> MemNode to resize

                ;-- Load MEMBLOCK info
                mov  ebx, [esi+MEMBLOCK.base]   ; linear adx
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  ebp, [esi+MEMBLOCK.size]   ; size of MEMBLOCK
                add  ebp, ebx                   ; -> final adx + 1

If DebugMode    ;-- Check MBSig
                cmp  [dword ebx], MBSig
                jne  RA_CorruptMB
                add  ebx, MBSigSize             ; -> 1st MemNode
EndIf
                ;-- Init previous MemNode ->
                xor  edi, edi

;---------------

RA_FindNode:
; ebx -> current MemNode
; ecx - new size
; edx -> MemNode to resize
; edi -> Previous MemNode
; ebp -> final byte of MEMBLOCK + 1

If DebugMode    ;-- Check MemNode
                mov  eax, [ebx+MemNode.size]
                xor  eax, NodeSigKey
                cmp  [ebx+MemNode.sig], eax
                jne  RA_CorruptMB               ; invalid MemNode?
EndIf
                ;-- Is current MemNode the one to resize?
                cmp  edx, ebx
                je   RA_FoundNode

                ;-- Store previous MemNode
                mov  edi, ebx

                ;-- Point to next node
                mov  eax, [ebx+MemNode.size]
                and  eax, 7fffffffh             ; kill 'used' flag if there
                add  ebx, size MemNode          ; skip MemNode
                add  ebx, eax                   ; skip MemAera

                ;-- Any more nodes to check?
                cmp  ebx, ebp
                jb   RA_FindNode
                ja   RA_CorruptMB
                jmp  RA_ExitNull                ; end of MEMBLOCK

;---------------

RA_FoundNode:
; ebx -> MemNode to resize
; ecx - new size
; edi -> Previous MemNode (null if none)
; ebp -> final byte of MEMBLOCK + 1

                ;-- Get old size
                mov  eax, [ebx+MemNode.size]
                xor  eax, 80000000h
                js   RA_ExitNull                ; MemNode was free

                ;-- Make MemArea larger, smaller or equal?
                cmp  ecx, eax
                ja   RA_Larger

;--------------- Make MemArea smaller (or equal)

RA_Smaller:
; eax - old size
; ebx -> MemNode to resize
; ecx - new size

                ;-- Can we create a new MemNode and Area?
                sub  eax, ecx                   ; # bytes left over
                sub  eax, size MemNode          ; # bytes ofter header
                jbe  RA_ExitPtr                 ; not enough bytes left
                ; eax - # bytes for 2nd MemArea

                ;-- Write 1st MemNode info
                mov  edx, ecx
                or   edx, 80000000h             ; mark area used
                mov  [ebx+MemNode.size], edx
If DebugMode
                xor  edx, NodeSigKey
                mov  [ebx+MemNode.sig], edx
EndIf
                ;-- Write 2nd MemNode info
                add  ebx, size MemNode
                add  ebx, ecx
                mov  [ebx+MemNode.size], eax    ; leave area free
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
EndIf
                jmp  RA_ExitPtr                 ; use old pointer...

;--------------- Make MemArea larger

RA_Larger:
; eax - old size
; ebx -> MemNode to resize
; ecx - new size
; edi -> Previous MemNode (null if none)
; ebp -> final byte of MEMBLOCK + 1

                ;-- Check next node
                mov  esi, ebx
                add  esi, size MemNode          ; for orig MemNode
                add  esi, eax
                cmp  esi, ebp
                ja   RA_CorruptMB
                je   RA_NoNext

                ;-- Is next MemArea free?
                mov  edx, [esi+MemNode.size]
If DebugMode
                xor  edx, NodeSigKey
                cmp  [esi+MemNode.sig], edx
                jne  RA_CorruptMB
                xor  edx, NodeSigKey
EndIf
                or   edx, edx
                js   RA_NoNext                  ; not free!

                ;-- Next MemNode enough?
                add  eax, size MemNode          ; for next MemNode
                add  eax, edx
                cmp  ecx, eax
                ja   RA_NextNotEnough

                ;-- Kill 2nd MemNode header
                mov  [esi+MemNode.size], 0

                ;-- Join with 1st MemNode
                or   eax, 80000000h             ; mark as used
                mov  [ebx+MemNode.size], eax
If DebugMode
                xor  eax, NodeSigKey
                mov  [esi+MemNode.sig], eax
                xor  eax, NodeSigKey
EndIf
                and  eax, 7fffffffh
                ;-- Now we're making the new node smaller (or equal)
                ;   with no memory moves
; eax - avail size
; ebx -> orig MemNode of size EAX
; ecx - new size
                jmp  RA_Smaller

;---------------

RA_NoNext:      xor  esi, esi                   ; no next node
RA_NextNotEnough:
; eax - total avail size so far
; ebx -> orig MemNode
; ecx - requested size
; esi -> next MemNode (or null)
; edi -> prev MemNode (or null)

                ;-- Any prev MemNode?
                or   edi, edi
                jz   RA_NoPrev

                ;-- Is previous MemArea free?
                mov  edx, [edi+MemNode.size]
If DebugMode
                xor  edx, NodeSigKey
                cmp  [edi+MemNode.sig], edx
                jne  RA_CorruptMB
                xor  edx, NodeSigKey
EndIf
                or   edx, edx
                js   RA_NoPrev                  ; not free!

                ;-- With prev enough?
                add  eax, edx
                add  eax, size MemNode          ; for orig MemNode
                cmp  ecx, eax
                ja   RA_PrevNotEnough

                ;-- Kill next MemNode
                or   esi, esi
                jz   RA_NoNextKill
                mov  [esi+MemNode.size], 0
RA_NoNextKill:
                ;-- Save requested size
                mov  ebp, ecx

                ;-- Set copy length
                mov  ecx, [ebx+MemNode.size]    ; from orig MemNode
                and  ecx, 7fffffffh

                ;-- Kill orig MemNode
                mov  [ebx+MemNode.size], 0

                ;-- Set source for copy
                mov  esi, ebx
                add  esi, size MemNode          ; -> orig MemArea

                ;-- Save prev MemNode ptr
                mov  ebx, edi

                ;-- Set dest for copy
                add  edi, size MemNode          ; -> prev MemArea

                ;-- Update stack MemArea ptr for exit code
                mov  [esp+pct+arg2], edi

                ;-- Copy data, length dword aligned
                shr  ecx, 2
                rep  movsd

                ;-- Write info for new node
                or   eax, 80000000h             ; mark size as used
                mov  [ebx+MemNode.size], eax    ; -> prev MemNode
If DebugMode
                xor  eax, NodeSigKey
                mov  [ebx+MemNode.sig], eax
                xor  eax, NodeSigKey
EndIf
                and  eax, 7fffffffh

                ;-- Restore requested size
                mov  ecx, ebp

                ;-- Shrink new node
; eax - avail size (new size of prev MemNode)
; ebx -> prev MemNode
; ecx - requested size
                jmp  RA_Smaller

;---------------

RA_NoPrev:
RA_PrevNotEnough:
; ebx -> orig memnode
; ecx - requested size

                ;-- Try a malloc within the same memory block
                ; PTR   __pascal mbmalloc (MEMBLOCK *mb, DWORD size);
                mov  eax, [esp+pct+arg1]        ; -> MEMBLOCK
                push eax
                push ecx
                call MBMALLOC                   ; ebx is preserved

                ;-- Did we get the requested memory?
                or   eax, eax
                jz   RA_ExitNull                ; could not increase size

                ;-- Copy memory
                mov  ecx, [ebx+MemNode.size]
                and  ecx, 7fffffffh             ; orig MemArea size
                mov  esi, ebx
                add  esi, size MemNode          ; -> orig MemArea
                mov  edi, eax                   ; -> new MemArea
                shr  ecx, 2                     ; copy size / 4
                rep  movsd

                ;-- Update stack MemArea ptr (for exit)
                mov  [esp+pct+arg2], eax

                ;-- Free orig MemArea
                ; void  __pascal mbfree (MEMBLOCK *mb, PTR ptr);
                mov  eax, [esi+pct+arg1]        ; -> MEMBLOCK
                add  ebx, size MemNode          ; -> orig MemArea
                push eax
                push ebx
                call MBFREE

                jmp  short RA_ExitPtr

;---------------

RA_ExitNull:    xor  eax, eax
                jmp  short RA_Exit

;---------------

RA_ExitPtr:     mov  eax, [esp+pct+arg2]        ; -> MemArea

;---------------

RA_Exit:        pop  ebp edi esi ebx
                ret  12                         ; 3 args

;---------------

RA_CorruptMB:
If DebugMode    ;-- Invalidate MEMBLOCK
                mov  ebx, [esp+pct+arg1]        ; -> MEMBLOCK
                mov  ebx, [ebx+MEMBLOCK.base]   ; linear adx of MEMBLOCK
                sub  ebx, [_database]           ; relative ofs to DGROUP
                mov  [dword ebx], MBSigInvl
EndIf
                jmp  short RA_ExitNull


;
EndS            _TEXT
End

