; STDLIB32 for PMC
; (c) Ng Yew Choong (arjuna/sad little people) 1995
; conv.asm - atoi and itoa clones

ideal
smart
jumps
locals  @@

p386

include "pmc.inc"
include "stdlib32.inc"


segDATA

digits  db      "0123456789abcdefghijklmnopqrstuvwxyz"

ends


segTEXT

proc c  _itoa uses edi ebx ecx edx, \
        num:dword, string:dword, radix:dword, sign:dword, prec:dword

        xor     eax,eax
        cmp     [radix],0
        jb      @@exit
        cmp     [radix],36
        ja      @@exit
        cmp     [radix],1
        jz      @@exit
        mov     edi,[string]
        or      edi,edi
        jz      @@exit

        xor     ecx,ecx
        cmp     [radix],0
        jnz     @@skip
        mov     [radix],10
        cmp     [num],0
        jnl     @@not_neg
        neg     [num]
        mov     [byte edi],'-'
        inc     edi
        inc     ecx
        dec     [prec]
        jmp     @@skip
@@not_neg:
        cmp     [sign],0
        jz      @@skip
        mov     [byte edi],'+'
        inc     edi
        inc     ecx
        dec     [prec]
@@skip:
        cmp     [prec],0
        jnl     @@skip2
        mov     [prec],0
@@skip2:
        push    edi
        mov     eax,[num]
@@loop:
        xor     edx,edx
        div     [radix]
        mov     ebx,offset digits
        add     ebx,edx
        mov     dl,[ebx]
        mov     [edi],dl
        inc     edi
        inc     ecx
        or      eax,eax
        jz      @@loop2
        jmp     @@loop
@@loop2:
        cmp     ecx,[prec]
        jnb     @@done
        mov     [byte edi],'0'
        inc     edi
        inc     ecx
        jmp     @@loop2
@@done:
        mov     [byte edi],0
        mov     ebx,edi
        dec     ebx
        pop     edi
        push    ecx
        mov     ecx,ebx
        sub     ecx,edi
        inc     ecx
        shr     ecx,1
        jecxz   @@done2
@@loop3:
        mov     al,[edi]
        mov     ah,[ebx]
        mov     [edi],ah
        mov     [ebx],al
        inc     edi
        dec     ebx
        loop    @@loop3
@@done2:
        pop     ecx
        mov     eax,ecx
@@exit:
        ret
endp


proc c  _atoi uses esi ebx ecx edx, \
        string:dword, radix:dword
        local   negflg:dword

        mov     [negflg],0              ;init neg flag
        cmp     [radix],0               ;check radix
        jb      @@error
        cmp     [radix],36
        ja      @@error
        cmp     [radix],1
        jz      @@exit
        mov     esi,[string]            ;check string ptr
        or      esi,esi
        jz      @@error

        xor     cl,cl                   ;cl has isalnum mask
        or      cl,_IS_DIG
        or      cl,_IS_UPP
        or      cl,_IS_LOW
@@loop_spc:
        xor     ebx,ebx
        mov     bl,[esi]
        or      bl,bl
        jz      @@error
        cmp     bl,'-'                  ;is it a neg sign? @@neg
        jz      @@neg
        mov     al,[_ctype+ebx+1]
        test    al,cl                   ;isalnum? @@start
        jnz     @@start
        test    al,_IS_SP               ;skip spaces
        jnz     @@skip_spc
        jmp     @@error
@@skip_spc:
        inc     esi
        jmp     @@loop_spc

@@neg:
        cmp     [radix],0               ;neg handling only for radix 0
        jnz     @@error
        mov     [negflg],-1             ;set neg flag
        cmp     bl,'-'
        jnz     @@start
        inc     esi                     ;skip '-' character
@@start:
        cmp     [radix],0
        jnz     @@start2
        mov     [radix],10
@@start2:
        xor     eax,eax                 ;eax holds converted number, init here
@@loop_conv:
        xor     ebx,ebx
        mov     bl,[esi]
        mov     ch,[_ctype+ebx+1]
        test    ch,cl                   ;!isalnum? @@done
        jz      @@done
        sub     bl,020h                 ;conversion starts
        and     bl,03fh
        sub     bl,020h
        xchg    eax,ebx
        cbw
        xchg    eax,ebx
        mov     ch,010h
        and     ch,bh
        add     bl,ch
        not     bh
        mov     ch,10
        and     ch,bh
        add     bl,ch
        and     ebx,0ffh
        cmp     ebx,[radix]
        jnb     @@done
        mul     [radix]
        add     eax,ebx
        inc     esi
        jmp     @@loop_conv

@@done:
        xor     eax,[negflg]            ;if neg flag, negate
        sub     eax,[negflg]
        jmp     @@exit

@@error:
        xor     eax,eax
@@exit:
        ret
endp


ends

end
