; STDLIB32 for PMC
; (c) Ng Yew Choong (arjuna/sad little people) 1995
; sprintf.asm - sprintf clone

ideal
smart
jumps
locals  @@

p386

include "pmc.inc"
include "stdlib32.inc"


segDATA

ends


segTEXT

proc c  sprintf uses esi edi ebx ecx edx, \
        buff:dword, fmt:dword, params:dword
        local   _left:dword, _sign:dword,  _alt:dword,  _pad:dword, \
                _mod:dword,  _width:dword, _prec:dword, _radix:dword, \
                _caps:dword, _prefix:dword

        mov     eax,-1
        mov     esi,[fmt]
        mov     edi,[buff]
        or      esi,esi
        jz      @@exit
        or      edi,edi
        jz      @@exit
        lea     ebx,[params]

        mov     [_left],0
        mov     [_sign],0
        mov     [_alt],0
        mov     [_mod],0
        mov     [_width],0
        mov     [_prec],-1
        mov     [_pad],' '
        mov     [_radix],0
        mov     [_caps],0
        mov     [_prefix],0
@@loop:
        mov     [byte edi],0
        mov     al,[esi]
        or      al,al
        jz      @@exit
        cmp     al,'%'
        jz      @@ctrl
        mov     [edi],al
        inc     esi
        inc     edi
        jmp     @@loop

@@ctrl:
        inc     esi
        mov     al,[esi]
        cmp     al,'-'
        jnz     @@skip_11
        mov     [_left],1
        jmp     @@ctrl
@@skip_11:
        cmp     al,'+'
        jnz     @@skip_12
        mov     [_sign],1
        jmp     @@ctrl
@@skip_12:
        cmp     al,'#'
        jnz     @@get_width
        mov     [_alt],1
        jmp     @@ctrl

@@get_width:
        mov     al,[esi]
        cmp     al,'0'
        jnz     @@get_width_skip
        mov     [_pad],'0'
        inc     esi
@@get_width_skip:
        mov     al,[esi]
        cmp     al,'*'
        jz      @@get_width2
        cmp     al,'0'
        jb      @@get_prec
        cmp     al,'9'
        ja      @@get_prec
        push    10
        push    esi
        call    _atoi
        add     esp,8
        mov     [_width],eax
@@get_width_loop:
        mov     al,[esi]
        cmp     al,'0'
        jb      @@get_prec
        cmp     al,'9'
        ja      @@get_prec
        inc     esi
        jmp     @@get_width_loop
@@get_width2:
        inc     esi
        mov     eax,[ebx]
        mov     [_width],eax
        add     ebx,4

@@get_prec:
        mov     al,[esi]
        cmp     al,'.'
        jnz     @@get_modifier
        inc     esi
        mov     al,[esi]
        cmp     al,'*'
        jz      @@get_prec2
        cmp     al,'0'
        jb      @@get_modifier
        cmp     al,'9'
        ja      @@get_modifier
        push    10
        push    esi
        call    _atoi
        add     esp,8
        mov     [_prec],eax
        mov     [_pad],' '
@@get_prec_loop:
        mov     al,[esi]
        cmp     al,'0'
        jb      @@get_modifier
        cmp     al,'9'
        ja      @@get_modifier
        inc     esi
        jmp     @@get_width_loop
@@get_prec2:
        inc     esi
        mov     eax,[ebx]
        mov     [_prec],eax
        mov     [_pad],' '
        add     ebx,4

@@get_modifier:
        mov     al,[esi]
        cmp     al,'F'
        jz      @@mod_ok
        cmp     al,'N'
        jz      @@mod_ok
        cmp     al,'h'
        jz      @@mod_ok
        cmp     al,'l'
        jz      @@mod_ok
        cmp     al,'L'
        jz      @@mod_ok
        jmp     @@get_type
@@mod_ok:
        mov     [byte _mod],al
        inc     esi

@@get_type:
        mov     al,[esi]
        inc     esi
        cmp     al,'%'
        jz      @@type_percent
        cmp     al,'c'
        jz      @@type_char
        cmp     al,'s'
        jz      @@type_string
        cmp     al,'n'
        jz      @@type_count
        cmp     al,'P'
        jz      @@type_pointer
        cmp     al,'d'
        jz      @@type_int
        cmp     al,'i'
        jz      @@type_int
        cmp     al,'u'
        jz      @@type_unsigned
        cmp     al,'o'
        jz      @@type_octal
        cmp     al,'x'
        jz      @@type_hex
        cmp     al,'X'
        jz      @@type_hex_caps
        jmp     @@loop

@@type_percent:
        mov     [byte edi],'%'
        inc     edi
        jmp     @@loop

@@type_char:
        mov     eax,[ebx]
        mov     [edi],al
        mov     [byte edi+1],0
        mov     ecx,1
        add     ebx,4
        jmp     @@justify

@@type_count:
        mov     eax,edi
        sub     eax,[buff]
        push    ebx
        mov     ebx,[ebx]
        mov     [ebx],eax
        pop     ebx
        add     ebx,4
        jmp     @@loop

@@type_string:
        xor     ecx,ecx
        push    ebx
        mov     ebx,[ebx]
@@type_string_loop:
        cmp     ecx,[_prec]
        jnb     @@type_string_loop_end
        mov     al,[ebx]
        or      al,al
        jz      @@type_string_loop_end
        mov     [edi],al
        inc     ebx
        inc     edi
        inc     ecx
        jmp     @@type_string_loop
@@type_string_loop_end:
        mov     [byte edi],0
        pop     ebx
        sub     edi,ecx
        add     ebx,4
        jmp     @@justify

@@type_int:
        mov     [_radix],0
        jmp     @@type_num

@@type_unsigned:
        mov     [_radix],10
        jmp     @@type_num

@@type_octal:
        mov     [_radix],8
        jmp     @@type_num

@@type_hex:
        mov     [_radix],16
        jmp     @@type_num

@@type_hex_caps:
        mov     [_radix],16
        mov     [_caps],1
        jmp     @@type_num

@@type_pointer:
        mov     [_radix],16
        mov     [_prec],8
        jmp     @@type_num

@@type_num:
        cmp     [_prec],-1
        jnz     @@type_num_prec
        mov     [_prec],1
@@type_num_prec:
        cmp     [_alt],0
        jz      @@type_num_no_alt
        cmp     [_radix],8
        jnz     @@type_num_not_oct
        sub     [_prec],1
        mov     [_prefix],1
        mov     [_pad],' '
        mov     [byte edi],'0'
        inc     edi
        jmp     @@type_num_no_alt
@@type_num_not_oct:
        cmp     [_radix],16
        jnz     @@type_num_not_hex
        sub     [_prec],2
        mov     [_prefix],2
        mov     [_pad],' '
        mov     [byte edi],'0'
        inc     edi
        mov     [byte edi],'x'
        inc     edi
        jmp     @@type_num_no_alt
@@type_num_not_hex:
@@type_num_no_alt:
        cmp     [_prec],1
        jnl     @@type_num_prec_ok
        mov     [_prec],1
@@type_num_prec_ok:
        xor     ecx,ecx
        mov     eax,[ebx]
        mov     edx,eax
        or      edx,[_prec]
        jz      @@type_num_skip
        cmp     [byte _mod],'h'
        jnz     @@type_num_not_short
        cmp     [_radix],0
        jnz     @@type_num_short_unsigned
        movsx   eax,ax
        jmp     @@type_num_short_fin
@@type_num_short_unsigned:
        movzx   eax,ax
@@type_num_short_fin:
@@type_num_not_short:
        push    [_prec]
        push    [_sign]
        push    [_radix]
        push    edi
        push    eax
        call    _itoa
        add     esp,20
        mov     ecx,eax
@@type_num_skip:
        sub     edi,[_prefix]
        add     ecx,[_prefix]
        add     ebx,4
        jmp     @@justify

@@justify:
        cmp     ecx,[_width]
        jnb     @@justify_end
        cmp     [_left],0
        jz      @@justify_right

        push    edi
        add     edi,ecx
        sub     ecx,[_width]
        neg     ecx
        cld
        mov     al,' '
        rep     stosb
        xor     al,al
        stosb
        pop     edi
        mov     ecx,[_width]
        jmp     @@justify_end

@@justify_right:
        push    edi
        push    esi
        push    [_width]
        cmp     [byte _pad],'0'
        jnz     @@justify_right_no_sign
        cmp     [byte edi],'+'
        jz      @@justify_right_sign
        cmp     [byte edi],'-'
        jnz     @@justify_right_no_sign
@@justify_right_sign:
        inc     edi
        dec     ecx
        dec     [_width]
@@justify_right_no_sign:
        push    ecx
        mov     esi,edi
        add     edi,[_width]
        add     esi,ecx
        inc     ecx
        std
        rep     movsb
        pop     ecx
        sub     ecx,[_width]
        neg     ecx
        mov     al,[byte _pad]
        rep     stosb
        cld
        pop     [_width]
        pop     esi
        pop     edi
        mov     ecx,[_width]

@@justify_end:
        add     edi,ecx
        jmp     @@loop

        mov     eax,edi
        sub     eax,[buff]
@@exit:
        ret
endp


ends

end
