;   FILENAME: KEYTASK.ASM
;
;   DESCRIPTION: This file includes all the keyboard interrupt routines.
;

%tabsize 4

ifndef  MDL
    display "Error: This module requires that you provide a memory model"
    display "       definition on the command line. I.E. /dMDL=SMALL."
    err ; Force a fatal error
else

    ideal                   ; Use TASM's Ideal mode
    model   MDL,Pascal	    ; Define the memory model
	P286

include "globals.inc"  ; Public symbol declarations
include "stdlib.inc"
include "keytask.inc"

dataseg

Int09		dd	0
KbdSet		db	0	; Is the keyboard interrupt set?
Key		dw	0	; Used in program
KeyCodes	dw	27,49,50,51,52,53,54,55,56,57,48,45,61,8,9,81,87,69
		dw	82,84,89,85,73,79,80,91,93,13,0,65,83,68,70,71,72,74
		dw	75,76,59,39,96,0,92,90,88,67,86,66,78,77,44,46,47,0
		dw	42,0,32,0,3b00h,3c00h,3d00h,3e00h,3f00h,4000h,4100h
		dw	4200h,4300h,4400h,0,0,4700h,4800h,4900h,4a00h,4b00h
		dw	4c00h,4d00h,4e00h,4f00h,5000h,5100h,5200h,5300h,0,0
		dw	0,0,0
Buttons 	dw	0	; Number of mouse buttons
MouseX		dw	0	; Mouse cursor loc and button info
MouseY		dw	0
Button		dw	0
GotMouse	dw	0
NKey		dw	0

codeseg

KeyTaskKey	dw	0	; Last interrupt key hit

proc	K_ConvertKey
	mov	ax,[Word cs:KeyTaskKey]
	mov	[NKey],ax
	cmp	[Word NKey],0FFFFh
	je	@@1
	cmp	[Word NKey],88
	jle	@@2
@@1:	mov	[Word Key],0
	jmp	@@Done
@@2:	cmp	[Word NKey],1
	jl	@@1
	mov	ax,[NKey]
	dec	ax
	shl	ax,1
	add	ax,offset KeyCodes
	mov	si,ax
	mov	ax,[si]
	mov	[Key],ax
@@Done: ret
endp	K_ConvertKey

proc	ms_init
	mov	ax,@data
	mov	ds,ax
	mov	ax,0
	int	33h
	mov	[Word GotMouse],1
	mov	[Word Buttons],bx
	cmp	ax,0
	jne	@@PassedTest
	mov	[Word GotMouse],0	  ; No mouse present or detected
	mov	[Word Buttons],0
	ret

@@PassedTest:
	ret
endp	ms_init

proc	ms_show
	uses	ds
	mov	ax,@data
	mov	ds,ax
	mov	ax,1
	int	33h
	mov	ax,3
	int	33h
	shr	cx,3
	shr	dx,3
	mov	[Button],bx
	mov	[MouseX],cx
	mov	[MouseY],dx
	ret
endp    ms_show

proc	ms_hide
	mov	ax,2
	int	33h
	ret
endp	ms_hide

proc	Keys
	push	ds
	mov	ax,@data
	mov	ds,ax
	call	K_ConvertKey
	mov	[Word cs:KeyTaskKey],0FFFFh
	cmp	[Word GotMouse],1
	je	@@CheckMouse
	mov	[Word MouseX],0
	mov	[Word MouseY],0
	mov	[Word Button],0
	jmp	@@TestAfterMouse

@@CheckMouse:
	mov	ax,3			; Read mouse stuff
	int	33h
	shr	cx,3
	shr	dx,3
	mov	[Button],bx
	mov	[MouseX],cx
        mov     [MouseY],dx

@@TestAfterMouse:
	cmp	[Button],0
	je	@@DoneWithItall
	cmp	[GotMouse],1
	jne	@@DoneWithItAll
	mov	ax,5
	mov	bx,0
	int	33h

@@DoneWithItAll:
	mov	ax,[Key]
	mov	bx,[MouseY]
	mov	cx,[MouseX]
	mov	dx,[Button]
	pop	ds
	cmp	ax,0
	ret
endp    Keys

proc    sd_KbdTask near
        push    ax cx dx bx si di ds
        mov     al,0ADh         ; Disable the keyboard
        call    sd_SendIt
        cli                     ; Disable interrupts
@@Get_KB_Stat:
        IN      al,64h          ; Get keyboard status
        TEST    al,02h          ; Is the coding complete?
        LOOPNZ  @@Get_KB_Stat   ; No, so continue waiting
        IN      al,60h          ; Yes, so get @code
        sti                     ; Enable interrupts
        TEST    al,80h          ; Is it an acknowledgment?
        jz      @@KeyHit        ; Yes, take care of it
        jmp     @@KbdTaskDone
;-----------------------------------------------
@@KeyHit:
	xor	ah,ah
	mov	[Word cs:KeyTaskKey],ax
@@KbdTaskDone:
        mov     al,0AEh
        call    sd_SendIt          ; Enable keyboard
        mov     al,20h
        out     20h,al          ;DIRECT_OUTPUT
        pop     ds di si bx dx cx ax
        iret
endp	sd_KbdTask

proc	sd_SendIt
	push	ax		; Save Byte to send
	cli			; Disable interrupts
@@SIO:	IN	al,64h		; Get keyboard status
	TEST	al,02h		; Is the coding complete?
	LOOPNZ	@@SIO		; No, so continue waiting
	pop	ax		; Retrieve Byte to send
	out	64h,al		; Send the Byte
	sti			; Enable interrupts
	ret
endp    sd_SendIt

proc    SetKbdTask
	push	ds
	mov	ax,@data
	mov	ds,ax
	cmp	[Byte KbdSet],1
        jne     @@1
	pop	ds
        ret
@@1:	mov	[Byte KbdSet],1

	; Install the keyboard handler
	mov	ax,3509h
	int	21h

	mov	[Word Int09+2],es
	mov	[Word Int09],bx

	push	ds
	mov	ax,2509h
	push	cs
	pop	ds
	mov	dx,offset sd_KbdTask
	int	21h
	pop	ds

	pop	ds
        ret
endp    SetKbdTask

proc    OffKbdTask
	push	ds
	mov	ax,@data
	mov	ds,ax
	cmp	[Byte KbdSet],0
        jne     @@1
	pop	ds
	ret
@@1:	mov	[Byte KbdSet],0
	mov	ax,2509h
	mov	dx,[Word Int09]
	mov	ds,[Word Int09+2]
        int     21h
	pop	ds
	ret
endp    OffKbdTask

proc    GetKey
	push	ds
	mov	ax,@data
	mov	ds,ax
@@1:	mov	ax,[Word cs:KeyTaskKey]
	cmp	ax,0FFFFh
	jz	@@1
	mov	[Word Key],ax
	mov	[Word cs:KeyTaskKey],0FFFFh
	pop	ds
	ret
endp    GetKey

endif   ; ifndef MDL

end


