; Version 1.00

; Pmode 32-bit MOD player (by Subliminal Death)
; Does not play mods.  It plays M32's (my own creation)
; Multi-channel,255 instruments,>64K samples !!!
; # of channels must be a power of 2 (2,4,8,16,32)
; see "convert.c" on the conversion method and what's striped out
;
; Uses SB16 or GUS(soon)
; Uses 347 byte buffers!  (22222 / 64)
; Supports any freq (5K - 44K)
; Supports 64 or 50 updates per second  (50=amiga) (64=m32 only)
;
;  347*4 bytes for 64updates/sec
;  444*4 bytes for 50updates/sec  (amiga style)

include qlib.inc
include file.inc
include string.inc
include irq.inc
include video.inc  ;for Oprint
include m32.inc

.data
align 4
;defined proc's for speed
m32_startproc dd nullproc      ;called once to start playback
m32_playproc dd nullproc       ;called during each IRQ
m32_mixproc dd nullproc        ;called to mix next 347 samples
m32_stopproc dd nullproc       ;stop playback
m32_irqproc dd m32_irqhand     ;does not change yet..

m32_loaded db 0
m32err db 0  ; Error code

atexitbak dd ?
old_rm_seg dw ?
old_rm_off dw ?
old_pmirq dd ?
old_pmcs dw ?

m32_card db ?       ;Card type 1=SB16 2=GUS(soon)
m32_size dw ?       ;size of buffers
m32_scsize dw ?     ;" -1 (for sound card)
m32_cbuf db ?       ;current buffer

realhead db 'M32v1',26     ;to compare headers in M32 files!

align 4
m32_buf1_phy dd ?  ;abs.address     ;DMA buffers
m32_buf2_phy dd ?  ;abs.address
m32_buf1_rel dd ?  ;near pt
m32_buf2_rel dd ?  ;near pt
  ; sizes=64(amiga=50)
  ; 347*4   (444*4) bytes for stereo 16-bit  (SB16 and GUS)

m32_mode db 0          ;mode  0=not     1=playing
m32_marker dw ?

bitsht db ?  ;used to shift over accuml. data from channels

;only 4 tracks so far
nooftrks equ 4
align 4
trkl label byte
trks m32_trks nooftrks dup (<>)

align 4
m32_header m32_headers <>

align 4
m32_instrdat db 255*sizeof m32_instrs dup (?)

align 4
notecnt db ?            ;new note counter (1=minimum 1/64th note)
notecntr db ?           ;actual counter 
seqcntr db ?            ;sequence counter (init=64)
songpos db ?            ;song pos. in sequence data (start = 0)

m32_irq db ?            ;IRQ
m32_int db ?            ;INT # = IRQ+(8 or 70h)

align 2
m32_addr dw ?           ;Sound Source ADDR.  (SB or GUS)
m32_dma db ?            ;DMA channel
m32_dma16 db ?          ;DMA 16

;DMA ports
m32_dmamask dw ?
m32_dmaclr dw ?
m32_dmamode dw ?
m32_dmaaddr dw ?
m32_dmacount dw ?
m32_dmapg dw ?
;DMA values
m32_dma_mode db ?
m32_dma_stop db ?
m32_dma_start db ?
m32_dma_size dw ?

m32_2nd db 0  ;set by IRQ to note that IRQ is working

m32_pat_width db 0  ;width of channels (used by m32edit to keep 32 channels
                    ; regardless of how many are currently loaded)
                    ; =0 if disabled
align 4
m32_pat_skip dd 0   ;(width-nch)*6  (=0 if disabled)
                    ;used to enlarge/shink # chs in a MOD editor

m32_patloc label dword
patloc dd ?             ;pattern starting location
patlocc dd ?            ;pattern current location
m32_samloc label dword
samloc dd ?             ;samples location
m32_patbsize label dword
patbsize dd ?           ;size of each pattern block (6 * #ch * 64)
                        ;or (6 * width * 64) if width!=0

m32_max_ps dd ?    ; pattern max size
m32_max_ss dd ?    ; sample max size

rm_seg dw ?    ;used to get RM IRQ  (alloc_rmintcallback thing)
rm_off dw ?

include m32tab.asm   ;tables
include m32t.asm     ;tracking
include m32o.asm     ;OSC
include m32d_sb.asm  ;SB drivers
include m32d_gus.asm ;GUS drivers (nothing in there yet!)
;mixers
include m32_816.asm
include m32_1616.asm

.code
align 4
m32_irqhand proc private
  .if m32_mode==2  ;hit end of music...
    call [m32_stopproc]
    mov m32_mode,0
    ret
  .endif
  mov m32_2nd,1       ;used to detect if IRQ is working
  call [m32_playproc] ;con't playback  (starts a DMA tx from m32_cbuf)
  xor m32_cbuf,1      ;switch buffer
  call [m32_mixproc]  ;mix next 347(444) data block
  call m32_updatechs  ;in m32t.asm
  ret
m32_irqhand endp

align 4
m32_pmirq proc private
  cli
  cld
  pushad
  push ds
  push es
  push fs
  push gs
  mov ax,cs:seldata
  mov ds,ax
  mov es,ax
  mov fs,ax
  mov gs,selzero
  call [m32_irqproc]
  mov al,20h
  .if m32_irq>7
    out 0a0h,al
  .else
    out 020h,al
  .endif
  pop gs
  pop fs
  pop es
  pop ds
  popad

  sti
  iretd
m32_pmirq endp

align 4
m32_rmirq proc private
  cli
  cld
  pushad
  push ds
	push es
  push fs
  push gs
  mov ax,cs:seldata
	mov ds,ax
	mov es,ax
	mov fs,ax
	mov gs,selzero
  call [m32_irqproc]
  mov al,20h
  .if m32_irq>7
    out 0a0h,al
  .else
    out 020h,al
  .endif
  pop gs
  pop fs
  pop es
  pop ds
  popad

  sti
  retf
m32_rmirq endp

m32_setup proc private
  ;setup some stuff after a M32 is loaded!

;set buffer sizes
  ;rem : the buffer is 16K
  .if m32_header.nfreq==64
    mov eax,347    ; for 64freq
  .else
    mov eax,444    ; for 50freq (old Amiga)
  .endif
  mov m32_size,ax  ;mixing size

  shl eax,1 ;stereo
  dec eax
  mov m32_scsize,ax  ;sound card needs # samples-1
  inc eax

  shl eax,1 ;16bit
  mov ebx,m32_buf1_phy
  mov edx,m32_buf1_rel
  add ebx,eax
  add edx,eax
  mov m32_buf2_phy,ebx
  mov m32_buf2_rel,edx

  shl eax,1 ;auto init DMA  (two buffers!)
  .if m32_dma16    ;we may be using an 8bit DMA for 16bit samples
    shr eax,1 ;16bit DMA in use
  .endif
  dec eax  ;DMA needs size-1
  mov m32_dma_size,ax
  ret
m32_setup endp

m32_init proc,snds:byte,maxps:dword,maxss:dword
	;snds=sound source
  ;  0-SB16
  ;  1-GUS

  pushad
  mov m32_addr,0
  mov m32_irq,0
  mov m32_dma,0
  mov m32_dmapg,0
  mov m32_dma16,0
  mov m32_mode,0
  mov m32err,0

  mov eax,atexit
  mov atexitbak,eax
  mov atexit,m32_uninit

;save IRQ handlers
  callp getrmint,m32_int
  mov rm_seg,ax
  mov rm_off,dx
  callp getint,m32_int
  mov old_pmcs,ax
  mov old_pmirq,edx

;alloc RAM
	;DMA buffer
  call alloc_dma16
  cmp eax,ERROR
  jz m32_memerr

  mov m32_buf1_phy,ebx
  mov m32_buf1_rel,edx

  .if maxps<64*1024
    mov maxps,64*1024
  .endif
  mov edx,maxps
	mov m32_max_ps,edx  ;max pat size
  callp malloc,edx
  cmp eax,ERROR
  jz m32_memerr
  mov patloc,eax
	
  .if maxss<256*1024
    mov maxss,256*1024
  .endif
	mov edx,maxss
	mov m32_max_ss,edx
  callp malloc,edx
  cmp eax,ERROR
  jz m32_memerr
  mov samloc,eax

;INIT sound card
  .if !snds
    mov m32_card,0
    call sb_init
  .elseif snds==1
    mov m32_card,1
    call gus_init
  .else
    popad
    mov eax,ERROR
    ret
  .endif
  .if eax
    popad
    mov eax,ERROR
    ret
  .endif

;setup IRQ handlers
  callp alloc_rmintcallback,m32_rmirq
  ;if eax==ERROR bad!
  mov rm_seg,ax
  mov rm_off,dx
  callp setrmint,m32_int,rm_seg,rm_off
  callp setint,m32_int,cs,m32_pmirq

;setup DMA ports
  .if m32_dma16  ;16bit mode!
    .if m32_dma16==5
      mov m32_dmapg,08bh
    .elseif m32_dma16==6
      mov m32_dmapg,089h
    .elseif m32_dma16==7
      mov m32_dmapg,08ah
    .else
      mov m32err,2
      mov eax,ERROR
      ret
    .endif
    mov al,m32_dma16
    mov m32_dma_stop,al
    sub al,4
    mov m32_dma_start,al
    mov m32_dmamask,0d4h
    mov m32_dmaclr,0d8h
    mov m32_dmamode,0d6h
    mov ax,0c0h
    movzx bx,m32_dma16
    sub bx,4
    shl bx,2   ;*4
    add ax,bx
    mov m32_dmaaddr,ax
    add ax,2
    mov m32_dmacount,ax
    shr bl,2
    add bl,48h
    mov m32_dma_mode,bl
  .else
    .if m32_dma==0
      mov m32_dmapg,087h
    .elseif m32_dma==1
      mov m32_dmapg,083h
    .elseif m32_dma==2
      mov m32_dmapg,081h
    .elseif m32_dma==3
      mov m32_dmapg,082h
    .else
      mov m32err,2
      mov eax,ERROR
      ret
    .endif
    mov al,m32_dma
    mov m32_dma_start,al
    add al,4
    mov m32_dma_stop,al
    mov m32_dmamask,0ah
    mov m32_dmaclr,0ch
    mov m32_dmamode,0bh
    sub al,4
    shl al,1
    xor ah,ah
    mov m32_dmaaddr,ax
    inc al
    mov m32_dmacount,ax
    mov al,m32_dma
    add al,48h
    mov m32_dma_mode,al
  .endif
  add m32_dma_mode,10h  ;AUTO DMA mode!!

  popad
  xor eax,eax
	ret
m32_memerr:
  mov m32err,4
  popad
  mov eax,ERROR
	ret
m32_init endp

m32_uninit proc private  ;uses atexit!
  pushad
  .if m32_2nd && m32_mode
    call m32_stop
  .endif
  callp irq_disable,m32_irq

  callp setrmint,m32_int,old_rm_seg,old_rm_off
  callp setint,m32_int,old_pmcs,old_pmirq

  mov eax,atexitbak
  mov atexit,eax

  popad
  ret
m32_uninit endp

m32_play proc  ;starts a playback after loaded
  .if !m32_loaded
    mov eax,ERROR
    ret
  .endif
  pushad
  .if m32_mode
    call m32_stop
  .endif

;reset all tracks
  mov ebx,offset trkl
  mov cl,nooftrks
@@:
  mov [ebx].m32_trks.on,1
  mov [ebx].m32_trks.off,0  ;offset
  .if cl&1
    ;right
    mov [ebx].m32_trks.voll,0h
    mov [ebx].m32_trks.volr,100h
  .else
    ;left
    mov [ebx].m32_trks.voll,100h
    mov [ebx].m32_trks.volr,0h
  .endif
  add ebx,sizeof m32_trks
  dec cl
  jnz @b
  mov m32_marker,0

;select proper mixing proc
  .if m32_header.res==16
      mov m32_mixproc,mix_16_16    ;stereo assumed
  .else
      mov m32_mixproc,mix_8_16     ;stereo assumed
  .endif

  mov al,m32_header.spd     ;how often to do new notes
  mov notecnt,al
  mov notecntr,1
  mov seqcntr,1
  mov songpos,0ffh          ;after m32_updatechs inc it, it will be 0
  call m32_updatechs

;call mixer
  mov m32_cbuf,0
  call [m32_mixproc]

;enable IRQ
  sti  ;just in case
  callp irq_enable,m32_irq

;call startup routine
  call m32_setdma ;setup DMA
  mov m32_2nd,0   ;Used to tell if IRQ is working
  mov m32_mode,1       ;now playin
  call [m32_startproc]  ;and it starts!
  xor m32_cbuf,1
	call m32_updatechs
	call [m32_mixproc]
  popad
  xor eax,eax
  ret
m32_play endp

m32_load proc,strg:dword
	local hand:word
  local patc:word,pl:dword,soch:dword
    ; pat count,pat loc(cur),sizeof ch*6

  pushad
  mov m32_loaded,0  ;NO file loaded until I say so
  mov m32err,3
  callp open,strg,0
  cmp eax,ERROR
	jnz @f
  jmp @@loaderr
@@:
	mov hand,ax
  callp read,hand,offset m32_header,sizeof m32_headers
  cmp eax,sizeof m32_headers
  jnz @@loaderr
	;calc. bit shift
	xor ah,ah
  mov al,m32_header.nch
	xor cl,cl
@@:
	inc cl
	shr ax,1
	jnz @b
  dec cl  ;one too many
  mov bitsht,cl

;calc patbsize
  .if m32_pat_width
    xor eax,eax
    mov al,m32_pat_width
    mov ebx,6*64
    mul ebx
  .else
    xor eax,eax
    mov al,m32_header.nch
    mov ebx,6*64
    mul ebx
  .endif
  mov patbsize,eax
	
	mov ecx,6
  mov esi,offset m32_header.head
	mov edi,offset realhead
loadchk:
	cmpsb
	jnz @@loaderr
	loop loadchk

  call m32_setup  ;setup misc. stuff

  callp read,hand,offset m32_instrdat,255*36
  cmp eax,255*36
	jnz @@loaderr
;NOW patterns
	mov eax,patbsize
	xor ebx,ebx
  mov bl,m32_header.npat
	mul ebx      ;eax=size of all patterns to load
	cmp eax,m32_max_ps
  ja @@loaderr ;Not enough RAM alloc. for patterns
  .if m32_pat_width!=0
    ; local chc:byte,patc:byte,pl:dword,soch:dword
    ;use m32_pat_skip&width to load patterns
    ;calc new m32_pat_skip
      ;skip=(width-nch)*6
      mov al,m32_pat_width
      sub al,m32_header.nch
      jb @@loaderr    ;width < nch
      movzx eax,al
      imul eax,6
      mov m32_pat_skip,eax
    ;end that
    mov al,m32_header.npat
    movzx ax,al
    imul ax,64
    mov patc,ax
    mov al,m32_header.nch
    movzx eax,al
    imul eax,6
    mov soch,eax    ;#ch*6
    mov eax,patloc
    mov pl,eax
  @@:
    callp read,hand,pl,soch
    cmp eax,soch
    jnz @@loaderr
    mov eax,m32_pat_skip
    add pl,eax
    mov eax,soch
    add pl,eax
    dec patc
    jnz @b
  .else
    push eax
    callp read,hand,patloc,eax
    pop ebx
    cmp eax,ebx
    jnz @@loaderr
  .endif

;now load samples & change sample info
  mov esi,offset m32_instrdat
	xor eax,eax    ;total sample size
	mov ebx,samloc ;loc. to load samples
	mov cl,255
@@load1:
  mov edx,[esi].m32_instrs.off   ;length
	add eax,edx  ;add length to total required to load
  mov [esi].m32_instrs.off,ebx   ; point to offset of sample
	add ebx,edx  ;add length to find new send (sample end)
  mov edx,[esi].m32_instrs.off
  cmp [esi].m32_instrs.repb,0
	jz norep
  add edx,[esi].m32_instrs.repb  ;repeat begin
  mov [esi].m32_instrs.repb,edx
  add edx,[esi].m32_instrs.reps  ;repeat length
  mov [esi].m32_instrs.reps,edx  ;repeat stop
	jmp yesrep
norep:
  mov [esi].m32_instrs.repb,0
  mov [esi].m32_instrs.reps,0
yesrep:  
	dec ebx
  mov [esi].m32_instrs.send,ebx   ;make send=sample end
	inc ebx ;now point at next place to load next sample
	;in the file off=length
	;after loaded off=phy. begining of sample (in DS)
  add esi,sizeof m32_instrs
	dec cl       ;
	jnz @@load1  ;loop @@load1

  cmp m32_header.saminc,0
	jz @f  ;skip if no samples in file

	cmp eax,m32_max_ss
	ja @@loaderr
	push eax
  callp read,hand,samloc,eax
	pop ebx
	cmp eax,ebx  ;verify amount read in
  jnz @@loaderr  ; most MOD's are wrong  (or most likely I'm wrong)
  callp close,hand
@@:
  popad
  xor eax,eax
  mov m32err,0
  mov m32_loaded,1
  ret
@@loaderr:
  popad
  mov eax,ERROR
	ret
m32_load endp

;loads in sample bank file
m32_loadsmp proc
	ret
m32_loadsmp endp

m32_addnote proc,chnl:dword,sfx:dword,vol:word,freq:word  ;vol:0-100h
	;add a note to the current music, great for adding SFX
  mov eax,chnl
  .if eax>nooftrks
    mov eax,ERROR
    ret
  .endif
  dec eax
  .if carry?
    mov eax,ERROR
    ret
  .endif
  pushad
  mov ebx,sizeof m32_trks
	mul ebx
	mov ebx,offset trkl
	add ebx,eax
  cli
  mov eax,sfx
  mov [ebx].m32_trks.off,eax
  mov [ebx].m32_trks.boff,eax
  mov [ebx].m32_trks.of,0
  mov [ebx].m32_trks.repb,0
  mov [ebx].m32_trks.reps,0
  mov [ebx].m32_trks.cmd,0
  mov [ebx].m32_trks.cmdb1,0
  mov [ebx].m32_trks.cmdb2,0
  mov ax,vol
  mov [ebx].m32_trks.vol,ax
  mov ax,freq
  mov [ebx].m32_trks.freq,ax
  sti
  popad
  ret
m32_addnote endp

m32_addnotefx proc,chnl:dword,sfx:dword,vol:word,freq:word,fx:byte,fx1:byte,fx2:byte
  ;add a note to the current music, great for adding SFX
  ;also adds a SFX with the note
  mov eax,chnl
  .if eax>nooftrks
    mov eax,ERROR
    ret
  .endif
  dec eax
  .if carry?
    mov eax,ERROR
    ret
  .endif
  pushad
  mov ebx,sizeof m32_trks
	mul ebx
	mov ebx,offset trkl
	add ebx,eax
  cli
  mov eax,sfx
  mov [ebx].m32_trks.off,eax
  mov [ebx].m32_trks.boff,eax
  mov [ebx].m32_trks.of,0
  mov [ebx].m32_trks.repb,0
  mov [ebx].m32_trks.reps,0
  mov al,fx
  mov [ebx].m32_trks.cmd,al
  mov al,fx1
  mov [ebx].m32_trks.cmdb1,al
  mov al,fx2
  mov [ebx].m32_trks.cmdb2,al
  mov ax,vol
  mov [ebx].m32_trks.vol,ax
  mov ax,freq
  mov [ebx].m32_trks.freq,ax
  sti
  popad
  ret
m32_addnotefx endp

m32_setvol proc,chnl:dword,lvol:byte,rvol:byte
  ;chnl = 1 -> (#chs)
  mov eax,chnl
  .if eax>nooftrks
    mov eax,ERROR
    ret
  .endif
  dec eax
  .if carry?
    mov eax,ERROR
    ret
  .endif
  pushad
  mov ebx,sizeof m32_trks
	mul ebx
	mov ebx,offset trkl
	add ebx,eax
  cli  ;BUG : don't know if this is really what I want yet....
  xor ah,ah
  mov al,lvol
  inc ax
  mov [ebx].m32_trks.voll,ax
  xor ah,ah
  mov al,rvol
  inc ax
  mov [ebx].m32_trks.volr,ax
  sti
  popad
  xor eax,eax
  ret
m32_setvol endp

m32_stop proc
  .if m32_2nd 
    pushad
    call [m32_stopproc]
    popad
  .endif
;disable IRQ
  callp irq_disable,m32_irq
  xor eax,eax
  ret
m32_stop endp

m32_pause proc
  ;disable IRQ
  callp irq_disable,m32_irq
  ret
m32_pause endp

m32_cont proc
  ;reenable IRQ
  callp irq_enable,m32_irq
	ret
m32_cont endp

m32_setdma proc private
  ;setup DMA chip
  mov dx,m32_dmamask
  mov al,m32_dma_stop  ;STOP dma
  out dx,al
    jmp $+2
    jmp $+2
  mov dx,m32_dmaclr
  xor al,al
  out dx,al  ;clear
    jmp $+2
    jmp $+2
  mov dx,m32_dmamode
  mov al,m32_dma_mode
  out dx,al  ;set mode (write)
    jmp $+2
    jmp $+2
  mov dx,m32_dmacount  ;size reg
  mov ax,m32_dma_size
  out dx,al
    jmp $+2
    jmp $+2
  mov al,ah
  out dx,al
    jmp $+2
    jmp $+2
;calc phy addr
  mov eax,m32_buf1_phy  ;AutoDMA  (so we always start with buffer #1)
  .if m32_dma16
    ;calc DMA 16bit offset stuff.  Very wierd
    mov ebx,eax
    shr ebx,1
    and ebx,8000h
    shr ax,1
    or ax,bx
  .endif
  mov ebx,eax  ;save phy addr for page l8r
  mov dx,m32_dmapg
  shr eax,16
  out dx,al  ;set page
    jmp $+2
    jmp $+2
  mov eax,ebx  ;restore
  mov dx,m32_dmaaddr
  out dx,al
    jmp $+2
    jmp $+2
  mov al,ah
  out dx,al
    jmp $+2
    jmp $+2
  mov dx,m32_dmamask
  mov al,m32_dma_start
  out dx,al
  ret
m32_setdma endp

end
