;M32 Driver for SB16

.data
align 2
sb_reset dw ?
sb_read dw ?
sb_write dw ?
sb_poll dw ?
sb_ack dw ?
sb_dspver1 db ?  ;major version
sb_dspver2 db ?  ;minor version

.code
sb_resetdsp proc private
  mov dx,sb_reset
  mov al,1
  out dx,al
  mov ecx,1000
@@:  
  loop @b  ;better be >= 1ms  (@ 100Mz = 4 ms)
  mov al,0
  out dx,al
  mov ecx,1000
  mov ebx,100
startagain:
  mov dx,sb_poll
  dec ebx
  jz bad
start:
  in al,dx
  or al,al
  js @f
  loop start
bad:
  mov eax,ERROR  ;error (no sound blaster @ addr!)
  ret ;unable to find SB
@@:
  mov dx,sb_read
  in al,dx
  cmp al,0AAh
  jnz startagain
  xor eax,eax
  ret
sb_resetdsp endp

;write to SB16 mixer chip
sb_writemix proc private,reg:byte,dat:byte
  mov dx,m32_addr
  add dx,4  ;mixer addr
  mov al,reg
  out dx,al
  inc dx
  mov al,dat
  out dx,al
  ret
sb_writemix endp

sb_readmix proc private,reg:byte
  mov dx,m32_addr
  add dx,4  ;mixer addr
  mov al,reg
  out dx,al
  inc dx
  jmp $+2
  in al,dx
  ret
sb_readmix endp

align 4
sb_wait proc private
  ;wait till SB not busy!
  mov dx,sb_write
@@:
  in al,dx
  and al,128
  jnz @b
  ret
sb_wait endp

align 4
sb_writedsp proc private,a:byte
  ;PRESERVE BX!!
  mov dx,sb_write
@@:
  in al,dx
  and al,128
  jnz @b
  mov al,a
  out dx,al
  ret
sb_writedsp endp

align 4
sb_readdsp proc private
  mov dx,sb_poll
@@:
  in al,dx
  and al,128
  jz @b
  mov dx,sb_read
  in al,dx
  ret
sb_readdsp endp

sb_init proc private
  local dma8:byte
  ;RET eax=0(successful)
  ;       =-1(error)
  callp getenv,"BLASTER"
  .if eax==ERROR
    ret
  .endif
  mov esi,eax
  mov dma8,0
top:
  mov al,[esi]
  inc esi
  cmp al,'A'
  jz addr1
  cmp al,'I'
  jz irq1
  cmp al,'D'
  jz dma
  cmp al,'H'
  jz hdma
  ;unknown value (ignore)
@@:
  .if bptr[esi]==' '
    inc esi
    jmp top
  .endif
  cmp bptr[esi],0
  jz done
  inc esi
  jmp @b
addr1:
  callp str2num_h,esi   ;esi must be preserved
  mov m32_addr,ax
  jmp @b
irq1:
  callp str2num,esi
  mov m32_irq,al
  jmp @b
dma:
  callp str2num,esi
  mov m32_dma,al
  mov dma8,1
  jmp @b
hdma:
  callp str2num,esi
  mov m32_dma16,al
  jmp @b
done:
  .if (!m32_addr)||(!m32_irq)||(!dma8)
    mov eax,ERROR
    mov merror,2  ;BLASTER set incorrectly
    ret
  .endif
  mov al,m32_irq
  .if al>7
    add al,70h
  .else
    add al,8
  .endif
  mov m32_int,al

  ;init SB stuff
  mov ax,m32_addr
  add ax,6
  mov sb_reset,ax
  add ax,4
  mov sb_read,ax
  add ax,2
  mov sb_write,ax
  add ax,2
  mov sb_poll,ax
  inc ax
  mov sb_ack,ax  ;16bit ACK

  call sb_resetdsp
  .if eax==ERROR
    mov merror,1
    ret ;not detected
  .endif
  ;SB detected
  ;get dspver
  callp sb_writedsp,0e1h
  callp sb_readdsp
  mov sb_dspver1,al
  callp sb_readdsp
  mov sb_dspver2,al

  .if sb_dspver1<4
    mov eax,ERROR
    mov merror,1  ;not detected
    ret
  .endif

  ;This code supports the future possiblity of a DSP V5.xx (or greater)
  ;it is assumed to be SB16 compatible
  ; I believe the SBawe32 is DSP V4.10h (not sure) or V4.20h

  callp sb_writemix,0eh,2  ;set mixer to stereo mode

  mov m32_startproc,sb_start
  mov m32_playproc,sb_play
  mov m32_stopproc,sb_stop

  xor eax,eax
  ret
sb_init endp

align 4
sb_start proc private 
  callp sb_writedsp,0d1h   ;speaker on!

  callp sb_writedsp,41h    ;set output freq.
  mov bx,m32_header.freq
  callp sb_writedsp,bh     ;note:reverse order for 41h/42h commands
  callp sb_writedsp,bl

  callp sb_writedsp,0b6h   ;16-bit OUTPUT autoDMA FIFO_ON
  callp sb_writedsp,20h    ;unsigned stereo mode
  mov bx,m32_scsize
  callp sb_writedsp,bl
  callp sb_writedsp,bh  ;GO!

  xor eax,eax
  ret
sb_start endp

align 4
sb_play proc private  ;this is called in IRQ
  mov dx,sb_ack
  in al,dx  ;ACK IRQ to Sb
  xor eax,eax
  ret
sb_play endp

align 4
sb_stop proc private
  ;fast stop
  callp sb_writedsp,0d9h      ;exit 16bit autoDMA
  callp sb_writedsp,0d3h      ;speaker off!
  mov m32_mode,0
  ret
sb_stop endp


