;tracking (updates chs according to music sheets and FXs)

.code
align 4
m32_updatechs proc private
  xor eax,eax
  dec notecntr
  jnz chkfx
;new notes
  
  mov bl,notecnt
  mov notecntr,bl
  dec seqcntr
  jnz @f
  ;end of sequence
  mov seqcntr,64  ;this is 64 seq/pattern
  xor ecx,ecx
  inc songpos
  mov cl,songpos
  mov ebx,offset m32_header.songdat
  add ebx,ecx
  xor eax,eax
  mov al,[ebx] ;al=new pattern
  cmp al,0
  jz endofsong
  dec al
  mul patbsize ;eax=new offset in pat
  add eax,patloc
  mov patlocc,eax
  jmp @f
endofsong:
  mov m32_mode,2   ;wait till last IRQ finished!
  ret
@@:
  mov ebx,patlocc
  mov cl,m32_header.nch
  ;edi-used for instrdat
  mov esi,offset trkl
@@:
  mov al,[ebx]
  cmp al,0
  jz contnch
;new note
  xor ah,ah
  dec al
  mov dx,sizeof m32_instrs
  mul dx
  movzx edi,ax
  add edi,offset m32_instrdat  ;edi pts to new instr
  mov [esi].m32_trks.of,0  ;reset overflow
  mov ax,[edi].m32_instrs.vol
  mov [esi].m32_trks.vol,ax
  mov [esi].m32_trks.vibidx,0
  mov eax,[edi].m32_instrs.off
  mov [esi].m32_trks.off,eax
  mov [esi].m32_trks.boff,eax
  mov eax,[edi].m32_instrs.send
  mov [esi].m32_trks.send,eax
  mov eax,[edi].m32_instrs.repb
  mov [esi].m32_trks.repb,eax
  mov eax,[edi].m32_instrs.reps
  mov [esi].m32_trks.reps,eax
  mov ax,[ebx].m32_pats.freq
  mov [esi].m32_trks.freq,ax
contnch:
;new effects (old ones wiped out)
  mov al,[ebx].m32_pats.eff
  mov [esi].m32_trks.cmd,al
  mov al,[ebx].m32_pats.effd1
  mov [esi].m32_trks.cmdb1,al
  mov al,[ebx].m32_pats.effd2
  mov [esi].m32_trks.cmdb2,al
  add esi,sizeof m32_trks
  add ebx,sizeof m32_pats ;6
  dec cl 
  jnz @b  ;loop @b
  add ebx,m32_pat_skip      ;used by my M32 editor
  mov patlocc,ebx
chkfx:  ;update fx currently in effect
  mov cl,m32_header.nch
  mov esi,offset trkl
@@:
  movzx edx,[esi].m32_trks.cmd
  cmp dl,0
  jz contchkeff
  mov al,[esi].m32_trks.cmdb1
  mov ah,[esi].m32_trks.cmdb2
  and dl,03fh
  cmp dl,21
  ja contchkeff
  shl edx,2  ;*4
  mov edx,[m32_fxs+edx]
  jmp edx
align 4
contchkeff:
;check for xtra slides
  mov dl,[esi].m32_trks.cmd
  mov al,[esi].m32_trks.cmdb2
  xor ah,ah
  .if dl & 80h
    .if dl & 40h
      ;down freq
      jmp eff2_11
    .else
      ;up freq
      jmp eff2_10
    .endif
  .else
    .if dl & 40h
      ;down vol
      jmp eff2_01
    .else
      ;up vol
      jmp eff2_00
    .endif
  .endif
;all others ignored
contchkeff2:
  add esi,sizeof m32_trks
  dec cl
  jnz @b
  ret ;wheh! done.  Next one due in 1/64 of a second(or 50 if Amiga)

; Effects !
; in : al=fxd1 ah=fxd2   (may trash & all other regs)
;    : cl = trak #     (must preserve)
;    : esi = trak info (must preserve)
; -------------------------------------------------
align 4
eff1: ;Set Volume
  xor ah,ah
  inc ax ;so the range is 1-256  (1=100% silent,256=loudest)
  mov [esi].m32_trks.vol,ax
  mov [esi].m32_trks.cmd,0  ;no need to do again
  jmp contchkeff
; -------------------------------------------------
align 4
eff2:  ;Set BMP
  .if !al
    inc al ;min=1
  .endif
  mov notecnt,al
  mov notecntr,al
  mov [esi].m32_trks.cmd,0
  jmp contchkeff2  ;no slides allowed!
; -------------------------------------------------
align 4
eff3: ;break current music sheet
  mov al,songpos
  inc al
; -------------------------------------------------
eff4: ;jump to music sheet #
  mov songpos,al
  mov al,notecnt
  mov notecntr,al
  mov seqcntr,64
  xor edx,edx
  mov dl,songpos
  mov ebx,offset m32_header.songdat
  add ebx,edx
  xor eax,eax
  mov al,[ebx] ;al=new pattern
  cmp al,0
  jnz @f
  jmp endofsong ;long jump up
@@:  
  dec al
  mul patbsize ;eax=new offset in pat
  add eax,patloc
  mov patlocc,eax
  jmp contchkeff2
; -------------------------------------------------
align 4
eff5:  ;stop FX
  mov [esi].m32_trks.cmd,0
  jmp contchkeff2
; -------------------------------------------------
align 4
eff6:  ;stop sample playback
  mov [esi].m32_trks.off,0
  mov [esi].m32_trks.cmd,0
  jmp contchkeff2
; -------------------------------------------------
align 4
eff7:  ;set marker value
  mov m32_marker,ax
  jmp contchkeff2
; -------------------------------------------------
;eff8-9 RESERVED
; -------------------------------------------------
align 4
eff10: ;slide vol up
  mov dx,[esi].m32_trks.vol
  xor ah,ah
  add dx,ax
  cmp dx,100h
  jbe @f
  mov dx,100h ;max vol.
@@:
  mov [esi].m32_trks.vol,dx
  or [esi].m32_trks.cmd,80h ;force freq slides
  jmp contchkeff
; -------------------------------------------------
align 4
eff11: ;slide vol down
  mov dx,[esi].m32_trks.vol
  xor ah,ah
  sub dx,ax
  jnc @f
  xor dx,dx ;min vol.
@@:
  mov [esi].m32_trks.vol,dx
  or [esi].m32_trks.cmd,80h ;force freq slides
  jmp contchkeff
; -------------------------------------------------
align 4
eff12:  ;slide freq up
  mov dx,[esi].m32_trks.freq
  xor ah,ah
  and [esi].m32_trks.cmd,7fh ;force vol slides
  add dx,ax
  jnc @f
  mov dx,0ffffh  ;maximum speed (it's insane!)
@@:
  mov [esi].m32_trks.freq,dx
  jmp contchkeff
; -------------------------------------------------
align 4
eff13:  ;slide freq down
  mov dx,[esi].m32_trks.freq
  xor ah,ah
  and [esi].m32_trks.cmd,7fh ;force vol slides
  sub dx,ax
  jnc @f
  mov dx,1      ;min speed VERY SLOW!!
@@:
  mov [esi].m32_trks.freq,dx 
  jmp contchkeff
; -------------------------------------------------
align 4
eff14:  ;vol vib   (sin)
  mov edi,offset sintab
  xor edx,edx
  mov dl,[esi].m32_trks.vibidx
  shl edx,1  ;words
  add edi,edx
  mov bl,al
  and bl,0fh
  add [esi].m32_trks.vibidx,bl
  jmp volvib
align 4
eff15:  ;freq vib  (sin)
  mov edi,offset sintab
  xor edx,edx
  mov dl,[esi].m32_trks.vibidx
  shl edx,1  ;words
  add edi,edx
  mov bl,al
  and bl,0fh
  add [esi].m32_trks.vibidx,bl
  jmp freqvib
align 4
eff16:  ;vol vib   (tri)
  mov edi,offset tritab
  xor edx,edx
  mov dl,[esi].m32_trks.vibidx
  shl edx,1  ;words
  add edi,edx
  mov bl,al
  and bl,0fh
  add [esi].m32_trks.vibidx,bl
  jmp volvib
align 4
eff17:  ;freq vib  (tri)
  mov edi,offset tritab
  xor edx,edx
  mov dl,[esi].m32_trks.vibidx
  shl edx,1  ;words
  add edi,edx
  mov bl,al
  and bl,0fh
  add [esi].m32_trks.vibidx,bl
  jmp freqvib
align 4
eff18:  ;vol vib   (squ)
  mov edi,offset squtab
  xor edx,edx
  mov dl,[esi].m32_trks.vibidx
  shl edx,1  ;words
  add edi,edx
  mov bl,al
  and bl,0fh
  add [esi].m32_trks.vibidx,bl
  jmp volvib
align 4
eff19:  ;freq vib  (squ)
  mov edi,offset squtab
  xor edx,edx
  mov dl,[esi].m32_trks.vibidx
  shl edx,1  ;words
  add edi,edx
  mov bl,al
  and bl,0fh
  add [esi].m32_trks.vibidx,bl
  jmp freqvib
  
;volume vibrato
align 4
volvib:
  and al,0f0h  ;multiply factor part
  shr al,4
  xor ah,ah
  mov bx,[edi]
  imul bx
;BUG : no limit checking!
  add [esi].m32_trks.vol,ax
  or [esi].m32_trks.cmd,80h ;force freq slides
  jmp contchkeff

;freq vibrate
align 4
freqvib:
  and al,0f0h
  shr al,4
  xor ah,ah
  mov bx,[edi]
  imul bx
;BUG : no limit checking!
  add [esi].m32_trks.freq,ax
  and [esi].m32_trks.cmd,7fh ;force vol slides
  jmp contchkeff

; -------------------------------------------------
align 4
eff20:  ;pan left
  or [esi].m32_trks.cmd,80h ;force freq slides
  xor ah,ah
  mov bx,[esi].m32_trks.voll
  mov dx,[esi].m32_trks.volr
  add bx,ax
  cmp bx,256
  jna @f
    mov bx,100h
@@:
  sub dx,ax
  jnc @f
    xor dx,dx
@@:
  mov [esi].m32_trks.voll,bx
  mov [esi].m32_trks.volr,dx
  jmp contchkeff
; -------------------------------------------------
align 4
eff21:  ;pan right
  or [esi].m32_trks.cmd,80h ;force freq slides
  xor ah,ah
  mov bx,[esi].m32_trks.voll
  mov dx,[esi].m32_trks.volr
  add dx,ax
  cmp dx,256
  jna @f
    mov dx,100h
@@:
  sub bx,ax
  jnc @f
    xor bx,bx
@@:
  mov [esi].m32_trks.voll,bx
  mov [esi].m32_trks.volr,dx
  jmp contchkeff
; -------------------------------------------------
align 4
eff22:  ;set left/right vol
  ;al=left
  ;ah=right
  movzx bx,al
  inc bx  ;1-256
  mov [esi].m32_trks.voll,bx
  movzx bx,ah
  inc bx  ;1-256
  mov [esi].m32_trks.volr,bx
  jmp contchkeff2

; the following are 2nd FXs (bits 7-6)

; in : ax=fxd2
;    : cl=channel #
;    : esi=trak info

align 4
eff2_00: ;slide vol up
  mov dx,[esi].m32_trks.vol
  xor ah,ah
  add dx,ax
  cmp dx,256
  jna @f
  mov dx,256 ;max vol.
@@:
  mov [esi].m32_trks.vol,dx
  jmp contchkeff2  ;finish it up
; -------------------------------------------------
align 4
eff2_01: ;slide vol down
  mov dx,[esi].m32_trks.vol
  xor ah,ah
  sub dx,ax
  jnc @f
  xor dx,dx ;min vol.
@@:
  mov [esi].m32_trks.vol,dx
  jmp contchkeff2
; -------------------------------------------------
align 4
eff2_10:  ;slide freq up
  mov dx,[esi].m32_trks.freq
  xor ah,ah
  add dx,ax
  jnc @f
  mov dx,0ffffh
@@:
  mov [esi].m32_trks.freq,dx
  jmp contchkeff2
; -------------------------------------------------
align 4
eff2_11:  ;slide freq down
  mov dx,[esi].m32_trks.freq
  xor ah,ah
  sub dx,ax
  jnc @f
  mov dx,1
@@:
  mov [esi].m32_trks.freq,dx
  jmp contchkeff2

effr:     ;RESERVED entry
  ;just ignore and do NOTHING!!
  jmp contchkeff2

m32_fxs label dword
  dd eff1
  dd eff2
  dd eff3
  dd eff4
  dd eff5
  dd eff6
  dd eff7
  dd effr
  dd effr
  dd eff10
  dd eff11
  dd eff12
  dd eff13
  dd eff14
  dd eff15
  dd eff16
  dd eff17
  dd eff18 
  dd eff19
  dd eff20
  dd eff21
  dd eff22
m32_updatechs endp

