; Math init (just detects for 80387)

;ret : EAX=ERROR 80387 not detected!
;      EAX=0 80387 detected!

.data
  ctrlword dw ?

.code
math_init proc private
  ;8087 detection
  fninit
  fnstcw ctrlword
  wait
  mov ax,ctrlword
  cmp ah,3
  jz OK1
    mov eax,ERROR
    ret
ok1:
  ;80387 detection
  and ctrlword,0ff7fh  ;turn on FPU ints
  fldcw ctrlword       ; by loading new cw
  fdisi                ;disable ints (works on 8087 only)
  fstcw ctrlword
  wait
  mov ax,ctrlword
  test ax,80h
  jz ok2
    ;8087 only!?  (But we can't get here unless you have a 386?)...
    mov eax,ERROR
    ret
ok2:
  finit
  fld1
  fldz
  fdiv     ;infinity
  fld st   ;generate negative infinity by pushing current stack
  fchs     ; and change sign
  fcompp   ;compare 2 infinities  ;equal for 87/287  NOT for 387
  fstsw ax
  wait
  and ah,40h ;mask C3 (of FPU status word)
  jz ok3     ;if zero, then must be 80387           
    mov eax,ERROR
    ret
ok3:
  finit
  xor eax,eax
  ret
math_init endp

