; Math Library to be used in C programs (Borland C 32-bit)

; results are left in the FPU regs

include qlib.inc
include math.inc

.data?
  result REAL8 ?
  x dw ?
  y dw ?
  merror dw ?  ;=1 if last operation out of range
externdef _turboFloat:ABS
externdef _floatconvert:ABS
  _turboFloat equ 80387h  ;for BCC32 v5.0 compatibility
                          ;Don't know why it needs it, it just does
  _floatconvert equ 80387h  ;something else it may need

.code
sin proc,a:REAL8
  fld a
  fsin
  fstsw ax
  .if ax&4  ;mask C2
    mov merror,1
  .else
    mov merror,0
  .endif
  wait
  ret
sin endp

cos proc,a:REAL8
  fld a
  fcos
  fstsw ax
  .if ax&4  ;mask C2
    mov merror,1
  .else
    mov merror,0
  .endif
  wait
  ret
cos endp

tan proc,a:REAL8
  fld a
  fsincos
  fstsw ax
  .if ax&4  ;mask C2
    mov merror,1
    fstp result  ;ignore
  .else
    mov merror,0
    fdivp st(1),st
  .endif
  wait
  ret
tan endp

ftol proc,a:REAL8
  fld a
__ftol::
  fistp dptr[result]
  wait
  mov eax,dptr[result]
  ret
ftol endp

_ftol proc   ;for BCC32 compiler
  push ebp
  mov ebp,esp
  jmp __ftol
_ftol endp
end
