; Math Library to be used in C programs (WATCOM)

;results are returned in CPU regs

include qlib.inc
include math.inc
include private.inc

.data?
  result REAL8 ?
  x dw ?
  y dw ?
  merror dw ?  ;=1 if last operation out of range

.code
sin proc,a:REAL8
  fld a
  fsin
  fstsw ax
  .if ax&4  ;mask C2
    mov merror,1
  .else
    mov merror,0
  .endif
  fstp result
  wait
  mov eax,dptr[result]
  mov edx,dptr[result+4]
  ret
sin endp

cos proc,a:REAL8
  fld a
  fcos
  fstsw ax
  .if ax&4  ;mask C2
    mov merror,1
  .else
    mov merror,0
  .endif
  fstp result
  wait
  mov eax,dptr[result]
  mov edx,dptr[result+4]
  ret
cos endp

tan proc,a:REAL8
  fld a
  fsincos
  fstsw ax
  .if ax&4  ;mask C2
    mov merror,1
    fstp result  ;ignore
  .else
    mov merror,0
    fdivp st(1),st
  .endif
  fstp result
  wait
  mov eax,dptr[result]
  mov edx,dptr[result+4]
  ret
tan endp

ftol proc,a:REAL8
  fld a
  fistp dptr[result]
  wait
  mov eax,dptr[result]
  ret
ftol endp

;this was stripped out of WATCOM Libs
_CHP proc
  push    eax
  fstcw   wptr[esp]
  wait    
  push    dptr[esp]
  mov     byte ptr [esp+1],1fH
  fldcw   wptr[esp]
  frndint 
  fldcw   wptr[esp+4]
  wait    
  add esp,8
  ret
_CHP endp

end
