;this is part of file i/o
;for packed file loading/etc.

.data

align 4
pt dd ?  ;the tables!
pe dw ?  ;# of entries
pef dw ? ;# of entries full
ph dw nops dup (?) ;   nops=no. of packed files that can be opened (16)
pnh dw ? ;# of handles in above table
align 4
old_int21h df ? ;old int21h handler
align 4
coff dd ?  ;current file offset (within the pack file)
csiz dd ?  ;current file size
cpos dd ?  ;current file position (0=starting pos)
temp4 dd ?   ;used all over
 noff dw ?   ;# of files
chand dw ? ;current handle (0=none!)  (if one file is opened then
           ; another cannot be opened!)
fn db 13 dup (?)    ;File name used by _open

ps struct
  fn db 13 dup (?)   ;the name
  fh dw ?            ;the handle (not used in file!)
  off dd ?           ;offset in the file
  siz dd ?           ;size of file
ps ends

.data

pack_on db 0  ;is packed file init?

.code

pack_init proc,siz:word  ;siz=# of entries(files)alloced for
  mov chand,0
  movzx eax,siz
  mov pe,ax
  mov ebx,sizeof ps
  mul ebx
  invoke malloc,eax
  cmp eax,NULL
  jnz @f
bad:
  mov eax,-1
  ret
@@:
  mov pt,eax
  mov pef,0
  mov pnh,0
  mov pack_on,1
  xor eax,eax
  invoke getint,21h
  mov word ptr[old_int21h+4],ax
  mov dword ptr[old_int21h],edx
  xor eax,eax
  mov ax,selcode
  mov edx,offset int_21h
  invoke setint,21h,ax,edx
  ret
pack_init endp

pack_open proc,strg:dword  ;opens a packed file
  local h:word,no:word

  cmp pnh,nops
  jz bad
  invoke open,strg,0  ;for reading only! (objections?)
  cmp eax,-1
  jnz @f
bad:
  mov eax,-1
  ret
@@:
  movzx ebx,pnh
  shl ebx,1
  add ebx,offset ph
  mov [ebx],ax
  mov h,ax
;now to read in the files
  invoke read,ax,offset temp4,6
  .if eax!=6
    invoke close,h
    jmp bad
  .endif
  mov ebx,offset temp4
  cmp dword ptr[ebx],01a4b4150h ;'PAK',26
  .if !zero?
    invoke close,h
    jmp bad
  .endif
  xor eax,eax
  mov ax,noff  ;[ebx+4]
  mov no,ax
  mov cx,pef
  add cx,ax
  cmp cx,pe
  jna @f
    invoke close,h
    jmp bad
@@:
  mov ebx,sizeof ps
  mul ebx 
  mov ecx,eax  ;siz (save for l8r)
  movzx eax,pef
  mov ebx,sizeof ps
  mul ebx
  add eax,pt
  push eax
  push ecx
  invoke read,h,eax,ecx
  pop ecx
  .if eax!=ecx
    add esp,4
    invoke close,h
    jmp bad
  .endif  
  pop edi
  ;fill edi len no with handle h  
  mov cx,no
  mov ax,h
@@:
  mov [edi].ps.fh,ax
  add edi,sizeof ps
  dec cx
  jnz @b
  inc pnh
  mov ax,no
  add pef,ax
  xor eax,eax
  ret
pack_open endp

align 4
int_21h:
  push ds
  mov ds,cs:seldata
  cmp pack_on,0
  jz do_dos
  cmp pef,0
  jz do_dos   ;no files opened yet!
  cmp ah,3dh
  jz _open
  cmp ah,3eh
  jz _close
  cmp ah,3fh
  jz _read
  cmp ah,42h
  jz _lseek
do_dos:
  pop ds
  jmp cs:[old_int21h]

_open:
;search in tables
  cmp chand,0
  jnz do_dos  ;other handle already open!
  pushad
  push es
  mov es,cs:seldata
  mov esi,edx ;strg
  mov edi,offset fn
  xor ecx,ecx
  cld
@@:           ;capatalize the string
  lodsb
  cmp al,0
  jz @f
  cmp al,'\'
  jz notfound
  cmp al,':'
  jz notfound
  .if ((al>='a')&&(al<='z'))
    sub al,32
  .endif
  stosb
  inc ecx
  .if ecx>12
    jmp notfound
  .endif
  jmp @b
@@:
  .if bptr[edi-1]=='.'
    mov bptr[edi-1],0
  .else
    xor al,al
    stosb
  .endif
  mov ebx,pt
  movzx ecx,pef   ;packed enties full
  mov eax,sizeof ps
  mul ecx
  mov edx,offset fn
  add ebx,eax
  sub ebx,sizeof ps  ;ptrs to last entry (so last occurance of file be used instead)
@@:
  invoke strcmp,edx,ebx
  cmp al,0
  jz found
  sub ebx,sizeof ps      ;search thru list backwards!!!
  dec ecx
  jnz @b
notfound:
  pop es
  popad
  jmp do_dos
found:
;pack file found!
  mov ax,[ebx+13]  ;handle
  mov edx,[ebx+15] ;offset
  mov ecx,[ebx+19]
  mov coff,edx
  mov chand,ax
  mov cpos,0
  mov csiz,ecx
  mov bx,ax
  mov ax,4200h
  ; invoke lseek,ax,ecx,SEEK_SET
  ;can't use this here, LSEEK will override and cause relative seek
  pushfd
  call [old_int21h]
  .if carry?
    ;error
    pop es
    popad
    pop ds
    or byte ptr[esp+8],1      ;set carry on error
    ; flags , cs , eip
    iretd
  .endif
  ;successful
  pop es
  popad
  pop ds
  and byte ptr[esp+8],0feh  ;clear carry
  ; flags , cs , eip
  mov ax,cs:chand
  iretd

_close:
  ;bx=hand
  pushad
  mov ax,bx
  mov esi,offset ph   ;handlers in use
  mov cx,pnh
@@:
  cmp [esi],ax
  jz @f
  add esi,2
  dec cx
  jnz @b
  popad
  jmp do_dos
@@:
  popad
  mov chand,0      ;Forget about this thing  eta V0.03
  pop ds
  and byte ptr[esp+8],0feh  ;clear carry
  ; ret,cs,flags
  iretd

_read:
  ;bx=hand
  pushad
  mov ax,bx
  mov esi,offset ph   ;handlers in use
  mov dx,pnh
@@:
  cmp [esi],ax
  jz @f
  add esi,2
  dec dx
  jnz @b
  popad
  jmp do_dos
@@:
  ;reading with a pack file!!
  ;must make sure we don't read past EOF
  ;ecx=MAX TO READ
  mov eax,ecx
  add eax,cpos
  .if eax>csiz
    mov ecx,csiz
    sub ecx,cpos  ;read what is left over  (=0 if cpos=csiz)
  .endif
  mov [esp+6*4],ecx
  popad
  pushfd
  call [old_int21h]
  ;gotta fix cpos to ptr to proper location within file
  .if carry?
    or byte ptr[esp+12],1      ;set carry
  .else
    and byte ptr[esp+12],0feh  ;clear carry
    add cpos,eax
  .endif
  pop ds
  iretd

_lseek:
  ;bx=hand
  pushad
  mov ax,bx
  mov esi,offset ph   ;handlers in use
  mov cx,pnh
@@:
  cmp [esi],ax
  jz @f
  add esi,2
  dec cx
  jnz @b
  popad
  jmp do_dos
@@:
  popad
  ;LSEEKing with a pack file!!
  .if al==0
    add edx,coff
  .endif
  ;if al==1 then do nothing
  .if al==2  ;this is not allowed if edx>0 so I just ignore edx!!
    mov edx,coff
    add edx,csiz
    mov al,0
  .endif
  pushfd
  call [old_int21h]
  ;gotta fix eax to ptr to proper location within file
  .if carry?
    ;ds,ret,cs,flg
    or byte ptr[esp+12],1      ;set carry
  .else
    and byte ptr[esp+12],0feh  ;clear carry
    sub eax,coff
    mov cpos,eax   ;new pos
  .endif
  pop ds
  iretd

;in:
;ah=45h
;bx=handle
;out:
;ax=new handle
; NOTE: changing offset of one changes the other.

