include qlib.inc
include video.inc
include key.inc
include gui.inc
include m32.inc
include string.inc
include file.inc
include error.asm

.data
  gui_config gui_cfg <>  ;font
  tvid dd 0
  fn db 128 dup (?)
  playing db 0

cursor label byte
  db 05,05,05,05,05,05,05,05,05,05,05,05,05,05,05,05
  db 05,03,03,03,03,03,03,03,03,03,03,03,03,03,05,00
  db 05,03,03,03,03,03,03,03,03,03,03,03,03,05,00,00
  db 05,03,03,03,03,03,03,03,03,03,03,03,05,00,00,00
  db 05,03,03,03,03,03,03,03,03,03,03,05,00,00,00,00
  db 05,03,03,03,03,03,03,03,03,03,05,00,00,00,00,00
  db 05,03,03,03,03,03,03,03,03,03,05,00,00,00,00,00
  db 05,03,03,03,03,03,03,03,03,03,03,05,00,00,00,00
  db 05,03,03,03,03,03,03,03,03,03,03,03,05,00,00,00
  db 05,03,03,03,03,03,03,03,03,03,03,03,03,05,00,00
  db 05,03,03,03,03,05,05,03,03,03,03,03,03,03,05,00
  db 05,03,03,03,05,00,00,05,03,03,03,03,03,03,03,05
  db 05,03,03,05,00,00,00,00,05,03,03,03,03,03,05,00
  db 05,03,05,00,00,00,00,00,00,05,03,03,03,05,00,00
  db 05,05,00,00,00,00,00,00,00,00,05,03,05,00,00,00
  db 05,00,00,00,00,00,00,00,00,00,00,05,00,00,00,00

  ;button = ;r,r,id,next,x1,y1,x2,y2,tx,ty,TEXT
  ;flist  = ;r,r,id,next,x1,y1,? ,y2,r,r,mask,current dir  
  ;str    = ;r,r,id,next,x1,y1,x2,y2,tx,ty,TEXT  

align 4
  g1  gui_button <,,1 ,g2,5,5 ,40,17,2,2,"Load">
  g2  gui_button <,,2 ,g3,5,20,40,32,2,2,"Play">
  g3  gui_button <,,3 ,g4,5,20,40,32,2,2,"Stop">
  g4  gui_button <,,4 ,g5,5,35,40,47,2,2,"Paws">
  g5  gui_button <,,5 ,g6,5,35,40,47,2,2,"Cont">
  g6  gui_button <,,6 ,g7,5,50,40,62,2,2,"Quit">
  g7  gui_flist  <,,7 ,g8,42,5, ?,133,,,"*.M32",'D:\32\M32'>
  g8  gui_button <,,8 ,g9,170,20,190,32,2,2,"Ok">
  g9  gui_button <,,9 ,g10,192,20,250,32,2,2,"Cancel">
  g10 gui_str    <,,10,  0,170,5 ,290,17,2,2,'DEMO.M32'>

.code
init proc
  callp m32_init,0,1024*1024,1024*1024  ;SB,1meg,1meg
  exit_on_error "''M32_INIT'' failed."

  mov eax,256+1  ;640x480x8bit
  call checkvbemode
  exit_on_error "Unable to setup VBE 2.0 video mode : 640x480x256"

  call setvbemode
  call mouse_init   ;if mouse_init is called after MODE is set the X/Y will
                    ;be setup automatically
  exit_on_error "Mouse not detected!"
  ;0-63
  callp setcol,0,0,0,0          ;black
  callp setcol,1,20,20,60       ;light blue
  callp setcol,2,0,0,63         ;blue
  callp setcol,3,0,0,32         ;dark blue
  callp setcol,4,50,50,50       ;grey
  callp setcol,5,63,63,63       ;white

  callp malloc,640*480
  exit_on_error "RAM"
  mov tvid,eax

  callp gset,eax

  callp mouse_setcursor,offset cursor,16,16,0,0

  callp gloadfnt,"norm.fnt"
  exit_on_error "Unable to load Font!"
  mov gui_config.font,eax
  callp gfntcolor,gui_config.font,5

  callp gui_init,offset gui_config
  exit_on_error "''gui_init'' failed."

  mov edi,tvid
  mov al,2
  mov ecx,640*140
  rep stosb
  mov al,0
  mov ecx,640*(480-140)
  rep stosb

  callp gsetfnt,gui_config.font
  call v_copy

  ret
init endp

main proc
  call init

  callp gui_addlist,offset g1
  exit_on_error "gui_addlist failed"

  callp gui_enable,1  ;enable all  (some will overlay - just testin)
  call mouse_on
  callp gui_enable,1
  callp gui_enable,6
top:
  .if playing
    call m32_oprint
  .endif
  call key_read
  .if al==27
    jmp exit_all
  .endif
  callp gui_update,1
  .if eax==6
    jmp exit_all
  .elseif eax==1
    callp gui_filelist,7,1,1,1
    callp gui_enable,7
    callp gui_enable,8
    callp gui_enable,9
    callp gui_enable,10
@@:
    callp gui_update,0
    ;ignore some buttons
    .if eax==6
      jmp exit_all
    .elseif eax==7
      .if !bptr[edx]
        jmp @b
      .endif
      mov al,[edx]
      mov bl,[edx+1]
      mov cl,[edx+2]
      .if al=='['
        mov edx,offset g7.cd
        mov [edx],bl
        mov [edx+1],cl
        mov bptr[edx+2],0
        callp gui_filelist,7,1,1,1
        callp gui_enable,7   ;re-enable to reprint it
        jmp @b
      .endif
      .if (al=='\') && (bl=='.')
        .if cl=='.' ;\..
          mov ebx,offset g7.cd
          callp strlen,ebx
          add ebx,eax
          .if eax<=2
            ;there is a \.. entry in the root
            jmp @b  ;ignore (this should never happen but can w/ subst and stuff)
          .endif
t1:
          .if !(bptr[ebx]=='\')
            dec ebx
            jmp t1
          .endif
          mov bptr[ebx],0
          callp gui_filelist,7,1,1,1
          callp gui_enable,7   ;re-enable to reprint it
          jmp @b
        .else
          jmp @b ;\.
        .endif
      .elseif (al=='\')
        mov eax,offset g7.cd
        callp strcat,eax,edx
        callp gui_filelist,7,1,1,1
        callp gui_enable,7   ;re-enable to reprint it
        jmp @b
      .endif
      ;; edx = file selected
      callp strcpy,offset g10.str1,edx
      callp gui_enable,10
    .elseif eax==8
      callp strcpy,offset fn,offset g7.cd
      callp strcat,offset fn,"\\"
      callp strcat,offset fn,offset g10.str1
      callp gui_disable,7,1
      callp gui_disable,8,1
      callp gui_disable,9,1
      callp gui_disable,10,1
      callp m32_load,offset fn
      .if eax==ERROR
        callp gprintxy,45,10,"Load failed!"
        callp gui_disable,2,1
      .else
        callp gui_enable,2
      .endif
      jmp top
    .elseif eax==9
      callp gui_disable,7,1
      callp gui_disable,8,1
      callp gui_disable,9,1
      callp gui_disable,10,1
      jmp top
    .endif
    jmp @b
  .elseif eax==2
    mov playing,1
    callp m32_play
    callp gui_disable,2,1
    callp gui_disable,1,1
    callp gui_enable,3
    callp gui_enable,4
    jmp top
  .elseif eax==3
    mov playing,0
    callp gboxfill,0,140,639,140+64,0
    callp m32_stop
    callp gui_disable,3,1
    callp gui_disable,4
    callp gui_enable,2
    callp gui_enable,1
    jmp top
  .elseif eax==4
    callp m32_pause
    callp gui_disable,4,1
    callp gui_disable,3,1
    callp gui_enable,5
    jmp top
  .elseif eax==5
    callp m32_cont
    callp gui_disable,5,1
    callp gui_enable,4
    callp gui_enable,3
    jmp top
  .endif
  jmp top

exit_all:
  .if playing
    call m32_stop
  .endif
  call gui_uninit
  callp setgmode,3
  ret
main endp
end

