{















                   Demonstration program to show how
                     to use SB FM & MIDI together

                     Code by: Jari Kaija 1992-93

                              FINLAND


                 If you haven't TPCRT and TPSTRING units,
                  replace TPCRT by CRT unit and remove
                     TPSTRING unit and also replace:
                > hexw(_ct_io_addx) < by > _ct_io_addx <
                > hexb(hi(_sbdsp))  < by > hi(_sbdsp)  <
                > hexb(lo(_sbdsp))  < by > lo(_sbdsp)  <














}


USES TPCRT,TPSTRING,SBC_TPx;

VAR a:byte;

BEGIN
     clrscr;
     maker;
     writeln;
     If getenvsetting<>0 then
     begin
      clrscr;
      writeln('Your "BLASTER=" environment is NOT set. I will try detect ');
      writeln('Sound Blaster myself. If your computer hangs, please reboot');
      writeln('and set BLASTER environment as your manual descripts it...');
      sbc_dsp_reset;
      sbc_scan_card;
      sbc_scan_int;
     end;

     { PLEASE, USE SBC_DSP_RESET IN THE START OF YOUR PROGRAM !!! }
     { IT SAVES A LOT OF TROUBLE...                               }

     sbc_dsp_reset;

     writeln;
     writeln('Using main address   ',hexw(_ct_io_addx),' hex.');
     writeln('Using interrupt line ',sbc_scan_int,' dec.');
     writeln('SB DSP version       ',hexb(hi(_sbdsp)),'.',hexb(lo(_sbdsp)));

     If _Uartmode then
     writeln('UART MIDI IN interrupt mode (FULL DUBLEX) used.')
     else
     writeln('Normal MIDI IN interrupt mode used.');

     {
       If _Uartmode = True, DSP takes every bytes, what you write to
       port _ct_io_addx+$0c (2xC Hex) as MIDI commands to send to
       midi instruments!

       So, if you need DSP to do something else than only midi, you
       should set _Uartmode to false before starting SB MIDI input
     }

     Sbfd_init;                { "Reset" FM Chip...  }
     sbfd_setmode(0);           { Set INSTRUMENT mode }

     sbfd_program_change(0,0);  { Set internal sound "1" }

     Sbmidi_start_input;        { Start midi in }
     writeln;
     writeln('Ready to receive MIDI data. Please press your MIDI instrument keyboard');
     writeln('(Press any key to exit from this demonstration...)');
     repeat
       gotoxy(1,16);

       a:=byte(sbmidi_get_input);   { Get first byte by MIDI instrument }

       If (a>=$90) and (a<=$9f) then { Turn note ON on channel 0-FHex }
       begin
            write('Note ON            ');
            sbfd_note_on(a-$90,byte(sbmidi_get_input),byte(sbmidi_get_input));
       end;

       If (a>=$80) and (a<=$8f) then { Turn note OFF on channel 0-FHex}
       begin
            write('Note OFF           ');
            sbfd_note_off(a-$80,byte(sbmidi_get_input),byte(sbmidi_get_input));
       end;

       If (a>=$c0) and (a<=$cf) then { Change sound on channel 0-FHex }
       begin
            write('Program change     ');
            sbfd_program_change(a-$c0,byte(sbmidi_get_input));
       end;
     until keypressed;
     Sbmidi_stop_input;         { Stop midi in }
END.
