{***********************************************************************}
{ CLI AND STI COMMANDS                                                  }
{***********************************************************************}

PROCEDURE CLI;ASSEMBLER;
ASM
   CLI
END;
PROCEDURE STI;ASSEMBLER;
ASM
   STI
END;

{***********************************************************************}
{ DELAY PROCEDURE.....                                                  }
{***********************************************************************}
PROCEDURE DELAY(MS:WORD);
VAR LL,HH:WORD;
BEGIN
     FOR LL:=1 TO MS DO
     BEGIN
       FOR HH:=1 TO 1000 DO;
     END;
END;

{***********************************************************************}
{ INTERRUPT ROUTINES                                                    }
{***********************************************************************}
{$F+}
PROCEDURE MIDI_COMING;INTERRUPT;
LABEL  NOT_THAT ;
VAR G,DU:BYTE;
BEGIN
      G:=0;
      REPEAT
       INC(G);
       DU :=PORT[_CT_IO_ADDX + $0E];
      UNTIL (DU AND 128=128) OR (G>200);
      MB:=PORT[_CT_IO_ADDX +$0A];
      IF (NOT _GET_MIDI_ACTIVE) AND (MB=$FE) THEN GOTO NOT_THAT;
      IF MIDICOUNT>2048 THEN GOTO NOT_THAT;
      INC(MIDICOUNT);
      MIDIBUF[MIDICOUNT]:=MB;

NOT_THAT:

     IF _CT_INT_NUM=10 THEN
     BEGIN
      PORT[$A0]:=$20;
      PORT[$20]:=$20;
     END ELSE
     BEGIN
      PORT[$20]:=$20;
     END;
END;
{$F-}

{--------------------------------------------------------------------------}

{$F+}
PROCEDURE MIDI_TIMER_INC;INTERRUPT;
BEGIN
     MIDITIMER:=MIDITIMER+100;
     INLINE($9C);
     MIDI_TIMER_SAVE;
END;
{$F-}

{--------------------------------------------------------------------------}

{$F+}
PROCEDURE INTTIPROCE;INTERRUPT;
BEGIN
     CLI;
     SUCCESS:=TRUE;
     DUMMY := PORT[_CT_IO_ADDX + $0E];
     IF I=10 THEN
     BEGIN
      PORT[$A0]:=$20;
      PORT[$20]:=$20;
     END ELSE
     BEGIN
      PORT[$20]:=$20;
     END;
     STI;
END;
{$F-}

{***********************************************************************}
{ MARK & RELEASE DMA                                                    }
{***********************************************************************}

PROCEDURE MARKDMA;
BEGIN
  DMA_A:=PORT[$0A];
  DMA_B:=PORT[$0B];
END;
PROCEDURE RELEASEDMA;
BEGIN
  PORT[$0A]:=DMA_A;
  PORT[$0B]:=DMA_B;
END;

{***********************************************************************}
{ BITTI                                                                 }
{***********************************************************************}

PROCEDURE BITTI;
BEGIN
     ERR:=BIT(_CT_IO_ADDX);
END;

{***********************************************************************}
{ PLAYDMADUMMY                                                          }
{***********************************************************************}

PROCEDURE SETUPDMA;
BEGIN
IF DMA=0 THEN
BEGIN
  PORT[$0A] := 4;
  PORT[$0C] := 0;
  PORT[$0B] := $48;
  PORT[$00] := 0;
  PORT[$00] := 0;
  PORT[$87] := $1;
  PORT[$01] := 0;
  PORT[$01] := 1;
  PORT[$0A] := 0;
END;

IF DMA=1 THEN
BEGIN
  PORT[$0A] := 5;
  PORT[$0C] := 0;
  PORT[$0B] := $49;
  PORT[$02] := 0;
  PORT[$02] := 0;
  PORT[$83] := $1;
  PORT[$03] := 0;
  PORT[$03] := 1;
  PORT[$0A] := 1;
END;

IF DMA=3 THEN
BEGIN
  PORT[$0A] := 7;
  PORT[$0C] := 0;
  PORT[$0B] := $51;
  PORT[$06] := 0;
  PORT[$06] := 0;
  PORT[$82] := $1;
  PORT[$07] := 0;
  PORT[$07] := 1;
  PORT[$0A] := 3;
END;
END;

{--------------------------------------------------------------------------}

PROCEDURE SETUPDSP;
BEGIN
  BITTI;
  BITTI;
  PORT[ _CT_IO_ADDX +$0C] := $40;
  BITTI;
  PORT[ _CT_IO_ADDX +$0C] := 255;
  BITTI;
  PORT[ _CT_IO_ADDX +$0C] := $80;
  BITTI;
  PORT[ _CT_IO_ADDX +$0C] := 0;
  BITTI;
  PORT[ _CT_IO_ADDX +$0C] := 1;
END;

{--------------------------------------------------------------------------}

PROCEDURE PLAYDUMMY;
BEGIN
  SETUPDMA;
  SETUPDSP;
  DELAY(10);
END;

{***********************************************************************}
{ FEW SUB PROCEDURES & FUNCTIONS                                        }
{***********************************************************************}

PROCEDURE TESTDSPADDR;
BEGIN
   FOR C:='1' TO '6' DO
   BEGIN
    S:='$2'+C+'0';
    VAL(S,X,ERROR);
     FOR T:=1 TO 100 DO
     BEGIN
     PORT[X+$06]:=1;
     DELAY(1);
     PORT[X+$06]:=0;
     DELAY(5);
     IF PORT[X+$0E] AND 128 = 128 THEN
     BEGIN
       DELAY(1);
       IF PORT[X+$0A]=$0AA THEN
       BEGIN
         _CT_IO_ADDX:=X;
         BXX:=BXX OR 4;
       EXIT;
       END;
     END;
     END;
   END;
END;

{--------------------------------------------------------------------------}

PROCEDURE TESTFMADDR;
BEGIN
     { CAN'T UNDERSTAND, HOW TO TEST FM CHIP. SB DEVELOPER KIT FOR ALL     }
     { SOUND BLASTER SERIES BY CREATIVE LABS! DID NOT TELL IT!  GRRRR...   }
     { BUT HAD WE EVER SITUATION, THAT FM IS MISSING. NOOOOO.... SO JUST   }
     { PUT "FM FUNCTIONING VARIABLE" TO OK :)                              }

     BXX:=BXX OR 2;
END;

{--------------------------------------------------------------------------}

PROCEDURE RESETD;
BEGIN
     PORT[_CT_IO_ADDX + $06]:=1;
     DELAY(10);
     PORT[_CT_IO_ADDX + $06]:=0;
     DELAY(10);
END;

{--------------------------------------------------------------------------}

PROCEDURE TESTINT(INTTI:WORD);
BEGIN
     RESETD;
     CLI;
     SAVEIM1:=PORT[$021];
     SAVEIM2:=PORT[$0A1];
     STI;
     I:=INTTI;
     CASE I OF
     2 :IRQ:=$0A;
     3 :IRQ:=$0B;
     5 :IRQ:=$0D;
     7 :IRQ:=$0F;
     10:IRQ:=$72;
     END;
     CLI;
     MARKDMA;
     GETINTVEC(IRQ,SAVEI);
     SETINTVEC(IRQ,ADDR(INTTIPROCE));
     STI;
     CASE I OF
     2 :PORT[$21]:=SAVEIM1 XOR 4;
     3 :PORT[$21]:=SAVEIM1 XOR 8;
     5 :PORT[$21]:=SAVEIM1 XOR 32;
     7 :PORT[$21]:=SAVEIM1 XOR 128;
     10:BEGIN
         PORT[$0A1]:=SAVEIM2 XOR 4;
         PORT[$21]:=SAVEIM1 XOR 4;
        END;
     END;
     IF I=10 THEN
     BEGIN
      PORT[$A0]:=$20;
      PORT[$20]:=$20;
     END ELSE
     BEGIN
      PORT[$20]:=$20;
     END;
     T:=0;
      REPEAT
       BITTI;
        PORT[_CT_IO_ADDX]:=0;
        DUMMY := PORT[_CT_IO_ADDX + $0E];
       INC(T);
      UNTIL (T>1000) OR (PORT[_CT_IO_ADDX + $0E]AND 128=128);
     SUCCESS:=FALSE;
     PLAYDUMMY;
     T:=0;
     REPEAT
      INC(T);
     UNTIL (SUCCESS=TRUE) OR (T>65530);
     IF I=10 THEN
     BEGIN
      PORT[$A0]:=$20;
      PORT[$20]:=$20;
     END ELSE
     BEGIN
      PORT[$20]:=$20;
     END;
     CLI;
     PORT[$A1]:=SAVEIM2;
     PORT[$21]:=SAVEIM1;
     SETINTVEC(IRQ,SAVEI);
     RELEASEDMA;
     STI;
     IF (SUCCESS=TRUE) AND (T<65530) THEN _CT_INT_NUM:=INTTI;

END;

{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{                                                                       }
{ SB GENERAL FUNCTIONS                                                  }
{                                                                       }
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}


FUNCTION SBC_VERSION:WORD;
BEGIN
     T:=0;
     REPEAT
      BITTI;
      PORT[_CT_IO_ADDX]:=0;
      INC(T);
     UNTIL (T>1000) OR (PORT[_CT_IO_ADDX + $0E]AND 128=128);
     X:=0;
     REPEAT
      INC(X);
        BITTI;
        IF PORT[_CT_IO_ADDX + $0C] AND 128 = 0 THEN
        BEGIN
                DUMMY:=PORT[_CT_IO_ADDX + $0A];
                BITTI;
                DUMMY:=PORT[_CT_IO_ADDX + $0A];
                BITTI;
                PORT[_CT_IO_ADDX + $0C]:=$E1;
                BITTI;
                DELAY(100);
                T:=0;
                REPEAT
                 INC(T);
                UNTIL (T>1000) OR (PORT[_CT_IO_ADDX + $0E] AND 128 = 128);
                BHH:=PORT[_CT_IO_ADDX + $0A];
                T:=0;
                REPEAT
                 INC(T);
                UNTIL (T>1000) OR (PORT[_CT_IO_ADDX + $0E] AND 128 = 128);
                BLL:=PORT[_CT_IO_ADDX + $0A];
               ASM
                  MOV AH,BHH
                  MOV AL,BLL
                  MOV _SBDSP,AX
               END;
        END;

     UNTIL (X>500) OR (_SBDSP>0) OR (_SBDSP<>$AAAA);

     IF BHH>=2 THEN _UARTMODE:=TRUE ELSE _UARTMODE:=FALSE;
     SBC_VERSION:=_SBDSP;
     DUMMY := PORT[_CT_IO_ADDX + $0E];
END;

{--------------------------------------------------------------------------}

FUNCTION SBC_DSP_RESET:WORD;
BEGIN
     SBC_DSP_RESET:=$0FFFF;
     FOR T:=1 TO 100 DO
     BEGIN
          PORT[_CT_IO_ADDX+$06]:=1;
          DELAY(2);
          PORT[_CT_IO_ADDX+$06]:=0;
          DELAY(3);
           IF PORT[_CT_IO_ADDX+$0E] AND 128 = 128 THEN
           BEGIN
             IF PORT[_CT_IO_ADDX+$0A]=$0AA THEN
             BEGIN
               SBC_DSP_RESET:=0;
               SBC_VERSION;
               EXIT;
             END;
           END;
     END;
END;

{--------------------------------------------------------------------------}

FUNCTION SBC_SCAN_INT:WORD;
BEGIN

 { THIS PROCEDURE DON'T WORK AS ORIGINAL SCAN ROUTINES, BUT WHO CARES...  }
 { I THINK, THE RESULT IS MOST IMPORTANT THAN 100% COPY OF CREATIVE LABS  }
 { PROGRAMS :) BTW: DMA DETECT DOESN'T WORK YET! YOU MUST SET DMA CHANNEL }
 { BY HAND (_CT_DMA_CHANNEL:=0,1 OR 3) AFTER SBC_SCAN_INT !!!!            }

     SBC_SCAN_INT:=0;
     SUCCESS:=FALSE;
   FOR D:=1 TO 3 DO
   BEGIN
    IF D=1 THEN DMA:=0;
    IF D=2 THEN DMA:=1;
    IF D=3 THEN DMA:=3;
     TESTINT(7);
     IF SUCCESS THEN
     BEGIN
      SBC_SCAN_INT:=7;
      _CT_DMA_CHANNEL:=DMA;
      EXIT;
     END;
     TESTINT(5);
     IF SUCCESS THEN
     BEGIN
      SBC_SCAN_INT:=5;
      _CT_DMA_CHANNEL:=DMA;
      EXIT;
     END;
     TESTINT(2);
     IF SUCCESS THEN
     BEGIN
      SBC_SCAN_INT:=2;
      _CT_DMA_CHANNEL:=DMA;
      EXIT;
     END;
     TESTINT(3);
     IF SUCCESS THEN
     BEGIN
      SBC_SCAN_INT:=3;
      _CT_DMA_CHANNEL:=DMA;
      EXIT;
     END;
     TESTINT(10);
     IF SUCCESS THEN BEGIN
      SBC_SCAN_INT:=10;
      _CT_DMA_CHANNEL:=DMA;
      EXIT;
     END;
   END;
END;
{--------------------------------------------------------------------------}

FUNCTION SBC_CHECK_CARD:WORD;
BEGIN
     BXX:=0;
     IF SBC_DSP_RESET=0 THEN BXX:=BXX OR 4;
     SBC_CHECK_CARD:=BXX;
     TESTFMADDR;
     SBC_CHECK_CARD:=BXX;
END;

{--------------------------------------------------------------------------}

FUNCTION SBC_TEST_INT:WORD;
BEGIN
     SUCCESS:=FALSE;
     TESTINT(_CT_INT_NUM);
     IF SUCCESS=FALSE THEN SBC_TEST_INT:=0 ELSE
     SBC_TEST_INT:=_CT_INT_NUM;
END;

{--------------------------------------------------------------------------}

FUNCTION SBC_TEST_DMA:INTEGER;
BEGIN

     DMA:=_CT_DMA_CHANNEL;
     SUCCESS:=FALSE;
     TESTINT(_CT_INT_NUM);
     IF SUCCESS THEN SBC_TEST_DMA:=_CT_DMA_CHANNEL
        ELSE SBC_TEST_DMA:= -1;
END;

{--------------------------------------------------------------------------}

FUNCTION GETENVSETTING:WORD;
BEGIN
     _CT_IO_ADDX:=$220;
     _CT_INT_NUM:=$7;
     _CT_DMA_CHANNEL:=$1;
     _WCARDID:=$1;
     GETENVSETTING:=0;
     IF GETENV('BLASTER')='' THEN
     BEGIN
         GETENVSETTING:=1;
         EXIT;
     END;
     IF POS('A',GETENV('BLASTER'))=0 THEN
     BEGIN
         GETENVSETTING:=2;
         EXIT;
     END;
     IF POS('I',GETENV('BLASTER'))=0 THEN
     BEGIN
         GETENVSETTING:=3;
         EXIT;
     END;
     IF POS('D',GETENV('BLASTER'))=0 THEN
     BEGIN
         GETENVSETTING:=4;
         EXIT;
     END;
     S:=COPY(GETENV('BLASTER'),POS('A',GETENV('BLASTER'))+1,3);
     S:='$'+S;
     VAL(S,_CT_IO_ADDX,ERROR);
     S:=COPY(GETENV('BLASTER'),POS('I',GETENV('BLASTER'))+1,2);
     IF S[2]=' ' THEN S:=COPY(GETENV('BLASTER'),POS('I',GETENV('BLASTER'))+1,1);
     VAL(S,_CT_INT_NUM,ERROR);
     S:=COPY(GETENV('BLASTER'),POS('D',GETENV('BLASTER'))+1,1);
     S:='$'+S;
     VAL(S,_CT_DMA_CHANNEL,ERROR);
     S:=COPY(GETENV('BLASTER'),POS('T',GETENV('BLASTER'))+1,1);
     S:='$'+S;
     VAL(S,_WCARDID,ERROR);
     IF ERROR>0 THEN _WCARDID:=1;
     IF _WCARDID>=2 THEN _UARTMODE:=TRUE ELSE _UARTMODE:=FALSE;
END;

{--------------------------------------------------------------------------}

FUNCTION SBC_SCAN_CARD:WORD;
BEGIN
     BXX:=0;
     TESTDSPADDR;
     SBC_SCAN_CARD:=BXX;
     TESTFMADDR;
     SBC_SCAN_CARD:=BXX;
END;

