{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{                                                                       }
{ SB FM low level functions                                             }
{                                                                       }
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}
{***********************************************************************}

Procedure waitfm;
var cr:word;
Begin
     cr:=0;
     repeat
       inc(cr);
     until (cr>_Fmwait) or (port[$388] and 128=128);
End;

Procedure Calcnote(note_num:byte);
Var note:byte;
    bem :byte;
Begin
        Note:=Note_Num+Transpose;
        CASE Note OF
         24..35: BEM:=1;
         36..47: BEM:=2;
         48..59: BEM:=3;
         60..71: BEM:=4;
         72..83: BEM:=5;
         84..95: BEM:=6;
         96..107:BEM:=7;
        end;
        Highbyte:=(bem*4);
        Lowbyte:=(Note-(BEM*12))-12;
        IF Lowbyte=0 THEN Lowbyte:=0;
        IF Lowbyte=1 THEN Lowbyte:=15;
        IF Lowbyte=2 THEN Lowbyte:=32;
        IF Lowbyte=3 THEN Lowbyte:=48;
        IF Lowbyte=4 THEN Lowbyte:=66;
        IF Lowbyte=5 THEN Lowbyte:=86;
        IF Lowbyte=6 THEN Lowbyte:=106;
        IF Lowbyte=7 THEN Lowbyte:=128;
        IF Lowbyte=8 THEN Lowbyte:=150;
        IF Lowbyte=9 THEN Lowbyte:=175;
        IF Lowbyte=10 THEN Lowbyte:=200;
        IF Lowbyte=11 THEN Lowbyte:=228;
End;

Procedure Setup_FM(ch,Tune,Fch,vol:byte);
var Tone:array[1..16]of byte;
    Modvol,
    ModSca,
    Carvol,
    CarSca:Byte;
Begin
    Move(FM_INST[Tune],Tone,16);

    waitfm;
    port[$388]:=$08;
    waitfm;
    port[$389]:=0;
    waitfm;
    port[$388]:=$20+CellModOfs[Fch];   {MODULATOR : Am,vib,eg,ksr,multiple}
    WaitFM;
    port[$389]:=Tone[1];
    WaitFM;
    port[$388]:=$20+CellCarOfs[Fch];   {CARRIER   : Am,vib,eg,ksr,multiple}
    WaitFM;
    port[$389]:=Tone[2];

    WaitFM;
    port[$388]:=$40+CellModOfs[Fch];   {MODULATOR : Scaling/Output level}
    WaitFM;
    port[$389]:=Tone[3];

 IF Stereo then
 begin
    If vol-Pan_left[ch]>=0 then Rightvol:=vol-Pan_left[ch] else Rightvol:=0;
    If vol-Pan_right[ch]>=0 then Leftvol:=vol-Pan_right[ch] else Leftvol:=0;

    Carvol:=Tone[4] shl 2;
    Carvol:=Carvol  shr 2;
    carvol:=63-carvol;
    Carvol:=((128-Leftvol)*Carvol) shr 7;
    CarSca:=Tone[4] shr 6;
    CarSca:=CarSca  shl 6;

    WaitFM;
    port[_ct_io_addx + $0]:=$40+CellCarOfs[Fch];   {CARRIER LEFT  : S/O level}
    WaitFM;
    port[_ct_io_addx + $1]:=Carvol+CarSca;

    Carvol:=Tone[4] shl 2;
    Carvol:=Carvol  shr 2;
    carvol:=63-carvol;
    Carvol:=((128-Rightvol)*Carvol) shr 7;
    CarSca:=Tone[4] shr 6;
    CarSca:=CarSca  shl 6;

    WaitFM;
    port[_ct_io_addx + $2]:=$40+CellCarOfs[Fch];   {CARRIER RIGHT : S/O level}
    WaitFM;
    port[_ct_io_addx + $3]:=Carvol+CarSca;

 end else
 begin

   { Volume settings, when card NOT support FM stereo method }

   Carvol:=Tone[4] shl 2;
   Carvol:=Carvol  shr 2;
   carvol:=63-carvol;
   Carvol:=((128-vol)*Carvol) shr 7;
   CarSca:=Tone[4] shr 6;
   CarSca:=CarSca  shl 6;

   WaitFM;
   port[$388]:=$40+CellCarOfs[Fch];   {CARRIER   : Scaling/Output level}
   WaitFM;
   port[$389]:=Carvol+CarSca;

 end;

    WaitFM;
    port[$388]:=$60+CellModOfs[Fch];   {MODULATOR : Attack/Decay}
    WaitFM;
    port[$389]:=Tone[5];
    WaitFM;
    port[$388]:=$60+CellCarOfs[Fch];   {CARRIER   : Attack/Decay}
    WaitFM;
    port[$389]:=Tone[6];
    WaitFM;
    port[$388]:=$80+CellModOfs[Fch];   {MODULATOR : Sustain/Release}
    WaitFM;
    port[$389]:=Tone[7];
    WaitFM;
    port[$388]:=$80+CellCarOfs[Fch];   {CARRIER   : Sustain/Release}
    WaitFM;
    port[$389]:=Tone[8];
    WaitFM;
    port[$388]:=$E0+CellModOfs[Fch];   {MODULATOR : Waves}
    WaitFM;
    port[$389]:=Tone[9];
    WaitFM;
    port[$388]:=$E0+CellCarOfs[Fch];   {CARRIER   : Waves}
    WaitFM;
    port[$389]:=Tone[10];
    WaitFM;
    port[$388]:=$C0+Fch-1;             {  Feedback/Connection }
    WaitFM;
    port[$389]:=Tone[11];


End;

Procedure KeyON(fch:byte);
Begin
    Waitfm;
    port[$388]:=$A0+Fch-1;        {A0-A8 (9)  lowbyte of note}
    WaitFM;
    Port[$389]:=Lowbyte;
    WaitFM;
    port[$388]:=$B0+Fch-1;        {B0-B8 (9) high bt. note, key,outoctblock}
    WaitFM;
    port[$389]:=32+Highbyte+1;
    FMByte[fch]:=Highbyte;
End;


Procedure Sbfd_instrument(inst_table:pointer);
Begin
     Instruments:=Inst_Table;
     Int_Inst:=False;
End;

Procedure noteon1(channel,fch,note_num,velocity:byte);
Begin
      Calcnote(note_num);
      Setup_FM(channel,FM_Tune[channel],Fch,velocity);
      KeyON(FCH);
      FM_Plays[fch]:=note_num;
End;

Procedure noteoff2(fmch:byte);
Begin
    waitfm;
    port[$388]:=$B0+fmch-1;
    waitfm;
    port[$389]:=Fmbyte[fmch]+1;
End;

Procedure noteoff1(channel,note_num,velocity:byte);
var ttt:byte;
Begin
   For ttt:=1 to maxch do
   begin
    If FM_Plays[ttt]=note_num then
    begin
     waitfm;
     port[$388]:=$B0+ttt-1;
     waitfm;
     port[$389]:=Fmbyte[ttt]+1;
     playing[ttt]:=0;
    end;
   end;
End;

Procedure Sbfd_note_on(channel,note_num,velocity:byte);
var rr,fre,rl:byte;
Begin
     Inc(channel);
     If channel>16 then exit;
     If (note_num<24) or (note_num>107)then exit;
     If velocity>127 then velocity:=127;

     ch_note[channel]:=note_num;


     For Free_ch:=1 to maxch do
     begin
       If playing[Free_ch]=0 then
       begin

         playing[Free_ch]:=maxch;
         noteoff2(Free_ch);
         noteon1(channel,Free_ch,note_num,velocity);
         LastFmch:=Free_ch;
         exit;
       end;
     end;

     Inc(LastFMCh);
     If LastFmch>Maxch then
     begin
      LastFmch:=1;
     end;

     RR:=LastFMCh;
     noteoff2(rr);
     playing[rr]:=1;
     noteon1(channel,rr,note_num,velocity);

End;

Procedure Sbfd_note_off(channel,note_num,velocity:byte);
Begin
     noteoff1(channel,note_num,velocity);
End;

Procedure Sbfd_program_change(channel,program_num:byte);
var tt,st,ot:word;
Begin
     inc(channel); {0-15 to 1-16}
     If Int_Inst then
     begin
      Program_num := Program_num shl 4;
      Program_num := Program_num shr 4;
     end;
     If program_num>127 then exit;
     If channel>16 then exit;
     inc(program_num);
     st:=Seg(Instruments^);
     ot:=Ofs(Instruments^);
     For tt:=1 to 16 do
     begin
         Fm_inst[channel,tt]:=mem[st:ot+tt+(16*program_num)-17];
     end;
     Fm_tune[channel]:=program_num;
End;

Procedure Sbfd_music_off;
var rr:byte;
Begin
     For rr:=1 to 9 do
     begin
          Setup_FM(0,0,rr,0);
          waitfm;
          port[$388]:=$B0+rr-1;
          waitfm;
          port[$389]:=0;
          playing[rr]:=0;
     end;
End;

Procedure Sbfd_setmode(fm_mode:integer);
var te:byte;
Begin
   If fm_mode=0 then
   begin
     waitfm;
     port[_ct_io_addx + $08]:=$BD;
     waitfm;
     port[_ct_io_addx + $09]:=0;
     _drum:=false;
   end else
   begin
     waitfm;
     port[_ct_io_addx + $08]:=$BD;
     waitfm;
     port[_ct_io_addx + $09]:=32;;
     waitfm;
     port[_ct_io_addx + $08]:=$B6;
     waitfm;
     port[_ct_io_addx + $09]:=0;;
     waitfm;
     port[_ct_io_addx + $08]:=$B7;
     waitfm;
     port[_ct_io_addx + $09]:=0;;
     waitfm;
     port[_ct_io_addx + $08]:=$B8;
     waitfm;
     port[_ct_io_addx + $09]:=0;;
     _drum:=true;
   end;
   If _drum then maxch:=6 else maxch:=9;
End;

Procedure Sbfd_mono_stereo(Stereovar:Boolean);
Begin
  If NOT Stereovar then
  begin
    delay(1);
    Port[_ct_io_addx + $04]:=$0e;
    delay(1);
    Port[_ct_io_addx + $05]:=0;
    stereo:=False;
  end else
  begin
    delay(1);
    Port[_ct_io_addx + $04]:=$0e;
    delay(1);
    Port[_ct_io_addx + $05]:=2;
    stereo:=True;
  end;

End;

Procedure Sbfd_panor(Channel,panor:byte);
var Left,Right:byte;
Begin
     Inc(Channel);
     If panor > 127 then exit;
     If channel>16 then exit;

     If panor = 64 then
     begin
      pan_left [channel]:=0;
      pan_right[channel]:=0;
     exit;
     end else
     begin

      If panor<64 then
      begin
        pan_left[channel]:=(64-panor)*2;
        pan_right[channel]:=0;
      end;

      If panor>64 then
      begin
        pan_right[channel]:=(panor-64)*2;
        pan_left[channel]:=0;
      end;
     end;
End;

Procedure Sbfd_init;
Begin
     Instruments:=@Inst;
     Int_Inst:=True;
     Move(Inst,Fm_inst,Sizeof(Inst));
     Sbfd_setmode(1);
     Sbfd_mono_stereo(False);
     For t:=0 to 15 do
     begin
          sbfd_program_change(t,t);  { <- set internal default voices }
          Pan_left [t+1]:=0;        { <- set panor to middle way     }
          Pan_right[t+1]:=0;
     end;
     Sbfd_music_off;
End;

Procedure Sbfd_reset;
Begin
     Sbfd_init;
End;

