% euclid.t finds the greatest common denominator of two integers
% using Euclid's algorithm

var x, y, z : int

program

    put "Numbers must be positive integers!"
    put "enter numerator   : "...
    get x
    assert x > 0

    put "enter denominator : "...
    get y
    assert y > 0

    z := gcd( x, y )
    put "greatest common denominator = ", z

    put "smallest numerator   = ", x/z
    put "smallest denominator = ", y/z

end program


function gcd( u : int, v : int ) : int
    var t : int

    loop
        exit when u <= 0
        if u < v then
            t := u
            u := v
            v := t
        end if
        u := u - v
    end loop
    return v
end gcd

