%
%  "lister.t" lists T source programs
%

type file_name : string( 32 )

var Main_file_name : file_name
var Main_file : int
var Line_buffer: string


program

    open_main
    process_file

end program


procedure open_main

    put "Enter main file name: "
    get Main_file_name

    Main_file := open( Main_file_name, "r" )
    if Main_file = 0 then
        put "ERROR -- File not found: ", Main_file_name
        assert false
    end if

end open_main


procedure process_file

    loop

        exit when eof( Main_file) 

        get :Main_file, Line_buffer : *
      
        if index( Line_buffer, "include " ) >= 0 then
            process_include_file( Line_buffer )
        else
            put Line_buffer 
        end if

        Line_buffer := ""
    
    end loop

    if not close( Main_file ) then
        put "file close error"
    end if

end process_file


procedure process_include_file( var inc_str : string )

    var i, j : int
    var include_file : int
    var include_file_name : file_name

    
    i := index( inc_str, "include" )
    i := i + 8
    loop
        exit when inc_str( i ) ~= ' ' 
        i := i + 1
    end loop

    j := 0
    loop
        include_file_name( j ) := inc_str( i )
        j := j + 1
        i := i + 1
        exit when inc_str( i ) = ' '
        exit when inc_str( i ) = chr( 0 )
    end loop
    include_file_name( j ) := chr( 0 )
    
    include_file := open( include_file_name, "r" )
    if include_file = 0 then
        put "ERROR -- Include file not found:  ", include_file_name
        return
    end if

    loop
        exit when eof( include_file )
        get :include_file, Line_buffer : *
        put Line_buffer 
        Line_buffer := ""
    end loop
    
    if not close( include_file ) then
        put "file close error"
    end if

end process_include_file


