% example of trapezoidal integration

var a : real
var n, i : int

function y( t : real ) : real

     return abs( sin( t ) ) / ( 3.0*t + 1.0 )

end y

program

   n := 0

   for i := 1 ... 10 do
 
      n := n + 10
      integrate( 0.0, 3.0, n, a )
      put n, a:12:9

   end for

end program

%
% Trapezoidal integration procedure
%  a - initial value of independent variable
%  b - final value of independent variable 
%  n - number of trapezoidal sections used
%  area - value of integral from a to b
%
procedure integrate( a, b : real, n : int, var area : real ) 

   var t, dt : real
   var i : int

   t := a
   dt := ( b - a ) / n

   area := y( a ) / 2.0

   % compute the n-1 terms of the summation

   if n ~= 1 then

      for i := 1 ... n-1 do

         watch( t )
         t := t + dt
         area := area + y( t )
       
      end for

   end if

   area := ( area + y( b ) / 2.0 ) * dt

end integrate



