{****************************************************************************}
{                                                                            }
{ MODULE:         DevAdLib                                                   }
{                                                                            }
{ DESCRIPTION:    Device driver for the Adlib sound card and compatibles.    }
{                 This works with Sound Blasters and with Covox SM II.       }
{                 It uses timer polling.                                     }
{                                                                            }
{ AUTHOR:         Juan Carlos Arvalo                                        }
{                                                                            }
{ MODIFICATIONS:  Nobody (yet ;-)                                            }
{                                                                            }
{ HISTORY:        12-Nov-1992 Description                                    }
{                                                                            }
{ (C) 1992 VangeliSTeam                                                      }
{____________________________________________________________________________}

UNIT DevAdLib;

INTERFACE




{ Device ID String. }

CONST
  AdlibDevID = 'AdLib';




IMPLEMENTATION

USES SoundDevices, StrConst;




{----------------------------------------------------------------------------}
{ AdLib routines.                                                            }
{____________________________________________________________________________}

PROCEDURE AdLibLoop; ASSEMBLER;
  ASM

@@lp:           IN      AL,DX
                LOOP    @@lp

  END;


PROCEDURE SendAdlibReg(Reg, Value: BYTE); ASSEMBLER;
  ASM
                MOV     DX,$388
                MOV     AL,Reg
                OUT     DX,AL

                MOV     CX,6
                CALL    AdLibLoop

                INC     DX
                MOV     AL,Value
                OUT     DX,AL

                MOV     CX,35
                CALL    AdLibLoop

  END;


PROCEDURE ResetAdlib;
  VAR
    i : WORD;
  BEGIN
    FOR i := 1 TO 255 DO
      SendAdlibReg(i, 0);
  END;




{----------------------------------------------------------------------------}
{ Assembler IRQ.                                                             }
{____________________________________________________________________________}

{$L DEVADLIB}

PROCEDURE AdLibIntHandler; FAR; EXTERNAL;




{----------------------------------------------------------------------------}
{ Name function.                                                             }
{____________________________________________________________________________}

FUNCTION AdLibName : TDevName; FAR;
  BEGIN
    AdLibName := GetString(StrDevAdLibName);
  END;




{----------------------------------------------------------------------------}
{ Autodetect routine. It's always present. Well, it's not, but... O:-)       }
{____________________________________________________________________________}

FUNCTION DevDetect : BOOLEAN; FAR;
  BEGIN
    DevDetect := TRUE;
  END;




{----------------------------------------------------------------------------}
{ Device Initialisation routine.                                             }
{____________________________________________________________________________}

PROCEDURE DevInit(Hz: WORD); FAR; 
  BEGIN
    ResetAdlib;             { Turn off all channels, and stuff. }
                            { Start in a known state.           }

    SendAdlibReg($01, $20);
    SendAdlibReg($C0, $01);
    SendAdlibReg($23, $27); { All this selects a sustained note, with a highest }
    SendAdlibReg($43, $00); { pitch and with a fully rectified wave form.       }
    SendAdlibReg($63, $FF); { Empirically calculated (trial and error). If you  }
    SendAdlibReg($83, $0F); { can find a better configuration, please tell me.  }
    SendAdlibReg($E3, $02);
    SendAdlibReg($A0, $0C);
    SendAdlibReg($B0, $3F);

    CalcTimerData(Hz);   { Then, standard pollin init. }
    InitTimer;
  END;




{----------------------------------------------------------------------------}
{ Device deinitialisation routine.                                           }
{____________________________________________________________________________}

PROCEDURE DevEnd; FAR;
  BEGIN
    ResetAdlib;
  END;




{----------------------------------------------------------------------------}
{ Accesory routines.                                                         }
{____________________________________________________________________________}

PROCEDURE DevChgHz(Hz: WORD); FAR;
  BEGIN
    CalcTimerData(Hz);
    InitTimer;
  END;

PROCEDURE DevPoll; FAR;
  BEGIN
  END;




{----------------------------------------------------------------------------}
{ Device record.                                                             }
{____________________________________________________________________________}

CONST
  AdLibData : TSoundDevice = (
    DevID      : AdLibDevID;
    DMA        : FALSE
  );




{----------------------------------------------------------------------------}
{ Init code.                                                                 }
{____________________________________________________________________________}

BEGIN

  WITH AdLibData DO BEGIN
    Name            := AdLibName;
    AutoDetect      := DevDetect;
    InitRut         := DevInit;
    ChgHzProc       := DevChgHz;
    GetRealFreqProc := GetRealFreq;
    TimerHandler    := AdLibIntHandler;
    PollRut         := DevPoll;
    EndRut          := DevEnd;
  END;

  InitDevice(@AdLibData);

END.
