PROGRAM OS2VT;

{$M 4000, 0, 655360}

USES Dos,
     VTSpecial, VTGlobal,
     SoundDevices, DevFile,
     PlayMod, ModUnit,
     DOSMem, Debugging;

CONST
  NombreApp = 'OS2VT';

  AppID : STRING[Length(NombreApp) + 2 + Length(Version) + Length(BetaStr)] =
            NombreApp+' v'+Version+BetaStr;

VAR
  Path    : PathStr;
  Dir     : DirStr;
  Name    : NameStr;
  Ext     : ExtStr;
  SearchR : SearchRec;
  s       : STRING;
  i, r    : WORD;
  ch      : CHAR;
  ac      : STRING[1];

BEGIN

  WriteLn;
  WriteLn(    '   Ŀ');
  WriteLn(    '     OS2VT. Versin para OS/2 del VangeliSTracker, v'+Version+'  ');
  WriteLn(    '                    (C) 1992 VangeliSTeam                 ');
  WriteLn(    '   ');

  IF ParamCount = 0 THEN
    BEGIN
      WriteLn(' Ŀ');
      WriteLn('  OS2VT <fichero>[.MOD] [<velocidad> [<fichero de salida>]] ');
      WriteLn(' ');
      HALT(1);
    END;

  VTResidentCheck(AppID);

  Debugging.Debug := FALSE{TRUE};

  LoopMod      := FALSE;
  ForceLoopMod := FALSE;

  DevID := FileDevID;

  s := ParamStr(3);
  IF s <> '' THEN
    FileDevFName := s;

  SetDevice(LocateDevice(DevID));

  s := ParamStr(2);
  IF s <> '' THEN
    BEGIN
      VAL(s, i, r);
      IF r = 0 THEN DesiredHz := i;
    END;

  InitModUnit;

  ChangeSamplingRate(DesiredHz);
  InitDOSMem;

  Path := ParamStr(1);
  Path := FExpand(Path);
  FSplit(Path, Dir, Name, Ext);
  IF Ext = '' THEN Ext := '.MOD';
  Path := Dir + Name + Ext;
  IF Ext = '.' THEN ac := Ext
               ELSE ac := '';

  ch := #0;

  Write(#13, Path);

  FindFirst(Path, ReadOnly, SearchR);

  WHILE (DosError = 0) AND (ch <> #27) DO
    BEGIN
      Write(#13, Dir + SearchR.Name);
      IF NOT LoadMod(Dir + SearchR.Name + ac) THEN
        Write(#13'Error en el fichero MOD:', Dir + SearchR.Name)
      ELSE
        BEGIN
          PlayStart;
          DMAOffset := 1;
          ch := FileRun;
          PlayStop;
          EndSampling;
        END;

      WriteLn;

      FindNext(SearchR);
    END;

END.
