PROGRAM VT;

{$M 8000,20000,655360}

USES VTSpecial,                      { Installation check.                 }
     VTStrConst, StrConst,           { Language support.                   }
     Dos,                            { Standard TP UNITs.                  }
     VTCfg, VTGlobal,                { VT-Specific UNITs.                  }
     VTWins, VTPlay, VTPartitura,    {                                     }
     VTScreens,                      {                                     }
     ModUnit, PlayMod, Filters,      { MOD-Specific UNITs.                 }
     SoundDevices, DevSB, DevSpkr,   { Sound output devices.               }
     DevDAC, DevSbDAC, DevAdLib,     {                                     }
     DevFile,                        {                                     }
     SoundBlaster,                   {                                     }
     Vid43, Output43,                { Video routines.                     }
     Kbd, Debugging, DOSMem,         { Miscelaneous UNITs.                 }
     FileUtil;                       {                                     }




VAR
  nt             : TModNote;
  pp             : PPattern;
  omd,
  md             : TPlayingNote;
  ThereIsNewNote : BOOLEAN;
  VTLoopMod      : BOOLEAN;

CONST
  Funking    : BOOLEAN = FALSE;
  FunkGoesUp : BOOLEAN = FALSE;
  FadingOut  : BOOLEAN = FALSE;
  FadedOut   : BOOLEAN = FALSE;
  FadeCount  : WORD    = 0;
  LastSeq    : BYTE    = 255;

VAR
  Sequences  : ARRAY[0..127] OF BOOLEAN;




{ -------------------------------------------------------------------------- }

FUNCTION IsAConsole(VAR f) : BOOLEAN; ASSEMBLER;
  ASM

                MOV     AX,$4400
                LES     BX,[f]
                MOV     BX,TextRec([ES:BX]).Handle
                INT     $21
                XOR     AX,AX
                TEST    DL,3
                JZ      @@Fin
                INC     AX
@@Fin:

  END;

FUNCTION RJust(s: STRING; i: WORD) : STRING;
  VAR
    r : STRING;
  BEGIN
    IF i <= Length(s) THEN
      BEGIN
        RJust := s;
        EXIT;
      END;
    r[0] := CHAR(i - Length(s));
    FillChar(r[1], i - Length(s), ' ');
    RJust := r + s;
  END;


FUNCTION LJust(s: STRING; i: WORD) : STRING;
  VAR
    r : STRING;
  BEGIN
    IF i <= Length(s) THEN
      BEGIN
        LJust := s;
        EXIT;
      END;
    r[0] := CHAR(i - Length(s));
    FillChar(r[1], i - Length(s), ' ');
    LJust := s + r;
  END;


FUNCTION Char2Str(c: CHAR; n: BYTE) : STRING;
  VAR
    s : STRING;
  BEGIN
    FillChar(s, SIZEOF(s), c);
    s[0] := CHAR(n);
    Char2Str := s;
  END;


PROCEDURE MyWriteLn(s: STRING);
  CONST
    Linea : WORD = 0;
  BEGIN
    IF ((Linea >= 24) OR (s = '')) AND IsAConsole(Output) THEN
      BEGIN
        Write(StdErr, GetString(StrUsagePressAKey));
        KbdReadKey;
        Write(StdErr, #13+Char2Str(' ', 79)+#13);
        Linea := 0;
      END;
    IF s <> '' THEN WriteLn(Output, s);
    INC(Linea);
  END;



PROCEDURE USAGE;
  VAR
    i : WORD;
    p : PSoundDevice;
  BEGIN
    MyWriteLn('                           ͻ');
    MyWriteLn('                            VangeliSTracker  v'+Version+' ');
    MyWriteLn('                           ͼ');

    IF Beta THEN
      MyWriteLn('                                     (beta)');

    MyWriteLn(GetString(StrUsageTop));
    MyWriteLn(GetString(StrUsage01));
    MyWriteLn(GetString(StrUsageBottom));

    MyWriteLn(GetString(StrUsageTop));
    MyWriteLn(GetString(StrUsage11));
    MyWriteLn(GetString(StrUsageEmpty));
    MyWriteLn(GetString(StrUsage12));
    MyWriteLn(GetString(StrUsage13));
    MyWriteLn(GetString(StrUsage14));
    MyWriteLn(GetString(StrUsageBottom));

    MyWriteLn('');

    MyWriteLn(GetString(StrUsageTop));
    MyWriteLn(GetString(StrUsage21));

    FOR i := 1 TO NumDevices DO
      BEGIN
        p := IndexDevice(i);
        MyWriteLn(LJust('    '+RJust(p^.DevID+':', SIZEOF(TDevID))+' '+p^.Name, 78)+'');
      END;

    MyWriteLn(GetString(StrUsageBottom));
    HALT(1);
  END;

{ -------------------------------------------------------------------------- }

PROCEDURE ORROR(s: STRING);
  BEGIN
    QuitaVideoMode43;

    WriteLn('ORROR: ', s);

    HALT(1);
  END;

{ -------------------------------------------------------------------------- }

CONST
  StkSize = 500;
VAR
  Stack1 : ARRAY[1..StkSize] OF BYTE;

PROCEDURE TickProc(note: BOOLEAN); FAR;
  CONST
    Semaphor  : BYTE    = 0;
    Semaphor2 : BYTE    = 0;
    Semaphor3 : BYTE    = 0;
    Semaphor4 : BYTE    = 0;
    NewNote   : BOOLEAN = FALSE;
    L2ndForz  : BOOLEAN = FALSE;
    Count     : BYTE    = 0;
    i         : WORD    = 0;
    j         : WORD    = 0;
    SS_1      : WORD    = 0;
    SP_1      : WORD    = 0;
  BEGIN

    IF (NOT Playing) AND (Semaphor4 = 0) THEN
      BEGIN
        INC(Semaphor4);
        UpdateBars;
{
        FillChar(nt, SIZEOF(nt), 0);
        FOR i := 1 TO 4 DO
          UpdateSampleInfo(nt, i);
        TickSampleInfo;
}
        DEC(Semaphor4);
        EXIT;
      END;

    IF note THEN BEGIN
      NewNote        := TRUE;
      ThereIsNewNote := TRUE;
    END;

    L2ndForz := L2ndForz OR w2ndLine.forz;

    IF Semaphor = 0 THEN BEGIN
      INC(Semaphor);

       ASM
                MOV     [SS_1],SS
                MOV     [SP_1],SP
                MOV     AX,DS
                MOV     SS,AX
                MOV     SP,OFFSET Stack1 + StkSize
       END;

       IF NewNote THEN BEGIN
         md := NoteSound^;
         UpdateRunInfo(md.Tempo, md.NotePlaying, md.SeqPlaying);

         pp := Patterns[PatternSequence[md.SeqPlaying]];

         w2ndLine.forz := L2ndForz;

         FOR i := 1 TO 4 DO BEGIN
           UnpackNote(pp^[md.NotePlaying][i], nt);

           UpdateNoteInfo  (nt, i);
           UpdateSampleInfo(nt, i);
           ParseBarInit    (nt, i);

         END;

         IF (md.SeqPlaying < 128) AND (LastSeq <> md.SeqPlaying) THEN
           BEGIN
             IF (NOT VTLoopMod) AND Sequences[md.SeqPlaying] THEN
               FadingOut := TRUE;

             Sequences[md.Seqplaying] := TRUE;
             LastSeq := md.SeqPlaying;
           END;

         NewNote  := FALSE;
         L2ndForz := FALSE;
       END;

       Update2ndLine(note);
       TickSampleInfo;

       ASM
                MOV     SS,[SS_1]
                MOV     SP,[SP_1]
       END;

      DEC(Semaphor);
    END;

    UpdateOscilloscInfo;

    IF Semaphor2 = 0 THEN
      BEGIN
        INC(Semaphor2);
        IF Funking THEN
          ASM
{
                MOV     DX,$3DA
@@lp1:           IN     AL,DX
                 AND    AL,8
                 JZ     @@lp1

                MOV     DX,$3D4
                MOV     AL,$18
                MOV     AH,[Count]
                OUT     DX,AX

                MOV     DL,[FunkGoesUp]
@@otra:         AND     DL,DL
                JZ      @@down
                 DEC    AH
                JMP     @@up
@@down:          INC    AH
@@up:           AND     AH,AH
                JNZ     @@ya
                 AND    DL,1
                 XOR    DL,1
                 MOV    [FunkGoesUp],DL
                 JMP    @@otra
@@ya:           MOV     [Count],AH
}
          END;
        DEC(Semaphor2);
      END;

    IF (FadingOut) AND (Semaphor3 = 0) THEN
      BEGIN
        INC(Semaphor3);
        IF NOT PermitFade THEN
          FadedOut := TRUE
        ELSE
          BEGIN
            INC(FadeCount, FadeIncr);
            FOR j := 1 TO HI(FadeCount) DO
              BEGIN
                IF LONGINT(UserVols) <> 0 THEN
                  BEGIN
                    IF UserVols[0] > 0 THEN DEC(UserVols[0]);
                    IF UserVols[1] > 0 THEN DEC(UserVols[1]);
                    IF UserVols[2] > 0 THEN DEC(UserVols[2]);
                    IF UserVols[3] > 0 THEN DEC(UserVols[3]);
                  END
                ELSE
                  FadedOut := TRUE;
              END;
            FadeCount := LO(FadeCount);
          END;
        DEC(Semaphor3);
      END;
  END;

{ -------------------------------------------------------------------------- }

PROCEDURE OsShell;
  VAR
    OldScr  : WORD;
    OldHz   : WORD;
    OldLMod : BOOLEAN;
    OldVMod : BOOLEAN;
    OldFall : BOOLEAN;
  BEGIN
    OldFall       := MyCanFallBack;
    OldScr        := ActiveWindows;
    OldVMod       := VTLoopMod;
    OldLMod       := MyLoopMod;
    OldHz         := DesiredHz;

    MyCanFallBack := FALSE;
    VTLoopMod     := TRUE;
    MyLoopMod     := TRUE;
    SetNothing;
    QuitaVideoMode43;
    IF DesiredHz > ShellHz THEN
      DesiredHz := ShellHz;
    ChangeSamplingRate(DesiredHz);

    SwapVectors;
    Exec(ShellPath, ShellParam);
    SwapVectors;

    ChangeSamplingRate(OldHz);
    PoneVideoMode43;
    InitWinF8Demo;
    SetUser(OldScr);
    RefreshMiscInfo;
    MyLoopMod   := OldLMod;
    VTLoopMod   := OldVMod;
    MyCanFallBack := OldFall;
  END;



PROCEDURE DoFunk;
  VAR
    f : BOOLEAN;
  BEGIN
    f := NOT Funking;
    IF f THEN
      ASM

          MOV     DX,$3D4

          MOV     AL,9
          OUT     DX,AL
          INC     DX
          IN      AL,DX
          AND     AL,$BF
          OUT     DX,AL
          DEC     DX

          MOV     AL,$11
          OUT     DX,AL
          INC     DX
          IN      AL,DX
          AND     AL,$7F
          OUT     DX,AL
          DEC     DX

          MOV     AL,7
          OUT     DX,AL
          INC     DX
          IN      AL,DX
          AND     AL,$EF
          OUT     DX,AL
          DEC     DX

          MOV     AL,$18
          MOV     AH,8*10 - 1
          OUT     DX,AX

          MOV     AL,f
          MOV     Funking,AL

      END
    ELSE
      ASM

          MOV     AL,f
          MOV     Funking,AL

          MOV     DX,$3D4

          MOV     AL,9
          OUT     DX,AL
          INC     DX
          IN      AL,DX
          OR      AL,$40
          OUT     DX,AL
          DEC     DX

          MOV     AL,7
          OUT     DX,AL
          INC     DX
          IN      AL,DX
          OR      AL,$10
          OUT     DX,AL
          DEC     DX

          MOV     AL,$11
          OUT     DX,AL
          INC     DX
          IN      AL,DX
          OR      AL,$80
          OUT     DX,AL
          DEC     DX

      END;
  END;

{ -------------------------------------------------------------------------- }

FUNCTION DoPlayMod : BOOLEAN;
  VAR
    cr   : CHAR;
    ch,
    LastHz,
    MyHz,
    i, r : WORD;
    s    : STRING;
    Fl   : BYTE ABSOLUTE $B800:0;
  BEGIN

    ThereIsNewNote := FALSE;

    DrawPartiture(0, 0, Patterns[PatternSequence[0]]);

    ModTickProc      := TickProc;
    ModTickProcValid := TRUE;

    FadingOut := FALSE;
    FadedOut  := FALSE;

    FillChar(Sequences, SIZEOF(Sequences), FALSE);
    LastSeq := 255;

    FillChar(UserVols, SIZEOF(UserVols), VtVolume);

    LastHz := SoundHz;

    InitPlayData;
    PlayStart;
    ChangeSamplingRate(DesiredHz);
    RefreshMiscInfo;

    REPEAT
      ch := 0;
      cr := #0;
      IF KbdKeyPressed THEN BEGIN
        ch := KbdReadKey;
        cr := UPCASE(CHAR(ch));
      END;

      CASE ch OF
        kbPgDn: IF NextSeq < SequenceLength-1 THEN BEGIN
                  Sequences[NextSeq]   := TRUE;
                  Sequences[NextSeq+1] := FALSE;
                  INC(NextSeq);
                END;
        kbPgUp: IF NextSeq > 0 THEN BEGIN
                  Sequences[NextSeq]   := FALSE;
                  Sequences[NextSeq-1] := FALSE;
                  DEC(NextSeq);
                END;
        kbHome: BEGIN
                  IF (NextNote < 8) AND (NextSeq > 0) THEN
                    BEGIN
                      Sequences[NextSeq]   := FALSE;
                      Sequences[NextSeq-1] := FALSE;
                      DEC(NextSeq);
                    END;
                  NextNote := 0;
                END;
        kbEnd:  IF NextSeq < SequenceLength-1 THEN BEGIN
                  Sequences[NextSeq]   := TRUE;
                  Sequences[NextSeq+1] := FALSE;
                  INC(NextSeq);
                  NextNote := 0;
                END;
        kbLeft: BEGIN
                  DEC(TicksPerSecond);
                END;
        kbRight:BEGIN
                  INC(TicksPerSecond);
                END;
        kbDown: BEGIN
                  IF DMAOffset > 0 THEN
                    BEGIN
                      DEC(DMAOffset);
                      HzChanged := TRUE;
                    END;
                END;
        kbUp:   BEGIN
                  INC(DMAOffset);
                  HzChanged := TRUE;
                END;
        kbF5:   SetBig;
        kbF6:   SetSmall_Samples;
        kbF7:   SetSmall_Oscillosc;
        kbF8:   SetCredits;
        kbF9:   DoFunk;
      ELSE
        CASE cr OF
          'D': OsShell;
          'N': FadingOut := TRUE;
          '1',
          '2',
          '3',
          '4': BEGIN
                 i := BYTE(cr) - BYTE('0');
                 Permisos[i-1]             := NOT Permisos[i-1];
                 w2ndLine.forz             := TRUE;
                 VTPartitura.PartWin^.forz := TRUE;
               END;
          'F': FilterOn  := TFilterMethod((BYTE(FilterOn)  + 1) MOD FilterMod);
          'G': FilterOff := TFilterMethod((BYTE(FilterOff) + 1) MOD FilterMod);
          '+': IF (NOT FadingOut) THEN
                 BEGIN
                   IF (VtVolume < 255-9) THEN
                     INC(VtVolume, 9)
                   ELSE
                     VtVolume := 255;
                   FOR i := 0 TO 3 DO UserVols[i] := VtVolume;
                 END;
          '-': IF (NOT FadingOut) THEN
                 BEGIN
                   IF (VtVolume > 9) THEN
                     DEC(VtVolume, 9)
                   ELSE
                     VtVolume := 0;
                   FOR i := 0 TO 3 DO UserVols[i] := VtVolume;
                 END;
          'R': BEGIN
                 MyHz := ActualHz;
                 WHILE (MyHz = ActualHz) AND (MyHz <> ActiveDevice^.GetRealFreqProc(0)) DO
                   BEGIN
                     DEC(DesiredHz, 100);
                     MyHz := ActiveDevice^.GetRealFreqProc(DesiredHz);
                   END;
                 ChangeSamplingRate(DesiredHz);
                 RefreshMiscInfo;
               END;
          'T': BEGIN
                 MyHz := ActualHz;
                 WHILE (MyHz = ActualHz) AND (MyHz <> ActiveDevice^.GetRealFreqProc(65535))  DO
                   BEGIN
                     INC(DesiredHz, 100);
                     MyHz := ActiveDevice^.GetRealFreqProc(DesiredHz);
                   END;
                 ChangeSamplingRate(DesiredHz);
                 RefreshMiscInfo;
               END;
          'S': BEGIN
                 Playing := NOT Playing;
               END;
        END;
      END;

      IF SoundHz <> LastHz THEN
        BEGIN
          RefreshMiscInfo;
          LastHz := SoundHz;
        END;

      IF ThereIsNewNote THEN
        DrawPartiture(md.NotePlaying, md.SeqPlaying, pp);

      PollDevice;

{      INC(Fl);}

    UNTIL (ch = kbESC) OR FadedOut OR NOT Playing;

    DoPlayMod := ch = kbESC;

    PlayStop;
  END;

{ -------------------------------------------------------------------------- }

CONST
  AppID : STRING[Length(NombreApp) + 2 + Length(Version) + Length(BetaStr)] = NombreApp+' v'+Version+BetaStr;

VAR
  Path    : PathStr;
  Dir     : DirStr;
  Name    : NameStr;
  Ext     : ExtStr;
  SearchR : SearchRec;

  s    : STRING;
  i, r : WORD;
LABEL
  Fin;
BEGIN

  StringsFName := FExpand(StringsFName);
  FSplit(StringsFName, Dir, Name, Ext);
  IF NOT FileExists(StringsFName) THEN
    StringsFName := Name+Ext;
  IF NOT FileExists(StringsFName) THEN
    StringsFName := VTDir+Name+Ext;

  IF (NOT FileExists(StringsFName)) OR NOT InitStrings(StringsFName) THEN
    BEGIN
      WriteLn(StdErr, 'VT needs a valid language file to run.');
      WriteLn(StdErr, 'VT necesita un fichero de lenguaje vlido para funcionar.');
      EXIT;
    END;

  IF ParamCount = 0 THEN USAGE;

  WriteLn(AppID, ' (C) 1992, VangeliSTeam.');
  WriteLn;
  Write(GetString(StrInitializing));

  VTResidentCheck(AppID);
  InitVid43;
  InitModUnit;

  VTLoopMod := MyLoopMod;
  IF (NOT MyLoopMod) AND (SequenceRepStart < SequenceLength) THEN
    MyLoopMod := TRUE;

  Debugging.Debug := FALSE{TRUE};

  IF ParamStr(2) <> '' THEN BEGIN
    s     := ParamStr(2);
    DevID := s;
  END;

  DevPtr := LocateDevice(DevID);
  IF (DevPtr = NIL) OR NOT DevPtr^.Autodetect THEN
    DevPtr := LocateDevice(SpkrDevID);
  SetDevice(DevPtr);

  IF ParamStr(3) <> '' THEN BEGIN
    VAL(ParamStr(3), i, r);
    DesiredHz := i;
  END;

  ChangeSamplingRate(DesiredHz);

  IF ParamStr(4) <> '' THEN BEGIN
    VAL(ParamStr(4), i, r);
    SbSplTimeout := i;
  END;

  IF ParamStr(5) <> '' THEN BEGIN
    VAL(ParamStr(5), i, r);
    SbIrq := i;
  END;

  Path := FExpand(ParamStr(1));
  FSplit(Path, Dir, Name, Ext);
  IF Ext = '' THEN Ext := '.MOD';
  Path := Dir + Name + Ext;


  InitVTScreens;
  PoneVideoMode43;
  InitWinF8Demo;
  SetSmall_Samples;

  SetOffs(ScrOffset);


  InitDOSMem;


  FindFirst(Path, ReadOnly, SearchR);
  IF DosError <> 0 THEN ORROR(GetErrorString(1));
  WHILE DosError = 0 DO
    BEGIN
      IF NOT LoadMod(Dir + SearchR.Name) THEN ORROR(GetErrorString(ErrorCode));

      InitVTScreens;
      RefreshVTScreens;

      IF DoPlayMod THEN GOTO Fin;

      FindNext(SearchR);
    END;

Fin:
  EndSampling;

END.
