unit MacroKey;

interface

uses DOS, CRT, DDPlus, DDScott;

procedure record_macro(var s: string);
procedure display_macro(s: string);

implementation

procedure record_macro(var s: string);
var
 ch: char;
 ln: byte;
begin;
 ln:=1;
 s:='';
 set_foreground(lightblue);
 swrite(va(ln)+'> ');
 set_foreground(white);
 repeat;
  sread_char(ch);
  if ch<>^n then begin;
   swrite(ch);
   if ch=#13 then begin;
    ln:=ln+1;
    set_foreground(lightblue);
    swrite(#10+va(ln)+'> ');
    set_foreground(white);
   end;
   s:=s+ch;
  end;
 until (ch=^N) or (length(s)=80);
 set_foreground(default_fore);
 if length(s)=80 then swriteln('Maximum length reached.');
end;

procedure display_macro(s: string);
var
 ln: byte;
 a: integer;
begin;
 ln:=1;
 if s='' then swriteln('No macro recorded.') else begin;
  set_Foreground(lightblue);
  swrite(va(ln)+'> ');
  set_foreground(white);
  for a:=1 to length(s) do begin;
   swrite(s[a]);
   if s[a]=#13 then begin;
    ln:=ln+1;
    swrite(#10);
    set_foreground(lightblue);
    swrite(va(ln)+'> ');
    set_foreground(white);
   end;
  end;
 end;
 swriteln('');
 swriteln('');
end;

End.