Program RIP2Pas;

Uses
  Dos, CRT;{OpCrt, OpeningTitle;}

Const
  MegaArray : array[0..35] of Char = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';

Type
  ParseStatus   = (None,Got_Excl,Got_Pipe,Got_Level,Got_SubLevel,Got_Command);
  CharStatus    = (cNone,Pending,ContLine,Escaped);

  Str2          = string[2];
  Str4          = string[4];
  Str5          = string[5];
  Str12         = string[12];

Var
  Level,SubLevel : byte;
  command        : char;
  firstcmd,nextcommand,commanddone : boolean;
  pstat          : parsestatus;
  cstat          : charstatus;
  lastc          : char;
  rBuffer        : Array[1..1024] of char;
  bufcount       : word;
  str1           : string;
  outfile        : text;

Procedure ParseRip(c : char); forward;
Function DoRipChar(c : char): boolean; forward;

Function I2S(I: longint) : string; {inttostr}
var
  s     : string[11];
begin
  str(I,S);
  i2s := s;
end;

Function StrToInt(S: string) : longint;
var
  I     : longint;
  code  : integer;
begin
  I := 0;
  val(S,I,code);
  strtoint := I;
end;

Function TorF(b:boolean) : str5;
begin
  if b then
    torf := 'True'
  else
    torf := 'False';
end;

Function WordToMega(Num : word) : Str2;
var
  Num2          : word;
  work1         : Char;
  work2         : Char;
begin
  num2 := 0;
  work1 := #0;
  work2 := #0;
  if (Num < 0) or (Num > 1295) then
  begin
    WordToMega := '  ';
    Exit;
  end;
  while Num >= 36 do
  begin
    inc(num2);
    dec(num,36);
  end;
  work1 := MegaArray[num2];
  Work2 := MegaArray[num];
  WordToMega := work1+work2
end;

Function WordToMega4(Num : word) : Str4;
var
  Num2          : word;
  num3          : word;
  num4          : word;
  work1         : Char;
  work2         : Char;
  work3         : char;
  work4         : char;
begin
  num2 := 0;
  num3 := 0;
  num4 := 0;
  work1 := #0;
  work2 := #0;
  work3 := #0;
  work4 := #0;
  if Num < 0 then
  begin
    WordToMega4 := '    ';
    Exit;
  end;
  while Num >= 36 do
  begin
    inc(num2);
    dec(num,36);
  end;
  while Num2 >= 36 do
  begin
    inc(num3);
    dec(num2,36);
  end;
  while Num3 >= 36 do
  begin
    inc(num4);
    dec(num3,36);
  end;
  work1 := MegaArray[num4];
  work2 := MegaArray[num3];
  work3 := MegaArray[num2];
  Work4 := MegaArray[num];
  WordToMega4 := work1+work2+work3+work4;
end;

Function MegaToWord(S2 : Str2) : Word;
var
  Num           : word;
  Num2          : word;
  work1         : Char;
  work2         : Char;
begin
  num := 0;
  num2 := 0;
  work1 := #0;
  work2 := #0;

  work1 := upcase(s2[1]);
  work2 := upcase(s2[2]);

  if not ord(work1) in [48..57,65..90] then
    Exit;
  if not ord(work2) in [48..57,65..90] then
    Exit;

  if ord(work1) in [48..57] then
    num2 := ord(work1)-48;
  if ord(work1) in [65..90] then
    num2 := ord(work1)-55;

  if ord(work2) in [48..57] then
    num := ord(work2)-48;
  if ord(work2) in [65..90] then
    num := ord(work2)-55;

  while Num2 > 0 do
  begin
    dec(num2);
    inc(num,36);
  end;
  MegaToWord := num;
end;

Function Mega4ToLong(S4 : Str4) : Longint;
var
  Num           : longint;
  Num2          : longint;
  Num3          : longint;
  Num4          : longint;
  work1         : Char;
  work2         : Char;
  work3         : Char;
  work4         : Char;
begin
  num := 0;
  num2 := 0;
  num3 := 0;
  num4 := 0;
  work1 := #0;
  work2 := #0;
  work3 := #0;
  work4 := #0;

  work1 := upcase(s4[1]);
  work2 := upcase(s4[2]);
  work3 := upcase(s4[3]);
  work4 := upcase(s4[4]);

  if not ord(work1) in [48..57,65..90] then
    Exit;
  if not ord(work2) in [48..57,65..90] then
    Exit;
  if not ord(work3) in [48..57,65..90] then
    Exit;
  if not ord(work4) in [48..57,65..90] then
    Exit;

  if ord(work1) in [48..57] then
    num4 := ord(work1)-48;
  if ord(work1) in [65..90] then
    num4 := ord(work1)-55;

  if ord(work2) in [48..57] then
    num3 := ord(work2)-48;
  if ord(work2) in [65..90] then
    num3 := ord(work2)-55;

  if ord(work3) in [48..57] then
    num2 := ord(work3)-48;
  if ord(work3) in [65..90] then
    num2 := ord(work3)-55;

  if ord(work4) in [48..57] then
    num := ord(work4)-48;
  if ord(work4) in [65..90] then
    num := ord(work4)-55;

  while Num2 > 0 do
  begin
    dec(num2);
    inc(num,36);
  end;
  while Num3 > 0 do
  begin
    dec(num3);
    inc(num,1296);
  end;
  while Num4 > 0 do
  begin
    dec(num4);
    inc(num,46656);
  end;
  Mega4ToLong := num;
end;


Function DisplayRIPfile(Path : string): boolean;
var
  FName         : String;
  F             : file;
  FBuf          : Array [0..1023] of Char;
  BufRead       : Word;
  BufCnt        : Word;
begin
  displayripfile := false;
  FName := Path;
  filemode := $20;
  Assign(F,FName);
  {$I-}
  Reset(F,1);
  {$I+}
  if ioresult <> 0 then
  begin
    exit;
  end;
  displayripfile := true;
  While not EOF(F) do
  begin
    fillchar(FBuf,1024,#0);
    BlockRead(F,FBuf,1024,BufRead);
    For BufCnt := 0 to BufRead-1 do
    begin
      ParseRip(fbuf[bufcnt]);
    end;
  end;
  Close(F);
end;

Procedure ParseRip(c : char);
var
  ctr : word;
begin
  if not DoRipChar(c) then
  begin
    fillchar(rbuffer,1024,#0);
    bufcount := 0;
    level := 0;
    sublevel := 0;
    command := #0;
    lastc := #0;
    firstcmd := false;
    if nextcommand then
      pstat := got_pipe
    else
      pstat := none;
    nextcommand := false;
    commanddone := false;
    cstat := cnone;
  end;
end;

Procedure WritePasNorm(s:string);
begin
  writeln(outfile,'  ',s);
end;

Procedure WritePas(s:string);
begin
  WritePasNorm('RIP^.Rip'+s);
end;

Function DoRipChar(c : char): boolean;
type
  PointRec = record
    X : word;
    Y : word;
  end;

  TempType = Array[1..512] of PointRec;
var
  doexit : boolean;
  st5    : string[5];
  tPos   : byte;
  st2    : string[2];
  w1,w2,w3,w4,w5,w6,w7,w8,w9,w10,w11,w12,w13,w14,w15,w16         : word;
  b1,b2,b3,b4,b5                                                 : byte;
  o1,o2                                                          : boolean;
  s1,s2,s3,s4                                                    : string;
  sCtr                                                           : byte;
  TempPoly : TempType;
  TempFPT  : array[1..8] of byte;

  Function MegaB(ch:char) :Boolean;
  begin
    if ch = '1' then
      megab := true
    else
      megab := false;
  end;

  Procedure DoTheButton;
  var
    sctr        : byte;
  begin
    s1 := ''; s2 := ''; s3 := ''; s4 := '';
    for sctr := tpos+13 to bufcount do
      s1 := s1 + rbuffer[sctr];
    case pos('<>',s1) of
      0 : begin
            if s1 <> '' then
            begin
              s2 := s1;
              s1 := '';
            end;
          end;
      1 : delete(s1,1{index},2{count});
      else
      begin
        s2 := copy(s1,1,pos('<>',s1)-1);
        delete(s1,1,pos('<>',s1)+1);
      end;
    end;
    case pos('<>',s1) of
      0 : begin
            if s1 <> '' then
            begin
              s3 := s1;
              s1 := '';
            end;
          end;
      1 : delete(s1,1{index},2{count});
      else
      begin
        s3 := copy(s1,1,pos('<>',s1)-1);
        delete(s1,1,pos('<>',s1)+1);
      end;
    end;
    case pos('<>',s1) of
      0 : begin
            if s1 <> '' then
            begin
              s4 := s1;
              s1 := '';
            end;
          end;
      1 : delete(s1,1{index},2{count});
      else
      begin
        s4 := copy(s1,1,pos('<>',s1)-1);
        delete(s1,1,pos('<>',s1)+1);
      end;
    end;

    w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
    w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
    w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
    w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
    w5 := megatoword(rbuffer[tpos+9]+rbuffer[tpos+10]);
    b1 := megatoword('0'+rbuffer[tpos+11]);
    str1 := 'Button('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+','+i2s(w5)+','+i2s(b1);
    writepas(str1+','''+s2+''','''+s3+''','''+s4+''');');
  end;

  Procedure DoTheButtonStyle;
  begin
    w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
    w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
    w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
    w4 := word(mega4tolong(rbuffer[tpos+7]+rbuffer[tpos+8]+rbuffer[tpos+9]+rbuffer[tpos+10]));
    w5 := megatoword(rbuffer[tpos+11]+rbuffer[tpos+12]);
    w6 := megatoword(rbuffer[tpos+13]+rbuffer[tpos+14]);
    w7 := megatoword(rbuffer[tpos+15]+rbuffer[tpos+16]);
    w8 := megatoword(rbuffer[tpos+17]+rbuffer[tpos+18]);
    w9 := megatoword(rbuffer[tpos+19]+rbuffer[tpos+20]);
    w10 := megatoword(rbuffer[tpos+21]+rbuffer[tpos+22]);
    w11 := megatoword(rbuffer[tpos+23]+rbuffer[tpos+24]);
    w12 := megatoword(rbuffer[tpos+25]+rbuffer[tpos+26]);
    w13 := megatoword(rbuffer[tpos+27]+rbuffer[tpos+28]);
    w14 := megatoword(rbuffer[tpos+29]+rbuffer[tpos+30]);
    str1 := 'ButtonStyle('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+','+i2s(w5)+','+i2s(w6)+','+i2s(w7);
    str1 := str1 + ','+i2s(w8)+','+i2s(w9)+','+i2s(w10)+','+i2s(w11)+','+i2s(w12)+','+i2s(w13)+','+i2s(w14)+');';
    writepas(str1);
  end;

  Procedure DoSetPalette;
  begin
    w1  := megatoword(rbuffer[tpos+1 ]+rbuffer[tpos+2 ]);
    w2  := megatoword(rbuffer[tpos+3 ]+rbuffer[tpos+4 ]);
    w3  := megatoword(rbuffer[tpos+5 ]+rbuffer[tpos+6 ]);
    w4  := megatoword(rbuffer[tpos+7 ]+rbuffer[tpos+8 ]);
    w5  := megatoword(rbuffer[tpos+9 ]+rbuffer[tpos+10]);
    w6  := megatoword(rbuffer[tpos+11]+rbuffer[tpos+12]);
    w7  := megatoword(rbuffer[tpos+13]+rbuffer[tpos+14]);
    w8  := megatoword(rbuffer[tpos+15]+rbuffer[tpos+16]);
    w9  := megatoword(rbuffer[tpos+17]+rbuffer[tpos+18]);
    w10 := megatoword(rbuffer[tpos+19]+rbuffer[tpos+20]);
    w11 := megatoword(rbuffer[tpos+21]+rbuffer[tpos+22]);
    w12 := megatoword(rbuffer[tpos+23]+rbuffer[tpos+24]);
    w13 := megatoword(rbuffer[tpos+25]+rbuffer[tpos+26]);
    w14 := megatoword(rbuffer[tpos+27]+rbuffer[tpos+28]);
    w15 := megatoword(rbuffer[tpos+29]+rbuffer[tpos+30]);
    w16 := megatoword(rbuffer[tpos+31]+rbuffer[tpos+32]);
    str1 := 'SetPalette('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+','+i2s(w5)+','+i2s(w6)+','+i2s(w7)+','+i2s(w8);
    str1 := str1+','+i2s(w9)+','+i2s(w10)+','+i2s(w11)+','+i2s(w12)+','+i2s(w13)+','+i2s(w14)+','+i2s(w15)+','+i2s(w16)+');';
    writepas(str1);
  end;

  Procedure DoFillPattern;
  begin
    tempfpt[1] := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
    tempfpt[2] := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
    tempfpt[3] := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
    tempfpt[4] := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
    tempfpt[5] := megatoword(rbuffer[tpos+9]+rbuffer[tpos+10]);
    tempfpt[6] := megatoword(rbuffer[tpos+11]+rbuffer[tpos+12]);
    tempfpt[7] := megatoword(rbuffer[tpos+13]+rbuffer[tpos+14]);
    tempfpt[8] := megatoword(rbuffer[tpos+15]+rbuffer[tpos+16]);
    w1 := megatoword(rbuffer[tpos+17]+rbuffer[tpos+18]);
    writepasnorm('tFPT[1] := '+i2s(tempfpt[1])+';');
    writepasnorm('tFPT[2] := '+i2s(tempfpt[2])+';');
    writepasnorm('tFPT[3] := '+i2s(tempfpt[3])+';');
    writepasnorm('tFPT[4] := '+i2s(tempfpt[4])+';');
    writepasnorm('tFPT[5] := '+i2s(tempfpt[5])+';');
    writepasnorm('tFPT[6] := '+i2s(tempfpt[6])+';');
    writepasnorm('tFPT[7] := '+i2s(tempfpt[7])+';');
    writepasnorm('tFPT[8] := '+i2s(tempfpt[8])+';');
    writepas('FillPattern(tFPT,'+i2s(w1)+');');
  end;

begin
  doripchar := false;
  doexit := false;
  {if (c = '|') then
    readkey;}
  if (c = #13) then
    firstcmd := true;
  if firstcmd then
    if not (c in [#13,#10,'!']) then
      firstcmd := false;
  if (not (c in [#13,#10])) and ((not (c in ['\','|','!']))) then
  begin
    inc(bufcount);
    rbuffer[bufcount] := c;
  end;

  case pstat of
    None          : begin
      if firstcmd then
      begin
        if c = '!' then
          pstat := got_excl
        else
          exit;
      end
      else
        if c in [#1,#2] then
          pstat := got_excl
        else
          if c = '|' then
            pstat := got_pipe
          else
            exit;
    end;
    Got_Excl      : begin
      if c = '|' then
        pstat := got_pipe
      else
        exit;
    end;
    Got_Pipe      : begin
      case c of
        '1'..'9' : begin
                     level := strtoint(c);
                     pstat := got_level;
                   end;
        #27,'#','*','=','>','@','A'..'Z','a'..'z' :
                   begin
                     level := 0;
                     command := c;
                     pstat := got_command;
                   end;
        else
          exit;
      end;
    end;
    Got_Level     : begin
      case c of
        '0'      : begin
                     sublevel := 10;
                     pstat := got_sublevel;
                   end;
        '1'..'9' : begin
                     sublevel := strtoint(c);
                     pstat := got_sublevel;
                   end;
        #27,'#','*','=','>','@','A'..'Z','a'..'z' :
                   begin
                     command := c;
                     pstat := got_command;
                   end;
        else
          exit;
      end;
    end;
    Got_SubLevel  : begin
      if c in [#27,'#','*','=','>','@','A'..'Z','a'..'z'] then
      begin
        command := c;
        pstat := got_command;
      end
      else
        exit;
    end;
    Got_Command   : begin
      if firstcmd and (cstat <> contline) and (cstat <> pending) then
        doexit := true;
      case cstat of
        pending  : begin
                     if c = #13 then
                       cstat := contline
                     else
                       cstat := escaped;
                   end;
        contline : cstat := cnone;
      end;
      if (c = '\') and (cstat <> escaped) then
        cstat := pending;
      if (c = '|') and (cstat <> escaped) then
        nextcommand := true;
      if (cstat = escaped) and (c in ['\','!','|']) then
      begin
        inc(bufcount);
        rbuffer[bufcount] := c;
        cstat := cnone;
      end;
      st5 := rbuffer[1]+rbuffer[2]+rbuffer[3]+rbuffer[4]+rbuffer[5];
      tpos := pos(command,st5);
      case level of
        0 : begin
          case command of
            'w' : begin {text window}
              if bufcount = (pos('w',st5)+ 10) then
              begin
                b1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                b2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                b3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                b4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                b5 := megatoword('0'            +rbuffer[tpos+10]);
                o1 := megab(rbuffer[tpos+9]);
                writepas('TextWindow('+i2s(b1)+','+i2s(b2)+','+i2s(b3)+','+i2s(b4)+','+torf(o1)+','+i2s(b5)+');');
                exit;
              end;
            end;
            'v' : begin {view port}
              if bufcount = (pos('v',st5)+ 8) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                writepas('ViewPort('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+');');
                exit;
              end;
            end;
            '*' : begin {reset windows}
              writepas('ResetWindows;');
              exit;
            end;
            'e' : begin {erase window}
              writepas('EraseWindow;');
              exit;
            end;
            'E' : begin {erase view}
              writepas('EraseView;');
              exit;
            end;
            'g' : begin {gotoxy}
              if bufcount = (pos('g',st5)+ 4) then
              begin
                b1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                b2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                writepas('GotoXY('+i2s(b1)+','+i2s(b2)+');');
                exit;
              end;
            end;
            'H' : begin {home}
              writepas('Home;');
              exit;
            end;
            '>' : begin {erase eol}
              writepas('EraseEOL;');
              exit;
            end;
            'c' : begin {color}
              if bufcount = (pos('c',st5)+ 2) then
              begin
                b1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                writepas('Color('+i2s(b1)+');');
                exit;
              end;
            end;
            'Q' : begin {set palette}
              if bufcount = (pos('Q',st5)+ 32) then
              begin
                DoSetPalette;
                exit;
              end;
            end;
            'a' : begin {one palette}
              if bufcount = (pos('a',st5)+ 4) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                writepas('OnePalette('+i2s(w1)+','+i2s(w2)+');');
                exit;
              end;
            end;
            'W' : begin {write mode}
              if bufcount = (pos('W',st5)+ 2) then
              begin
                b1  := megatoword(rbuffer[tpos+1 ]+rbuffer[tpos+2 ]);
                writepas('WriteMode('+i2s(b1)+');');
                exit;
              end;
            end;
            'm' : begin {move}
              if bufcount = (pos('m',st5)+ 4) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                writepas('Move('+i2s(w1)+','+i2s(w2)+');');
                exit;
              end;
            end;
            'T' : begin {text}
              if doexit or nextcommand then
              begin
                s1 := '';
                for sctr := tpos+1 to bufcount do
                  s1 := s1 + rbuffer[sctr];
                writepas('Text('''+s1+''');');
                exit;
              end;
            end;
            '@' : begin {textxy}
              if doexit or nextcommand then
              begin
                s1 := '';
                for sctr := tpos+1+4 to bufcount do
                  s1 := s1 +rbuffer[sctr];
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                writepas('TextXY('+i2s(w1)+','+i2s(w2)+','''+s1+''');');
                exit;
              end;
            end;
            'Y' : begin {font style}
              if bufcount = (pos('Y',st5)+ 8) then
              begin
                b1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                b2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                b3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                writepas('FontStyle('+i2s(b1)+','+i2s(b2)+','+i2s(b3)+');');
                exit;
              end;
            end;
            'X' : begin {pixel}
              if bufcount = (pos('X',st5)+ 4) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                writepas('Pixel('+i2s(w1)+','+i2s(w2)+');');
                exit;
              end;
            end;
            'L' : begin {line}
              if bufcount = (pos('L',st5)+ 8) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                writepas('Line('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+');');
                exit;
              end;
            end;
            'R' : begin {rectangle}
              if bufcount = (pos('R',st5)+ 8) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                writepas('Rectangle('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+');');
                exit;
              end;
            end;
            'B' : begin {bar}
              if bufcount = (pos('B',st5)+ 8) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                writepas('Bar('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+');');
                exit;
              end;
            end;
            'C' : begin {circle}
              if bufcount = (pos('C',st5)+ 6) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                writepas('Circle('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+');');
                exit;
              end;
            end;
            'O' : begin {oval}
              if bufcount = (pos('O',st5)+ 12) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                w5 := megatoword(rbuffer[tpos+9]+rbuffer[tpos+10]);
                w6 := megatoword(rbuffer[tpos+11]+rbuffer[tpos+12]);
                writepas('Oval('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+','+i2s(w5)+','+i2s(w6)+');');
                exit;
              end;
            end;
            'o' : begin {filled oval}
              if bufcount = (pos('o',st5)+ 8) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                writepas('FilledOval('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+');');
                exit;
              end;
            end;
            'A' : begin {arc}
              if bufcount = (pos('A',st5)+ 10) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                w5 := megatoword(rbuffer[tpos+9]+rbuffer[tpos+10]);
                writepas('Arc('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+','+i2s(w5)+');');
                exit;
              end;
            end;
            'V' : begin {oval arc}
              if bufcount = (pos('V',st5)+ 12) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                w5 := megatoword(rbuffer[tpos+9]+rbuffer[tpos+10]);
                w6 := megatoword(rbuffer[tpos+11]+rbuffer[tpos+12]);
                writepas('OvalArc('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+','+i2s(w5)+','+i2s(w6)+');');
                exit;
              end;
            end;
            'I' : begin {pie slice}
              if bufcount = (pos('I',st5)+ 10) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                w5 := megatoword(rbuffer[tpos+9]+rbuffer[tpos+10]);
                writepas('PieSlice('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+','+i2s(w5)+');');
                exit;
              end;
            end;
            'i' : begin {oval pie slice}
              if bufcount = (pos('i',st5)+ 12) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                w5 := megatoword(rbuffer[tpos+9]+rbuffer[tpos+10]);
                w6 := megatoword(rbuffer[tpos+11]+rbuffer[tpos+12]);
                writepas('OvalPieSlice('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+','+i2s(w5)+','+i2s(w6)+');');
                exit;
              end;
            end;
            'Z' : begin {bezier}
              if bufcount = (pos('Z',st5)+ 18) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                w5 := megatoword(rbuffer[tpos+9]+rbuffer[tpos+10]);
                w6 := megatoword(rbuffer[tpos+11]+rbuffer[tpos+12]);
                w7 := megatoword(rbuffer[tpos+13]+rbuffer[tpos+14]);
                w8 := megatoword(rbuffer[tpos+15]+rbuffer[tpos+16]);
                w9 := megatoword(rbuffer[tpos+17]+rbuffer[tpos+18]);
                str1 := 'Bezier('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+',';
                writepas(str1+i2s(w5)+','+i2s(w6)+','+i2s(w7)+','+i2s(w8)+','+i2s(w9)+');');
                exit;
              end;
            end;
            'P' : begin {polygon}
              tpos := pos('P',st5);
              if bufcount >= (tpos+ 2) then
              begin
                st2 := rbuffer[tpos+1]+rbuffer[tpos+2];
                if bufcount = (tpos+2+ (4* megatoword(st2))) then
                begin
                  fillchar(temppoly,2048,#0);
                  for sctr := 1 to megatoword(st2) do
                  begin
                    temppoly[sctr].X := megatoword(rbuffer[tpos+3+((sctr-1)*4)]+
                                                   rbuffer[tpos+4+((sctr-1)*4)]);
                    temppoly[sctr].Y := megatoword(rbuffer[tpos+5+((sctr-1)*4)]+
                                                   rbuffer[tpos+6+((sctr-1)*4)]);
                  end;
                  w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                  for sctr := 1 to megatoword(st2) do
                  begin
                    writepasnorm('PPoints['+i2s(sctr)+'].X := '+i2s(temppoly[sctr].X)+';');
                    writepasnorm('PPoints['+i2s(sctr)+'].Y := '+i2s(temppoly[sctr].Y)+';');
                  end;
                  writepas('Polygon('+i2s(w1)+',PPoints);');
                  exit;
                end;
              end;
            end;
            'p' : begin {fill polygon}
              tpos := pos('p',st5);
              if bufcount >= (tpos+ 2) then
              begin
                st2 := rbuffer[tpos+1]+rbuffer[tpos+2];
                if bufcount = (tpos+2+ (4* megatoword(st2))) then
                begin
                  fillchar(temppoly,2048,#0);
                  for sctr := 1 to megatoword(st2) do
                  begin
                    temppoly[sctr].X := megatoword(rbuffer[tpos+3+((sctr-1)*4)]+
                                                   rbuffer[tpos+4+((sctr-1)*4)]);
                    temppoly[sctr].Y := megatoword(rbuffer[tpos+5+((sctr-1)*4)]+
                                                   rbuffer[tpos+6+((sctr-1)*4)]);
                  end;
                  w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                  for sctr := 1 to megatoword(st2) do
                  begin
                    writepasnorm('PPoints['+i2s(sctr)+'].X := '+i2s(temppoly[sctr].X)+';');
                    writepasnorm('PPoints['+i2s(sctr)+'].Y := '+i2s(temppoly[sctr].Y)+';');
                  end;
                  writepas('FillPoly('+i2s(w1)+',PPoints);');
                  exit;
                end;
              end;
            end;
            'l' : begin {polyline}
              tpos := pos('l',st5);
              if bufcount >= (tpos+ 2) then
              begin
                st2 := rbuffer[tpos+1]+rbuffer[tpos+2];
                if bufcount = (tpos+2+ (4* megatoword(st2))) then
                begin
                  fillchar(temppoly,2048,#0);
                  for sctr := 1 to megatoword(st2) do
                  begin
                    temppoly[sctr].X := megatoword(rbuffer[tpos+3+((sctr-1)*4)]+
                                                   rbuffer[tpos+4+((sctr-1)*4)]);
                    temppoly[sctr].Y := megatoword(rbuffer[tpos+5+((sctr-1)*4)]+
                                                   rbuffer[tpos+6+((sctr-1)*4)]);
                  end;
                  w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                  for sctr := 1 to megatoword(st2) do
                  begin
                    writepasnorm('PPoints['+i2s(sctr)+'].X := '+i2s(temppoly[sctr].X)+';');
                    writepasnorm('PPoints['+i2s(sctr)+'].Y := '+i2s(temppoly[sctr].Y)+';');
                  end;
                  writepas('PolyLine('+i2s(w1)+',PPoints);');
                  exit;
                end;
              end;
            end;
            'F' : begin {fill}
              if bufcount = (pos('F',st5)+ 6) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                writepas('Fill('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+');');
                exit;
              end;
            end;
            '=' : begin {line style}
              if bufcount = (pos('=',st5)+ 8) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := word(mega4tolong(rbuffer[tpos+3]+rbuffer[tpos+4]
                                      +rbuffer[tpos+5]+rbuffer[tpos+6]));
                w3 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                writepas('LineStyle('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+');');
                exit;
              end;
            end;
            'S' : begin {fill style}
              if bufcount = (pos('S',st5)+ 4) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                writepas('FillStyle('+i2s(w1)+','+i2s(w2)+');');
                exit;
              end;
            end;
            's' : begin {fill pattern}
              if bufcount = (pos('s',st5)+ 18) then
              begin
                DoFillPattern;
                exit;
              end;
            end;
            '#' : begin {no more}
              writepas('NoMore;');
            end;
            else {case command of}
              exit;
          end; {case}
        end;
        1 : begin
          case command of
            'M' : begin {mouse}
              if doexit or nextcommand then
              begin
                s1 := '';
                for sctr := tpos+18 to bufcount do
                  s1 := s1 + rbuffer[sctr];
                w1 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w2 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w3 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                w4 := megatoword(rbuffer[tpos+9]+rbuffer[tpos+10]);
                o1 := megab(rbuffer[tpos+11]);
                o2 := megab(rbuffer[tpos+12]);
                writepas('Mouse('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+','+torf(o1)+','+torf(o2)+','''+s1+''');');
                exit;
              end;
            end;
            'K' : begin {kill mouse fields}
              writepas('KillMouseFields;');
              exit;
            end;
            'T' : begin {begin text}
              if bufcount = (pos('T',st5)+ 10) then
              begin
                exit;
              end;
            end;
            't' : begin {region text}
              if doexit or nextcommand then
              begin
                exit;
              end;
            end;
            'E' : begin {end text}
              exit;
            end;
            'C' : begin {get image}
              if bufcount = (pos('C',st5)+ 9) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                w4 := megatoword(rbuffer[tpos+7]+rbuffer[tpos+8]);
                writepas('GetImage('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+i2s(w4)+');');
                exit;
              end;
            end;
            'P' : begin {put image}
              if bufcount = (pos('P',st5)+ 7) then
              begin
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                writepas('PutImage('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+');');
                exit;
              end;
            end;
            'W' : begin {write icon}
              if doexit or nextcommand then
              begin
                s1 := '';
                for sctr := tpos+2 to bufcount do
                  s1 := s1 + rbuffer[sctr];
                writepas('WriteIcon('''+s1+''');');
                exit;
              end;
            end;
            'I' : begin {load icon}
              if doexit or nextcommand then
              begin
                s1 := '';
                for sctr := tpos+10 to bufcount do
                  s1 := s1 + rbuffer[sctr];
                w1 := megatoword(rbuffer[tpos+1]+rbuffer[tpos+2]);
                w2 := megatoword(rbuffer[tpos+3]+rbuffer[tpos+4]);
                w3 := megatoword(rbuffer[tpos+5]+rbuffer[tpos+6]);
                o1 := megab(rbuffer[tpos+7]);
                writepas('LoadIcon('+i2s(w1)+','+i2s(w2)+','+i2s(w3)+','+torf(o1)+','''+s1+''');');
                exit;
              end;
            end;
            'B' : begin {button style}
              if bufcount = (pos('B',st5)+ 36) then
              begin
                DoTheButtonStyle;
                exit;
              end;
            end;
            'U' : begin {button}
              if doexit or nextcommand then
              begin
                DoTheButton;
                exit;
              end;
            end;
            'D' : begin {define}
              if doexit or nextcommand then
              begin
                exit;
              end;
            end;
            #27 : begin {query}
              if doexit or nextcommand then
              begin
                exit;
              end;
            end;
            'G' : begin {copy region}
              if bufcount = (pos('G',st5)+ 12) then
              begin
                exit;
              end;
            end;
            'R' : begin {read scene}
              if doexit or nextcommand then
              begin
                exit;
              end;
            end;
            'F' : begin {file query}
              if doexit or nextcommand then
              begin
                exit;
              end;
            end;
            else {case command of}
              exit;
          end; {case}
        end;
        9 : begin
          case command of
            #27 : begin {enter block mode}
              if doexit or nextcommand then
              begin
                exit;
              end;
            end;
            else {case}
              exit;
          end; {case command of}
        end;
        else {case level of}
          exit;
      end; {case level of}
      if doexit then
        exit;
    end; {got_command}
  end; {case}
  doripchar := true;
end;

Function Exists(FN : string) : boolean;
var
  F     : searchrec;
begin
  findfirst (FN,AnyFile,F);
  Exists := DosError = 0;
end;

Procedure InitOutFile;
begin
  if exists(paramstr(2)) then
  begin
    writeln('  Error: ',paramstr(2),' already exists.');
    writeln('  Exiting...');
    halt;
  end;
  assign(outfile,paramstr(2));
  {$I-}
  rewrite(outfile);
  {$I+}
  if ioresult <> 0 then
  begin
    writeln('  Error: Creating ',paramstr(2));
    writeln('  Exiting...');
    halt;
  end;
  writeln(outfile,'{This file created by RIP2PAS}');
  writeln(outfile,'{May require editing before use.}');
  writeln(outfile);
  writeln(outfile,'Procedure Display',paramstr(1),';');
  writeln(outfile,'Type');
  writeln(outfile,'  PointRec = record');
  writeln(outfile,'    X : word;');
  writeln(outfile,'    Y : word;');
  writeln(outfile,'  end;');
  writeln(outfile);
  writeln(outfile,'  TempType = Array[1..512] of PointRec;');
  writeln(outfile);
  writeln(outfile,'Var');
  writeln(outfile,'  PPoints : TempType;');
  writeln(outfile,'  tFPT    : Array[1..8] of Byte;');
  writeln(outfile);
  writeln(outfile,'Begin');
end;

Begin
  Writeln('RIP2PAS Converts .RIP files to RIPlink Pascal source.');
  if paramcount < 2 then
  begin
    writeln('');
    writeln('Usage: RIP2PAS <input file (*.RIP)> <output file>');
    writeln('No wildcards allowed.');
    writeln;
    halt;
  end;
  InitOutFile;
  if not DisplayRipFile(paramstr(1)) then
  begin
    writeln('  Error: Opening ',paramstr(1));
    writeln('  Exiting...');
    writeln(outfile,'{Abnormal termination}');
    close(outfile);
    halt;
  end;
  writeln(outfile,'end;');
  close(outfile);
  writeln('  ',paramstr(2),' successfully written.');
End.
