{****************************************************************************

                        FPKPascal Runtime-Library
                          Copyright (c) 1994 by 
                             Florian Klmpfl

 ****************************************************************************}

{
  History:
  30.3.1994: Version 0.5
             Unit ist elementar implementiert
             (INT $33 Funktionen 0-3)
  2.4.1995:  Version 0.55
             - mousereset in eine function umgewandelt
             - mousesetpos implementiert
             - mouserelx, mouserely implementiert
             - mousex und mousey erweitern nun ihre Resultate
               immer auf 32 Bit
  14.4.1995: Version 0.56
             - mouserelx und mouserely mssen ihre
               Resultate natrlich Vorzeichen erweitert auf
               32 Bit kopieren
            - mouserelx und mouserely zu einer Funktion zusammen-
              gefat, da sonst viele Bewegungen verloren gehen
}

{$E-}

unit mouse;

  interface
  
    function mousereset : word;
    procedure mouseon;
    procedure mouseoff;
    function mousex : longint;
    function mousey : longint;
    procedure mouserel(var x,y : longint);
    function mousebuttons : longint;
    procedure mousesetpos(x,y : longint);
  
  implementation
  
    function mousereset : word;

      begin
         asm
            movw $0,%ax
            pushl %ebp
            int	 $0x33
            popl %ebp
            leave
            ret
         end;
      end;

   procedure mouseon;

     begin
         asm
            movw $1,%ax
            pushl %ebp
            int	 $0x33
            popl %ebp
         end;
     end;

   procedure mouseoff;

     begin
        asm
           movw $2,%ax
           pushl %ebp
           int	 $0x33
           popl %ebp
        end;
     end;
     
   function mousex : longint;

     begin
        asm
           movw $3,%ax
           pushl %ebp
           int	 $0x33
           popl %ebp
           movzwl %cx,%eax
           leave
           ret
        end;
     end;
     
   function mousey : longint;

     begin
        asm
           movw $3,%ax
           pushl %ebp
           int	 $0x33
           popl %ebp
           movzwl %dx,%eax
           leave
           ret
        end;
     end;

   function mousebuttons : longint;

     begin
        asm
           movw $3,%ax
           pushl %ebp
           int	 $0x33
           popl %ebp
           movl %ebx,%eax
           andl $7,%eax
           leave
           ret
        end;
     end;
     
   procedure mousesetpos(x,y : longint);
   
     begin
        asm
           movw $4,%ax
           movl 8(%ebp),%ecx
           movl 12(%ebp),%edx
           pushl %ebp
           int	 $0x33
           popl %ebp
        end;
     end;
     
   procedure mouserel(var x,y : longint);

     begin
        asm
           movw $11,%ax
           pushl %ebp
           int	 $0x33
           popl %ebp
           movswl %cx,%ecx
           movl 8(%ebp),%eax
           movl %ecx,(%eax)
           movswl %dx,%edx
           movl 12(%ebp),%eax
           movl %edx,(%eax)
        end;
     end;
     
end.
