unit mouse;

interface

{M_Image: 0: No change
          1: OR bit
          2: AND bit
          3: AND bit only if bit is already set in font we're changing}
const m_image: array[0..8*16-1] of byte=(
      2,2,0,0,0,0,0,0,
      2,1,2,0,0,0,0,0,
      2,1,1,2,0,0,0,0,
      2,1,1,1,2,0,0,0,
      2,1,1,1,1,2,0,0,
      2,1,1,1,1,1,2,0,
      2,1,3,1,1,3,2,0,
      3,3,0,2,1,3,0,0,
      0,0,0,3,1,3,0,0,
      0,0,0,3,1,1,3,0,
      0,0,0,3,1,1,3,0,
      0,0,0,0,3,3,0,0,
      0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0);

      maxlines: word=400; {Max scan lines, in normal text mode it's 400}
      mouse_irq=4; {Mouse IRQ. In COM port 1, it's 4 and in COM port 2 it's 3}

var mx,my: integer; {Mouse X and Y positions}
    but1,but2: boolean; {Button statuses}

function m_detect: boolean;
{Returns true, if mouse was detected}
procedure m_init(chara: byte; segm,offs: word);
{Init mouse driver, 'chara' is the first of the all four character, in which
 the mouse cursor is. Segm and Offs are the segment and offset to fonts.
 Note that 'chara' should be in range 192-220, because fonts 192-223 are
 'special' fonts. The bit 0 is copied to the 9th bit in font. On other fonts
 the 9th bit is set to zero. Look the example program for more info about
 font addresses}
procedure m_deinit;
{Deinitialize mouse driver. But...
  - It doesn't remove the cursor from the screen
  - It doesn't set the original fonts to changed ones}

procedure m_show;
{Show mouse cursor}
procedure m_hide;
{Hide mouse cursor. Note that mouse still moves!}

implementation uses dos;

var bytenum: byte; {Bytes recieved from mouse, mouse sends 3 bytes always}
    combytes: array[0..2] of byte; {Bytes recieved from mouse}
    omx,omy: integer; {Old X and Y positions of mouse}
    old_handler: pointer; {Old handler address}
    oldbyte: array[0..3] of byte; {Old fonts, which mouse cursor changes}
    cha: array[0..63] of byte; {Temp fonts area}
    hiding: boolean; {If this is set, mouse cursor doesn't move}
    dbyte: byte; {First font where mouse cursor is put}
    tseg,tofs: word; {Segment and offset to first normal fonts}

procedure m_handler; interrupt; {Mouse handler}
var dx,dy: integer;
    inbyte: byte;
    x,y: byte;

label jump;

begin
  inbyte:=Port[$3f8]; {Recieve a byte from mouse}
  if (inbyte and 64)=64 then bytenum:=0;
  combytes[bytenum]:=inbyte; {Save the byte}
  inc(bytenum);
  if bytenum=3 then {If all 3 bytes are recieved from mouse, 'do the mouse stuff'}
    begin
      dx:=(combytes[0] and 3) shl 6+combytes[1]; {Get the increment to the mouse X position}
      dy:=(combytes[0] and 12) shl 4+combytes[2]; {Get the increment to the mouse Y position}
      if dx>=128 then dec(dx,256);
      if dy>=128 then dec(dy,256);
      if (dx<-15) or (dx>15) then inc(dx,dx); {Double the moving speed, so}
      if (dy<-15) or (dy>15) then inc(dy,dy); {you can move the cursor faster.
                                         You can also cut these lines off too}
      inc(mx,dx); {Update the mouse cursor position}
      inc(my,dy);
      if mx<0 then mx:=0; {Check the cursor position, so the cursor doesn't}
      if my<0 then my:=0; {disappear from screen}
      if mx>639 then mx:=639;
      if my>maxlines-1 then my:=maxlines-1;
      but1:=(combytes[0] and 32) <> 0; {Get the button statuses}
      but2:=(combytes[0] and 16) <> 0;

      if hiding then goto jump; {Jump to end if mouse is hiding}
      if (omx shr 3<>mx shr 3) or (omy shr 4<>my shr 4) then {If mouse position}
        begin {is changed, draw the cursor again}
          mem[$b800:(omx shr 3) shl 1+(omy shr 4)*160]:=oldbyte[0]; {Draw the old fonts}
          mem[$b800:(omx shr 3) shl 1+(omy shr 4+1)*160]:=oldbyte[1];
          mem[$b800:(omx shr 3+1) shl 1+(omy shr 4)*160]:=oldbyte[2];
          mem[$b800:(omx shr 3+1) shl 1+(omy shr 4+1)*160]:=oldbyte[3];
          oldbyte[0]:=mem[$b800:(mx shr 3) shl 1+(my shr 4)*160]; {Get the old fonts}
          oldbyte[1]:=mem[$b800:(mx shr 3) shl 1+(my shr 4+1)*160];
          oldbyte[2]:=mem[$b800:(mx shr 3+1) shl 1+(my shr 4)*160];
          oldbyte[3]:=mem[$b800:(mx shr 3+1) shl 1+(my shr 4+1)*160];
        end;
      for x:=0 to 15 do {Get the old patterns from the four fonts}
        begin
          cha[x]:=mem[tseg:tofs+x+(oldbyte[0] shl 4)];
          cha[x+16]:=mem[tseg:tofs+x+(oldbyte[1] shl 4)];
          cha[x+32]:=mem[tseg:tofs+x+(oldbyte[2] shl 4)];
          cha[x+48]:=mem[tseg:tofs+x+(oldbyte[3] shl 4)];
        end;
      for y:=0 to 15 do {Put the mouse cursor to fonts}
        for x:=0 to 7 do
          if m_image[x+y shl 3]>0 then
            begin
              if m_image[x+y shl 3]=3 then
                begin
                  cha[y+my and 15]:=cha[y+my and 15] and not($80 shr (x+mx and 7));
                  cha[y+my and 15+32]:=cha[y+my and 15+32] and not($80 shr (x-8+mx and 7));
                end else
                begin
                  if (cha[y+my and 15] and ($80 shr (x+mx and 7))>0) and (m_image[x+y shl 3]=2) then
                    cha[y+my and 15]:=cha[y+my and 15] and not($80 shr (x+mx and 7)) else
                      cha[y+my and 15]:=cha[y+my and 15] or ($80 shr (x+mx and 7));
                  if (cha[y+my and 15+32] and ($80 shr (x-8+mx and 7))>0) and (m_image[x+y shl 3]=2) then
                    cha[y+my and 15+32]:=cha[y+my and 15+32] and not ($80 shr (x-8+mx and 7)) else
                      cha[y+my and 15+32]:=cha[y+my and 15+32]
                        or ($80 shr (x-8+mx and 7));
                end;
            end;
      asm
        mov     dx,3dah {Wait for vertical retrace}
@v1:    in      al,dx
        test    al,8
        jz      @v1
@v2:    in      al,dx
        test    al,8
        jnz     @v2

        mov     ax,1100h {Change the four fonts}
        mov     bx,1000h
        mov     cx,4
        xor     dh,dh
        mov     dl,dbyte
        push    bp
        push    ds
        pop     es
        mov     bp,offset cha
        int     10h
        pop     bp
      end;
      if (omx shr 3<>mx shr 3) or (omy shr 4<>my shr 4) then {Draw the mouse}
        begin {cursor fonts to screen}
          mem[$b800:(mx shr 3) shl 1+(my shr 4)*160]:=dbyte;
          mem[$b800:(mx shr 3) shl 1+(my shr 4+1)*160]:=dbyte+1;
          if mx+8<640 then
            begin
              mem[$b800:(mx shr 3+1) shl 1+(my shr 4)*160]:=dbyte+2;
              mem[$b800:(mx shr 3+1) shl 1+(my shr 4+1)*160]:=dbyte+3;
            end;
        end;
      bytenum:=0; {Set mouse bytes to zero}
      omx:=mx; {Save X and Y positions to OMX and OMY}
      omy:=my;
jump:
    end;

  Port[$20]:=$20; {Send EOI command to IRQ controller}
end;

procedure m_show;
var x,y: byte;

begin
  asm cli end; {Disable interrupts, just for sure}
  oldbyte[0]:=mem[$b800:(mx shr 3) shl 1+(my shr 4)*160]; {Get old fonts}
  oldbyte[1]:=mem[$b800:(mx shr 3) shl 1+(my shr 4+1)*160];
  oldbyte[2]:=mem[$b800:(mx shr 3+1) shl 1+(my shr 4)*160];
  oldbyte[3]:=mem[$b800:(mx shr 3+1) shl 1+(my shr 4+1)*160];
  for x:=0 to 15 do {Get the old patterns from the four fonts}
    begin
      cha[x]:=mem[tseg:tofs+x+(oldbyte[0] shl 4)];
      cha[x+16]:=mem[tseg:tofs+x+(oldbyte[1] shl 4)];
      cha[x+32]:=mem[tseg:tofs+x+(oldbyte[2] shl 4)];
      cha[x+48]:=mem[tseg:tofs+x+(oldbyte[3] shl 4)];
    end;
  for y:=0 to 15 do {Put the mouse cursor to fonts}
    for x:=0 to 7 do
      if m_image[x+y shl 3]>0 then
        begin
          if m_image[x+y shl 3]=3 then
            begin
              cha[y+my and 15]:=cha[y+my and 15] and not($80 shr (x+mx and 7));
              cha[y+my and 15+32]:=cha[y+my and 15+32] and not($80 shr (x-8+mx and 7));
            end else
            begin
              if (cha[y+my and 15] and ($80 shr (x+mx and 7))>0) and (m_image[x+y shl 3]=2) then
                cha[y+my and 15]:=cha[y+my and 15] and not($80 shr (x+mx and 7)) else
                  cha[y+my and 15]:=cha[y+my and 15] or ($80 shr (x+mx and 7));
              if (cha[y+my and 15+32] and ($80 shr (x-8+mx and 7))>0) and (m_image[x+y shl 3]=2) then
                cha[y+my and 15+32]:=cha[y+my and 15+32] and not ($80 shr (x-8+mx and 7)) else
                  cha[y+my and 15+32]:=cha[y+my and 15+32]
                    or ($80 shr (x-8+mx and 7));
            end;
        end;
  asm
        mov     dx,3dah {Wait for vertical retrace}
@v1:    in      al,dx
        test    al,8
        jz      @v1
@v2:    in      al,dx
        test    al,8
        jnz     @v2

        mov     ax,1100h {Change the four fonts}
        mov     bx,1000h
        mov     cx,4
        xor     dh,dh
        mov     dl,dbyte
        push    bp
        push    ds
        pop     es
        mov     bp,offset cha
        int     10h
        pop     bp
  end;
  mem[$b800:(mx shr 3) shl 1+(my shr 4)*160]:=dbyte; {Draw the mouse fonts}
  mem[$b800:(mx shr 3) shl 1+(my shr 4+1)*160]:=dbyte+1;
  if mx+8<640 then
    begin
      mem[$b800:(mx shr 3+1) shl 1+(my shr 4)*160]:=dbyte+2;
      mem[$b800:(mx shr 3+1) shl 1+(my shr 4+1)*160]:=dbyte+3;
    end;
  omx:=mx;
  omy:=my;
  hiding:=false;
  asm sti end;
end;

procedure m_hide;
begin
  hiding:=true;
  mem[$b800:(omx shr 3) shl 1+(omy shr 4)*160]:=oldbyte[0]; {Draw the old fonts}
  mem[$b800:(omx shr 3) shl 1+(omy shr 4+1)*160]:=oldbyte[1];
  mem[$b800:(omx shr 3+1) shl 1+(omy shr 4)*160]:=oldbyte[2];
  mem[$b800:(omx shr 3+1) shl 1+(omy shr 4+1)*160]:=oldbyte[3];
end;

function m_detect: boolean; assembler;
asm
        xor     ax,ax {If this returns $ffff, old mouse driver exists}
        int     33h
        mov     bl,1
        cmp     ax,0ffffh
        je      @ok
        dec     bl
@ok:    mov     al,bl
end;

procedure m_init(chara: byte; segm,offs: word);
begin
  tseg:=segm; {Set few variables}
  tofs:=offs;
  dbyte:=chara;
  bytenum:=0; {Reset variables}
  mx:=0;
  my:=0;
  omx:=$7fff;
  omy:=$7fff;

  but1:=false;
  but2:=false;

  hiding:=true;

  getintvec(8+mouse_irq, old_handler); {Get old mouse handler address}
  setintvec(8+mouse_irq, @m_handler); {Set new mouse handler}
end;

procedure m_deinit;
begin
  setintvec(8+mouse_irq, old_handler); {Set old mouse handler}
end;

end.