{==========================================================================
  DEMO2.PAS - GV-SOUND(tm) Demo #2 - 4 sample playback on free channel.
  Copyright (c) 1994,95 Jarrod Davis Software Co.

  This demo will play up to 4 channels at the same time. Each time keys
  1-4 is pressed the sample starts playing on a free channel. If a sample is
  already playing, that sample will start playing again, but on a new free
  channel.
===========================================================================}
program Demo2;
uses
  Crt, GvSound;
var
  Finished: Boolean;
  Sample  : array[1..4] of TSample;

procedure LoadSamples;
begin
  Sample[1].Init('aha.wav');
  Sample[2].Init('thunder.raw');
  Sample[3].Init('eagle.raw');
  Sample[4].Init('boom.wav');
end;

procedure FreeSamples;
var
  i: Byte;
begin
  for i := 1 to 4 do
    Sample[i].Done;
end;

procedure PlaySamples;
var
  K: Char;
begin
  K := ReadKey;
  case UpCase(K) of
    '1': Sample[1].Play(False);
    '2': Sample[2].Play(False);
    '3': Sample[3].Play(False);
    '4': Sample[4].Play(False);
    'Q': Finished := True;
  end;
end;

begin

  WriteLn('GV-SOUND(tm) Demo #2 - 4 Sample playback');
  WriteLn('Copyright (c) 1994,95 Jarrod Davis Software Co.');
  WriteLn;
  WriteLn('  1 - Audio Hardware Activated');
  WriteLn('  2 - Thunder');
  WriteLn('  3 - Eagle');
  WriteLn('  4 - Boom');
  WriteLn('  Q - Quit');
  WriteLn;
  Write('Press 1-4, or ''Q'' to Quit...');

  gvSetDigitalVolume(8);
  LoadSamples;
  Finished := False;
  repeat
    if KeyPressed then
      PlaySamples;
  until Finished;
end.
