{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
{                     MS-DOS DATE/TIME/TIMER ROUTINES

                           Capt Al "Prof" Morrison
                         Arkansas Air National Guard
                               AV  962-8208

  IMPORTANT NOTES:
    1.  In order to use timers you must call "init_timer" at the beginning
        of your program and "quit_timer" when finished.  Failure to do so
        will corrupt your MS-DOS and almost certainly result in a system
        crash (or worse)!

    2.  When you call "set_timer" a timer is allocated for your use.  You
        MUST release it by calling "release_timer".  You cannot retain use
        of it over several uses.  You must "set_timer" and "release_timer"
        each time.  Failure to do so will exhaust all the available timers
        in short order.
                                                                            }
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
type
  str2    = string[2];
  str4    = string[4];

  tcb              = record
                       inuse      : boolean;
                       count_down : integer
                     end;
  registers        = record case boolean of
                       true  : (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags : integer);
                       false : (AL,AH,BL,BH,CL,CH,DL,DH : byte)
                     end;
  jump_instruction = record
                       far_jump : byte;
                       offset   : integer;
                       segment  : integer
                     end;

var
  regpack:          registers;

const
  ten_milli_seconds= 1;
  seconds          = 100;
  minutes          = 6000;
  numtimers        = 5;

  DS_save          : integer = 0;
  ticks            : integer = 0;

  timer            : array[1..numtimers] of tcb = (
                     (inuse : false;
                      count_down : 0),
                     (inuse : false;
                      count_down : 0),
                     (inuse : false;
                      count_down : 0),
                     (inuse : false;
                      count_down : 0),
                     (inuse : false;
                      count_down : 0));

{ ATTENTION:  The following record is defined as a typed constant to force
              it to be in the code segment (accessable via the CS register).
              Do not move or otherwise mess with it unless you really know
              what you're doing! }

  timer_chain      : jump_instruction =
                       (far_jump : $EA;
                        offset   : $0000;
                        segment  : $0000); { Tricky, huh?  -- Prof }
{===========================================================================}
procedure tick(ticks : integer);

var
  i : integer;

begin
  for i := 1 to numtimers do
    with timer[i] do
      if count_down>0
        then count_down := count_down - ticks
end;
{===========================================================================}
procedure timer_int;

begin
  inline(
    $FB/              { STI              ; Interrupts on                    }
    $1E/              { PUSH DS          ; Save all the registers           }
    $50/              { PUSH AX                                             }
    $53/              { PUSH BX                                             }
    $51/              { PUSH CX                                             }
    $52/              { PUSH DX                                             }
    $57/              { PUSH DI                                             }
    $56/              { PUSH SI                                             }
    $06/              { PUSH ES                                             }

    $2E/              { CS:                                                 }
    $8E/$1E/>DS_save/ { MOV DS,[DS_save] ; Restore Turbo's DS register      }

    $50/              { PUSH AX          ; Number of ticks since last int   }
    $E8/>tick-*-2/    { CALL tick        ; Call timer routine               }

    $07/              { POP ES           ; Restore registers                }
    $5E/              { POP SI                                              }
    $5F/              { POP DI                                              }
    $5A/              { POP DX                                              }
    $59/              { POP CX                                              }
    $5B/              { POP BX                                              }
    $58/              { POP AX                                              }
    $1F/              { POP DS                                              }
    $8B/$E5/          { MOV SP,BP        ; (Saved by Turbo on entry into    }
    $5D/              { POP BP           ;  this procedure)                 }
    $E9/>timer_chain-*-2) { JMP timer_chain ; Jump to next timer ISR        }
end;
{===========================================================================}
procedure init_timer;

var
  regs : registers;
  i    : integer;

begin
  for i := 1 to numtimers do
    timer[i].inuse := false;
  DS_save := Dseg;
  with regs do begin
    ah := $35;            { Get Interrupt Vector function }
    al := $51;            { Interrupt 51H (timer)         }
    intr($21,regs);       { Function Request Interrupt    }
    timer_chain.segment := es; {Save in JMP instruction   }
    timer_chain.offset  := bx;
    ah := $25;            { Set Interrupt Vector function }
    al := $51;            { Interrupt 51H (timer)         }
    dx := ofs(timer_int); { DS:DX = Interrupt adrs        }
    ds := cseg;
    intr($21,regs)        { Function Request Interrupt    }
  end
end;
{===========================================================================}
procedure quit_timer;

var
  regs : registers;

begin
  with regs do begin
    ah := $25;            { Set Interrupt Vector function }
    al := $51;            { Interrupt 51H (timer)         }
    dx := timer_chain.offset; { Retore from JMP instruction   }
    ds := timer_chain.segment;
    intr($21,regs)        { Function Request Interrupt    }
  end
end;
{===========================================================================}
function timeout(n : integer) : boolean;

var
  i : integer;

begin
  with timer[n] do
    if count_down<=0
      then timeout := true
      else timeout := false
end;
{===========================================================================}
procedure set_timer(var n        : integer;
                        howlong  : integer;
                    var ok       : boolean);

var
  i : integer;

begin
  n := 0;
  i := 1;
  repeat
    with timer[i] do
      if not inuse
        then begin
          inuse := true;
          n := i
        end
        else i := i + 1
  until (n<>0) or (i>numtimers);
  ok := (n<>0);
  if ok
    then timer[n].count_down := howlong
end;
{===========================================================================}
procedure release_timer(n : integer);

begin
  timer[n].inuse := false
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure date(var dt : dt_block_type);

begin
  with regpack do begin
    ah := $2a;
    intr($21,regpack);
    dt.yy := cx;
    dt.mo := dx shr 8;
    dt.dd := dx and 255;
  end;
  dt.yy := dt.yy - 1900
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure time(var dt : dt_block_type);

begin
  with regpack do begin
    ah := $2c;
    intr($21,regpack);
    dt.hh := cx shr 8;
    dt.mi := cx and 255;
    dt.ss := dx shr 8
  end
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure datetime(var dt : dt_block_type);

begin
  date(dt);
  time(dt)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure setdate(dt : dt_block_type);

begin
  with regpack do begin
    ah := $2b;
    cx := dt.yy + 1900;
    dx := (dt.mo shl 8) + dt.dd;
    intr($21,regpack)
  end
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure settime(dt : dt_block_type);

begin
  with regpack do begin
    ah := $2d;
    cx := (dt.hh shl 8) + dt.mi;
    dx := dt.ss shl 8;
    intr($21,regpack);
  end
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure InputStr(var S     : Str2);

var
  L, P : Integer;
  Ch : Char;

begin
  S := '';
  L := 2;
  Write('__',^H,^H);
  P := 0;
  repeat
    Read(Kbd,Ch);
    case Ch of
      ' ','0'..'9': if P < L then
                    begin
                      if Ch=' '
                        then Ch:='0';
                      S := S + Ch;
                      P := P + 1;
                      Write(Ch);
                    end
                    else Write(^G);
        ^H,#127   : if P > 0 then
                    begin
                      Delete(S,P,1);
                      Write(^H,'_',^H);
                      P := P - 1;
                    end
                    else Write(^G);
      else
        Write(^G);
    end;  {of case}
  until P=L
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure getstr2(var fld : integer;
                  lwr,
                  upr     : integer);

var
  strfld : string[2];
  good   : boolean;
  result : integer;

begin
  repeat
    inputstr(strfld);
    val(strfld,fld,result);
    good := (result=0) and (fld>=lwr) and (fld<=upr);
    if not good
      then begin
        Write(^G);
        write(^H,^H)
      end
  until good
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure getdate(var dt : dt_block_type);

begin
  write('__/__/__',^H^H^H^H^H^H^H^H);
  getstr2(dt.mo,01,12);
  write('/');
  getstr2(dt.dd,01,31);
  write('/');
  getstr2(dt.yy,86,99);
  writeln
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure gettime(var dt : dt_block_type);

begin
  write('__:__:__',^H^H^H^H^H^H^H^H);
  getstr2(dt.hh,00,23);
  write(':');
  getstr2(dt.mi,00,59);
  write(':');
  getstr2(dt.ss,00,59);
  writeln
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure showdate(dt : dt_block_type);

begin
  write(makestr(dt.mo,2));
  write('/');
  write(makestr(dt.dd,2));
  write('/');
  write(makestr(dt.yy,2));
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure showtime(dt : dt_block_type);

begin
  write(makestr(dt.hh,2));
  write(':');
  write(makestr(dt.mi,2));
  write(':');
  write(makestr(dt.ss,2));
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure verifydt;

var
  dtb        : dt_block_type;
  i,
  n,
  beeps      : integer;
  yorn       : char;
  which      : string[4];
  ok         : boolean;

begin
  which := 'date';
  for i := 1 to 2 do begin
    date(dtb);
    time(dtb);
    writeln;
    write('I show the current ',which,' to be ');
    if which='date'
      then showdate(dtb)
      else showtime(dtb);
    write('  Is that correct? (Y/N) ');
    reset(kbd);
    beeps := 0;
    repeat
      Write(^G);
      set_timer(n,3*seconds,ok);
      repeat
      until keypressed or timeout(n);
      release_timer(n);
      beeps := succ(beeps)
    until keypressed or (beeps=10);
    if keypressed
      then begin
        read(kbd,yorn);
        writeln(yorn);
        reset(kbd)
      end
      else yorn := 'Y';
    if not (yorn in ['Y','y',^M])
      then begin
        write('Enter the correct ',which,' ');
        if which='date'
          then begin
            write('(MM/DD/YY) : ');
            getdate(dtb);
            setdate(dtb)
          end
          else begin
            write('(HH:MM:SS) : ');
            gettime(dtb);
            settime(dtb)
          end
      end;
    which := 'time'
  end;
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function julian(dt : dt_block_type) : integer;

var
   result : integer;

const
     days : array[1..12] of integer = (0, 31, 59, 90, 120, 151, 181, 212,
                                        243, 273, 304, 334);

begin
  result := days[dt.mo] + dt.dd;
  if (dt.mo>2) and ((dt.yy mod 4)=0)
    then result := result + 1;
  julian := result
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function dt_str(dt : dt_block_type) : str12;

begin
  dt_str := makestr(dt.yy,2) +
            makestr(dt.mo,2) +
            makestr(dt.dd,2) +
            makestr(dt.hh,2) +
            makestr(dt.mi,2) +
            makestr(dt.ss,2)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
