{  E_HMQUE.INC -- Host index & queue routines. }

var
  bin_index_entry : index_type;

function bin_get_key;

begin
  {For debugging purposes:
    writeln('Getting record ',bin_rn);}
  seek(unit_ndx_file,bin_rn);
  read(unit_ndx_file,bin_index_entry);
  bin_get_key := addr(bin_index_entry.unit)
end;

function bin_less_than;

var
  target,
  current_key : ^key_type;

begin
  setptr(target,bin_target);
  setptr(current_key,bin_current);
  { For debugging purposes:
    writeln('Is ',target^,' less than ',current_key^); }
  bin_less_than := target^<current_key^
end;

function bin_equal_to;

var
  target,
  current_key : ^key_type;

begin
  setptr(target,bin_target);
  setptr(current_key,bin_current);
  { For debugging purposes:
    writeln('Is ',target^,' equal to ',current_key^); }
  bin_equal_to := target^=current_key^
end;

function index_rec_no(unit : unit_type) : integer;

begin
  index_rec_no := bin_search(1,filesize(unit_ndx_file)-1,unit)
end;

procedure index_delete(index_rn   : integer;
                       index_item : index_type);

var
  last_rn,
  rn         : integer;
  index_rec  : index_type;

begin
  index_rn := abs(index_rn);
  seek(unit_ndx_file,index_rn);
  read(unit_ndx_file,index_rec);
  last_rn := filesize(unit_ndx_file) - 1;
  for rn := index_rn + 1 to last_rn do begin
    seek(unit_ndx_file,rn);
    read(unit_ndx_file,index_rec);
    seek(unit_ndx_file,rn-1);
    write(unit_ndx_file,index_rec)
  end;
  seek(unit_ndx_file,last_rn);
  truncate(unit_ndx_file);
  reset(unit_ndx_file);  {Force directory update}
  last_rn := pred(last_rn);
  for rn := 1 to last_rn do begin
    seek(unit_ndx_file,rn);
    read(unit_ndx_file,index_rec);
    if index_rec.queue_hdr_rn>index_item.queue_hdr_rn {Queue hdr rec moved!}
      then begin
        index_rec.queue_hdr_rn := pred(index_rec.queue_hdr_rn);
        seek(unit_ndx_file,rn);
        write(unit_ndx_file,index_rec)
      end
  end
end;

procedure index_add(index_rn   : integer;
                    index_item : index_type);

var
  last_rn,
  rn         : integer;
  index_rec  : index_type;

begin
  index_rn := abs(index_rn);
  last_rn := filesize(unit_ndx_file) - 1;
  if last_rn>0
    then for rn := last_rn downto index_rn do begin
      seek(unit_ndx_file,rn);
      read(unit_ndx_file,index_rec);
      seek(unit_ndx_file,rn+1);
      write(unit_ndx_file,index_rec)
    end;
  seek(unit_ndx_file,index_rn);
  write(unit_ndx_file,index_item);
  reset(unit_ndx_file);  {Force directory update}
  last_rn := succ(last_rn);
  for rn := 1 to last_rn do begin
    seek(unit_ndx_file,rn);
    read(unit_ndx_file,index_rec);
    if      (index_rec.queue_hdr_rn>=index_item.queue_hdr_rn)
        and (rn<>index_rn)
      then begin {Queue hdr rec moved -- must adjust pointer}
        index_rec.queue_hdr_rn := succ(index_rec.queue_hdr_rn);
        seek(unit_ndx_file,rn);
        write(unit_ndx_file,index_rec)
      end
  end;
end;

function queue_hdr_rec_no(unit : unit_type) : integer;

var
  index_rn  : integer;
  index_rec : index_type;

begin
  index_rn := index_rec_no(unit);
  if index_rn>0 {index_rn<0 means the unit is not in the index}
    then begin
      seek(unit_ndx_file,index_rn);
      read(unit_ndx_file,index_rec);
      queue_hdr_rec_no := index_rec.queue_hdr_rn
    end
    else queue_hdr_rec_no := -1
end;

procedure get_queue_hdr(var hdr          : queue_hdr_type;
                        var queue_hdr_rn : integer;
                        var ok           : boolean);

begin
  queue_hdr_rn := queue_hdr_rec_no(hdr.unit);
  ok := (queue_hdr_rn>0);
  if ok
    then begin
      seek(queue_hdr_file,queue_hdr_rn);
      read(queue_hdr_file,hdr)
    end
end;

procedure put_queue_hdr(    hdr          : queue_hdr_type;
                            queue_hdr_rn : integer;
                        var ok           : boolean);

begin
  seek(queue_hdr_file,queue_hdr_rn);
  write(queue_hdr_file,hdr);
  ok := true;
end;

procedure add_queue_hdr(    hdr : queue_hdr_type;
                        var ok  : boolean);

var
  index_rn     : integer;
  hdr_rn       : integer;
  temp_hdr     : queue_hdr_type;
  index_rec    : index_type;

begin
  ok := (hdr.time_zone<=max_time_zone) and (hdr.time_zone>=min_time_zone);
  if not ok
    then exit;
  index_rn := index_rec_no(hdr.unit);
  ok := (index_rn<0); {index_rn>0 means the unit is already in the index}
  if ok
    then begin
      hdr_rn := filesize(queue_hdr_file) - 1;
      if hdr_rn>=0
        then repeat
          seek(queue_hdr_file,hdr_rn);
          read(queue_hdr_file,temp_hdr);
          if temp_hdr.time_zone>hdr.time_zone
            then begin
              seek(queue_hdr_file,hdr_rn+1);
              write(queue_hdr_file,temp_hdr);
              hdr_rn := pred(hdr_rn)
            end
        until (hdr_rn=-1) or (temp_hdr.time_zone<=hdr.time_zone);
      hdr_rn := succ(hdr_rn);
      seek(queue_hdr_file,hdr_rn);
      write(queue_hdr_file,hdr);
      reset(queue_hdr_file);  {Force directory update}
      index_rec.unit := hdr.unit;
      index_rec.queue_hdr_rn := hdr_rn;
      index_add(index_rn,index_rec)
    end
end;

procedure delete_queue_hdr(    unit : unit_type;
                           var ok   : boolean);

var
  index_rn     : integer;
  hdr_rn       : integer;
  temp_hdr     : queue_hdr_type;
  index_rec    : index_type;
  last_hdr_rec : integer;

begin
  index_rn := index_rec_no(unit);
  ok := (index_rn>0); {index_rn<0 means the unit is not in the index}
  if ok
    then begin
      seek(unit_ndx_file,index_rn);
      read(unit_ndx_file,index_rec);
      hdr_rn := index_rec.queue_hdr_rn;
      seek(queue_hdr_file,hdr_rn);
      read(queue_hdr_file,temp_hdr);
      ok := (temp_hdr.head=-1);
      if ok
        then begin
          index_delete(index_rn,index_rec);
          last_hdr_rec := filesize(queue_hdr_file)-1;
          while hdr_rn<last_hdr_rec do begin
            seek(queue_hdr_file,hdr_rn + 1);
            read(queue_hdr_file,temp_hdr);
            seek(queue_hdr_file,hdr_rn);
            write(queue_hdr_file,temp_hdr);
            hdr_rn := succ(hdr_rn)
          end;
          seek(queue_hdr_file,last_hdr_rec);
          truncate(queue_hdr_file);
          reset(queue_hdr_file) {Forces directory update}
        end
    end
end;

procedure get_first_queue_entry(    queue_hdr_rn     : integer;
                                var mail_queue_entry : mail_que_type;
                                var mail_queue_rn    : real;
                                var ok               : boolean);

var
  temp_hdr : queue_hdr_type;

begin
  seek(queue_hdr_file,queue_hdr_rn);
  read(queue_hdr_file,temp_hdr);
  ok := (temp_hdr.head<>-1);  {Mail in queue}
  if ok
    then begin
      mail_queue_rn := temp_hdr.head;
      seek(queue_file,mail_queue_rn);
      read(queue_file,mail_queue_entry);
    end
end;

procedure get_next_queue_entry(    queue_hdr_rn     : integer;
                               var mail_queue_entry : mail_que_type;
                               var mail_queue_rn    : real;
                               var ok               : boolean);

var
  temp_hdr : queue_hdr_type;

begin
  ok := (mail_queue_entry.next<>-1);  {More mail in queue}
  if ok
    then begin
      mail_queue_rn := mail_queue_entry.next;
      seek(queue_file,mail_queue_rn);
      read(queue_file,mail_queue_entry);
    end
end;

procedure add_queue_entry(queue_hdr_rn     : integer;
                          mail_queue_entry : mail_que_type);

var
  free_hdr         : queue_hdr_type;
  temp_queue_entry : mail_que_type;
  temp_hdr         : queue_hdr_type;
  old_tail         : real;
  new_rn           : real;

begin
  seek(queue_hdr_file,0);  {Free list header}
  read(queue_hdr_file,free_hdr);
  if free_hdr.head=-1  {Free list empty}
    then new_rn := longfilesize(queue_file)
    else begin
      new_rn := free_hdr.head;
      seek(queue_file,free_hdr.head);
      read(queue_file,temp_queue_entry);
      free_hdr.head := temp_queue_entry.next;
      if free_hdr.head=-1
        then free_hdr.tail := -1;
      seek(queue_hdr_file,0);
      write(queue_hdr_file,free_hdr);
    end;
  mail_queue_entry.next := -1; {Nil -- end of queue}
  seek(queue_file,new_rn);
  write(queue_file,mail_queue_entry);
  seek(queue_hdr_file,queue_hdr_rn);
  read(queue_hdr_file,temp_hdr);
  with temp_hdr do begin
    if head=-1  {No mail in queue}
      then begin
        head := new_rn;
        tail := new_rn
      end
      else begin
        old_tail := tail;
        tail := new_rn;
        seek(queue_file,old_tail);
        read(queue_file,temp_queue_entry);
        temp_queue_entry.next := new_rn;
        seek(queue_file,old_tail);
        write(queue_file,temp_queue_entry)
      end
  end;
  seek(queue_hdr_file,queue_hdr_rn);
  write(queue_hdr_file,temp_hdr);
  reset(queue_file);
  reset(queue_hdr_file)
end;

procedure delete_queue_entry(queue_hdr_rn     : integer;
                             mail_queue_rn    : real;
                             mail_queue_entry : mail_que_type);

var
  free_hdr         : queue_hdr_type;
  temp_queue_entry : mail_que_type;
  temp_hdr         : queue_hdr_type;
  save_rn          : real;

begin
  seek(queue_hdr_file,queue_hdr_rn);
  read(queue_hdr_file,temp_hdr);
  if temp_hdr.head=mail_queue_rn {First item in queue}
    then begin
      temp_hdr.head := mail_queue_entry.next;
      if temp_hdr.head=-1
        then temp_hdr.tail := -1;
      seek(queue_hdr_file,queue_hdr_rn);
      write(queue_hdr_file,temp_hdr);
    end
    else begin
      save_rn := temp_hdr.head;
      seek(queue_file,temp_hdr.head);
      read(queue_file,temp_queue_entry);
      while temp_queue_entry.next<>mail_queue_rn do begin
        save_rn := temp_queue_entry.next;
        seek(queue_file,temp_queue_entry.next);
        read(queue_file,temp_queue_entry)
      end;
      temp_queue_entry.next := mail_queue_entry.next;
      seek(queue_file,save_rn);
      write(queue_file,temp_queue_entry);
    end;
  seek(queue_hdr_file,0);  {Free list header}
  read(queue_hdr_file,free_hdr);
  mail_queue_entry.next := free_hdr.head;
  mail_queue_entry.sender_adrs.unit := '*'; {Mark as deleted (for crash recovery!)}
  seek(queue_file,mail_queue_rn);
  write(queue_file,mail_queue_entry);
  free_hdr.head := mail_queue_rn;
  if free_hdr.tail=-1
    then free_hdr.tail := mail_queue_rn;
  seek(queue_hdr_file,0);
  write(queue_hdr_file,free_hdr);
  reset(queue_file);
  reset(queue_hdr_file)
end;
