{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
program e_host;

{$I e_types.inc}
{$I e_misc.inc }
{$I e_dt.inc   }

var
  unit_ndx_file   : file of index_type;       {Ndx for mail queue header file}
  queue_hdr_file  : file of queue_hdr_type;   {Mail queue header file}
  queue_file      : file of mail_que_type;    {Mail queue file}
  list_file       : text;                     {Distribution & conference lists}
  sys_info_file   : file of sys_info_type;    {System information}
  log_file        : text;                     {Log of system activity}
  block_file      : file {of untyped};        {General purpose block file}
  byte_file       : file of byte;             {General purpose file}

  queue_hdr_rec   : queue_hdr_type;
  last_dt         : dt_block_type;
  host_day_start   : byte;
  host_night_start : byte;
  sys_info        : sys_info_type;
  ok,
  quit            : boolean;

const
  max_retries     = 3;

  min_time_zone   = 5;
  max_time_zone   = 8;
  remote_day_start   = 6;
  remote_night_start = 18;
  null            = 0;

  mail_pending    : boolean = true;

  file_path       : file_path_type = '\EMAIL\';
  unit_ndx_fname  : file_path_type = '\EMAIL\E_UNIT.NDX';
  queue_hdr_fname : file_path_type = '\EMAIL\E_MQUE.HDR';
  queue_fname     : file_path_type = '\EMAIL\E_MAIL.QUE';
  sys_info_fname  : file_path_type = '\EMAIL\E_HINFO.SYS';

{$I e_hlog.inc }
{$I e_mdm.inc  }
{$I e_srch.inc }
{$I e_hmque.inc}

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure init_date_time;

begin
  verifydt;
  datetime(last_dt)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function is_day(dt : dt_block_type) : boolean;

begin
  is_day := (dt.hh>=host_day_start) and (dt.hh<host_night_start)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function is_night(dt : dt_block_type) : boolean;

begin
  is_night := not is_day(dt)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function night_time : boolean;

var
  now : dt_block_type;

begin
  time(now);
  night_time := is_night(now)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function day_to_night : boolean;

var
  now : dt_block_type;

begin
  time(now);
  day_to_night := is_day(last_dt) and is_night(now);
  last_dt := now
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function too_early(time_zone : time_zone_type) : boolean;

var
  now_there : dt_block_type;

begin
  time(now_there);
  now_there.hh := now_there.hh - (time_zone - sys_info.time_zone) mod 24;
  too_early := (now_there.hh>=12) and (now_there.hh<host_night_start)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function too_late(time_zone : time_zone_type) : boolean;

var
  now_there : dt_block_type;

begin
  time(now_there);
  now_there.hh := now_there.hh - (time_zone - sys_info.time_zone) mod 24;
  too_late := (now_there.hh>=host_day_start) and (now_there.hh<12)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function next_fname(first_char : char) : file_name_type;

var
  temp,
  dummy          : integer;
  now            : dt_block_type;
  next_serial_no : str5;
  yy_str         : string[2];
  julian_str     : string[3];

begin
  seek(sys_info_file,0);
  read(sys_info_file,sys_info);
  with sys_info do begin
    next_serial_no := makestr(serial_no,5);
    serial_no := succ(serial_no) mod 32767;
  end;
  seek(sys_info_file,0);
  write(sys_info_file,sys_info);
  close(sys_info_file);
  reset(sys_info_file);  {Force update}
  date(now);
  str(now.yy,yy_str);
  julian_str := makestr(julian(now),3);
  next_fname := first_char + next_serial_no + yy_str + '.' + julian_str
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function io_err(fname : file_path_type) : boolean;

var
  ok        : boolean;
  err_value : integer;

begin
  err_value := ioresult;
  if err_value<>0
    then begin
      writeln('>>>>> I/O ERROR #',err_value,' ON FILE ',fname);
      if copy(fname,length(fname)-2,3)<>'LOG'
        then log(io_error,err_value,fname)
    end;
  io_err := (err_value<>0)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure open_log_file(    dtb : dt_block_type;
                        var ok : boolean        );

var
  log_fname  : file_path_type;
  io_err_val : integer;
  dtb_str    : string[12];

begin
  dtb_str := copy(dt_str(dtb),1,6);
  log_fname := file_path + 'E_' + copy(dtb_str,1,6) + '.LOG';
  assign(log_file,log_fname);
  {$I-} append(log_file); {$I+}
  io_err_val := ioresult;
  case io_err_val of
    0 : ok := true;
    1 : begin {File not found -- create it}
          {$I-} rewrite(log_file); {$I+}
          ok := not io_err(log_fname)
        end
    else begin
          {$I-} append(log_file); {$I+} {Repeat the error to reset ioresult}
          ok := not io_err(log_fname)
        end
  end;
  if ok
    then log(open_log,null,dtb_str)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure init_files(var ok : boolean);

var
  now : dt_block_type;

begin
  datetime(now);
  open_log_file(now,ok);
  if not ok
    then exit;
  assign(unit_ndx_file,unit_ndx_fname);
  {$I-} reset(unit_ndx_file); {$I+}
  ok := not io_err(unit_ndx_fname);
  if not ok
    then exit;
  assign(queue_hdr_file,queue_hdr_fname);
  {$I-} reset(queue_hdr_file); {$I+}
  ok := not io_err(queue_hdr_fname);
  if not ok
    then exit;
  assign(queue_file,queue_fname);
  {$I-} reset(queue_file); {$I+}
  ok := not io_err(queue_fname);
  if not ok
    then exit;
  assign(sys_info_file,sys_info_fname);
  {$I-} reset(sys_info_file); {$I+}
  ok := not io_err(sys_info_fname);
  if ok
    then begin
      read(sys_info_file,sys_info);
      host_day_start := remote_day_start +
                       (max_time_zone - sys_info.time_zone);
      host_night_start := remote_night_start +
                         (min_time_zone - sys_info.time_zone)
    end
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function kbd_terminate : boolean;

var
  yorn : char;

begin
  write('Terminate program? (Y/N) ');
  read(kbd,yorn);
  writeln(yorn);
  kbd_terminate := (upcase(yorn)='Y');
  log(kbd_interrupt,null,upcase(yorn))
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure connect(phone_no : ph_num_type;
                  unit_id  : unit_type;
                  var ok   : boolean     );

var
  response : char;
  id_block : unit_type;

begin
  log(place_call,null,unit_id+'|'+phone_no);
  call(phone_no,ok);

ok := data_set_ready;

  if ok
    then begin
      sendaux(attention+send_id,recved_ok,response);
      ok := (response=recved_ok);
      if ok
        then begin
          read_aux_packet(id_block,sizeof(id_block),00,unsqueeze,ok);
          ok := ok and (id_block=unit_id)
        end
    end;
  if ok
    then log(connected,null,'')
    else begin
      log(no_connect,null,
          copy('FT',ord(data_set_ready)+1,1)+
          copy('FT',ord(response=recved_ok)+1,1)+
          copy('FT',ord(id_block=unit_id)+1,1));
      hangup
    end
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure recv_mail(var ok           : boolean);

label 999;

var
  more_mail        : boolean;
  response         : char;
  mail_queue_entry : mail_que_type;
  mail_queue_rn    : real;
  to_queue_hdr_rn  : integer;
  len              : real;
  lenstr           : string[8];
  packet           : array[1..aux_buffer_size] of byte;
  numread          : integer;
  numbytes         : integer;
  seq_no           : byte;
  send_count       : send_count_type;
  temp_unit        : unit_array_type;
  temp_attn        : attn_array_type;
  high             : byte;
  i                : integer;

const
  blank            = ' ';

begin
  sendaux(attention+send_hdr,affirmative+negative,response);
  more_mail := (response=affirmative);

  while more_mail do begin
    read_aux_packet(mail_queue_entry,sizeof(mail_queue_entry),
                    00,unsqueeze,ok);
    if not ok
      then begin
        log(bad_mail_hdr,null,'');
        goto 999
      end
      else begin
        str(mail_queue_entry.mail_length:7:0,lenstr);
        log(mail_hdr,null,
            copy('LPS',ord(mail_queue_entry.type_mail)+1,1)+ ':' +
            copy('UDC',ord(mail_queue_entry.type_adrsee)+1,1)+ ':' +
            mail_queue_entry.recvr_adrs.unit + '|' +
            lenstr)
      end;

    if mail_queue_entry.type_adrsee=dist_list
      then begin
        mail_queue_entry.dist_list := next_fname('D');
        log(recv_dist_list,null,mail_queue_entry.dist_list);
        assign(block_file,mail_queue_entry.dist_list);
        rewrite(block_file);
        len := mail_queue_entry.dist_length;
        seq_no := 0;
        sendaux(attention+send_dist_list,noresponse,response);

        repeat
          if len<aux_buffer_size
            then numbytes := trunc(len)
            else numbytes := aux_buffer_size;
          read_aux_packet(packet,numbytes,seq_no,unsqueeze,ok);
          if not ok
            then begin
              log(bad_block,seq_no,'Distribution list');
              close(block_file);
              erase(block_file);
              goto 999
            end;
          blockwrite(block_file,packet,num_aux_buffer_recs);
          seq_no := succ(seq_no);
          len := len - numbytes
        until len=0;
        close(block_file);

        assign(byte_file,mail_queue_entry.dist_list);
        reset(byte_file);
        seek(byte_file,mail_queue_entry.dist_length);
        truncate(byte_file);
        close(byte_file);

        assign(list_file,mail_queue_entry.dist_list);
        reset(list_file);
        ok := true
      end;

    if mail_queue_entry.type_adrsee=conference
      then begin
        assign(list_file,file_path+mail_queue_entry.recvr_adrs.unit);
        {$I-} reset(list_file); {$I+}
        ok := not io_err(file_path+mail_queue_entry.recvr_adrs.unit);
        if not ok
          then log(bad_conference,null,mail_queue_entry.recvr_adrs.unit)
      end;

    if mail_queue_entry.type_adrsee=unit
      then begin
        ok := queue_hdr_rec_no(mail_queue_entry.recvr_adrs.unit)>0;
        if not ok
          then log(unit_error,null,mail_queue_entry.recvr_adrs.unit)
      end;

    if ok
      then begin
        mail_queue_entry.mail_item := next_fname('M');
        log(recv_mail_item,null,mail_queue_entry.mail_item);
        assign(block_file,mail_queue_entry.mail_item);
        rewrite(block_file);
        len := mail_queue_entry.mail_length;
        seq_no := 0;
        sendaux(attention+send_item,noresponse,response);

        repeat
          if len<aux_buffer_size
            then numbytes := trunc(len)
            else numbytes := aux_buffer_size;
          read_aux_packet(packet,numbytes,seq_no,not(unsqueeze),ok);
          if not ok
            then begin
              log(bad_block,seq_no,'Mail item');
              close(block_file);
              erase(block_file);
              if mail_queue_entry.type_adrsee=dist_list
                then begin
                  close(list_file);
                  erase(list_file)
                end
                else if mail_queue_entry.type_adrsee=conference
                  then close(list_file);
              goto 999
            end;
          blockwrite(block_file,packet,num_aux_buffer_recs);
          seq_no := succ(seq_no);
          len := len - numbytes;
        until len=0;
        close(block_file);

        send_count.int_val := 0;

        if     (mail_queue_entry.type_adrsee=dist_list)
            or (mail_queue_entry.type_adrsee=conference)
          then begin

{new stuff 10/01/86 *********************************}

            while not eof(list_file) do begin
              high := 0;
              readln(list_file,temp_unit,temp_attn);

              For i := 1 to 20  do
                 begin
                 if temp_unit[21-i] <> blank then
                    if i>high then high := i;
                 end;  {for i := 1 to 20}

              mail_queue_entry.recvr_adrs.unit := stringit(temp_unit,high);
              high := 0;

              For i := 1 to 20 do
                 begin
                 if temp_attn[21-i] <> blank then
                    if i>high then high := i;
                 end;  {for i := 1 to 20}

              mail_queue_entry.recvr_adrs.attn := stringit(temp_attn,high);

{end of new stuff 10/01/86}

              to_queue_hdr_rn := queue_hdr_rec_no(mail_queue_entry
                                                  .recvr_adrs.unit);
              if to_queue_hdr_rn>0 {Unit found}
                then begin
                  log(add_to_queue,null,mail_queue_entry.recvr_adrs.unit);
                  add_queue_entry(to_queue_hdr_rn,mail_queue_entry);
                  send_count.int_val := succ(send_count.int_val)
                end
                else log(unit_error,null,mail_queue_entry.recvr_adrs.unit)
            end;
            close(list_file);
          end
          else begin
            to_queue_hdr_rn := queue_hdr_rec_no(mail_queue_entry
                                                .recvr_adrs.unit);
            if to_queue_hdr_rn>0 {Unit found}
              then begin
                log(add_to_queue,null,mail_queue_entry.recvr_adrs.unit);
                add_queue_entry(to_queue_hdr_rn,mail_queue_entry);
                send_count.int_val := 1
              end
              else log(unit_error,null,mail_queue_entry.recvr_adrs.unit)
          end;

        assign(byte_file,mail_queue_entry.mail_item);
        if send_count.int_val>0
          then begin
            reset(byte_file);
            seek(byte_file,mail_queue_entry.mail_length);
            write(byte_file,send_count.first_byte);
            write(byte_file,send_count.second_byte);
            truncate(byte_file);
            close(byte_file);
            mail_pending := true
          end
          else begin
            log(erase_no_recvrs,null,'');
            erase(byte_file)
          end;

      end
      else begin {not ok}
        sendaux(negative,noresponse,response)
      end;

    sendaux(attention+send_hdr,affirmative+negative,response);
    more_mail := (response=affirmative)
  end;

999:  {Emergency exit}

  reset(queue_file);
  reset(queue_hdr_file);

end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure send_mail(    queue_hdr_rn  : integer;
                        send_priority : priority_type;
                    var ok            : boolean);

label 999;

var
  response         : char;
  more_mail        : boolean;
  mail_queue_entry : mail_que_type;
  mail_queue_rn    : real;
  len              : real;
  packet           : array[1..aux_buffer_size] of byte;
  numread          : integer;
  numbytes         : integer;
  seq_no           : byte;
  send_count       : send_count_type;
  dummy            : integer;

begin
  get_first_queue_entry(queue_hdr_rn,mail_queue_entry,
                        mail_queue_rn,more_mail);

  while more_mail do begin

    if mail_queue_entry.priority>=send_priority
      then begin
        log(send_mail_item,null,mail_queue_entry.mail_item);
        assign(block_file,mail_queue_entry.mail_item);
        {$I-} reset(block_file); {$I+}
        ok := not io_err(mail_queue_entry.mail_item);
        if not ok
          then begin
            log(bad_mail_item,null,mail_queue_entry.mail_item);
            goto 999
          end;

        sendaux(attention+recv_hdr,affirmative+negative,response);
        ok := (response=affirmative);
        if not ok
          then begin
            log(mail_hdr_refused,null,'');
            close(block_file);
            goto 999
          end;

        send_aux_packet(mail_queue_entry,sizeof(mail_queue_entry),00,squeeze,ok);
        if not ok
          then begin
            log(bad_block,00,'Mail queue entry');
            close(block_file);
            goto 999
          end;

        sendaux(attention+recv_item,noresponse,response);
        len := mail_queue_entry.mail_length;
        seq_no := 0;
        repeat
          blockread(block_file,packet,num_aux_buffer_recs,dummy);
          if len<aux_buffer_size
            then numbytes := trunc(len)
            else numbytes := aux_buffer_size;
          send_aux_packet(packet,numbytes,seq_no,not(squeeze),ok);
          if not ok
            then begin
              close(block_file);
              goto 999
            end;
          seq_no := succ(seq_no);
          len := len - numbytes;
        until len=0;
        close(block_file);

        delete_queue_entry(queue_hdr_rn,mail_queue_rn,mail_queue_entry);

        assign(byte_file,mail_queue_entry.mail_item);
        reset(byte_file);
        seek(byte_file,mail_queue_entry.mail_length);
        with send_count do begin
          read(byte_file,first_byte);
          read(byte_file,second_byte);
          int_val := pred(int_val);
          if int_val>0
            then begin
              seek(byte_file,mail_queue_entry.mail_length);
              write(byte_file,first_byte);
              write(byte_file,second_byte);
              close(byte_file);
              log(send_count_is,int_val,mail_queue_entry.mail_item)
            end
            else begin
             if mail_queue_entry.type_mail <> system
              then begin
              close(byte_file);
              erase(byte_file);
              log(erase_mail_item,null,mail_queue_entry.mail_item)
              end
            end
        end
      end;

    get_next_queue_entry(queue_hdr_rn,mail_queue_entry,
                          mail_queue_rn,more_mail);

  end;

  reset(queue_file);
  reset(queue_hdr_file);

999: {Emergency exit}

end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure pass_a(var quit : boolean );

var
  yorn          : char;
  call_unit_rn,
  last_unit_rn,
  start_here_rn : integer;
  queue_hdr_rec : queue_hdr_type;
  ok            : boolean;

begin
  log(start_pass_a,null,'');
  start_here_rn := 1;
  call_unit_rn := 1;
  last_unit_rn := filesize(queue_hdr_file)-1;
  quit := false;

  while (start_here_rn<=last_unit_rn) and night_time and not quit do begin
    if call_unit_rn>last_unit_rn
      then call_unit_rn := start_here_rn;
    seek(queue_hdr_file,call_unit_rn);
    read(queue_hdr_file,queue_hdr_rec);
    if too_early(queue_hdr_rec.time_zone)
      then call_unit_rn := start_here_rn
    else if too_late(queue_hdr_rec.time_zone)
      then begin
        start_here_rn := succ(call_unit_rn);
        call_unit_rn := start_here_rn
      end
    else with queue_hdr_rec do begin
      if (pass_a_retry_count>0)
        then begin
          connect(phone_no,unit,ok);
          if ok
            then begin
              send_mail(call_unit_rn,bulk,ok);
              if ok
                then recv_mail(ok);
              hangup;
              log(hanging_up,null,copy('FT',ord(ok)+1,1) + '|' + unit)
            end;
          seek(queue_hdr_file,call_unit_rn);
          read(queue_hdr_file,queue_hdr_rec);
          if ok
            then pass_a_retry_count := -1
          else if not keypressed
            then pass_a_retry_count := pred( pass_a_retry_count);
          seek(queue_hdr_file,call_unit_rn);
          write(queue_hdr_file,queue_hdr_rec)
        end;
      if (pass_a_retry_count<=0) and (call_unit_rn=start_here_rn)
        then start_here_rn := succ(start_here_rn);
      call_unit_rn := succ(call_unit_rn)
    end;
    if keypressed
      then quit := kbd_terminate
  end;
  mail_pending := (start_here_rn<=last_unit_rn)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure pass_b(var quit             : boolean );

var
  yorn          : char;
  call_unit_rn,
  last_unit_rn,
  start_here_rn : integer;
  queue_hdr_rec : queue_hdr_type;
  ok            : boolean;

begin
  log(start_pass_b,null,'');
  start_here_rn := 1;
  call_unit_rn := 1;
  last_unit_rn := filesize(queue_hdr_file)-1;
  quit := false;

  while (start_here_rn<=last_unit_rn) and night_time and not quit do begin
    if call_unit_rn>last_unit_rn
      then call_unit_rn := start_here_rn;
    seek(queue_hdr_file,call_unit_rn);
    read(queue_hdr_file,queue_hdr_rec);
    if too_early(queue_hdr_rec.time_zone)
      then call_unit_rn := start_here_rn
    else if too_late(queue_hdr_rec.time_zone)
      then begin
        start_here_rn := succ(call_unit_rn);
        call_unit_rn := start_here_rn
      end
    else with queue_hdr_rec do begin
      if (pass_b_retry_count>0) and (head<>-1)
        then begin
          connect(phone_no,unit,ok);
          if ok
            then begin
              send_mail(call_unit_rn,bulk,ok);
              hangup;
              log(hanging_up,null,unit)
            end;
          seek(queue_hdr_file,call_unit_rn);
          read(queue_hdr_file,queue_hdr_rec);
          if ok
            then pass_b_retry_count := -1
            else if not keypressed
              then pass_b_retry_count := pred(pass_b_retry_count);
          seek(queue_hdr_file,call_unit_rn);
          write(queue_hdr_file,queue_hdr_rec)
        end;
      if     ((pass_b_retry_count<=0) or (head=-1))
          and (call_unit_rn=start_here_rn)
        then start_here_rn := succ(start_here_rn);
      call_unit_rn := succ(call_unit_rn)
    end;
    if keypressed
      then quit := kbd_terminate
  end;
  mail_pending := (start_here_rn<=last_unit_rn)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure handlecall;

var
  response     : char;
  id_block     : unit_type;
  call_unit_rn : integer;

begin
  ok := data_set_ready;
  if ok
    then begin
      sendaux(attention+send_id,recved_ok,response);
      ok := (response=recved_ok);
      if ok
        then begin
          read_aux_packet(id_block,sizeof(id_block),00,unsqueeze,ok);
          call_unit_rn := queue_hdr_rec_no(id_block);
          ok := ok and (call_unit_rn>0)
        end
    end;
  if ok
    then log(connected,null,id_block)
    else log(no_connect,null,
             copy('FT',ord(data_set_ready)+1,1)+
             copy('FT',ord(response=recved_ok)+1,1)+
             copy('FT',ord(call_unit_rn>0)+1,1));
  if ok
    then begin
      send_mail(call_unit_rn,immediate,ok);
      if ok
        then recv_mail(ok);
      hangup;
      log(hanging_up,null,copy('FT',ord(ok)+1,1) + '|' + id_block)
    end;

end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure await_mail(var quit : boolean);

var
  yorn : char;

begin
  quit := false;
  awaitcall(1*minutes);
  if data_set_ready
    then begin
      handlecall;
      hangup
    end
  else if keypressed
    then quit := kbd_terminate
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure cleanup;

var
  last_unit_rn,
  rn            : integer;
  queue_hdr_rec : queue_hdr_type;
  now           : dt_block_type;

begin

  {Reset all retry counts in queue_hdr_recs & log all units not contacted}

  last_unit_rn := filesize(queue_hdr_file) - 1;
  for rn := 1 to last_unit_rn do begin
    seek(queue_hdr_file,rn);
    read(queue_hdr_file,queue_hdr_rec);
    with queue_hdr_rec do begin
      if pass_a_retry_count<>-1
        then log(no_contact_a,max_retries - pass_a_retry_count,unit);
      if (pass_b_retry_count<>-1) and (head<>-1)
        then log(no_contact_b,max_retries - pass_b_retry_count,unit);
      pass_a_retry_count := max_retries;
      pass_b_retry_count := max_retries;
    end;
    seek(queue_hdr_file,rn);
    write(queue_hdr_file,queue_hdr_rec);
  end;

  {Close old log file and start new one.}

  close(log_file);
  datetime(now);
  open_log_file(now,ok);

end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
label 999;

begin {main}
  clrscr;
  host := true;
  init_mdm(bd1200);
  init_date_time;
  init_files(ok);
  if not ok
    then goto 999;

  repeat
    if day_to_night or (night_time and mail_pending)
      then begin
        pass_a(quit);
        if not quit
          then pass_b(quit);
        if not quit
          then cleanup
      end
      else await_mail(quit)
  until quit;

999:  {Emergency exit}

  quit_mdm;
  log(terminate,null,'');

  {$I-}  {Ignore errors -- files may not be open.}
  close(log_file);
  close(unit_ndx_file);
  close(queue_hdr_file);
  close(queue_file);
  close(sys_info_file);
  {$I+}

end. {main}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
