{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
program e_hutil;

{$I e_types.inc  }

var
  unit_ndx_file   : file of index_type;       {Index for mail queue header file}
  queue_hdr_file  : file of queue_hdr_type;   {Mail queue header file}
  queue_file      : file of mail_que_type;    {Mail queue file}
  mail_item_file  : file of byte;             {Actual mail item}
  sys_info_file   : file of sys_info_type;    {System information}
  system_file     : file of byte;             {for passing system mail}

  today           : string[6];
  choice          : integer;

  c               : char;
  i               : integer;
  index_rec       : index_type;
  hdr             : queue_hdr_type;
  ok              : boolean;
  unit_name       : unit_type;
  queue_hdr_rn    : integer;
  mail_queue_entry: mail_que_type;
  mail_queue_rn   : real;
  sys_info        : sys_info_type;

const
  max_retries     = 3;
  min_time_zone   = 5;
  max_time_zone   = 8;
  password        = 'noshit';

  null            = 0;

  logoline1       = '    EMAIL HOST UTILITY PROGRAM';

  unit_change     : boolean = false;

  file_path       : file_path_type = '\EMAIL\';
  unit_ndx_fname  : file_path_type = '\EMAIL\E_UNIT.NDX';
  queue_hdr_fname : file_path_type = '\EMAIL\E_MQUE.HDR';
  queue_fname     : file_path_type = '\EMAIL\E_MAIL.QUE';
  sys_info_fname  : file_path_type = '\EMAIL\E_HINFO.SYS';

{$I e_misc.inc }
{$I e_dt.inc   }
{$I e_scrn.inc }
{$I e_menu.inc }
{$I e_srch.inc }
{$I e_hmque.inc}

const
  mainmenu : menurec =
               (heading     : 'MAIN MENU';
                first_chars : 'EUML';
                item        : ('(E)xit',
                               '(U)nit maintenance functions',
                               '(M)ail maintenance functions',
                               '(L)og maintenance functions',
                               '',
                               '',
                               '',
                               '',
                               '',
                               ''));

  unitmenu : menurec =
               (heading     : 'UNIT MAINTENANCE MENU';
                first_chars : 'EADVLC';
                item        : ('(E)xit',
                               '(A)dd a unit',
                               '(D)elete a unit',
                               '(V)iew a unit',
                               '(L)ist all units',
                               '(C)hange unit phone number',
                               '',
                               '',
                               '',
                               ''));

  mailmenu : menurec =
               (heading     : 'MAIL MAINTENANCE MENU';
                first_chars : 'EASV';
                item        : ('(E)xit',
                               '(A)dd a mail item',
                               '(S)end system mail',
                               '(V)iew mail',
                               '',
                               '',
                               '',
                               '',
                               '',
                               ''));

  logmenu : menurec =
               (heading     : 'LOG MAINTENANCE MENU';
                first_chars : 'EVD';
                item        : ('(E)xit',
                               '(V)iew log',
                               '(D)elete log',
                               '',
                               '',
                               '',
                               '',
                               '',
                               '',
                               ''));

{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure init_date_time;

var
  dtb : dt_block_type;

begin
  verifydt;
  date(dtb);
  today := stringit(dtb.yy,2) + stringit(dtb.mo,2) + stringit(dtb.dd,2)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function io_err(fname : file_path_type) : boolean;

var
  ok        : boolean;
  err_value : integer;

begin
  err_value := ioresult;
  if err_value<>0
    then writeln('>>>>> I/O ERROR #',err_value,' on file ',fname);
  io_err := (err_value<>0)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure init_files(var ok : boolean);

begin
  assign(unit_ndx_file,unit_ndx_fname);
  {$I-} reset(unit_ndx_file); {$I+}
  ok := not io_err(unit_ndx_fname);
  if not ok
    then exit;
  assign(queue_hdr_file,queue_hdr_fname);
  {$I-} reset(queue_hdr_file); {$I+}
  ok := not io_err(queue_hdr_fname);
  if not ok
    then exit;
  assign(queue_file,queue_fname);
  {$I-} reset(queue_file); {$I+}
  ok := not io_err(queue_fname);
  assign(sys_info_file,sys_info_fname);
  {$I-} reset(sys_info_file); {$I+}
  ok := not io_err(sys_info_fname);
  if ok
    then read(sys_info_file,sys_info)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function next_fname(first_char : char) : file_name_type;

var
  temp,
  dummy          : integer;
  now            : dt_block_type;
  next_serial_no : str5;
  yy_str         : string[2];
  julian_str     : string[3];

begin
  seek(sys_info_file,0);
  read(sys_info_file,sys_info);
  with sys_info do begin
    next_serial_no := makestr(serial_no,5);
    serial_no := succ(serial_no) mod 32767;
  end;
  seek(sys_info_file,0);
  write(sys_info_file,sys_info);
  close(sys_info_file);
  reset(sys_info_file);  {Force update}
  date(now);
  str(now.yy,yy_str);
  julian_str := makestr(julian(now),3);
  next_fname := first_char + next_serial_no + yy_str + '.' + julian_str
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure copyfile(    origfname,
                       destfname : file_path_type;
                   var ok        : boolean        );

const
  numrecs = 128;   {Number of 128 byte blocks in buffer}
  bufsize = 16384; {128 * 128}

var
  buf : array[1..bufsize] of char;
  lenfile    : file of byte;
  len        : real;
  origfile,
  destfile   : file;
  numread    : integer;

begin
  assign(lenfile,origfname);
  {$I-} reset(lenfile); {$I+}
  ok := (ioresult=0);
  if not ok
    then exit;
  len := longfilesize(lenfile);
  close(lenfile);

  assign(origfile,origfname);
  reset(origfile);

  assign(destfile,destfname);
  {$I-} rewrite(destfile); {$I+}
  ok := (ioresult=0);
  if not ok
    then begin
      close(origfile);
      exit
    end;

  repeat
    blockread(origfile,buf,numrecs,numread);
    blockwrite(destfile,buf,numread)
  until numread=0;

  close(origfile);
  close(destfile);

  assign(lenfile,destfname);
  reset(lenfile);
  seek(lenfile,len);
  truncate(lenfile);
  close(lenfile)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure unit_functions;

var
  choice : integer;

procedure add_unit;

begin
  fillchar(hdr,sizeof(hdr),0);
  with hdr do begin
    write('Unit        : ');
    readln(unit);
    write('Time zone   : ');
    readln(time_zone);
    write('Phone number: ');
    readln(phone_no);
    head := -1;
    tail := -1;
    pass_a_retry_count := max_retries;
    pass_b_retry_count := max_retries
  end;
  add_queue_hdr(hdr,ok);
  if ok
    then begin
      unit_change := true;
      writeln('Successfully added')
    end
    else writeln('ERROR - Failed to add');
  await_any_key('Press any key to continue...')
end;

procedure delete_unit;

begin
  write('Unit        : ');
  readln(unit_name);
  delete_queue_hdr(unit_name,ok);
  if ok
    then begin
      unit_change := true;
      writeln('Successfully deleted')
    end
    else writeln('ERROR - Failed to delete');
  await_any_key('Press any key to continue...')
end;

procedure view_unit;

begin
  write('Unit              : ');
  readln(hdr.unit);
  get_queue_hdr(hdr,queue_hdr_rn,ok);
  if ok
    then with hdr do begin
      writeln('Time zone         : ',time_zone);
      writeln('Retry counts (A/B): ',pass_a_retry_count,'/',pass_b_retry_count);
      writeln('Phone number      : ',phone_no);
      if head=-1
        then writeln('No mail in queue')
        else writeln('Mail in queue')
    end
    else writeln('ERROR - Not found');
  await_any_key('Press any key to continue...')
end;

procedure list_units;

begin
  write('(A)lphabetic or (T)ime zone order?');
  read(kbd,c);
  writeln(c);
  case c of
    'A','a' : for i := 1 to filesize(unit_ndx_file)-1 do begin
                seek(unit_ndx_file,i);
                read(unit_ndx_file,index_rec);
                seek(queue_hdr_file,index_rec.queue_hdr_rn);
                read(queue_hdr_file,hdr);
                with hdr do
                  writeln('Unit: ',hdr.unit,'  ','Time zone: ',time_zone,
                          '  ','Phone number: ',phone_no)
              end;
    'T','t' : for i := 1 to filesize(queue_hdr_file)-1 do begin
                seek(queue_hdr_file,i);
                read(queue_hdr_file,hdr);
                with hdr do
                  writeln('Unit: ',hdr.unit,'  ','Time zone: ',time_zone,
                          '  ','Phone number: ',phone_no)
              end;
  end;
  await_any_key('Press any key to continue...')
end;

procedure change_phone;

begin
  write('Unit        : ');
  readln(hdr.unit);
  get_queue_hdr(hdr,queue_hdr_rn,ok);
  if ok
    then with hdr do begin
      writeln('Old phone number is   : ',phone_no);
      write(  'Enter new phone number: ');
      readln(phone_no);
      put_queue_hdr(hdr,queue_hdr_rn,ok)
    end
    else begin
      writeln('ERROR - Not found');
      await_any_key('Press any key to continue...')
    end
end;

begin {Unit maint functions}
  repeat
    clrscr;
    choice := menu(unitmenu);
    clrscr;
    case choice of
      2 : add_unit;
      3 : delete_unit;
      4 : view_unit;
      5 : list_units;
      6 : change_phone;
  end
  until choice=1
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure mail_functions;

var
  choice : integer;

procedure add_mail;

var
  send_count : send_count_type;
  orig_name  : file_path_type;
  npos       : integer;
  found      : boolean;      {the following 3 types/vars were added}
  m_ans      : integer;

begin
  fillchar(mail_queue_entry,sizeof(mail_queue_entry),0);
  with mail_queue_entry do begin
    write('Dest unit              : ');
    readln(recvr_adrs.unit);
    queue_hdr_rn := queue_hdr_rec_no(recvr_adrs.unit);
    if queue_hdr_rn>=0
      then begin
        write('Attn                   : ');
        readln(recvr_adrs.attn);
        write('Sender unit            : ');
        readln(sender_adrs.unit);
        write('Reply to               : ');
        readln(sender_adrs.attn);
        repeat
          write('Path\name of mail item : ');
          readln(orig_name);
          assign(mail_item_file,orig_name);
          {$I-} reset(mail_item_file); {$I+}
          ok := not io_err(orig_name);
        until ok;
        close(mail_item_file);

{new stuff here --- 9/18/86 -----------------------------}

        write('Type of mail (0=letter, 1=system)? : ');
        readln(m_ans);
        if m_ans <> 1
           then begin                                 { end, but look at else}
        mail_item := file_path + next_fname('M');
        copyfile(orig_name,mail_item,ok);   {copy file to M0014686.201}
           end
           else
           mail_item := orig_name;                {added 3 lines here}

        assign(mail_item_file,mail_item);
        reset(mail_item_file);
        mail_length := longfilesize(mail_item_file); {size of mail item}

        send_count.int_val := 1;
        seek(mail_item_file,mail_length);
        write(mail_item_file,send_count.first_byte);
        write(mail_item_file,send_count.second_byte);
        close(mail_item_file);

        npos := length(orig_name);
        found := false;
        while (npos>0) and not found do
          case copy(orig_name,npos,1) of
              ':','\' : found := true
            else        npos := pred(npos)
          end;

        npos := succ(npos);
        original_name := copy(orig_name,npos,length(orig_name)-npos+1);

        type_adrsee := unit;
       if m_ans = 0 then type_mail := letter;
       if m_ans = 1 then type_mail := system;

       { type_mail := letter;    <--- commented out for test  }

        priority := routine;
        datetime(when_mailed);
        add_queue_entry(queue_hdr_rn,mail_queue_entry)
      end

      else begin
        writeln('Can''t find ',recvr_adrs.unit);
        await_any_key('Press any key to continue')
      end
  end
end;

procedure view_mail;

var
  send_count : send_count_type;

begin
  with mail_queue_entry do begin
    write('Dest unit  : ');
    readln(recvr_adrs.unit);
    if (recvr_adrs.unit='FREE') or (recvr_adrs.unit='free')
      then queue_hdr_rn := 0
      else queue_hdr_rn := queue_hdr_rec_no(recvr_adrs.unit);
    ok := (queue_hdr_rn>=0);
    if ok
      then
        get_first_queue_entry(queue_hdr_rn,mail_queue_entry,mail_queue_rn,ok)
      else writeln('No such unit');
    while ok do begin
      writeln('Sender  : ',sender_adrs.unit,'  Attn: ',sender_adrs.attn);
      writeln('Receiver: ',recvr_adrs.unit ,'  Reply to: ',recvr_adrs.attn);
      writeln('Item    : ',mail_item,'  Length: ',mail_length:7:0);
      if (sender_adrs.unit='*')
        then
          get_next_queue_entry(queue_hdr_rn,mail_queue_entry,mail_queue_rn,ok)
      else if no('Delete this entry? ')
        then begin
          writeln;
          get_next_queue_entry(queue_hdr_rn,mail_queue_entry,mail_queue_rn,ok)
        end
      else begin
          delete_queue_entry(queue_hdr_rn,mail_queue_rn,mail_queue_entry);
          assign(mail_item_file,mail_queue_entry.mail_item);
          {$I-} reset(mail_item_file); {$I+}
          ok := not io_err(mail_queue_entry.mail_item);
          if ok
            then begin
              seek(mail_item_file,mail_queue_entry.mail_length);
              with send_count do begin
                read(mail_item_file,first_byte);
                read(mail_item_file,second_byte);
                int_val := pred(int_val);
                if int_val>0
                  then begin
                    seek(mail_item_file,mail_queue_entry.mail_length);
                    write(mail_item_file,first_byte);
                    write(mail_item_file,second_byte);
                    close(mail_item_file)
                  end
                  else begin
                    if mail_queue_entry.type_mail <> system
                      then begin
                    close(mail_item_file);
                    erase(mail_item_file)
                      end
                  end
              end
            end;
          get_next_queue_entry(queue_hdr_rn,mail_queue_entry,mail_queue_rn,ok)
        end
    end
  end;
  await_any_key('Press any key to continue')
end;

{===================================== TEST ONLY BELOW ===================}
{   procedure send_system_mail;

var
  adrs_rec        : adrs_lst_type;
  send_count      : send_count_type;
  len             : real;
  new_queue_entry : mail_que_type;
  act_fname       : file_path_type;

begin

  assign(system_file,act_fname);
  {$I-} rewrite(system_file); {$I+}
  ok := not io_err(act_fname);
  if not ok
    then exit;

  for i := 1 to filesize(unit_ndx_file) - 1 do begin
    seek(unit_ndx_file,i);
    read(unit_ndx_file,index_rec);
    adrs_rec.unit := index_rec.unit;
    adrs_rec.host := 0;
    seek(adrs_file,i-1); {First rec will be #0 vs. #1 in unit_ndx_file}
    write(adrs_file,adrs_rec)
  end;
  close(system_file);

  send_count.int_val := filesize(unit_ndx_file) - 1;
  assign(mail_item_file,adrs_fname);
  reset(mail_item_file);
  len := longfilesize(mail_item_file);
  seek(mail_item_file,len);
  write(mail_item_file,send_count.first_byte);
  write(mail_item_file,send_count.second_byte);
  close(mail_item_file);

  fillchar(new_queue_entry,sizeof(new_queue_entry),0);
  with new_queue_entry do begin
    sender_adrs.unit := 'HOST';
    sender_adrs.attn := '';
    recvr_adrs.attn := '';
    host_sys := 0;
    type_adrsee := unit;
    type_mail := system;
    priority := routine;
    datetime(when_mailed);
    mail_item := adrs_fname;
    original_name := 'E_ADRS.LST';
    mail_length := len
  end;

  for i := 1 to filesize(unit_ndx_file) - 1 do begin
    seek(unit_ndx_file,i);
    read(unit_ndx_file,index_rec);
    mail_queue_entry.recvr_adrs.unit := index_rec.unit;
    queue_hdr_rn := queue_hdr_rec_no(mail_queue_entry.recvr_adrs.unit);
    if queue_hdr_rn>=0
      then begin
        get_first_queue_entry(queue_hdr_rn,mail_queue_entry,mail_queue_rn,ok);
        while ok and (mail_queue_entry.mail_item<>adrs_fname) do
          get_next_queue_entry(queue_hdr_rn,mail_queue_entry,mail_queue_rn,ok);
        if ok {We must have found it}
          then delete_queue_entry(queue_hdr_rn,mail_queue_rn,mail_queue_entry);
        add_queue_entry(queue_hdr_rn,new_queue_entry)
      end
  end

end;
}           { above is experimental only!!!!!!!!!!!!!!!}
{===================================================================}
begin {Mail maint functions}
 repeat
    clrscr;
    choice := menu(mailmenu);
    clrscr;
    case choice of
      2 : add_mail;
      3 : view_mail;
    end
  until choice=1
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure log_functions;

var
  choice : integer;
  log_file    : text;
  log_fname   : file_path_type;

procedure view_log;

var
  sp          : char;
  f           : text;
  time_str    : string[6];
  out_time_str : string[8];
  event_code  : log_event_type;
  event_fake  : byte absolute event_code;
  number      : real;
  infostr     : anystr;
  io_err_val  : integer;

begin
  write('Enter log file name -->');
  readln(log_fname);
  if pos('.',log_fname)=0
    then log_fname := log_fname + '.LOG';

  write('To (S)creen or (P)rinter? ');
  read(kbd,sp);
  writeln(sp);
  if sp in ['P','p']
    then assign(f,'prn')
    else assign(f,'con');
  rewrite(f);

  assign(log_file,log_fname);
  {$I-} reset(log_file); {$I+}
  io_err_val := ioresult;

  case io_err_val of
    0 :   while not eof(log_file) do begin
            readln(log_file,time_str,event_fake,number,infostr);
            event_fake := event_fake - 32;
            out_time_str := time_str;
            insert(':',out_time_str,5);
            insert(':',out_time_str,3);
            write(f,out_time_str,'  ');
            case event_code of
              debug             : write(f,'DEBUG---->');
              open_log          : write(f,'Open log ');
              io_error          : write(f,'I/O error ');
              unit_error        : write(f,'Unit not found ');
              awaiting_call     : write(f,'Awaiting call ');
              connected         : write(f,'Connect ');
              no_connect        : write(f,'No carrier ');
              terminate         : write(f,'Terminating ');
              main_loop         : write(f,'Main loop ');
              kbd_interrupt     : write(f,'Keyboard interrupt ');
              place_call        : write(f,'Placing call');
              bad_mail_hdr      : write(f,'Bad mail header');
              mail_hdr          : write(f,'Mail header');
              recv_dist_list    : write(f,'Receiving distribution list');
              bad_block         : write(f,'Bad block');
              bad_conference    : write(f,'Bad conference name');
              recv_mail_item    : write(f,'Receiving mail item');
              add_to_queue      : write(f,'Add mail to queue');
              erase_no_recvrs   : write(f,'Erase mail item -- no receivers');
              send_mail_item    : write(f,'Sending mail item');
              bad_mail_item     : write(f,'Bad mail item');
              mail_hdr_refused  : write(f,'Mail header refused');
              mail_item_refused : write(f,'Mail item refused');
              send_count_is     : write(f,'Send count');
              erase_mail_item   : write(f,'Erase mail item -- send count zero');
              start_pass_a      : write(f,'Starting pass A');
              start_pass_b      : write(f,'Starting pass B');
              no_contact_a      : write(f,'No contact on pass A');
              no_contact_b      : write(f,'No contact on pass B');
              hanging_up        : write(f,'Hanging up');
            else write(f,'LOG ERROR -- Unknown event code =<',ord(event_code),'>')
            end;
            if number<>null
              then write(f,' <',number:7:0,'>');
            if infostr>'             '
              then writeln(f,' -- ',infostr)
              else writeln(f)
          end;
    1 : writeln('File not found.');
  else writeln('I/O Error #',io_err_val)
  end;

  writeln(f);
  close(f);
  close(log_file);
  await_any_key('Press any key to continue')
end;

procedure delete_log;

var
  io_err_val  : integer;

begin
  write('Enter log file name -->');
  readln(log_fname);
  if pos('.',log_fname)=0
    then log_fname := log_fname + '.LOG';

  assign(log_file,log_fname);
  {$I-} erase(log_file); {$I+}
  io_err_val := ioresult;
  case io_err_val of
    0 : ;
    1 : writeln('File not found.')
  else writeln('I/O Error #',io_err_val)
  end;
  await_any_key('Press any key to continue')
end;

begin {Log maint functions}
 repeat
    clrscr;
    choice := menu(logmenu);
    clrscr;
    case choice of
      2 : view_log;
      3 : delete_log
    end
  until choice=1
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
procedure send_adrs_list;

var
  adrs_file       : file of adrs_lst_type;        {Master adrs list}
  adrs_rec        : adrs_lst_type;
  send_count      : send_count_type;
  len             : real;
  new_queue_entry : mail_que_type;

const
  adrs_fname : file_path_type = '\EMAIL\E_ADRS.LST';

begin
  assign(adrs_file,adrs_fname);
  {$I-} rewrite(adrs_file); {$I+}
  ok := not io_err(adrs_fname);
  if not ok
    then exit;

  for i := 1 to filesize(unit_ndx_file) - 1 do begin
    seek(unit_ndx_file,i);
    read(unit_ndx_file,index_rec);
    adrs_rec.unit := index_rec.unit;
    adrs_rec.host := 0;
    seek(adrs_file,i-1); {First rec will be #0 vs. #1 in unit_ndx_file}
    write(adrs_file,adrs_rec)
  end;
  close(adrs_file);

  send_count.int_val := filesize(unit_ndx_file) - 1;
  assign(mail_item_file,adrs_fname);
  reset(mail_item_file);
  len := longfilesize(mail_item_file);
  seek(mail_item_file,len);
  write(mail_item_file,send_count.first_byte);
  write(mail_item_file,send_count.second_byte);
  close(mail_item_file);

  fillchar(new_queue_entry,sizeof(new_queue_entry),0);
  with new_queue_entry do begin
    sender_adrs.unit := 'HOST';
    sender_adrs.attn := '';
    recvr_adrs.attn := '';
    host_sys := 0;
    type_adrsee := unit;
    type_mail := system;
    priority := routine;
    datetime(when_mailed);
    mail_item := adrs_fname;
    original_name := 'E_ADRS.LST';
    mail_length := len
  end;

  for i := 1 to filesize(unit_ndx_file) - 1 do begin
    seek(unit_ndx_file,i);
    read(unit_ndx_file,index_rec);
    mail_queue_entry.recvr_adrs.unit := index_rec.unit;
    queue_hdr_rn := queue_hdr_rec_no(mail_queue_entry.recvr_adrs.unit);
    if queue_hdr_rn>=0
      then begin
        get_first_queue_entry(queue_hdr_rn,mail_queue_entry,mail_queue_rn,ok);
        while ok and (mail_queue_entry.mail_item<>adrs_fname) do
          get_next_queue_entry(queue_hdr_rn,mail_queue_entry,mail_queue_rn,ok);
        if ok {We must have found it}
          then delete_queue_entry(queue_hdr_rn,mail_queue_rn,mail_queue_entry);
        add_queue_entry(queue_hdr_rn,new_queue_entry)
      end
  end

end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
begin {main}
{  if paramstr(1)<>password
    then begin
      writeln('Bad command or file name');
      exit
    end;}

  clrscr;
  init_files(ok);
  if not ok
    then exit;
  init_timer;
  init_date_time;
  initgraph;

  repeat
    clrscr;
    choice := menu(mainmenu);
    clrscr;
    case choice of
      2 : unit_functions;
      3 : mail_functions;
      4 : log_functions
    end
  until choice=1;

  quit_timer;

  if unit_change
    then send_adrs_list;

  {$I-}  {Ignore errors -- files may not be open}
  close(unit_ndx_file);
  close(queue_hdr_file);
  close(queue_file);
  close(mail_item_file);
  {$I+}

end. {main}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}

