type
  index_type = record
                 case boolean of
                   true  : (unit         : unit_type;
                            queue_hdr_rn : integer);
                   false : (last_date    : string[6];
                            last_pass    : char;
                            last_unit    : integer);

var
  bin_index_entry : index_type;

function bin_get_key;

begin
  {For debugging purposes:
    writeln('Getting record ',bin_rn); }
  seek(unit_ndx_file,bin_rn);
  read(unit_ndx_file,bin_index_entry);
  bin_get_key := addr(bin_index_entry.unit)
end;

function bin_less_than;

var
  target,
  current_key : ^key_type;

begin
  setptr(target,bin_target);
  setptr(current_key,bin_current);
  { For debugging purposes:
    writeln('Is ',target^,' less than ',current_key^); }
  bin_less_than := target^<current_key^
end;

function bin_equal_to;

var
  target,
  current_key : ^key_type;

begin
  setptr(target,bin_target);
  setptr(current_key,bin_current);
  { For debugging purposes:
    writeln('Is ',target^,' equal to ',current_key^); }
  bin_equal_to := target^=current_key^
end;

function index_rec_no(unit : unit_type) : integer;

begin
  index_rec_no := bin_search(1,filesize(unit_ndx_file),unit)
end;

procedure index_delete(    index_rn : integer);

var
  last_rn,
  rn         : integer;
  index_rec  : index_type;

begin
  seek(unit_ndx_file,index_rn);
  read(unit_ndx_file,index_rec);
  last_rn := filesize(unit_ndx_file) - 1;
  for rn := index_rn + 1 to last_rn do begin
    seek(unit_ndx_file,rn);
    read(unit_ndx_file,index_rec);
    seek(unit_ndx_file,rn-1);
    write(unit_ndx_file,index_rec)
  end;
  seek(unit_ndx_file,last_rn);
  truncate(unit_ndx_file);
  reset(unit_ndx_file)  {Force directory update}
end;

procedure index_add(index_rn   : integer;
                    index_item : index_type);

var
  last_rn,
  rn         : integer;
  index_rec  : index_type;

begin
  last_rn := filesize(unit_ndx_file) - 1;
  for rn := last_rn downto index_rn do begin
    seek(unit_ndx_file,rn);
    read(unit_ndx_file,index_rec);
    seek(unit_ndx_file,rn+1);
    write(unit_ndx_file,index_rec)
  end;
  seek(unit_ndx_file,index_rn);
  write(unit_ndx_file,index_item);
  reset(unit_ndx_file)  {Force directory update}
end;

procedure get_queue_hdr(var hdr      : queue_hdr_type;
                        var ok       : boolean);

var
  index_rn     : integer;
  index_rec    : index_type;

begin
  index_rn := index_rec_no(hdr.unit);
  ok := (index_rn>0) {index_rn<0 means the unit is not in the index}
  if ok
    then begin
      seek(unit_ndx_file,index_rn);
      read(unit_ndx_file,index_rec);
      seek(queue_hdr_file,index_rec.queue_hdr_rn);
      read(queue_hdr_file,hdr)
    end
end;

procedure add_queue_hdr(    hdr : queue_hdr_type;
                        var ok  : boolean);

var
  index_rn     : integer;
  hdr_rn       : integer;
  temp_hdr     : queue_hdr_type;
  index_rec    : index_type;

begin
  ok := (hdr.time_zone>max_time_zone) or (hdr.time_zone<min_time_zone)
  if not ok
    then exit;
  index_rn := index_rec_no(hdr.unit);
  ok := (index_rn<0) {index_rn>0 means the unit is already in the index}
  if ok
    then begin
      hdr_rn := filesize(queue_hdr_file) - 1;
      repeat
        seek(queue_hdr_file,hdr_rn);
        read(queue_hdr_file,temp_hdr);
        if temp_hdr.timer_zone>hdr.time_zone
          then begin
            seek(queue_hdr_file,hdr_rn+1);
            write(queue_hdr_file,temp_hdr);
            hdr_rn := pred(hdr_rn)
          end
      until (hdr_rn=1) or (temp_hdr.time_zone<=hdr.time_zone);
      hdr_rn := succ(hdr_rn);
      seek(queue_hdr_file,hdr_rn);
      write(queue_hdr_file,hdr);
      reset(queue_hdr_file);  {Force directory update}
      index_rec.unit := hdr.unit;
      index_rec.queue_hdr_rn := hdr_rn;
      index_add(index_rn,index_rec)
    end
end;

procedure delete_queue_hdr(    unit : unit_type;
                           var ok   : boolean);

var
  index_rn     : integer;
  hdr_rn       : integer;
  temp_hdr     : queue_hdr_type;
  index_rec    : index_type;

begin
  index_rn := index_rec_no(unit);
  ok := (index_rn>0) {index_rn<0 means the unit is not in the index}
  if ok
    then begin
      seek(unit_ndx_file,index_rn);
      read(unit_ndx_file,index_rec);
      hdr_rn := index_rec.queue_hdr_rn;
      seek(queue_hdr_file,hdr_rn);
      read(queue_hdr_file,temp_hdr);
      ok := (temp_hdr.head=0);
      if ok
        then begin
          index_delete(index_rn,ok);
          last_hdr_rec := filesize(queue_hdr_file)-1;
          while hdr_rn<last_hdr_rec do begin
            seek(queue_hdr_file,hdr_rn + 1);
            read(queue_hdr_file,temp_hdr);
            seek(queue_hdr_file,hdr_rn);
            write(queue_hdr_file,temp_hdr);
            hdr_rn := succ(hdr_rn)
          end;
          truncate(queue_hdr_file);
          reset(queue_hdr_file) {Forces directory update}
        end
    end
end;


