{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
program e_rinit;

{$I e_types.inc  }

var
  queue_hdr_file  : file of queue_hdr_type;   {Mail queue header file}
  queue_file      : file of mail_que_type;    {Mail queue file}
  sys_info_file   : file of sys_info_type;    {System information file}

  sys_info        : sys_info_type;
  temp_hdr        : queue_hdr_type;
  exists          : boolean;
  choice          : char;
  quit            : boolean;

const
  password        = 'really';

  cr              = ^M;
  lf              = ^J;
  bell            = ^G;

  queue_hdr_fname : file_path_type = '\EMAIL\E_MQUE.HDR';
  queue_fname     : file_path_type = '\EMAIL\E_MAIL.QUE';
  sys_info_fname  : file_path_type = '\EMAIL\E_RINFO.SYS';
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function readchar(ok_chars : char_set) : char; { Restricts input to ok_chars }

var
  c : char;

begin
  repeat
    read(kbd,c);
    if not (c in ok_chars)
      then write(bell)
  until c in ok_chars;
  readchar := c
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function yes(txt : anystr) : boolean; { Display txt, get Y or N,
                                        return TRUE if Y, FALSE if N }

var
  c : char;
  cursor : integer;

begin
  write(txt+' (Y/N) ');
  c := readchar(['y','Y','n','N']);
  yes := (upcase(c) = 'Y');
  writeln
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
function no(txt : anystr) : boolean; { Same as "yes" except opposite logic }

begin
  no := not yes(txt)
end;
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
begin {main}
  if paramstr(1)<>password
    then begin
      writeln('Bad command or file name');
      exit
    end;

  clrscr;
  assign(queue_hdr_file,queue_hdr_fname);
  {$I-} reset(queue_hdr_file); {$I+}
  exists := (ioresult=0);
  if exists
    then if yes(queue_hdr_fname+
        ' already exists.'+cr+lf+
        'Would you like to delete it and create a new one? ')
      then if yes(lf+'ARE YOU SURE!!!? '+bell)
        then begin
          close(queue_hdr_file);
          erase(queue_hdr_file);
          exists := false
        end;
  if not exists
    then begin
      rewrite(queue_hdr_file);
      with temp_hdr do begin
        fillchar(temp_hdr,sizeof(temp_hdr),0);
        head := -1;
        tail := -1;
        unit := 'FREE LIST HEADER';
        write(queue_hdr_file,temp_hdr);
        unit := 'INCOMING';
        write(queue_hdr_file,temp_hdr);
        unit := 'OUTGOING';
        write(queue_hdr_file,temp_hdr);
        close(queue_hdr_file)
      end;
    end;

  assign(queue_file,queue_fname);
  {$I-} reset(queue_file); {$I+}
  exists := (ioresult=0);
  if exists
    then if yes(queue_fname+
        ' already exists.'+cr+lf+
        'Would you like to delete it and create a new one? ')
      then if yes(lf+'ARE YOU SURE!!!? '+bell)
        then begin
          close(queue_file);
          erase(queue_file);
          exists := false
        end;
  if not exists
    then begin
      rewrite(queue_file);
      close(queue_file)
    end;

  assign(sys_info_file,sys_info_fname);
  {$I-} reset(sys_info_file); {$I+}
  exists := (ioresult=0);
  if exists
    then read(sys_info_file,sys_info)
    else with sys_info do begin
      rewrite(sys_info_file);
      unit := '';
      serial_no := 0;
      host_no := 0;
      host_phone_no := '';
      time_zone := 5
    end;

  with sys_info do repeat
    clrscr;
    writeln;
    writeln('Current system information:');
    writeln;
    writeln('  Unit name                       : ',sys_info.unit);
    writeln('  Host number                     : ',host_no);
    writeln('  Phone number of host            : ',host_phone_no);
    writeln('  Time zone (Local Standard Time) : ',time_zone);
    writeln;
    if yes('Any changes?')
      then begin
        write('Which field to change? (U,H,P, or T) : ');
        choice := readchar(['U','u','H','h','P','p','T','t']);
        writeln;
        case choice of
          'U','u' : begin
                      write('  New unit name     : ');
                      readln(unit)
                    end;
          'H','h' : begin
                      write('  New host number   : ');
                      readln(host_no)
                    end;
          'P','p' : begin
                      write('  New phone number  : ');
                      readln(host_phone_no)
                    end;
          'T','t' : begin
                      write('  New time zone     : ');
                      readln(time_zone)
                    end
          else write(bell)
        end;
        quit := false
      end
      else quit := true
  until quit;
  seek(sys_info_file,0);
  write(sys_info_file,sys_info);
  close(sys_info_file)

end. {main}
{=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=}
